<?php

namespace Warpit\Console\Job;

use App\Services\ProjectManager\Projects\NotActiveProjectService;
use App\Services\SendMailService;
use App\Services\WarpitConfigService;
use Carbon\Carbon;
use Warpit\Console\Interfaces\JobInterface;

use Log;

class AnonymizationNoificationsJob implements JobInterface
{
    protected $notActiveProjectService;

    protected $sendMailService;

    protected $configService;

    public function __construct(NotActiveProjectService $notActiveProjectService,
                                SendMailService $sendMailService,
                                WarpitConfigService $configService)
    {
        $this->configService = $configService;
        $this->sendMailService = $sendMailService;
        $this->notActiveProjectService = $notActiveProjectService;

    }

    public function run()
    {
        $groupId    = intval($this->configService->getConfig('webcati', 'anonymization_group', 0));
        $templateId = intval($this->configService->getConfig('webcati', 'anonymization_template', 0));

        $enable = intval($this->configService->getConfig('webcati','anonymization_enable_notice', 0));

        if($enable === 0){
            return false;
        }

        $warpitUrl = $this->configService->getConfig('paths','cli_www', null);

        if($groupId <= 0 || $templateId <= 0){
            Log::info('Config for notifications not set!');
            return false;
        }

        $projects = $this->notActiveProjectService->get();
        $projects = $this->removeAnonimyzedProjects($projects);

        if(empty($projects) === true){
            Log::info('No projects for anonymizations');
            return false;
        }
        foreach($projects as $project){
            Log::info('Sending mails for projects: ' . $project->proj_name);

            $anonymizationLink = $warpitUrl . '?anonymizationProject=' . $project->id;

            $customFields = json_encode([
                'anonymizationUrl'         => $anonymizationLink,
                'anonymizationProjectName' => $project->proj_name,
            ]);

            $this->sendMailService->send($groupId, $templateId, 0,0, $customFields);
        }

        return true;

    }

    protected function isAnonimyzed($anonimizationDate, $lastInterviewDate)
    {
        if($anonimizationDate === null){
            return false;
        }

        $anonimizationDate = Carbon::parse($anonimizationDate);
        $lastInterviewDate = Carbon::parse($lastInterviewDate);

        if($lastInterviewDate->greaterThan($anonimizationDate) === true){
            return false;
        }

        return true;
    }

    protected function removeAnonimyzedProjects($projects)
    {
        $filteredProjects = [];
        foreach ($projects as $project){

            if($this->isAnonimyzed($project->anonymization_datetime,$project->startDate) === false){
                $filteredProjects[] = $project;
            }
        }

        return $filteredProjects;
    }
}
