<?php

namespace Warpit\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Warpit\Console\Schedule as Schedule;
use Illuminate\Contracts\Container\Container as Container;

class ScheduleCommand extends Command
{
    public function __construct(Schedule $schedule, Container $container)
    {
      $this->schedule  = $schedule;
      $this->container = $container;
      parent::__construct();
    }

    protected function configure()
    {
      $this
        ->setName('warpit:run-scheduler')
        ->setDescription('Run scheduler')
        ->setHelp('Run scheduler');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->schedule->call([$this, 'sendEmails'])->everyMinute();
        $this->schedule->call([$this, 'anonymizationNotifications'])->daily();
        $this->schedule->call([$this, 'cleanTelephoneBlacklist'])->daily();
        $this->schedule->call([$this, 'resetQuotas'])->weeklyOn(0, '22:00');

        $this->schedule->runDueCommands();
    }


    public function sendEmails()
    {
        $job = $this->container->make(\Warpit\Console\Job\SendMailJob::class);
        $job->run();
    }

    public function anonymizationNotifications()
    {
        $job = $this->container->make(\Warpit\Console\Job\AnonymizationNoificationsJob::class);
        $job->run();
    }

    public function cleanTelephoneBlacklist()
    {
        $job = $this->container->make(\Warpit\Console\Job\CleanBlacklistJob::class);
        $job->run();
    }

    public function resetQuotas()
    {
        $job = $this->container->make(\Warpit\Console\Job\ResetQuotasJob::class);
        $job->run();
    }


}
