<?php

namespace Warpit\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\Question;
use Symfony\Component\Console\Question\ChoiceQuestion;
use Warpit\Console\Utilities;
use Warpit\Services\WarpitInstallService;

class InstallWarpitCommand extends Command
{
    protected $requiredProperties = [
        "MAIN_DATABASE",
        "MYSQL_USER",
        "MYSQL_PASS",
        "MYSQL_HOST",
        "WARPIT_WWW",
        "WEBPROJECTS_WWW",
        "WEBPROJECTS_FOLDER",
        "PROTOCOL",
        "DESIGN_DEPTH"
    ];

    public function __construct(WarpitInstallService $warpitInstallService)
    {
        $this->warpitInstallService = $warpitInstallService;

        parent::__construct();
    }

    protected function configure()
    {
        define("WARPIT_LOGS", "");

        /*  $this->fileName = PATH_TO_ROOT . '_config/dbConfig.php';*/

        $this
            ->setName('warpit:install')
            ->setDescription('Install warpit')
            ->setHelp('This command allows you to install base warpit database run migrations and setup config');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $command = $this->getApplication()->find('install:config');
        $arguments = [
            'command' => 'install:config',
            '--force' => true
        ];
    
        $greetInput = new ArrayInput($arguments);
        $command->run($greetInput, $output);

        $command = $this->getApplication()->find('install:database');
        $arguments = [
            'command' => 'install:database',
        ];
    
        $greetInput = new ArrayInput($arguments);
        $command->run($greetInput, $output);

        $command = $this->getApplication()->find('install:files');
        $arguments = [
            'command' => 'install:files',
        ];
    
        $greetInput = new ArrayInput($arguments);
        $command->run($greetInput, $output);

        $command = $this->getApplication()->find('install:cronjob');
        $arguments = [
            'command' => 'install:cronjob',
        ];
    
        $greetInput = new ArrayInput($arguments);
        $command->run($greetInput, $output);
    }
}
