<?php

namespace Warpit\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\Question;
use Symfony\Component\Console\Question\ChoiceQuestion;
use Warpit\Console\Utilities;
use Warpit\Services\WarpitInstallService;
use SolveX\Support\Dotenv;

class InstallCronjobCommand extends Command
{
    public function __construct(WarpitInstallService $warpitInstallService)
    {
        $this->warpitInstallService = $warpitInstallService;

        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setName('install:cronjob')
            ->setDescription('Install warpit cronjobs')
            ->setHelp('This command create warpit cronjobs');
    }
    
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        if($this->warpitInstallService->configExists() === false){
            $output->writeln('<bg=yellow;options=bold>Config check failed</>');
            return;
        }

        if( $this->warpitInstallService->crontabEntryExists() === true){
            $output->writeln('<bg=yellow;options=bold>Cronjob exists</>');
            return;
        }

        $this->warpitInstallService->addCrontabEntry();
        
        $output->writeln('<fg=green>Cronjob created</>');
    }
}
