<?php

namespace Warpit\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\Question;
use Symfony\Component\Console\Question\ChoiceQuestion;
use Warpit\Console\Utilities;
use Warpit\Services\WarpitInstallService;
use SolveX\Support\Dotenv;

class InstallConfigCommand extends Command
{
    public function __construct(WarpitInstallService $warpitInstallService)
    {
        $this->warpitInstallService = $warpitInstallService;

        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setName('install:config')
            ->setDescription('Install warpit config')
            ->setHelp('This command create warpit configs. Use --file-only (-o) to update only config file')
            ->addOption('force', 'f', InputOption::VALUE_OPTIONAL, 'Update config if exists.', false)
            ->addOption('file-only', 'o', InputOption::VALUE_OPTIONAL, 'Update only config file.', false);
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $force =  $input->getOption('force') !== false;
        $fileOnly =  $input->getOption('file-only') !== false;
        
        $env = $this->warpitInstallService->loadConfig();
        
        if($this->warpitInstallService->configExists() === true && $force === false){
            $output->writeln('<bg=yellow;options=bold>Config exists. Use option --force to overwrite</>');
            return;
        }

        $this->warpitInstallService->createConfig($env['MYSQL_USER'], $env['MYSQL_PASS'], $env['MAIN_DATABASE'], $env['MYSQL_HOST']);
        
        $output->writeln('<fg=green>Config created</>');

        if($fileOnly === true){
            return;
        }

        $db = new \db;
        $db->SetDatabaseConnection($env['MYSQL_USER'], $env['MYSQL_PASS'], $env['MYSQL_HOST']);

        $this->warpitInstallService->setDatabase($db);

        if($this->warpitInstallService->mainDatabaseExists($env['MAIN_DATABASE']) === true){
            $output->writeln('<bg=yellow;options=bold>Config database exists.</>');
            return;
        }

        $this->warpitInstallService->createMainDatabase($env['MYSQL_USER'], $env['MYSQL_PASS'], $env['MYSQL_HOST'], $env['databases']);
        $this->warpitInstallService->databaseConfiguration($env);

        $output->writeln('<fg=green>Config database created</>');
    }
}
