<?php

class ddf2warpit
{
	protected $name_project = null;
	protected $L_cnt = 0;
	protected $S_cnt =-1;
	protected $Q_cnt = 0;
	protected $Qlgn_cnt = 0;
	protected $C_cnt = 0;
	protected $TGIoption = array();
	
	protected $AnswerCounter;
	protected $MBRX_cnt;
	
	protected $S_guide = false; // I should read guide for complete S from first MBRQ Question
	protected $S_read_guide = false; // set to false, only if I am sure that next A will give me some instructions I set it to true
	protected $showLegend = false;
	protected $Qvariable = null;
	protected $AnswerCode = null;
	protected $setSwitch = array();
	
	protected $keywordAnswerCheck = array();
	
	protected $db;
	
	public $language = array();
	public $project = array();
	public $storeAnswers = array();
	public $storeQuestions = array();
	
	
	public function __construct($db)
	{
		$this->db=$db;
		
	}
	
	
	protected function getTGIoptions() {
		$sql = "SELECT * FROM ".DB_WARPIT_TGI.".TGI_options";
		$this->db->LogWrite($sql,true,"get TGI options");
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchAssoc($res)) {
			$option = $row['cValue'];
			if ($row['cName'] == "path_images") $option = str_replace("/","\\",$option);
			
			$this->TGIoption[$row['cName']] = $option; 
			$this->db->LogWrite(print_r($this->TGIoption,1),true,"TGI options...");
		}
		return true;
	}
	
	
	public function getActiveProject() {
		$row = $this->db->get("TGI_projects","active=1","id");
		$id_project = $row[0];
		
		$this->db->LogWrite($id_project,true,"get active project");
		
		return $id_project;
	}
	

	public function getActiveProjectName($id_project) {
		$name_project = $this->db->get("TGI_projects",$id_project,"name");
		$this->name_project = $name_project;
		
		return $name_project;
	}
	
	
	protected function checkRow($row) {
		$category = $row['category'];
		
		switch ($category)  {
			
			case "H":
				$this->setSwitch['H'] = true;
				
				$availableLanugages = explode(",", strtoupper($row['variable']));
				foreach ($availableLanugages AS $keyLang => $itemLang) {
					if ($availableLanugages[$keyLang] == "URD") 
						$this->language[$keyLang] = 125;
					elseif ($availableLanugages[$keyLang] == "SLV") 
						$this->language[$keyLang] = 91;
					elseif ($availableLanugages[$keyLang] == "ENG") 
						$this->language[$keyLang] = 46;
					else 
						$this->language['language'][$keyLang] = 46;
				}	
				$this->db->LogWrite($this->language[0],true,"inside H, language");
				$this->db->LogWrite($this->language[1],true,"inside H, language");
				
				$this->L_cnt = 0; 
				break;
				
			case "C";
				$this->setSwitch['C'] = true;
				$this->setSwitch['S'] = false;
				$this->setSwitch['Q'] = false;
				$this->setSwitch['A'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['X'] = false;
				$this->setSwitch['T'] = false;
				$this->C_cnt++;
				
				if ($this->C_cnt < 10) $this->C_cnt = "0".$this->C_cnt;
				$this->project[$this->C_cnt]['name'] = $this->name_project."_".$this->C_cnt;
				
				$this->db->LogWrite($this->project[$this->C_cnt]['name'],true,"inside C, name");
				$this->L_cnt = 0;
				break;
			
			case "L";
				$this->setSwitch['L'] = true;
				
				$this->db->LogWrite("S:".$this->setSwitch['S']." - "."V:".$this->setSwitch['V']." - "."X:".$this->setSwitch['X']." - "."Q:".$this->setSwitch['Q']." - "."MBRX_A:".$this->setSwitch['MBRX_A']." - "."A:".$this->setSwitch['A']." - "."T:".$this->setSwitch['T']." - "."C:".$this->setSwitch['C'],true,"inside L");
				$this->db->LogWrite("controlCode_label:".$row['controlCode_label']." --- AnswerCode:".$this->AnswerCode." --- L_cnt:".$this->L_cnt." --- Qvariable:".$this->Qvariable,true,"inside L");
				
				if ($this->setSwitch['A'] == true OR $this->setSwitch['MBRX_A'] == true OR $this->setSwitch['V'] == true OR $this->setSwitch['X'] == true) {
					if ($this->setSwitch['T'] == true) {
						if ($this->showLegend == true) {
							$outputLabel = $row['controlCode_label'];
							if ($row['longer_description']) $outputLabel = $row['longer_description'];
							
							// add also image to answers
							if ($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_A_image'][$this->AnswerCode]) {
								$outputLabel = $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_A_image'][$this->AnswerCode]." ".$outputLabel;
							}
							
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['legend'][$this->Qlgn_cnt]['answers'][$this->AnswerCode][$this->L_cnt] = $this->specCharCheck($outputLabel);
							$this->db->LogWrite("Qvariable:".$this->Qvariable." --- Legend counter:".$this->Qlgn_cnt,true,"inside L, T is true, show legend");
						} else {
							$this->db->LogWrite("Qvariable:".$this->Qvariable." --- Legend counter:".$this->Qlgn_cnt,true,"inside L, T is true, not adding answers under legend");
						}
					} else {
						if ($this->setSwitch['MBRX_A'] == true) {
							// I show always all answers for now, if question is set to be shown 
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 1; // show answer
						}
						$this->db->LogWrite($this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode],true,"inside L, T is false, answer visible?");

						if ($this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] == 1) {
							$outputLabel = $row['controlCode_label'];
							if ($row['longer_description']) $outputLabel = $row['longer_description'];
							
							// add also image to answers
							if ($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_A_image'][$this->AnswerCode]) {
								$outputLabel = $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_A_image'][$this->AnswerCode]." ".$outputLabel;
							}
							
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers'][$this->AnswerCode][$this->L_cnt] = $this->specCharCheck($outputLabel);
							$this->db->LogWrite("Qvariable:".$this->Qvariable." --- L_cnt counter:".$this->L_cnt,true,"inside L, T is false, standard answers");
							$this->db->LogWrite("Added label to array:".$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers'][$this->AnswerCode][$this->L_cnt],true,"inside L, T is false, standard answers");
						} else {
							$this->db->LogWrite($this->project[$this->C_cnt]['question'][$this->Qvariable]['answers'][$this->AnswerCode][$this->L_cnt],true,"inside L, T is false, label not added");
						}
					}
					

					// check if guide for S exist...
					if ($this->S_read_guide == true AND $this->L_cnt == 0 AND $this->MBRX_cnt > 0) {
						$this->db->LogWrite("Qvariable:".$this->Qvariable." --- MBRX counter:".$this->MBRX_cnt,true,"inside L, set guide");
						
						// save also original description, before modification
						$DescriptionVariablesOriginal = $row['longer_description'];
						$DescriptionVariablesOriginal = str_replace(" ","",$DescriptionVariablesOriginal);
						
						$DescriptionVariables = strtoupper($row['longer_description']);
						$DescriptionVariables = str_replace(array(" OR "," AND "),array("||","&&"),$DescriptionVariables);
						$DescriptionVariables = str_replace(" ","",$DescriptionVariables);
						$row['longer_description'] = $DescriptionVariables = str_replace(array("||","&&"),array(" OR "," AND "),$DescriptionVariables);
						
						$this->db->LogWrite("keyword:".$this->keyword,true,"inside L, set guide");
						if ($this->keyword == "WEB1") {
							if ($DescriptionVariables) {
								$web1_array = explode(",", $DescriptionVariables);
								if (!isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'])) $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'] =  array();
								$this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'] = array_merge($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'],$web1_array);
								$this->db->LogWrite("WEB1",true,"inside L, set guide");
							}
						} elseif ($this->keyword == "WEB2") {
							if ($DescriptionVariables) {
								$web2_array = explode(",", $DescriptionVariables);
								if (!isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question'])) $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question'] =  array();
								$this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question'] = array_merge($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question'],$web2_array);
								$this->db->LogWrite("WEB2",true,"inside L, set guide");
							}
						} elseif ($this->keyword == "WEB3") {
							if ($DescriptionVariables) {
								$web3_array = explode(",", $DescriptionVariables);
								if (!isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_answer'])) $this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_answer'] =  array();
								$this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_answer'] = array_merge($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_answer'],$web3_array);
								$this->db->LogWrite("WEB3",true,"inside L, set guide");
							}
						} elseif ($this->keyword == "WEB4") {
							if ($DescriptionVariables) {
								$web4_array = explode(",", $DescriptionVariables);
								if (!isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_question'])) $this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_question'] =  array();
								$this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_question'] = array_merge($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_question'],$web4_array);
								$this->db->LogWrite("WEB4",true,"inside L, set guide");
							}
						} elseif ($this->keyword == "WEB5") {
							if ($DescriptionVariables) {
								$web5_array = explode(",", $DescriptionVariables);
								if (!isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['multi'])) $this->project[$this->C_cnt]['guide'][$this->Svariable]['multi'] =  array();
								$this->project[$this->C_cnt]['guide'][$this->Svariable]['multi'] = array_merge($this->project[$this->C_cnt]['guide'][$this->Svariable]['multi'],$web5_array);
								$this->db->LogWrite("WEB5",true,"inside L, set guide");
							}
						} elseif ($this->keyword == "WEB6") {
							if ($DescriptionVariables) {
								$web6_array = explode(",", $DescriptionVariables);
								if (!isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer'])) $this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer'] =  array();
								$this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer'] = array_merge($this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer'],$web6_array);
								$this->db->LogWrite("WEB6",true,"inside L, set guide");
							}
						} elseif ($this->keyword == "WEB7") {
							if ($DescriptionVariables) {
								$web7_array = explode(";", $DescriptionVariables);
								foreach($web7_array AS $filterVar) {
									$filterQuestion_array = explode(":",$filterVar,2);
									$filterQuestion = $filterQuestion_array[0];
									$filterFilter = $filterQuestion_array[1];
									$this->project[$this->C_cnt]['guide']['filter_all'][$filterQuestion] = $filterFilter;
								}
								$this->db->LogWrite("WEB7",true,"inside L, set guide");
							}
						} elseif ($this->keyword == "WEB8") {
							if ($DescriptionVariables) {
								$web8_array = explode(";", $DescriptionVariables);
								foreach($web8_array AS $filterVar) {
									$filterQuestion_array = explode(":",$filterVar);
									$filterQuestion = $filterQuestion_array[0];
									$filterFilter = $filterQuestion_array[1];
									$this->project[$this->C_cnt]['guide']['filter_inside'][$filterQuestion] = $filterFilter;
								}
								$this->db->LogWrite("WEB8",true,"inside L, set guide");
							}
						} elseif ($this->keyword == "WEB9") {
							if ($DescriptionVariables) {
								$web9_array = explode(",", $DescriptionVariables);
								if (!isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_grid'])) $this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_grid'] =  array();
								$this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_grid'] = array_merge($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_grid'],$web9_array);
								$this->db->LogWrite("WEB9",true,"inside L, set guide");
							}
						} elseif ($this->keyword == "WEB10") {
							if ($DescriptionVariablesOriginal) {
								$web10_array = explode(",", $DescriptionVariablesOriginal);
								foreach($web10_array AS $images) {
									$image_arr = trim($images);
									$image_prop = explode(":",$image_arr,2);

									$imageKeyword = trim($image_prop[0]);
									$imageName = trim($image_prop[1]);
									$web10_images[$imageKeyword] = str_replace("[","[".$this->TGIoption['path_images'],$imageName);
									
									if (!isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_A_image'])) $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_A_image'] =  array();
									$this->project[$this->C_cnt]['guide'][$this->Svariable]['show_A_image'] = array_merge($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_A_image'],$web10_images);
								}
								$this->db->LogWrite("WEB10",true,"inside L, set guide");
								$this->db->LogWrite(print_r($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_A_image'],1),true,"inside L, set guide web10");
							}
						}	
						$this->db->LogWrite("MBRX counter:".$this->MBRX_cnt." --- longer description variables:".$DescriptionVariables,true,"inside L, set guide");
					}
										
					$this->db->LogWrite($this->Qvariable,true,"inside L, set answers text");
				} elseif ($this->setSwitch['S'] == true OR $this->setSwitch['Q'] == true) {
					if ($this->setSwitch['T'] == true) {
						if ($this->showLegend == true) {
							$outputLabel = $row['controlCode_label'];
							if ($row['longer_description']) $outputLabel = $row['longer_description'];
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['legend'][$this->Qlgn_cnt][$this->L_cnt] = $this->specCharCheck($outputLabel);
							$this->db->LogWrite($this->Qvariable,true,"inside L, set T,Q legend question text");
						} else {
							$this->db->LogWrite($this->Qvariable,true,"inside L, set T,Q legend question text NOT SET");
							$this->db->LogWrite("BUT!!!, I might have guide to show the question?",true,"inside L, set T,Q legend question text NOT SET");
							$this->db->LogWrite("check question WEB2 guide:".print_r($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question'],1),true,"inside Q");
							
							// I do not know on this point if I should show or hide the legend
							// added 26.3. store legend no matter of MBRX record to possible show it latter
							$outputLabel = $row['controlCode_label'];
							if ($row['longer_description']) $outputLabel = $row['longer_description'];
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['legend_bck'][$this->Qlgn_cnt][$this->L_cnt] = $this->specCharCheck($outputLabel);
							$this->db->LogWrite($this->Qvariable,true,"inside L, set T,Q legend_bck question text no matter if MBRX is set");
						}
					} else {
						$outputLabel = $row['controlCode_label'];
						if ($row['longer_description']) $outputLabel = $row['longer_description'];
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['label'][$this->L_cnt] = $this->specCharCheck($outputLabel);
						$this->db->LogWrite($this->Qvariable,true,"inside L, set question text");
					}
				} elseif ($this->setSwitch['T'] == true) {
					if ($this->setSwitch['MBRX'] == true) {
						$this->db->LogWrite($this->Qvariable,true,"inside L, set nothing, A is disabled because ob MBRX");
					} else {
						$outputLabel = $row['controlCode_label'];
						if ($row['longer_description']) $outputLabel = $row['longer_description'];
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['label'][$this->L_cnt] = $this->specCharCheck($outputLabel);
						$this->db->LogWrite($this->Qvariable,true,"inside L, set T question text");
					}
				} elseif ($this->setSwitch['C'] == true) {
					$this->project[$this->C_cnt]['sub_name'][$this->L_cnt] = $row['controlCode_label'];
					$this->db->LogWrite($this->C_cnt,true,"inside L, set C question text");
				} else {
					$this->db->LogWrite($this->Qvariable,true,"inside L, set nothing");
				}
				
				$this->L_cnt++;
				break;
			
			case "S";
				$this->S_cnt++;
				$this->Q_cnt = 0;
				$this->S_guide = true;
				
				$this->setSwitch['S'] = true;
				$this->setSwitch['A'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['X'] = false;
				$this->setSwitch['Q'] = false;
				$this->setSwitch['T'] = false;
				$this->setSwitch['C'] = false;
				
				$this->Qvariable = $this->getSQname($this->S_cnt,$this->Q_cnt);
				$this->Svariable = $this->getSname($this->S_cnt);
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['type'] = 5; // info qustion
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['subtype'] = 1; // as radio
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 1; // show question
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['must_answer'] = 0; // disable must answer
				
				$this->db->LogWrite($this->S_cnt.":S and Q:".$this->Q_cnt,true,"inside S");
				$this->L_cnt = 0;
				break;
			
			case "T";
				$this->setSwitch['T'] = true;
				$this->setSwitch['A'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['X'] = false;
				$this->setSwitch['S'] = false; // izklopim S ker sem ze opravil z info vprasanjem
				$this->setSwitch['MBRX'] = false;
				$this->setSwitch['MBRX_A'] = false;
				$this->AnswerCode = null;
				$this->Qlgn_cnt = 0;
				$this->Q_cnt++;
				$this->Qvariable = $this->getSQname($this->S_cnt,$this->Q_cnt);
				
				// ce je izklopljen grid prikaz se obnasam kot da Tja ni
				if (strtoupper($row['variable']) == "NOSHOW") {
					$this->setSwitch['T'] = false;
					$this->db->LogWrite($this->setSwitch['T'],true,"inside T, check NOSHOW - setSwitch = ");
				}
				
				$this->db->LogWrite($this->setSwitch['T'],true,"inside T, setSwitch");

				$this->L_cnt = 0;
				break;
			
			case "Q";
				$this->setSwitch['Q'] = true;
				$this->setSwitch['A'] = false;
				$this->setSwitch['X'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['S'] = false;
				$this->setSwitch['MBRX'] = false;
				$this->setSwitch['MBRX_A'] = false;
				$this->S_read_guide = false; // I set on all Q this to false, at this point I do not know if this will be instructions for me
				$this->AnswerCode = null;
				$this->db->LogWrite("controlCode_label:".$row['controlCode_label']." --- variable:".$row['variable'],true,"inside Q");
				
				if ($this->setSwitch['T'] == true) { 
					$this->db->LogWrite("set type to 2",true,"inside Q");
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['type'] = 2; // default is scale
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['subtype'] = 1; // as radio
					
					$this->showLegend = true;
					$this->Qlgn_cnt++;
				} else {
					$this->Q_cnt++;
					$this->Qvariable = $this->getSQname($this->S_cnt,$this->Q_cnt);
					
					$this->db->LogWrite("set type to 1",true,"inside Q");
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['type'] = 1; // single
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['subtype'] = 1; // as radio
				}	
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 1; // show question
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['must_answer'] = 0; // disable must answer
				$this->db->LogWrite($this->Qvariable,true,"inside Q, Qvariable");
				$this->db->LogWrite($this->S_guide,true,"inside Q, S_guide");
				
				// preverim MRBX kodo, ce je noter, ne naredim nic, razen ce je seveda to koda za navodilo za sklop
				if ($row['controlCode_label'] == "MRBX") {
					if ($this->setSwitch['T'] == true) {
						$this->showLegend = false;
						$this->Qlgn_cnt--;
						$this->db->LogWrite("removing legend because of MRBX record",true,"inside Q, T is set");
					} else {
						if ($this->S_guide == true) {
							$this->MBRX_cnt = 0;
							$this->S_read_guide = true;
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 0; // hide question
							$this->db->LogWrite("setting S_read_guide to true",true,"inside Q");
						}
					}
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 0; // hide question
					// after first MBRX I try to read guide for whole S, if possible, if not I disable reading till end of S
				}
				
									
				$this->S_guide = false; // ce ni navodil na prvem Q zapisu po S, potem preskocim navodila in jih ne iscem vec
				$this->L_cnt = 0;
				break;
			
			case "V";
				// ne nardim nič, izklopim samo S in Q
				$this->setSwitch['S'] = false;
				$this->setSwitch['Q'] = false;
				$this->setSwitch['A'] = false;
				
				$this->AnswerCode = strtoupper($row['variable']);
				$this->db->LogWrite("setting S, Q and A to false, AnswerCode:".$this->AnswerCode,true,"inside V");
				
				$this->storeAnswers[$this->AnswerCode] = $this->project[$this->C_cnt]['name'];
				$this->storeQuestions[$this->AnswerCode] = $this->Qvariable;
				$this->db->LogWrite($this->AnswerCode."-->".$this->project[$this->C_cnt]['name'],true,"inside V, store answer");
				
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'])) {
					$this->db->LogWrite("show answer is set".print_r($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'],1),true,"inside V");
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'])) {
						$this->db->LogWrite("answerCode found in show_answer array",true,"inside V");
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 1; // show answer
						$this->setSwitch['V'] = true;
					} else {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 0; // hide answer
					}
				} else {
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 0; // hide answer
				}
						
				$this->L_cnt = 0;
				break;
			
			case "A";
				$this->setSwitch['A'] = true;
				$this->setSwitch['Q'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['X'] = false;
				$this->setSwitch['MBRX'] = false;
				$this->showLegend = false;
				
				$this->AnswerCode = null;
				$this->keyword = null;

				$this->AnswerCode = strtoupper($row['variable']);
				$keyword_arr = explode("_",$this->AnswerCode);
				
				$this->storeAnswers[$this->AnswerCode] = $this->project[$this->C_cnt]['name'];
				$this->storeQuestions[$this->AnswerCode] = $this->Qvariable;
				$this->db->LogWrite($this->AnswerCode."-->".$this->project[$this->C_cnt]['name'],true,"inside A, store answer");
				
				// preverim MRBX kodo, ce je noter navodilo za sklop
				if ($row['controlCode_label'] == "MRBX" AND substr($keyword_arr[1],0,3) == "WEB") {
					// ce imam za precitat definicijo grem tole naredit
					if ($this->S_read_guide == true) {
						$this->MBRX_cnt++;
						$this->keyword = $keyword_arr[1]; 
						
						$this->db->LogWrite("S_read_guide = true --- MBRX counter:".$this->MBRX_cnt,true,"inside A, MRBX check");
					}
												
					$this->db->LogWrite("setSwitch A:".$this->setSwitch['A']." --- controlCode_label:".$row['controlCode_label'],true,"inside A, MRBX check");
				} elseif ($row['controlCode_label'] == "MRBX") {
					if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer']) AND $this->AnswerCode) {
						// check if answer should be shown (no matter if MBRX is set)
						if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'])) {
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 1; // show answer
							$this->showLegend = true;  // in L, I check if it is T set and showLegend true, I add answer under legend
							$this->db->LogWrite("show answer",true,"inside A, keyword check");
							
							// add keyword to answer array to check if answer is repeated (control for rotated grids)
							if (in_array($this->AnswerCode,$this->keywordAnswerCheck)) {
								$this->project[$this->C_cnt]['question'][$this->Qvariable]['legend'][$this->Qlgn_cnt]['hide'] = 1;
								$this->db->LogWrite($this->AnswerCode,true,"inside A, MBRX, answer exists, after guide");
							} else {
								$this->keywordAnswerCheck[] = $this->AnswerCode;
								$this->db->LogWrite($this->AnswerCode,true,"inside A, MBRX, store answer check, after guide");
							}
						} else {
							$this->setSwitch['A'] = false;
							$this->setSwitch['MBRX'] = true;
							$this->db->LogWrite("false",true,"inside A, set switch A (upper)");
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 0; // hide answer
						}
					} else {
						$this->setSwitch['A'] = false;
						$this->setSwitch['MBRX'] = true;
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 0; // hide answer
						$this->db->LogWrite("false",true,"inside A, set switch A (lower)");
					}
				} else {
					$this->db->LogWrite($row['controlCode_label'],true,"inside A, not MBRX");
					
					if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_answer']) AND $this->AnswerCode) {
						if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_answer'])) {
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 0; // hide answer
							$this->db->LogWrite("hide answer",true,"inside A, keyword check");
							$this->setSwitch['A'] = false;
						} else {
							$this->db->LogWrite($this->AnswerCode,true,"inside A, not MBRX, set to visible, array check not true");
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 1; // show answer
							$this->showLegend = true;  // in L, I check if it is T set and showLegend true, I add answer under legend
							
							// add keyword to answer array to check if answer is repeated (control for rotated grids)
							if (in_array($this->AnswerCode,$this->keywordAnswerCheck)) {
								$this->project[$this->C_cnt]['question'][$this->Qvariable]['legend'][$this->Qlgn_cnt]['hide'] = 1;
								$this->db->LogWrite($this->AnswerCode,true,"inside A, not MBRX, answer exists, after guide");
							} else {
								$this->keywordAnswerCheck[] = $this->AnswerCode;
								$this->db->LogWrite($this->AnswerCode,true,"inside A, not MBRX, store answer check, after guide");
							}
						}
					} else {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 1; // show answer
						$this->db->LogWrite("show answer",true,"inside A, not MBRX");
						$this->showLegend = true;  // in L, I check if it is T set and showLegend true, I add answer under legend
						
						// add keyword to answer array to check if answer is repeated (control for rotated grids)
						if (in_array($this->AnswerCode,$this->keywordAnswerCheck)) {
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['legend'][$this->Qlgn_cnt]['hide'] = 1;
							$this->db->LogWrite($this->AnswerCode,true,"inside A, not MBRX, answer exists, not guide");
						} else {
							$this->keywordAnswerCheck[] = $this->AnswerCode;
							$this->db->LogWrite($this->AnswerCode,true,"inside A, not MBRX, store answer check, not guide");
						}
					}
				}
				
				
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question']) AND $this->AnswerCode) {
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question'])) {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 1; // show question
						$this->setSwitch['A'] = true;
						$this->db->LogWrite("show question",true,"inside A, keyword check");
						
						// because question is shown additionaly, I must by default show also all answers, I hide only if somethin is psecified indide WEB3
						$this->setSwitch['MBRX_A'] = true;
					}
				}
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_question']) AND $this->AnswerCode) {	
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_question'])) {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 0; // hide question
						$this->setSwitch['A'] = false;
						$this->db->LogWrite("hide question",true,"inside A, keyword check");
					}
				}
				
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_grid']) AND $this->AnswerCode) {				
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_grid'])) {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 0; // hide grid question
						$this->db->LogWrite("disable grid question",true,"inside T, check guide");
					}
				}
				
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['multi']) AND $this->AnswerCode) {
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['multi'])) {
						if ($this->project[$this->C_cnt]['question'][$this->Qvariable]['type'] == 1) {
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['type'] = 3; // multi
							$this->db->LogWrite("multi",true,"inside A, keyword check");
						} elseif ($this->project[$this->C_cnt]['question'][$this->Qvariable]['type'] == 2) {
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['type'] = 3; // multi
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['subtype'] = 4; // checkox legend
							$this->db->LogWrite("multi legend checked",true,"inside A, keyword check");
						}
					}
				}
				
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer']) AND $this->AnswerCode) {
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer'])) {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['must_answer'] = 1; // must answer
						$this->db->LogWrite("must_answer",true,"inside A, keyword check");
					}
				}
				
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_image']) AND $this->AnswerCode) {
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_image'])) {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['show_image'] = 1; // show_image
						$this->db->LogWrite("show_image",true,"inside A, keyword check");
					}
				}
				
				$this->db->LogWrite("AnswerCode:".$this->AnswerCode." --- controlCode_label:".$row['controlCode_label'],true,"inside A");
							
				$this->L_cnt = 0;
				break;
			
			case "X";
				$this->setSwitch['X'] = true;
				$this->setSwitch['Q'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['A'] = false;
				$this->showLegend = false; // if I do not have any answer under legend, I unset the legend
				$this->AnswerCode = strtoupper($row['variable']);
				
				$this->db->LogWrite("S:".$this->setSwitch['S']." - "."Q:".$this->setSwitch['Q']." - "."A:".$this->setSwitch['A']." - "."T:".$this->setSwitch['T'],true,"inside X");
				$this->db->LogWrite($this->AnswerCode." --- legend counter:".$this->Qlgn_cnt,true,"inside X, AnswerCode");					
				
				// ce imam vklopljen T moram izbrisat legendo, ker tudi odgovorov nimam, za vse jezike naenkrat
				if ($this->setSwitch['T'] == true) { 
					if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer']) AND $this->AnswerCode) {
						if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'])) {
							$this->showLegend = true;
							$this->db->LogWrite("show legend item",true,"inside X, T is set, keyword check");
						} else {
							$this->db->LogWrite("hide legend item",true,"inside X, T is set, keyword check");
						}
					}
				}
				
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_grid']) AND $this->AnswerCode) {				
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_grid'])) {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 0; // hide grid question
						$this->db->LogWrite("disable grid question",true,"inside X, check hide grid guide");
					}
				}
								
				$this->L_cnt = 0;
				break;
				
			case "Z":
				// ne nardim nič, načeloma je to zadnja ddf vrstica
				
				$QuestEnd = true;
				$this->L_cnt = 0;
				break;
		}
		 
	}
	
	
	protected function getSQname($Scnt,$Qcnt) {
		if ($Scnt<10) 
			$Szero = "00".$Scnt;
		else if ($Scnt<100 AND $Scnt>9) 
			$Szero = "0".$Scnt;
		else
			$Szero = $Scnt;
			
			
		if ($Qcnt<10) 
			$Qzero = "00".$Qcnt;
		else if ($Qcnt<100 AND $Qcnt>9) 
			$Qzero = "0".$Qcnt;
		else
			$Qzero = $Qcnt;
			
		return "S".$Szero."Q".$Qzero;
	}
	
	
	protected function specCharCheck($str) {
		$str = str_replace(array("\t","\r\n","\n","\r","/"),array(" ","<br>","<br>","<br>","&#47;"),$str);
		return $str;
	}
	
	
	protected function getSname($Scnt) {
		if ($Scnt<10) 
			$Szero = "00".$Scnt;
		else if ($Scnt<100 AND $Scnt>9) 
			$Szero = "0".$Scnt;
		else
			$Szero = $Scnt;
			
		return "S".$Szero;
	}
	
	
	public function readDDF($id_project) {
		$this->getTGIoptions();
		
		try {
			$sql = "SELECT * FROM ".$this->getActiveProjectName($id_project)."___import";
			$this->db->LogWrite($sql,true,"vcitam komplet DDF vprasalnik");
			$result = $this->db->SQLexecute($sql);
			while ($row = mysql_fetch_array($result)) {
				$this->checkRow($row); 
			}
			
			return true;
		}	
		catch (Exception $e)
		{
		    $this->db->LogWrite($e->getMessage(),true,"error creating XML->warpit");
		    return false;
		}
	}

}	

?>