<?php

Route::get('/',     'App\Controllers\V2\UtilitiesController@welcome');
Route::get('/doc', 'App\Controllers\V2\UtilitiesController@docs');
Route::get('/examples', 'App\Controllers\V2\UtilitiesController@examples');
Route::get('/ping', 'App\Controllers\V2\UtilitiesController@ping');

Route::get(
    '/phpinfo',
            'App\Middleware\BasicAuth@authenticate',
            'App\Controllers\V2\UtilitiesController@phpinfo'
);

Route::get(
    '/testZone',
            'App\Controllers\V2\UtilitiesController@testZone'
);

Route::post(
    '/v1/users',
            'App\Middleware\BasicAuth@authenticate',
            'App\Controllers\V1\UserController@addUser'
);

Route::get(
    '/v1/users/search',
          'App\Middleware\BasicAuth@authenticate',
          'App\Controllers\V1\UserController@searchUsers'
);

Route::get(
    '/v1/users/{id}',
          'App\Middleware\BasicAuth@authenticate',
          'App\Controllers\V1\UserController@getUser'
);

Route::post(
    '/v1/users/{id}/points',
            'App\Middleware\BasicAuth@authenticate',
            'App\Controllers\V1\UserController@addOrSubtractPoints'
);

Route::post(
    '/v1/transfer',
            'App\Middleware\BasicAuth@authenticate',
            'App\Controllers\V1\UserController@transfer'
);

Route::get(
    '/v1/users/{id}/surveys',
            'App\Middleware\BasicAuth@authenticate',
            'App\Controllers\V1\UserController@getUserSurveys'
);

Route::get(
    '/v1/users/{id}/surveys/{surveyId}',
          'App\Middleware\BasicAuth@authenticate',
          'App\Controllers\V1\SurveyController@createSurveyLink'
);

Route::get(
    '/v1/survey/{surveyId}/unique_link',
          'App\Middleware\BasicAuth@authenticate',
          'App\Controllers\V1\SurveyController@createUniqueLink'
);

Route::get(
    '/v1/users/{id}/surveys_percent_answered',
            'App\Middleware\BasicAuth@authenticate',
            'App\Controllers\V1\UserController@getQuestionPosition'
);

Route::get(
    '/v1/users/{id}/surveys_activity_of_user',
           'App\Middleware\BasicAuth@authenticate',
           'App\Controllers\V1\UserController@surveysActivityOfUser'
);

Route::get(
    '/v1/users/{id}/{filter}/points_activity_of_user',
            'App\Middleware\BasicAuth@authenticate',
            'App\Controllers\V1\UserController@pointsActivityOfUser'
);

//onboarding questionare
Route::get(
    '/v1/users/{id}/getonboarding',
            'App\Middleware\BasicAuth@authenticate',
            'App\Controllers\V1\SurveyController@getOnboardingQuestionare'
);

//get user points earning and loss
Route::get(
    '/v1/users/{id}/get_user_points_earning_loss',
            'App\Middleware\BasicAuth@authenticate',
            'App\Controllers\V1\UserController@getUserPointsEarningLoss'
);

//V2
//Project
Route::post(
    '/v2/project',
             'App\Middleware\BasicAuth@authenticate',
             'App\Middleware\DefaultLanguage@setDefault',
             'App\Middleware\ProjectNameConverter@toProjectName',
             'App\Controllers\V2\ProjectController@create'
);

Route::delete(
    '/v2/project',
              'App\Middleware\BasicAuth@authenticate',
              'App\Middleware\DefaultLanguage@setDefault',
              'App\Middleware\ProjectNameConverter@toProjectName',
              'App\Controllers\V2\ProjectController@delete'
);

Route::get(
    '/v2/project',
              'App\Middleware\BasicAuth@authenticate',
              'App\Middleware\DefaultLanguage@setDefault',
              'App\Middleware\ProjectNameConverter@toProjectName',
              'App\Controllers\V2\ProjectController@get'
);

Route::post(
    '/v2/project/folder',
            'App\Middleware\BasicAuth@authenticate',
            'App\Controllers\V2\ProjectController@createFolder'
);

//Question
Route::post(
    '/v2/question',
            'App\Middleware\BasicAuth@authenticate',
            'App\Middleware\DefaultLanguage@setDefault',
            'App\Middleware\ProjectNameConverter@toProjectName',
            'App\Controllers\V2\QuestionController@create'
);

Route::get(
    '/v2/question',
          'App\Middleware\BasicAuth@authenticate',
          'App\Middleware\DefaultLanguage@setDefault',
          'App\Middleware\ProjectNameConverter@toProjectName',
          'App\Controllers\V2\QuestionController@get'
);

Route::delete(
    '/v2/question',
              'App\Middleware\BasicAuth@authenticate',
              'App\Middleware\DefaultLanguage@setDefault',
              'App\Middleware\ProjectNameConverter@toProjectName',
              'App\Controllers\V2\QuestionController@delete'
);

Route::get(
    '/v2/question/property',
          'App\Middleware\BasicAuth@authenticate',
          'App\Middleware\DefaultLanguage@setDefault',
          'App\Middleware\ProjectNameConverter@toProjectName',
          'App\Controllers\V2\QuestionController@getProperty'
);

Route::post(
    '/v2/question/answers',
            'App\Middleware\BasicAuth@authenticate',
            'App\Middleware\DefaultLanguage@setDefault',
            'App\Middleware\ProjectNameConverter@toProjectName',
            'App\Controllers\V2\QuestionController@addAnswers'
);

Route::get(
    '/v2/question/answers',
            'App\Middleware\BasicAuth@authenticate',
            'App\Middleware\DefaultLanguage@setDefault',
            'App\Middleware\ProjectNameConverter@toProjectName',
            'App\Controllers\V2\QuestionController@getAnswers'
);

Route::delete(
    '/v2/question/answers',
            'App\Middleware\BasicAuth@authenticate',
            'App\Middleware\DefaultLanguage@setDefault',
            'App\Middleware\ProjectNameConverter@toProjectName',
            'App\Controllers\V2\QuestionController@deleteAnswer'
);

Route::post(
    '/v2/question/text',
            'App\Middleware\BasicAuth@authenticate',
            'App\Middleware\DefaultLanguage@setDefault',
            'App\Middleware\ProjectNameConverter@toProjectName',
            'App\Controllers\V2\QuestionController@addQuestionText'
);

Route::get(
    '/v2/question/text',
            'App\Middleware\BasicAuth@authenticate',
            'App\Middleware\DefaultLanguage@setDefault',
            'App\Middleware\ProjectNameConverter@toProjectName',
            'App\Controllers\V2\QuestionController@getQuestionText'
);

Route::get('/v2/email/response/{interviwerId}/{mailset}',
              'App\Controllers\V2\EmailController@response'
);

Route::get('/v2/panelist/fields', 'App\Middleware\BasicAuth@authenticate', 'App\Controllers\V2\PanelistController@getFields');

Route::get('/v2/panelist/{id}/allowedToLogin', 'App\Middleware\BasicAuth@authenticate', 'App\Controllers\V2\PanelistController@allowedToLogin');
Route::post('/v2/panelist/{id}/removalRequest', 'App\Middleware\BasicAuth@authenticate', 'App\Controllers\V2\PanelistController@addRemovalRequestStatus');

Route::get('/v2/panelist/{id}', 'App\Middleware\BasicAuth@authenticate', 'App\Controllers\V2\PanelistController@get');
Route::post('/v2/panelist/{id}', 'App\Middleware\BasicAuth@authenticate', 'App\Controllers\V2\PanelistController@update');


Route::get('/v2/project/{id}/data/export/csv',
    'App\Middleware\BasicAuth@authenticate',
    'App\Controllers\V2\ExportProjectDataController@getCSV');

Route::get('/v2/exportTemplate/{templateId}/data/csv',
    'App\Middleware\BasicAuth@authenticate',
    'App\Controllers\V2\ExportTemplateDataController@getCSV');

Route::get('/v2/projects',
    'App\Middleware\BasicAuth@authenticate',
    'App\Controllers\V2\ProjectsController@get');

Route::get('/v2/panelist/{id}/points',
    'App\Middleware\BasicAuth@authenticate',
    'App\Controllers\V2\PanelistController@getPoints');
