<?php

namespace App\Transformers;

use App\Entities\Question;

class QuestionTransformer
{
    public function transform($questionData)
    {
      if (count($questionsData) <= 0) {
          return null;
      }

      if (count($questionsData) == 1) {
          return Question::createQuestion($questionsData->first());
      }

      $questions = [];
      foreach ($questionsData as $question) {
          $questions[] = Question::createQuestion($question);
      }

      return $questions;
    }
}
