<?php

namespace App\Services;

use App\Repositories\MailStatisticsRepository;

class MailStatisticsService
{
    protected $mailStatisticsRepository;

    public function __construct(MailStatisticsRepository $mailStatisticsRepository)
    {
            $this->mailStatisticsRepository = $mailStatisticsRepository;
    }

    public function create($mailSetId, $addresses)
    {
        $records = [];
        foreach($addresses as $address){
            $records[] = [
                'mail_set'       => $mailSetId,
                'interviewer_id' => $address->id,
                'mail_address'   => $address->email,
                'mail_status'    => 2,
            ];
        }

        $this->mailStatisticsRepository->create($records);
    }
}