<?php

namespace App\Services;
use App\Repositories\EmailRepository;
use App\Services\WarpitConfigService;

class EmailService
{
    public function __construct(WarpitConfigService $config, EmailRepository $emailRepository)
    {
        $this->config = $config;
        $this->emailRepository = $emailRepository;
    }

    public function markAsRead($interviwerId, $mailset, $token)
    {
          $warpitRoot = $this->config->getConfig('paths', 'warpit_absolute');
          $pixelImage = $warpitRoot . 'survey/piksel.png';

          $emailAddress = $this->emailRepository->getAddress($interviwerId, $mailset);
          $expectedToken = $this->generateToken($interviwerId, $mailset, $emailAddress);

          if($token === $expectedToken){
            $this->emailRepository->markAsRead($interviwerId, $mailset, $emailAddress);
          }

          return $pixelImage;
    }

    private function generateToken($interviwerId, $mailSet, $email)
    {
        return substr(md5($email . $interviwerId . $mailSet), 0, 24);
    }
}
