<?php

namespace App\Routing;

use SolveX\Routing\Route as SolveXRoute;
use SolveX\Exceptions\NotFoundHttpException;

/**
 * Routing.
 *
 */
class Route extends SolveXRoute
{
    /**
     * Actually perform action registered with routes, subject
     * to incoming request.
     */
    public function dispatch()
    {
        $routes = $this->routes;
        $dispatcher = \FastRoute\simpleDispatcher(function(\FastRoute\RouteCollector $routeCollector) use($routes) {
            foreach ($routes as $route)
                $routeCollector->addRoute($route['method'], $route['path'], $route);
        });

        $request = $this->request;
        $routeInfo = $dispatcher->dispatch($request->method(), $request->path());
        if ($routeInfo[0] === \FastRoute\Dispatcher::NOT_FOUND ||
            $routeInfo[0] === \FastRoute\Dispatcher::METHOD_NOT_ALLOWED)
            throw new NotFoundHttpException; // Check your routes.php!

        $route = $routeInfo[1];

        $parameters  = $routeInfo[2];
        $currentPath = $route['path'];

        $this->request->setQueryParams($parameters);
        $this->request->setCurrentRoute($currentPath);

        $this->callMiddlewareAndRoute($route, $parameters);
    }



}
