<?php

namespace App\Repositories\ProjectManager\Projects;

use App\Repositories\BaseRepository;
use Carbon\Carbon;

class NotActiveProjectRepository extends BaseRepository
{
    public function get($minDate)
    {
        return $this
                ->webcatiBaseConnection
                ->select("SELECT p.id, p.proj_name, p.active, s.startDate,p.anonymization_datetime
                                FROM _Projects as p 
                                LEFT JOIN (SELECT  * FROM (SELECT id_project, startDate FROM _www_interviewer_statistics ORDER BY id_project DESC) as x GROUP BY x.id_project) as s
                                ON p.id = s.id_project
                                WHERE p.active = 0 AND s.startDate < ? AND p.end_date < ?", [$minDate, Carbon::now()]);
    }
}