<?php

namespace App\Repositories;

use Carbon\Carbon;

class PanelistStatusRepository extends BaseRepository
{
    protected $table = '_InterviewerStatuses';

    public function insert($panelistId, $status)
    {
        $this
            ->webuserspool
            ->table($this->table)
            ->insert([
                'interviewer_id' => $panelistId,
                'definedStatus'  => $status,
                'definedDate'    => Carbon::now()->toDateTimeString(),
            ]);
    }

    public function get($panelistId)
    {
        return $this
            ->webuserspool
            ->table($this->table)
            ->select('definedStatus')
            ->where('interviewer_id', $panelistId)
            ->orderBy('definedDate', 'DESC')
            ->get()
            ;
    }

    public function update($panelistId, $status)
    {
        $this
            ->webuserspool
            ->table($this->table)
            ->where('interviewer_id', $panelistId)
            ->update(['definedStatus' => $status]);

    }
}