<?php

namespace App\Repositories;


use Carbon\Carbon;
use DB;

class MailSetRepository extends BaseRepository
{
    public function create($groupId, $templateId, $projectId = 0, $projectType = 0, $customFields = null)
    {
        return DB::table('_SendMailSet')
            ->insertGetId([
                'date_queue'    => Carbon::now()->toDateTimeString(),
                'date_schedule' => Carbon::now()->toDateTimeString(),
                'id_project'    => $projectId,
                'project_type'  => $projectType,
                'id_template'   => $templateId,
                'id_user'       => -1,
                'id_group'      => $groupId,
                'status'        => 3,
                'custom_fields' => $customFields,
            ]);
    }
}
