<?php

namespace App\Middleware;

use SolveX\Interfaces\RequestInterface as Request;
use App\Repositories\ProjectRepository;

class ProjectNameConverter
{
    public function __construct(ProjectRepository $projectRepository)
    {
        $this->projectRepository = $projectRepository;
    }

    public function toProjectName(Request $request)
    {
        if(!$request->has('projectName')){
            return;
        }

        $projectName = $request->input('projectName');
        if (ctype_digit($projectName)) {
            $projectName = $this->projectRepository->getProjectName($projectName);
        }

        $request->set('projectName', $projectName);
    }
}
