<?php

namespace App\Middleware;

use SolveX\Interfaces\RequestInterface as Request;
use App\Services\WarpitConfigService;

class DefaultLanguage
{
    public function __construct(WarpitConfigService $warpitConfigService)
    {
        $this->warpitConfigService = $warpitConfigService;
    }

    public function setDefault(Request $request)
    {
        $defaultLanguageId = $this
                              ->warpitConfigService
                              ->getConfig('multilanguage', 'id_default_language', 91);

        $request->set('languageId', $defaultLanguageId);
    }
}
