<?php

namespace App\Http;

class Response
{
    /**
     * Throw an HttpException with the given data.
     *
     * @param  int     $code
     * @param  string  $message
     * @param  array   $headers
     */
    public function abort($code, $message = '', $headers = [])
    {
        if ($code == 404) {
            throw new \SolveX\Exceptions\NotFoundHttpException($message);
        }

        throw new \SolveX\Exceptions\HttpException($code, $message, null, $headers);
    }

    public function msg($code, $message = '')
    {
        return ['code' => $code, 'message' => $message];
    }

    public function error($message, $code = 400)
    {
        return $this->msg($code, $message);
    }
}
