<?php

namespace App\Http;

use SolveX\Http\Request as Req;
use SolveX\ViewModel\DataSourceInterface as DSI;

class Request extends Req implements DSI
{
    protected $queryParams = [];

    protected $currentRoute = null;

    public function setQueryParams(array $queryParams)
    {
        $this->queryParams = $queryParams;
    }

    public function set($key, $value)
    {
        $this->params[$key] = $value;
    }

    public function get($key)
    {
        if($this->has($key)){
          return $this->input($key);
        }
        //TODO check query parameters in has method
        return $this->queryParams[$key];
    }

    public function setCurrentRoute($currentRoute)
    {
        $this->currentRoute = $currentRoute;
    }

    public function getCurrentRoute()
    {
        return $this->currentRoute;
    }
}
