<?php

namespace App\Exceptions;

use SolveX\Exceptions\Handler as BaseHandler;
use SolveX\Exceptions\NotFoundHttpException;
use SolveX\Exceptions\HttpException;
use SolveX\ViewModel\ValidationException;
use App\Exceptions\RuntimeException;
use Exception;
use Response;

class Handler extends BaseHandler
{
    public function handle(Exception $exception)
    {
        if ($exception instanceof ValidationException) {
            $this->toJson(400, 'Invalid parameters');
        } elseif ($exception instanceof RuntimeException) {
            $this->toJson($exception->getCode(), $exception->getMessage());
        } else {
            parent::handle($exception);
        }
    }

    public function toJson($status, $message)
    {
        header('Content-Type: application/json');
        http_response_code($status);
        echo(json_encode([
            'code'    => $status,
            'message' => $message,
        ]));
    }
}
