<?php

namespace App\Entities;

use Exception;

/**
 * Base class for entities to extend.
 */
class BaseEntity
{
    public  $mapper = [];

    public static function create($class, $data)
    {
        $object = new $class();
        $properties = get_object_vars($object);

        foreach(array_keys($properties) as $property){

            $dataProperty = array_search($property,$object->mapper);

            if($dataProperty === false){
                $dataProperty = $property;
            }
            if(property_exists($data,$dataProperty) === true){
                $object->$property = $data->$dataProperty;
            }

        }

        return $object;
    }

    /**
     * Magic method __set() is run when writing data to inaccessible properties
     * (those that do not exist or are private/protected).
     * We're using this to prevent typo errors.
     */
    public function __set($name, $value)
    {
        throw new Exception('Trying to set an invalid property on an entity!');
    }
}
