<?php

namespace App\Controllers\V2;

use SolveX\Interfaces\RequestInterface as Request;
use App\Services\QuestionService;
use App\Services\AnswerService;
use App\ViewModel\QuestionViewModel;
use App\ViewModel\QuestionTextViewModel;
use App\ViewModel\QuestionPropertyViewModel;
use App\ViewModel\AnswerViewModel;
use Response;
use \Exception;

class QuestionController
{
    public function __construct(QuestionService $questionService, AnswerService $answerService)
    {
        $this->questionService = $questionService;
        $this->answerService   = $answerService;
    }

    public function create(QuestionViewModel $model)
    {
        return $this->questionService->create($model->questionName,
                                              $model->type,
                                              $model->projectName,
                                              $model->questionName
                                            );
    }

    public function get(QuestionViewModel $model)
    {
        return $this->questionService->getIfExists($model->questionName,$model->projectName, $model->languageId);
    }


    public function delete(QuestionViewModel $model)
    {
        return $this->questionService->delete($model->questionName, $model->projectName, $model->languageId);
    }

    public function addAnswers(AnswerViewModel $model)
    {

        return $this
                ->answerService
                ->addAnswer($model->questionName,
                      $model->projectName,
                      $model->answerValue,
                      $model->answerLabel,
                      $model->languageId);
      }

    public function getAnswers(QuestionViewModel $model)
    {
        return $this->answerService->getAnswers($model->questionName, $model->projectName, $model->languageId);;
    }

    public function deleteAnswer(AnswerViewModel $model)
    {
        return $this
                  ->answerService
                  ->deleteAnswer($model->questionName,
                                $model->projectName,
                                $model->answerValue,
                                $model->languageId);
    }

    public function getProperty(QuestionPropertyViewModel $model)
    {
        return $this
                ->questionService
                ->getPropertyValue($model->questionName, $model->projectName, $model->propertyName, $model->languageId);
    }

    public function addQuestionText(QuestionTextViewModel $model)
    {

        return $this
                  ->questionService
                  ->addQuestionText($model->questionName,
                                $model->projectName,
                                $model->questionText,
                                $model->languageId);
    }

    public function getQuestionText(QuestionViewModel $model)
    {
        return $this
                  ->questionService
                  ->getQuestionText(
                      $model->questionName,
                      $model->projectName,
                      $model->languageId);
    }
}
