<?php

namespace App\Controllers\V2;

use App\Services\PanelistService;
use App\Exceptions\RuntimeException;
use SolveX\Interfaces\RequestInterface as Request;

class PanelistController
{
    public function allowedToLogin(PanelistService $panelistService, $panelistId)
    {
        $allowLogin = $panelistService->allowedToLogin($panelistId);
        return ['canLogin' => $allowLogin];
    }

    public function addRemovalRequestStatus(PanelistService $panelistService, $panelistId)
    {
        $panelistService->addRemovalRequestStatus($panelistId);
        return ['success' => true];
    }

    public function get(PanelistService $panelistService, $panelistId)
    {
        return $panelistService->get($panelistId);
    }

    public function update(Request $request, PanelistService $panelistService, $panelistId)
    {
        if(!$request->has('fields')){
            return false;
        }

        $fields = json_decode($request->input('fields'), true);

        if($fields === false || $fields === null){
            throw new RuntimeException('Input fields are missing or are malformed!');
        }

        $panelistService->update($panelistId, $fields);

        return $panelistService->get($panelistId);
    }

    public function getPoints(PanelistService $panelistService, $panelistId)
    {
        if($panelistService->get($panelistId) === null){
            throw new RuntimeException('Panelist doesn\'t exists', 400);
        }

        return $panelistService->getPoints($panelistId);
    }

    public function getFields(Request $request, PanelistService $panelistService)
    {
      if(!$request->has('fields')){
          throw new RuntimeException('No sufficient data', 400);
      }

      $fields = $request->get('fields');
      $data = [];

      for ($i=0; $i < count($fields); $i++) {
        $data[$fields[$i]] = $panelistService->getFieldWithLabels($fields[$i]);
      }

      return $data;
    }
}
