<?php

namespace App\Controllers\V2;

use App\Http\Request;
use App\Services\ProjectService;
use App\Services\ProjectManager\Projects\ExportProjectDataService;
use App\Services\StructureTableService;

class ExportProjectDataController
{
    protected $exportProjectService = null;

    protected $projectService = null;

    protected $structureTableService = null;

    public function __construct(ExportProjectDataService $exportProjectService,
                                ProjectService $projectService,
                                StructureTableService $structureTableService)
    {
        $this->exportProjectService = $exportProjectService;
        $this->projectService = $projectService;
        $this->structureTableService = $structureTableService;
    }

    public function getCSV(Request $request, $projectId)
    {
        $projectName = $this->projectService->getProjectById($projectId)->projectName;

        $excludedColumns = explode(',', $request->input('excludedColumns',''));

        $onlyValidRecords = filter_var(
            $request->input('onlyValidRecords', false),
            FILTER_VALIDATE_BOOLEAN
        );

        if($onlyValidRecords != false){
            $this->exportProjectService->validRecordsOnly();
        }

        if($this->projectService->projectExists($projectId) === false){
            throw new RuntimeException('Project doesn\'t exists!', 400);
        }

        $selectedColumns = array_diff(
            $this->structureTableService->getColumns($projectName),
            $excludedColumns
        );

        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=project_data.csv");
        header("Pragma: no-cache");
        header("Expires: 0");

        $this->exportProjectService->exportCSV($projectId, $selectedColumns);

        exit;
    }
}