<?php

include_once("_dirinfo.php");
require_once PATH_TO_ROOT .'/API/silex/vendor/autoload.php';
require_once PATH_TO_ROOT . '_class/createQuestion/Question.php';
require_once PATH_TO_ROOT .'/_config/dbConfig.php';

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;

$app = new Silex\Application();
//$app['debug'] = true;

function loadAllowedFields($db,$projName)
{
    $ids_question = $db->get($projName, '', 'id', DB_WARPIT_WEBCATI);
    $allowed =  [];
    foreach($ids_question as $id_question)
    {
        $q = Question::createQuestionFromTable($db, $projName, $id_question);
        $structFields = $q->getStructureFields();

        if(count($structFields))
          $allowed = array_merge($allowed, $structFields);
    }
    $allowed[] = 'status';
    $allowed[] = 'status_rec';
    return $allowed;

}

$app->before(function (Request $request, Silex\Application $app) use($db){
    $loginSID = $request->get('loginSID');
    $sql = "SELECT id FROM " . DB_WARPIT_WEBCATI_BASE . "._www_ids WHERE loginSID = '" . $loginSID ."'";
    $res = $db->SQLexecute($sql);

    if($db->NumRows($res) <= 0)
      return $app->json(['success' => false, 'errorCode' => 3, 'msg'=>'Not authorized!'], 401);

});

$app->post('/', function (Request $request) use($db)
{
  $id_project = $request->get('id_project');
  $id_record  = $request->get('id_record');
  $fields     = $request->get('fields');

  if(!$id_project || !$fields)
    return new JsonResponse(['success' => false, 'errorCode' => 4, 'msg'=>'Missing required fields'], 400);

  $projName = $db->get('_Projects', $id_project, 'proj_name', DB_WARPIT_WEBCATI_BASE);
  $structure = $projName . '_structure';

  if(!$projName)
    return new JsonResponse(['success' => false, 'errorCode' => 4, 'msg'=>'Project doesn\'t exists'], 400);

  $allowed = loadAllowedFields($db,$projName);


  $questions = array_keys($fields);
  $intersect = array_intersect($questions, $allowed);

  //we check if array contains database fields that we can't change
  if(count($intersect) != count($questions))
    return new JsonResponse(['success' => false, 'errorCode' => 1, 'msg'=>'Wrong fields!'], 400);
  $tmpSql = [];
  foreach ($fields as $q_name => $q_value)
  {
      if($q_value['type'] === 'integer' && !ctype_digit($q_value['value']))
        return new JsonResponse(['success' => false, 'errorCode' => 2, 'msg'=>'Wrong field type!'], 400);

      $tmpSql[] = $q_name . '=\'' . mysql_real_escape_string($q_value['value']) . '\'';
  }
  if(!$id_record)
      $sql = "INSERT INTO ";
  else
      $sql = "UPDATE ";

  $sql .=  DB_WARPIT_WEBCATI_BASE . "." . $structure . " ";
  $sql .= " SET " . implode(',', $tmpSql);

    if($id_record)
      $sql .= " WHERE id =  " . intval($id_record);

  $db->SQLexecute($sql);

  if(!$id_record)
    $id_record = $db->GetLastInsertId();

  $insertedData = $db->get($structure, $id_record, implode(',', $questions) .',id as id_record', DB_WARPIT_WEBCATI_BASE);

  return new JsonResponse($insertedData);
});

$app->run();
