<?php

include_once(PATH_TO_ROOT . "_class/createQuestion/MultiResponse.php");

class MultiResponseEPQ extends MultiResponse
{
    public function __construct(MultiResponse $q)
    {
        foreach(get_object_vars($q) as $property => $value){
            $this->$property = $value;
        }
    }

    protected function buildMustAnswerCondition($questionField)
    {
        return " strlen($" . $questionField . ") > 0 ";
    }

    public function getAnswersArray()
    {
        $legArr       = $this->PluginGetLegend();
        $fields       = $this->getStructureFields();
        $ansArr       = $this->PluginGetAnswers();
        $fieldsValues = $this->getFieldValues($fields);

        //this is something that warpit needs to have in order to remove unselected answers
        $_SESSION['questionFields'] =  array_merge($_SESSION['questionFields'], $fields);

        $answers = [];
        foreach ($ansArr as $answerKey => $answerData) {
            list($answerValue, $answerLabel) = $answerData;

            $answerIndex   = $answerKey + 1;
            $value         = $this->getSelectedValue($fieldsValues, $answerIndex);

            $legend = [];
            $legendMustAnswer = [];
            $selected = true;
            foreach($legArr as $legendKey => $legendData){
                list($legendValue, $legendLabel) = $legendData;

                $legendIndex = ($answerKey * count($legArr)) + ($legendKey);

                $questionField = $this->getQuestionField($fields, $legendIndex);

                $enteredValue = $fieldsValues[$questionField];
                $selected &= (strlen($enteredValue) > 0);
                $legend[] = [
                    'label'         => $this->display->readRequiredQuestionVariables($legendLabel),
                    'value'         => $enteredValue,
                //    'selected'      => $selected,
                    'questionField' => $questionField,
                ];

                $legendMustAnswer[] = $this->buildMustAnswerCondition($questionField);
            }

            $answers[] = [
                'label'         => $this->display->readRequiredQuestionVariables($answerLabel),
                'legend'        => $legend,
                'value'         => $answerValue,
                'hasValue'      => (bool)$selected,
            ];

            $pluginMustCondition[] = "(" . implode(" AND ", $legendMustAnswer) . ")";

        }
        $leaveCondition = implode(' AND ', $pluginMustCondition);
        $this->setMustAnswerCondition($leaveCondition);

        return $answers;
    }
}
