<?php

class DragToScaleQuestion extends Scale
{
    public function __construct(Scale $q)
    {
        foreach(get_object_vars($q) as $property => $value){
            $this->$property = $value;
        }
    }

    protected function buildMustAnswerCondition($questionField)
    {
        return " strlen($" . $questionField . ") > 0 ";
    }

    public function getAnswersArray()
    {
        $legArr       = $this->PluginGetLegend();
        $fields       = $this->getStructureFields();
        $ansArr       = $this->PluginGetAnswers();
        $fieldsValues = $this->getFieldValues($fields);

        //this is something that warpit needs to have in order to remove unselected answers
        $_SESSION['questionFields'] =  array_merge($_SESSION['questionFields'], $fields);

        $answers = [];
        foreach ($ansArr as $answerKey => $answerData) {
            list($answerValue, $answerLabel) = $answerData;

            $answerIndex   = $answerKey + 1;
            $value         = $this->getSelectedValue($fieldsValues, $answerIndex);

            $questionField = $fields[$answerKey];
            $selectedValue = $fieldsValues[$questionField];

            $answers[] = [
                'label'         => $this->display->readRequiredQuestionVariables($answerLabel),
                'value'         => $selectedValue,
                'questionField' => $questionField,
                'hasValue'      => strlen($selectedValue) > 0
            ];

            $pluginMustCondition[] = $this->buildMustAnswerCondition($questionField);

        }
        $leaveCondition = implode(' AND ', $pluginMustCondition);
        $this->setMustAnswerCondition($leaveCondition);

        return $answers;
    }
}
