$(function() {
	
	//radio gumb za 'No answer'
	$("#no_answer").change(function(){
		$("#slider").find(".ui-slider-handle").text("Default text");
		$("#slider").slider("value", 100 );
	});
	
	//skrivanje in prikazovanje lestvice
	$("#scale_points").prop("checked", true);
	$("#scale_points").change(function() {
		if($(this).is(":checked")){
			$(".steps").show();
			$("#min").css({"margin-top": "30px"});
			$("#max").css({"margin-top": "30px"});
		} else {
			$(".steps").hide();
			$("#min").css({"margin-top": "0px"});
			$("#max").css({"margin-top": "0px"});
		}
	});
	
	/* SKALA ZA DOLOČEN INTERVAL ŠTEVIL */
	if($('#numbers_scale').is(':checked')) { $("#set_interval").show(); } else { $("#set_interval").hide(); }
	
	$("#numbers_scale").change(function() {
		if($(this).is(":checked")) {
			$("#set_interval").show(); 
		}
	});
	
	$("#submit_interval").click(function() {
		FillIntervalScale();
		UnlimitedIntervalSlider();
	});
	
	/* SKALA ZA ČAS */
	if($('#time_scale').is(':checked')) { FillTimeScale(); UnlimitedTimeSlider(); }
	
	$("#time_scale").change(function() {
		if($(this).is(":checked")) {
			$("#set_interval").hide();
			FillTimeScale();
			UnlimitedTimeSlider(); 
		}
	});

	//uporaba zgornje in spodnje meje
	$("#submit").click(function() {
		if($('#time_scale').is(':checked')){
			LimitedTimeSlider();	
		} else if($('#numbers_scale').is(':checked')){
			LimitedIntervalSlider();
		}
	});
	
	//ponastavitev sliderja
	$("#reset").click(function() {
		if($('#time_scale').is(':checked')){
			UnlimitedTimeSlider();	
		} else if($('#numbers_scale').is(':checked')){
			UnlimitedIntervalSlider();
		}
	});
	
	//nastavitev koraka pomikanja
	$("#submit_step").click(function() {
		var value = parseInt($('#step_val').val()); 
		if(value != null){
			$("#slider").slider({ step: value });
		}
	});
	
	/* OBLIKOVANJE PISAV */
	$("#scale_font").change(function() {
		var font = $(this).val();
		$(".steps").css({ "font-family": font });
	});
	
	$("#scale_font_size").change(function() {
		var size = $(this).val();
		var margin = 0;
		if(size > 11){
			margin = -5;
		}
		$(".number").css({ "font-size": size + "px", "margin-top": margin + "px" });
		$(".tick").css({ "margin-top": margin + "px" });
	});
	
	$("#slider_font").change(function() {
		var font = $(this).val();
		$("#slider").find(".ui-slider-handle").css({ "font-family": font });
	});
	
	$("#slider_font_size").change(function() {
		var size = $(this).val();
		$("#slider").find(".ui-slider-handle").css({ "font-size": size + "px" });
	});
	
	$("#extreme_font").change(function() {
		var font = $(this).val();
		$("#min").css({ "font-family": font });
		$("#max").css({ "font-family": font });
	});
	
	$("#extreme_font_size").change(function() {
		var size = $(this).val();
		$("#min").css({ "font-size": size + "px" });
		$("#max").css({ "font-size": size + "px" });
	});
	
	$("#ex_radius_submit").click(function() {
		var radius = parseInt($("#extreme_radius").val());
		$("#min").css({ "border-radius": radius + "px" });
		$("#max").css({ "border-radius": radius + "px" });
	});
	
	$("#slider_shape").change(function() {
		if($(this).val() == "circle"){
			$("#slider").find(".ui-slider-handle").css({
				"margin-left": "-2.7em",
				"width": "5.4em", 
				"border-radius": "5em" 
			});
		} else {
			$("#slider").find(".ui-slider-handle").css({
				"margin-left": "-1.7em", 
				"width": "3.4em",
				"border-radius": "5px" 
			});
		}
	});
});

/* FUNCTIONS */

//slider z omejeno skalo
function LimitedTimeSlider(){
	var minValue = parseInt($("#sp_meja").val());
	var maxValue = parseInt($("#zg_meja").val());
	var min = minValue * 60;
	var max = maxValue * 60;
	var minValueText = $("#sp_meja option[value='"+ minValue +"']").text();
	
	$("#slider").find(".ui-slider-handle").text(minValueText);
	
	$("#slider").slider({
		value: min,
		min: 0,
		max: 1440,
		step: 15,
		slide: function(event, ui) {
			if(ui.value >= min && ui.value <= max){
				var hours = Math.floor(ui.value / 60);
				var minutes = Math.round(ui.value % 60);
				
				if(hours.toString().length == 1)
					hours = "0" + hours;
				if(minutes.toString().length == 1)
					minutes = "0" + minutes;
				ui.value = hours + ":"+ minutes;
		    	$(this).find('.ui-slider-handle').text(ui.value);
			} else {
				return false;
			}
			
	    	//resetiranje radio gumba
	    	$("#no_answer").prop("checked", false);
		}
	})
}

//slider z omejeno skalo
function LimitedIntervalSlider(){
	var min = parseInt($("#sp_meja").val());
	var max = parseInt($("#zg_meja").val());
	var from = parseInt($("#numbers_from").val());
	var to = parseInt($("#numbers_to").val());
	
	$("#slider").find(".ui-slider-handle").text(min);
	$("#slider").slider({
		value: min,
		min: from,
		max: to,
		step: 1,
		slide: function(event, ui) {
			if(ui.value >= min && ui.value <= max){
	    		$(this).find('.ui-slider-handle').text(ui.value);
	    	} else {
	    		return false;
	    	}
	    	//resetiranje radio gumba
	    	$("#no_answer").prop("checked", false);
		},
		create: function(event, ui){						
			$(this).find(".ui-slider-handle").text(min);
			
		}
	})
}

//časovni slider brez omejene skale
function UnlimitedTimeSlider(){
	$("#slider").find(".ui-slider-handle").text("00:00");

	$("#slider").slider({
		value:0,
		min: 0,
		max: 1440,
		step: 15,
		slide: function(event, ui) {
			var hours = Math.floor(ui.value / 60);
			var minutes = Math.round(ui.value % 60);
			
			if(hours.toString().length == 1)
				hours = "0" + hours;
			if(minutes.toString().length == 1)
				minutes = "0" + minutes;
			ui.value = hours + ":"+ minutes;
	    	$(this).find('.ui-slider-handle').text(ui.value);
	    	
	    	
	    	//resetiranje radio gumba
	    	$("#no_answer").prop("checked", false);
		},
		create: function(event, ui){						
			$(this).find(".ui-slider-handle").text("00:00");
			
		}
	});
}

//intervalni slider brez omejene skale
function UnlimitedIntervalSlider(){
	var from = parseInt($("#numbers_from").val());
	var to = parseInt($("#numbers_to").val());
	
	$("#slider").find(".ui-slider-handle").text(from);
	$("#slider").slider({
		value: from,
		min: from,
		max: to,
		step: 1,
		slide: function(event, ui) {
	    	$(this).find('.ui-slider-handle').text(ui.value);
	    	
	    	//resetiranje radio gumba
	    	$("#no_answer").prop("checked", false);
		},
		create: function(event, ui){						
			$(this).find(".ui-slider-handle").text(from);
			
		}
	});
}

function FillTimeScale(){
	$("#sp_meja").empty();
	$("#zg_meja").empty();
	$(".steps").empty();

	$("#min").text("00:00");
	$("#max").text("24:00");
	
	//polnjenje lestvice z urami od 00:00 do 24:00
	for(var i=0; i<24; i++){
		var pos = (100/24)*i;
		if(i > 0){
			jQuery("<span/>", {
			    class: 'tick',
			    style: "left: " + pos + "%;",
			    //html: i+ ":00<br>|"
			    html: "<span class='time'>"+i+":00</span><br />|"
			}).appendTo(".steps");
		}
	}
	//polnjenje comboboxa za nastavitev spodnje meje
	for(var i=0; i<24; i++){
		if(i.toString().length == 1)
			i = "0" + i;
		
		jQuery("<option/>", {
		    value: i,
		    text: i+":00",
		}).appendTo("#sp_meja");
	}
	//polnjenje comboboxa za nastavitev zgornje meje
	for(var i=0; i<25; i++){
		if(i.toString().length == 1)
			i = "0" + i;
		
		jQuery("<option/>", {
		    value: i,
		    text: i+":00",
		}).appendTo("#zg_meja");
	}
}

function FillIntervalScale(){
	$("#sp_meja").empty();
	$("#zg_meja").empty();
	$(".steps").empty();
	
	var num1 = parseInt($("#numbers_from").val());
	var num2 = parseInt($("#numbers_to").val());
	var n = num2 - num1;
	
	$("#min").text(num1);
	$("#max").text(num2);
	
	//polnjenje lestvice z števili od num1 do num2
	var j = 0;
	for(var i=num1; i<num2; i++){
		var pos = (100/n)*j;
		if(j > 0){
			jQuery("<span/>", {
			    class: 'tick',
			    style: "left: " + pos + "%;",
			    //html: i+ "<br>|"
			    html: "<span class='number'>"+i+"</span><br />|"
			}).appendTo(".steps");
		}
		j++;
	}
	//polnjenje comboboxa za nastavitev spodnje meje
	for(var i=num1; i<num2; i++){
		jQuery("<option/>", {
		    value: i,
		    text: i,
		}).appendTo("#sp_meja");
	}
	//polnjenje comboboxa za nastavitev zgornje meje
	for(var i=num1; i<=num2; i++){
		jQuery("<option/>", {
		    value: i,
		    text: i,
		}).appendTo("#zg_meja");
	}
}