$(document).ready(function() {
    var imageSelection = false;
    var curImage = $("img");

    $(window).resize(function(){
        if(imageSelection){
            imageRenderAndSelection(curImage);
        }
    });


    imageRenderAndSelection(curImage);


    function imageRenderAndSelection(meImg){
        $(".jumbotron").empty();
        $(".jumbotron").removeClass('col-scrollable');
        $(".jumbotron").html('<div class="col-md-8 col-centered fill"></div>', function(){

            $(".jumbotron").children().append('<img class="imageSize" src='+meImg.attr('src')+' alt="img" />');
            var img = $("img");

            var w = img.width();
            var h = img.height();




            $(".jumbotron").children().append("<div class='selectionBorder'><div class='selectionBorderDiv' style='position: relative;'></div></div>");



            $(".jumbotron").append('<div id="popUpContainer" class="col-md-4 col-centered">'+
                                        '<div id="valueSlider"></div>'+
                                        '<textarea rows=10 class="commentSection"></textarea>'+
                                        '<div>'+
                                            '<button class="saveButton">Save</button>'+
                                            '<button class="cancleButton">Cancel</button>'+
                                            '<div class="clear"></div>'+
                                        '</div>'+
                                    '</div>');

            var divAbs = "<ul id='imgOverlay' class='OverLayImage' style='left: "+ img.position().left +"px; top: "+img.position().top+"px; width: "+w + "px; height: "+ h +"px; '></ul>";

            $(".jumbotron").children().first().append(divAbs);

            var parent = $("#imgOverlay");
            var arr = [];
            for (var i = 0; i < Math.ceil(w/squareDimension); i++) {
                for (var j = 0; j < Math.ceil(h/squareDimension); j++) {

                    var styles = [];
                    styles.push("position: absolute");
                    styles.push("display: inline-block");
                    styles.push("width: " + (squareDimension) + "px");
                    styles.push("height: " + (squareDimension) + "px");

                    styles.push("left: "+ (i*squareDimension) + "px");
                    styles.push("top: " + (j*squareDimension) + "px");

                    var d = "<li id='"+i+"_"+j+"' class='ui-state-default' style='" +styles.join(";") + "'></li>";
                    arr.push(d);

                    //arr.push("<div style='position: absolute; border: 1px solid black; width: "+squareDimension+"px; height: "+squareDimension+"px; left: "+(img.position().left + (i*squareDimension))+"px; top: "+((j*squareDimension))+"px;'>");
                }
            }
            for (i = 0; i < arr.length; i++) {
                parent.append(arr[i]);
            }
            var selectedDiv = $(".selectionBorder");
            selectedDiv.hide();

            var initialValue = 1;
            var sliderTooltip = function(event, ui) {
                var curValue = ui.value || initialValue;
                var tooltip = '<div class="sliderTooltip"><div class="tooltip-inner">' + curValue + '</div><div class="tooltip-arrow"></div></div>';

                $('.ui-slider-handle').html(tooltip);

            };

            var selection = [];
            var picSelected = false;

            $(".saveButton").click(function(event) {
                event.preventDefault();
                var score = $("#valueSlider").slider("option", "value");
                var comment = $("textarea").val();
                console.log(selection, squareDimension);
                alert("Score: " + score +"\nComment: " + comment);
            });


            $(".cancleButton").click(function(event) {
                event.preventDefault();
                picSelected = false;
                $( "#imgOverlay" ).selectable("option", "filter", "*");

                selection = [];
                $('.selectionBorderDiv').children().each(function(index, el) {
                    $(el).removeClass();
                    $(el).addClass('ui-state-default');
                    $(el).addClass('ui-selectee');
                    $(el).appendTo('#imgOverlay');
                    $(el).removeClass('floatLeft');
                    $(el).css('position', 'absolute');
                    $(el).css('left', $(el).attr('left-t'));
                    $(el).css('top', $(el).attr('top-t'));
                    $(el).removeAttr('top-t');
                    $(el).removeAttr('left-t');
                    $(el).removeAttr('width-t');
                    $(el).removeAttr('height-t');
                });

                selectedDiv.hide();
            });

            $( "#valueSlider" ).slider({
                value: initialValue,
                min: 1,
                max: 10,
                step: 1,
                slide: sliderTooltip,
                create: sliderTooltip
            });

            var resetDivs = [];
            $( "#imgOverlay" ).selectable({
                autoRefresh: true,
             //   filter: 'lll',
                start: function(event, ui){
                    if(picSelected) return false;
                    selectedDiv.show();
                },
                selecting: function(event, ui){
                    var item = ui.selecting;
                    if(picSelected) {
                        resetDivs.push(item);
                        return false;
                    }
                    selection.push(item.id);


                    var dim = getDimenzions(selection, img.position());

                    $(item).appendTo('.selectionBorderDiv');
                    $(item).css('position', '');
                    $(item).addClass('floatLeft');

                    renameStyles($(item), "width", item.id);
                    renameStyles($(item), "height", item.id);
                    renameStyles($(item), "left", item.id, selection);
                    renameStyles($(item), "top", item.id, selection);

                    selectedDiv.width(dim.width);
                    selectedDiv.height(dim.height);
                    selectedDiv.css('top', dim.top);
                    selectedDiv.css('left', dim.left);

                },
                unselecting: function(event, ui){
                    if(picSelected) return;
                    var el = ui.unselecting;
                    $(el).removeClass();
                    $(el).addClass('ui-state-default');
                    $(el).addClass('ui-selectee');
                    $(el).appendTo('#imgOverlay');
                    $(el).css('position', 'absolute');
                    $(el).css('left', $(el).attr('left-t'));
                    $(el).css('top', $(el).attr('top-t'));
                    $(el).removeAttr('top-t');
                    $(el).removeAttr('left-t');
                    $(el).removeAttr('width-t');
                    $(el).removeAttr('height-t');
                    selection = $.grep(selection, function(value){
                        return value != ui.unselecting.id;
                    });
                    var dim = getDimenzions(selection, img.position());
                    selectedDiv.width(dim.width);
                    selectedDiv.height(dim.height);
                    selectedDiv.css('top', dim.top);
                    selectedDiv.css('left', dim.left);
                },
                stop: function(event, ui){
                    picSelected = true;
                    $( "#imgOverlay" ).selectable("option", "filter", "ll");
                    $(resetDivs).each(function(index, el) {
                        $(el).removeClass('ui-selected');
                    });
                    resetDivs = [];
                }
            });
        });
    }


    function getDimenzions(items, position){
        var maxY = 0,
            minY = 10000,
            maxX = 0,
            minX = 10000;

        $(items).each(function(index, el) {
            var temp = el.split("_");
            if(parseInt(temp[1]) > maxY)
                maxY = parseInt(temp[1]);
            if(parseInt(temp[0]) > maxX)
                maxX = parseInt(temp[0]);
            if(parseInt(temp[0]) <= minX)
                minX = parseInt(temp[0]);
            if(parseInt(temp[1]) <= minY)
                minY = parseInt(temp[1]);
        });


        var returnValues = {};

        returnValues.width = squareDimension + (maxX * squareDimension) - (minX * squareDimension);
        returnValues.height = squareDimension + (maxY * squareDimension) - (minY * squareDimension);
        returnValues.left = position.left + (minX * squareDimension);
        returnValues.top = position.top + (minY * squareDimension);

        return returnValues;
    }
    function renameStyles(el, name, id, items){
        var temp = id.split("_");

        var minY = 10000,
            minX = 10000;


        if(name == "width"){
            el.attr(name+"-t", el.width());
        }
        else if(name == "height")
            el.attr(name+"-t", el.height());
        else if(name == "top"){

            $(items).each(function(index, el) {
                var temp = el.split("_");
                if(parseInt(temp[1]) <= minY)
                    minY = parseInt(temp[1]);
            });

            el.attr(name+"-t", el.css('top'));
            el.css('top', ((temp[1] - minY) * squareDimension));
        }
        else if(name == "left"){

            $(items).each(function(index, el) {
                var temp = el.split("_");
                if(parseInt(temp[0]) <= minX)
                    minX = parseInt(temp[0]);
            });
            el.attr(name+"-t", el.css('left'));
            el.css('left', ((temp[0] - minX) * squareDimension));
        }
    }
});