<?php
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");
include_once(PATH_TO_ROOT."_class/class.Extjs_grid.php");


	$tabId = $_POST['uniqueTabId'];
	$projectId = $_POST['id_project'];
	$projName = $_POST['projName'];
	$tableName = $projName.'___telLog';

	//let's check if there is any telLog table
	if(!$db->TableExists($projName.'___telLog',DB_WARPIT_WEBCATI_BASE))
	{
		echo "alert('Telephone log table $tableName is missing for project $projName!')
		removeSession('$tabId')";
		exit;
	}

	// if I have custom telephone fields, I need ID of telephone table
	$id_telname = $db->get('_Projects',$projectId,'id_telname',DB_WARPIT_WEBCATI_BASE);
	$telTable = 'tel___'.$db->get('_TelephoneTables',$id_telname,'name',DB_WARPIT_WEBCATI_BASE);

	$grid = new MakeGrid( 'grid_'.$tabId );
	$gridName = $grid->getName();

	$grid->setMainTable($tableName,DB_WARPIT_WEBCATI_BASE)->setTitle('Telephone numbers log');

	$dbCallTime = " FROM_UNIXTIME(a.call_time , '%H:%i:%s') AS call_time ";
	$dbCallDate = " FROM_UNIXTIME(a.call_time , '%Y-%m-%d') AS call_date ";
	$dbEndTime = " FROM_UNIXTIME(a.end_time , '%H:%i:%s') AS end_time ";
	$dbEndDate = " FROM_UNIXTIME(a.end_time , '%Y-%m-%d') AS end_date ";
	$dbDruation = " TIME_FORMAT(SEC_TO_TIME(GREATEST((a.end_time - a.call_time), 0)),'%H:%i:%s') AS duration ";

	$grid->selectSQL = "SELECT a.id, a.id_tel, a.id_telname, a.id_structure, a.id_user, a.user_type, a.oms, a.telephone, a.status, a.status_rec, $dbCallTime, $dbCallDate, $dbEndTime, $dbEndDate, a.app_koment,b.name,b.address,b.zip,b.town, $dbDruation FROM $tableName a LEFT JOIN $telTable b ON a.id_tel = b.id";

	$grid->setReqUrl("webcati/_ajax/telNumberManagment/ajax.telNumbersLog.php")
	->dateSQL = 'Y-m-d';

	$grid->dateDisplay = 'Y.m.d';
	$grid->addColumn('id','ID')->width(50)->tableAs('a');
	$grid->addColumn('id_tel','Id. tel.')->width(80)->type('int');
	$grid->addColumn('id_telname','ID tel. table')->width(70)->type('int');

	$grid->addColumn('id_structure','ID structure')->width(80)->type('int');
	$grid->addColumn('id_user','ID interviewer')->width(80)->type('int');
	$grid->addColumn('user_type','Interviewer type')->width(100)->type('int');
	$grid->addColumn('oms','Area code')->width(70)->tableAs('a');
	$grid->addColumn('telephone','Telephone number')->width(120)->tableAs('a');
	$grid->addColumn('status','Status')->width(70)->type('int')->tableAs('a');
	$grid->addColumn('status_rec','Status rec')->width(70)->type('int')->tableAs('a');
	$grid->addColumn('name','Name')->width(120)->tableAs('b');
	$grid->addColumn('address','Address')->width(120)->tableAs('b');
	$grid->addColumn('zip','Zip')->width(50)->type('int')->tableAs('b');
	$grid->addColumn('town','Town')->width(120)->tableAs('b');
	$grid->addColumn('call_date','Call date')->width(120)->type('date');
	$grid->addColumn('call_time','Call time')->width(120);
	$grid->addColumn('end_date','End date')->width(120)->type('date');
	$grid->addColumn('end_time','End time')->width(120);
	$grid->addColumn('duration','Duration')->width(120);
	$grid->addColumn('app_koment','Comment')->width(250);
	//$grid->setAutoExpand('app_koment');

	$grid->setPaging()
		->region('center')
		->setCheckBoxSelectionModel(true)
		->setRemoteSort()
		->setFiltering(true)
		->setSearchField('Search','top', 0, "['duration', 'end_date', 'call_date']")
		->addtBarItem("new Ext.form.Label({text:'Call Time: '})")
		->addtBarItem("new Ext.form.TimeField({
			id: '{$tabId}_call_time_from',
			format: 'H:i',
			increment: 10,
			width: 70,
			listeners:{
				select: function(that, record, index){
					var store = $gridName.getStore();
					var value = that.getValue();

					store.baseParams.timeFrom = value;
					store.lastOptions.params.timeFrom = value;
					store.reload();
				}
			}

		})")
		->addtBarItem("new Ext.form.Label({text:'--'})")
		->addtBarItem("new Ext.form.TimeField({
			id: '{$tabId}_call_time_to',
			format: 'H:i',
			increment: 10,
			width: 70,
			listeners:{
				select: function(that, record, index){
					var store = $gridName.getStore();
					var value = that.getValue();

					store.baseParams.timeTo = value;
					store.lastOptions.params.timeTo = value;
					store.reload();
				}
			}
		})")
		->addtBarItem("{
				text:'Clear',
				handler:function(bt,state){
					var store = $gridName.getStore();
					delete store.baseParams.timeFrom;
					delete store.lastOptions.params.timeFrom;

					delete store.baseParams.timeTo;
					delete store.lastOptions.params.timeTo;

					console.log(store);

					var comboTimeFrom = Ext.getCmp('{$tabId}_call_time_from');
					comboTimeFrom.setValue('');

					var comboTimeTo = Ext.getCmp('{$tabId}_call_time_to');
					comboTimeTo.setValue('');

					store.reload();
				}
		  }")
		->addtBarItem("'->'")
		->addExportButton();

	echo $grid->createGrid();


	echo "
		mainTabPanel.add({
		id: '$tabId',
		iconCls:'RMicon_tel_numbers_log',
		layout:'border',
		title: 'Telephone number log - $tableName',
		closable: true,
		items:[$grid]
	 })";

	 if(!$_POST['uniqueNotShow']) echo  ".show();";


?>
