<?php
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");
include_once(PATH_TO_ROOT."_class/class.Extjs_tree.php");
include_once(PATH_TO_ROOT."_class/class.Extjs_grid.php");

$grid = new MakeGrid();
$gridName = $grid->getName();
$id_user = $_SESSION["UserInfo"]["id"];
$user_type = $_SESSION["UserInfo"]["user_type"];
$tabId = $_POST['uniqueTabId'];
$projectId = $_POST['id_project'];
$projName = $_POST['projName'];
$tableName = $projName.'___telIndex';
$database = DB_WARPIT_WEBCATI_BASE;

//let's check if there is any telIndex table
if(!$db->TableExists($projName.'___telIndex',DB_WARPIT_WEBCATI_BASE))
{
    echo "Ext.Msg.alert('Error','There is no telephone sample reserved for the project!');
	removeSession('$tabId')";
    exit;
}

// if I have custom telephone fields, I need ID of telephone table
$id_telname = $db->get('_Projects',$projectId,'id_telname',DB_WARPIT_WEBCATI_BASE);
$telTable = 'tel___'.$db->get('_TelephoneTables',$id_telname,'name',DB_WARPIT_WEBCATI_BASE);

$countGrid = new MakeGrid();

$grid->setMainTable($tableName,DB_WARPIT_WEBCATI_BASE);

// I need additional columns, if exists
$extraFields = $db->get('_TelephoneTablesAddon','id_telbaza = '.$id_telname.' AND is_leaf = 1','name' );
if(is_array($extraFields)) {
    $sql_extraFields = ",b.tel_".implode(",b.tel_", $extraFields);
    // put all possible sort fields to ajax request
    $str_extraFields = "oms,tel_".implode(",tel_", $extraFields);
}

$grid->selectSQL = "SELECT a.*,a.id, a.status,b.oms,b.telephone,b.name,b.address, b.id_import, b.town $sql_extraFields FROM $tableName a INNER JOIN $telTable b ON a.id_tel = b.id";
$grid->setReqUrl('webcati/_ajax/telNumberManagment/ajax.catiTools.php');
//$grid->baseParams = "SQLwhere : '(a.status = 91 OR a.status = 89)'";
$grid->baseParams = " str_extraFields : '$str_extraFields', id_project:$projectId";

$grid->addColumn('id');
$grid->addColumn('statIcon');
$grid->addColumn('statTooltip');
$grid->addRowAction('icons',"new Ext.ux.grid.RowActions({

	actions:[{
		iconIndex:'statIcon',
		qtipIndex:'statTooltip'
		},
		{
		iconCls:'RMicon_delete_app',
		tooltip:'Delete'
		},
		{
		iconCls:'RMicon_reactivate_app',
		tooltip:'Reactivate'
		}
	],
	listeners: {
		action: function(g,r,a){
			var act;
			if(a == 'RMicon_cancel_app') act = 'cancelApp';
			else if(a == 'RMicon_restore_app') act = 'restoreApp';
			else if(a == 'RMicon_delete_app') act = 'deleteApp';
			else if(a == 'RMicon_reactivate_app') act = 'reactivateApp';
			$grid.RMconn.request({params:{
				action:act,
				id:r.id},
				success:function(){ $grid.getStore().reload(); $countGrid.getStore().reload();}
			});
		}
	}
})");
$grid->addSetter("'app_time','id_ank', 'tdisable','region','status','status_rec','call_time','call_num'");
$grid->addColumn('id','ID')->type('int')->width(40)->tableAs('a');
$grid->addColumn('tdisable','tdisable')->type('checkColumn')->width(60)->tableAs('a');
$grid->addColumn('status','Status')->width(50)->tableAs('a');
$grid->addColumn('status_rec','Status rec')->width(50)->tableAs('a');
$grid->addColumn('call_num','No. of calls')->width(50);
$grid->addColumn('id_tel','Id tel.')->width(30)->tableAs('a');
$grid->addColumn('structureId','Structure ID')->width(80)->tableAs('c');
$grid->addColumn('id_ank','Int. ID')->width(50)->editor("new Ext.form.TextField()");
//oms and telefon from the tel___database!
//$grid->addColumn('oms','Tel. num.')->type('int')->width(150)->renderer("function(val,md,rec){return val+'/'+rec.data.telephone;}");
$grid->addColumn('oms','Area code')->width(50)->tableAs('b');
$grid->addColumn('telephone','Telephone')->width(150)->tableAs('b');
$grid->addColumn('name','Name')->width(200);
$grid->addColumn('address','Address')->width(200)->tableAs('b');
$grid->addColumn('town','Town')->width(150)->tableAs('b');
$grid->addColumn('region','Region')->tableAs('b');
$grid->addColumn('zip','ZIP')->tableAs('b');
$grid->addColumn('id_import','Import seq.')->tableAs('b');
//$grid->addColumn('ime','Name');



$grid->dateSQL = 'U';
$grid->dateDisplay = 'd.m.Y H:i:s';

$grid
    ->addColumn('last_call','Last call')
    ->type('date')
    ->width(200)
    ->renderer("function(value){
		if(value.format('U') > 100) return Ext.util.Format.date(value, 'd.m.Y H:i:s');	
	}");
$grid->addColumn('callback', 'Callback')->table('a');
//$grid->addColumn('call_time',"Call time")->type('date')->width(200)->editor('new Ext.ux.form.DateTime()');

$grid
    ->addColumn('app_time','Next call time (app, busy, no answer)')
    ->type('date')
    ->width(200)
    ->editor('new Ext.ux.form.DateTime()')
    ->renderer("function(value){
		if(value.format('U') > 100) return Ext.util.Format.date(value, 'd.m.Y H:i:s');	
	}");
$grid->addColumn('app_call_this_num','New call number')->width(150)->editor('new Ext.form.TextField()');
$grid->addColumn('status_comment','Status comment')->width(200)->editor('new Ext.form.TextField()');
$grid->addColumn('app_koment','Appointment comment')->width(200)->editor('new Ext.form.TextField()');

if(is_array($extraFields)) {
    foreach ($extraFields as $telField) {
        $extraCol = $grid->addColumn('tel_'.$telField,$telField)->tableAs('b');

    }
}


$grid->setAutoExpand('id_tel');
$grid->setCheckBoxSelectionModel()
    ->setSearchField()
    ->setFiltering()
    ->region('center');

$grid->setPaging()
    ->region('center')
    ->setCheckBoxSelectionModel(true)
    ->setRemoteSort()
    ->setFiltering(true)
    ->setSearchField('Search','top');

$grid->addtBarItem("{
			text:'On hold',
			iconCls:'cancelMultiAppointments',
			handler:function(bt,state){

			var q = $grid.selModel.getSelections();
			if(q) {
				var qId = new Array();
				for(var i=0;i<q.length;i++)
					qId.push( q[i].id );
			}
			$grid.RMconn.request({
					  url:'webcati/_ajax/telNumberManagment/ajax.appointmentActions.php',
					  params:{action:'MultiCancel', database:'$database', RMtable:'$tableName', selRecords:Ext.encode(qId) },
					  success:function(){
					  	$grid.getStore().reload();
					  }
				})
       		}
	   }");

$grid->addtBarItem("{
			text:'Restore',
			iconCls:'restoreMultiAppointments',
			handler:function(bt,state){

			var q = $grid.selModel.getSelections();
			if(q) {
				var qId = new Array();
				for(var i=0;i<q.length;i++)
					qId.push( q[i].id );
			}
			$grid.RMconn.request({
					  url:'webcati/_ajax/telNumberManagment/ajax.appointmentActions.php',
					  params:{action:'MultiRestore', database:'$database', RMtable:'$tableName', selRecords:Ext.encode(qId) },
					  success:function(){
					  	$grid.getStore().reload();
					  }
				})
       		}
	   }");

$grid->addtBarItem("{
			text:'Delete',
			iconCls:'deleteMultiAppointments',
			handler:function(bt,state){

			var q = $grid.selModel.getSelections();
			if(q) {
				var qId = new Array();
				for(var i=0;i<q.length;i++)
					qId.push( q[i].id );
			}
			$grid.RMconn.request({
					  url:'webcati/_ajax/telNumberManagment/ajax.appointmentActions.php',
					  params:{action:'MultiDelete', database:'$database', RMtable:'$tableName', selRecords:Ext.encode(qId) },
					  success:function(){
					  	$grid.getStore().reload();
					  }
				})
       		}
	   }");

$grid->addtBarItem("{
			text:'Reactivate',
			iconCls:'reactivateMultiAppointments',
			handler:function(bt,state){

			var q = $grid.selModel.getSelections();
			if(q) {
				var qId = new Array();
				for(var i=0;i<q.length;i++)
					qId.push( q[i].id );
			}
			$grid.RMconn.request({
					  url:'webcati/_ajax/telNumberManagment/ajax.appointmentActions.php',
					  params:{action:'MultiReactivate', database:'$database', RMtable:'$tableName', selRecords:Ext.encode(qId) },
					  success:function(){
					  	$grid.getStore().reload();
					  }
				})
       		}
	   }");

$grid->addTbarItem("'&nbsp;&nbsp;&nbsp;&nbsp;',{
			text:'Appointments',
			iconCls:'RMicon_Appointment',
			menu: [{
			    text: 'Set',
			    handler: function(){
                    var sel = $grid.selModel.getSelections();
                    
                    var selIds = [];
                    for(var i = 0; i < sel.length; i++){
                        selIds.push(sel[i].data.id_tel);
                    }
                    
                    if(selIds.length == 0) return;
                    var w = new Ext.Window({
                        autoDestroy:false,
                        title:'Set appointments',
                        items:[new Ext.ux.form.DateTime({
                            ref:'valueToSet',fieldLabel : 'Appointment time'
                        })],
                        layout:'form',
                        height:120,
                        width:400,
                        labelWidth:130,
                        labelAlign:'right',
                        padding:'15',
                        modal:true,
                        buttons:[{
                            text:'Ok',
                            handler: function(){
                                var val = w.valueToSet.getValue();
                                val = Ext.util.Format.date(val, 'U');
                                $grid.RMconn.request({
                                    params:{
                                        action:'setAppointments',
                                        ids: selIds.join(),
                                        setValue:val,
                                        id_telTable: $id_telname
                                    },
                                    success: function(){
                                        $grid.store.reload();
                                    }
                                });
                                w.close();
                            }
                        },{
                            text:'Cancel',handler:function(){
                            w.close();
                        }
                        }]
                    }).show();
			    }
			},
			{
			text:'Copy',
			handler: function(){
				var selIds = $grid.getSelectedIds();
				if(selIds.length == 0) {
				    Ext.Msg.show({ 
				        title:'Info', 
				        msg: 'You have to select numbers!', 
				        icon: Ext.MessageBox.INFO, 
				        buttons: Ext.Msg.OK
                    });
				    return
                };
				
				var projectIds = Ext.getCmp('WCprojects').getChecked('id');
				if(projectIds.length !== 1) {
				      Ext.Msg.show({ 
				        title:'Info', 
				        msg: 'You have to select destination project!', 
				        icon: Ext.MessageBox.INFO, 
				        buttons: Ext.Msg.OK
                    });
				    return;
				 }
				
				$grid.RMconn.request({
                    url: 'webcati/_ajax/telNumberManagment/ajax.manageTelTable.php',
                    params:{
                        action:'copyAppointments',
                        ids: selIds.join(),
                        newProjectId: projectIds.join(),
                        originalProjectName: '$projName',
                        originalProjectId: '$projectId',
                    },
                    success: function(response){
                        var jsonResponse = Ext.decode(response.responseText);
                        
                        if(jsonResponse.success === true){
                         Ext.Msg.show({ 
                                title:'Info', 
                                msg: 'Appointments copied to destination project!', 
                                icon: Ext.MessageBox.INFO, 
                                buttons: Ext.Msg.OK
                            });
                            $grid.store.reload();
                        } else {
                            Ext.Msg.alert('Error',jsonResponse.msg);
                        }
                    }
                });	
			}
		}]
		}");

$gridUsers = "";
$gridStatuses = "";
$formDateTime = "";

$grid->addtBarItem("{
		   		xtype: 'button',
				text:'Advanced Filter',
				iconCls:'iconFilter',
	   			handler:function(sender,state){
					CallScript('webcati/_forms/telNumberManagment/window.advancedFilterCatiTools.php', {
						id_project: $projectId,
						project_name: '$projName',
						mainGrid: '$gridName'
					});
	          	}
	   	   }");

$importSeq = array();
$importSeq[] = "[0,' All imports']";
$sql = "SELECT count(*) as n, id_import FROM " . DB_WARPIT_WEBCATI_BASE . "." . $telTable . " GROUP BY id_import";
$resImport = $db->SQLexecute($sql);
while ($zadImport = $db->fetchAssoc($resImport)) $importSeq[] = "[".$zadImport['id_import'].", '".$zadImport['id_import']." - ( ".$zadImport['n']." numbers )']";

$grid->addTbarItem("'&nbsp;&nbsp;','-','&nbsp;&nbsp;','Import sequence filter:',new Ext.form.ComboBox({
	    typeAhead: true,
	    id: 'importSeqCombo" . $projName . "',
	    triggerAction: 'all',
	    mode: 'local',

	    store: new Ext.data.ArrayStore({
	        fields: [
	            'filID',
	            'displayText'
	        ],
	        data: [
	        		".implode(",",$importSeq)."
	        	  ]
	    }),
	   	 valueField: 'filID',
	   	 value: '0',
	   	 displayField: 'displayText',
	   	 listeners: {
	   	 	select : function(combo,rec) {
	   	 		$grid.getStore().baseParams.ComboImportFilter = rec.get('filID');
	   	 		$grid.getStore().reload();
	   	 	}
	   	 }
}) ");
unset($importSeq);

$grid->addtBarItem("'->'");
$grid->addExportButton();

$grid->addBottomBarItem(
    "{
				xtype: 'button',
				text:'Clear Advanced Filter',
				iconCls:'iconClearFilter',
				handler:function(sender,state)
				{
					var store = $gridName.getStore();
					delete store.lastOptions.params.advanceFilter;
					delete store.lastOptions.params.advanceFilterIds;
					delete store.lastOptions.params.advanceFilterStatuses;
					delete store.lastOptions.params.advanceFilterStatusesRec;
					delete store.lastOptions.params.advanceFilterDateFrom;
					delete store.lastOptions.params.advanceFilterDateTo;
					delete store.lastOptions.params.advanceFilterTimeFrom;
				    delete store.lastOptions.params.advanceFilterTimeTo;
					delete store.baseParams.advanceFilterOnlyOpenQuota;

					delete store.baseParams.advanceFilter;
					delete store.baseParams.advanceFilterIds;
					delete store.baseParams.advanceFilterStatuses;
					delete store.baseParams.advanceFilterStatusesRec;
					delete store.baseParams.advanceFilterDateFrom;
					delete store.baseParams.advanceFilterDateTo;
					delete store.baseParams.advanceFilterTimeFrom;
					delete store.baseParams.advanceFilterTimeTo;
					delete store.baseParams.advanceFilterOnlyOpenQuota;
					store.reload();

					delete $gridName.advancedFilter;
				}
		   }"
);

/*
$grid->addTbarItem(" new Ext.form.ComboBox({
	    typeAhead: true,
	    triggerAction: 'all',
	    mode: 'local',
	    store: new Ext.data.ArrayStore({
	        fields: [
	            'filID',
	            'displayText'
	        ],
	        data: [
	        		[1,' Show all numbers'],
	        	 	[2,' Show only available numbers (tdisable = 0)']
	        	  ]
	   	 }),
	   	 valueField: 'filID',
	   	 value: '1',
	   	 displayField: 'displayText',
	   	  listeners: {
	   	 	select : function(combo,rec) {
				$grid.getStore().reload({params:{ ShowFilter : rec.get('filID')} });
	   	 	}
	   	 }

		}) ");
*/
//20160524 Bojan Orter - We read from config if we show only appointments on load. If we do we set filter and apply it before grid render
$configWebcati = configLoader::loadConfig('webcati');
$applyFilterBeforeRender = "";
if($configWebcati["show_only_app"])
{
    $applyFilterBeforeRender = "
		var statusFilter = $grid.filters.getFilter('status');
		statusFilter.menu.fields.eq.value = 91;
		statusFilter.active = true;
	";
}
//END Bojan Orter

$grid->addListener('beforerender',"function(){

	//20160524 Bojan Orter - we apply filter for status
	$applyFilterBeforeRender
	//END Bojan Orter

	this.getStore().on('beforeload',function(store){
	    var importFilter = Ext.getCmp('importSeqCombo" . $projName . "').getValue();
	    store.lastOptions.params.ComboImportFilter = importFilter;
		$countGrid.getStore().reload();
	});

//20170223 Tanis: if you are on page 6 and then you filter records to only 4 pages your position will still be page 6 and you will see no records.
// in this case we check what is the number of total records in store and how many records are we displaying. If there should be some records but we
// don't display any this means that we are on wrong page so we go to the last aviable page
	this.getStore().on('load',function(store, records){
			if(store.totalLength > 0 && records.length == 0)
			{
				$grid.getBottomToolbar().moveLast();
			}
	});
	//20170223 Tanis: END
}");


$countGrid->setTitle('Appointments count');
$countGrid->setMainTable($tableName,DB_WARPIT_WEBCATI_BASE);
$countGrid->setReqUrl('webcati/_ajax/telNumberManagment/ajax.catiTools.php');
$countGrid->baseParams = "countGrid : true";
$countGrid->setAutoLoad(false);
$countGrid->addColumn('date','Date');
//$countGrid->addColumn('count','All numbers');
$countGrid->addColumn('count','Available numbers');
//$countGrid->addColumn('countAvail','Available numbers');
$countGrid->setHeight(200)->region('south');

//20170104 Bojan Orter - We hidde and add order columns by saved state, before grid is rendered
$allColumns = getFieldsOrderHidden($db, $id_telname, $id_user, $user_type, $projectId);
$gridColumns = $grid->getColumns();

$newOrder = Array();
foreach($allColumns as $column)
{
    if(array_key_exists($column["name"], $gridColumns))
    {
        $gridColumn = $gridColumns[$column["name"]];
        if(is_object($gridColumn))
        {
            $gridColumn->hidden($column["hidden"]);
            $gridColumn->setProperty("orderHiddenID", $column["id"]);
            $gridColumn->setProperty("realOrderBy", $column["orderBy"]);
        }
        $newOrder[$column["name"]] = $gridColumn;
    }
}



$grid->setColumns($newOrder);
//END Bojan Orter

echo $grid->createGrid();
echo $countGrid->createGrid();

//20170104 Bojan Orter - Method for hide and show columns (updating saved state)
echo "$grid.getColumnModel().on('hiddenchange', function(columnModel, colIndex, hidden){
	var id = columnModel.config[colIndex].orderHiddenID;
	$grid.RMconn.request({
		params:{action:'columnHide',id_field:id,hidden:hidden}
	});
});";

//20170104 Bojan Orter - Method for moving columns (updating saved state)
echo "$grid.getColumnModel().on('columnmoved',function(colModel,oldInd,newInd){
	var movedColumn = colModel.config[newInd];
	if(movedColumn.realOrderBy)
	{
		var oldIndex = movedColumn.realOrderBy;
		var newIndex = newInd;

		while(newIndex > 0)
		{
			newIndex--;
			var leftColumn = colModel.config[newIndex];
			if(leftColumn.realOrderBy)
			{
				newIndex = leftColumn.realOrderBy;
				break;
			}
		}
		$grid.RMconn.request({
			params:{action:'columnMove',projectId:$projectId, telbaseId:$id_telname,newInd:newIndex, oldInd:oldIndex},
			success: function(result)
			{
				result = JSON.parse(result.responseText);
				updatedOrderBy = result.updatedOrderBy;
				for(var i = 0; i < updatedOrderBy.length; i++)
				{
					var colIndex = colModel.getIndexById(updatedOrderBy[i].name);
					if(colIndex != -1)
					{
						colModel.config[colIndex].realOrderBy = updatedOrderBy[i].orderBy;
					}
				}
			}
		});
	}
});";

//20170104 Bojan Orter - We look if all fields are saved, if not we add missing fields
function getFieldsOrderHidden($db, $id_telname, $id_user, $user_type, $id_project)
{

    //CHECK if all fields exist
    $db->changeDatabase(DB_WARPIT_WEBCATI_BASE);
    $sqlAllFieldsCount = "SELECT name, 1 system FROM _TelephoneTableSystemFields UNION SELECT name, 0 system FROM _TelephoneTablesAddon WHERE id_telbaza = $id_telname AND is_leaf = 1";
    if(!$res = $db->SQLexecute($sqlAllFieldsCount))
    {
        echo 	"alert(\"".$db->GetError()."\");";
        exit;
    }

    $telephoneFields = [];

    while($row = $db->fetchAssoc($res)){
          if($row['system'] === '1') {
              $telephoneFields[] = $row['name'];
          } else {
              $telephoneFields[] = 'tel_' .$row['name'];
          }
    }

    $telephoneFields[] = 'id_import';
    $telephoneFields[] = 'structureId';
    $telephoneFields[] = 'address';
    $telephoneFields[] = 'town';
    $telephoneFields[] = 'zip';
    $telephoneFields[] = 'callback';


    $sqlSelectFields = "SELECT * FROM _TelephoneFieldOrder WHERE id_user = $id_user AND user_type = $user_type AND id_project = $id_project ORDER BY orderBy ASC";
    if(!$res = $db->SQLexecute($sqlSelectFields))
    {
        echo 	"alert(\"".$db->GetError()."\");";
        exit;
    }

    $rowsOrderHidden = [];
    while($row = $db->fetchAssoc($res)) {
        $rowsOrderHidden[] = $row;
    }

    $fieldsToAdd = array_diff($telephoneFields, array_column($rowsOrderHidden, 'name'));
    $lastField = end($rowsOrderHidden);
    $maxOrderBy = $lastField['orderBy'];

    reset($rowsOrderHidden);

    foreach($fieldsToAdd as $field){
        $maxOrderBy++;
        $fieldsRow = [
            'name'       => "'" . $field . "'",
            'id_user'    => $id_user,
            'user_type'  => $user_type,
            'id_project' => $id_project,
            'orderBy'    => $maxOrderBy,
            'hidden'     => 0
        ];
		
        $insertQuery = "INSERT INTO _TelephoneFieldOrder (`name`,`id_user`,`user_type`,`id_project`, `orderBy`,`hidden`) VALUES";
        $insertQuery .= '(' . implode(',', $fieldsRow) . ')';

        if(!$db->SQLexecute($insertQuery)) {
            echo 	"alert(\"".$db->GetError()."\");";
            exit;
        }

		$fieldsRow['id'] = $db->GetLastInsertId();
		$fieldsRow['name'] = $field;
        $rowsOrderHidden[] = $fieldsRow;
    }
    return $rowsOrderHidden;
}

echo "$grid.getStore().on('update',function(a,b,c){ if(c=='commit') $countGrid.getStore().reload(); });
mainTabPanel.add({
		id:'$tabId',
		title:'Preview / calls scheduler - $projName',
		iconCls:'RMicon_Appointment',
		listeners: {
            'activate': function() {
                //This is workaround for bug when you open multiple panels at once sometimes pager disaper
                // we need to rerender the grid again 
                $grid.setSize($grid.width, $grid.height);
            }
        },
		closable:true,
		layout:'border',
		items: [$grid,$countGrid]
}).show();";

?>
