Live watch, Warpit questionnaires, WebSockets
=============================================

Folder config
-------------

For server pid and log:
λ chmod 777 ./tmp



Nginx TLS config
----------------

λ (generate self-signed ssl public private key pair)
λ openssl req -x509 -nodes -days 365 -newkey rsa:2048 -keyout localhost.key -out localhost.crt

λ cat /etc/nginx/sites-available/default
# WebSocketSecure SSL Endpoint
#
# The proxy is also an SSL endpoint for WSS and HTTPS connections.
# So the clients can use wss:// connections 
# (e.g. from pages served via HTTPS) which work better with broken 
# proxy servers, etc.

server {
    listen 443;

    # host name to respond to
    server_name _;

    # your SSL configuration
    ssl on;
    ssl_certificate /tmp/localhost.crt;
    ssl_certificate_key /tmp/localhost.key;

    location / {
        # switch off logging
        access_log off;

        # redirect all HTTP traffic to localhost:8000
        proxy_pass http://localhost:8000;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header Host $host;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;

        # WebSocket support (nginx 1.4)
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection "upgrade";
    }
}



