<?php

class QuotasCalculator
{

  public function __construct($db, $id_project, $layer)
  {
      $this->db = $db;
      $this->id_project = $id_project;
      $this->layer = $layer;

      $this->result = false;
  }

  public function getResult()
  {
      return $this->result;
  }

  public function loadInterviwers()
  {
    $sql = "SELECT id_user, region FROM " . DB_WARPIT_WEBCATI_BASE . "._www_ids as a LEFT JOIN " . DB_WARPIT_WEBCATI_BASE . "._Interviewer as b ON b.id = a.id_user WHERE a.user_type IN(1,0) AND a.id_project = " . $this->id_project;
    $res = $this->db->SQLexecute($sql);

    $interviwers = array();
    while($row = $this->db->fetchAssoc($res))
    {
        $interviwers[$row['region']]['user_'.$row['id_user']] = null;
    }

    return $interviwers;
  }

  public function removeOverflow($result, $interviwers  = null)
  {
      $matrix = Matrix::getInstance();


      $data = $matrix->get();
      $userData = $matrix->getUser();
      $regionData = $matrix->getRegion();

      foreach($data as $var => $overflow)
      {

          if($overflow > 1)
          {
              $tmp = $overflow;
              while($tmp >= 1)
              {

                arsort($userData);
                $key = key($userData);
                $user = explode("_", $key);
                $user = $user[1];
                $needed = $interviwers->getTotal($user);

                while($result[$key][$var] <= 0 || $needed >= $userData[$key])
                {
                  next($userData);
                  $key = key($userData);

                  if(is_null($key)) exit;

                  $user = explode("_", $key);
                  $user = $user[1];
                  $needed = $interviwers->getTotal($user);
                }
                $region = $interviwers->getRegion($user);


                if($result[$key][$var] > 0)
                {
                  $result[$key][$var] -= 1;
                  $userData[$key] -= 1;
                  $data[$var] -= 1;
                  $regionData[$var] -= 1;
                  $tmp--;
                }
              }
          }
      }

      foreach($userData as $id_user => $cnt)
      {

          $user = explode("_", $id_user);
          $user = $user[1];

          $needed = $interviwers->getTotal($user);

          while($cnt > $needed)
          {
              asort($data);
              $key = key($data);



              while($data[$key] <= 0 || $result[$id_user][$key] <= 0 || $regionData[$key] <= 1)
              {
                next($data);
                $key = key($data);

                if(is_null($key)) break;
              }

              if(is_null($key))
              {
                  $keys = array_keys($data);

                  $keys = array_filter($keys,function($item) use($data, $result, $id_user){
                      return $data[$item] > 0 &&  $result[$id_user][$item] > 0;
                  });

                  if(array_sum($regionData) <= count($regionData))
                  {
                    $k = array_rand($keys);
                    $key = $keys[$k];
                  }

              }

              $result[$id_user][$key] -=1;
              $userData[$key] -= 1;
              $regionData[$key] -= 1;
              $data[$var] = 0;
              $cnt--;
          }
      }
      $matrix->restart();
      //print "ustavi javascript";*/


      return $result;
  }

  public function parseFile($filename)
  {
      $parser = new QuotaFileParser($filename);

      $interviwers = new Interviewers();
      $interviwers->loadInterviwers($this->id_project, $this->db);

      $this->result = array();
      $forest = array();
      //foreach ($parser->parse() as $row)
      foreach ($parser as $row)
      {
          if(array_key_exists("id_user", $row))
          {
              if(strlen($row['id_user']))
              {
                $interviwers->addTotal($row['id_user'], $row['total']);
              }
          }
          else
          {
              $tree = new CalculateTree();
              $tree->buildTree($row);

              $region = $tree->getRegion();
              $total = $interviwers->getRegionTotal($region);
              if($total > 0)
                $tree->setRegionTotal($total);

              $forest[] = $tree;
          }


          /*  $interviwersFromRegion = $interviwers->getFromRegion($region);
            if(count($interviwersFromRegion) > 0)
            {
              $tree->calculate($interviwersFromRegion);
              $this->result[$region] = $tree->getResult();
            }*/


      }

      foreach($forest as $tree)
      {
          $region = $tree->getRegion();
          $interviwers->calculateShare($region);
          $interviwersFromRegion = $interviwers->getFromRegion($region);
          $tree->calculate($interviwersFromRegion);
          $res = $tree->getResult();
          $this->result[implode('*', $region)] = $this->removeOverflow($tree->getResult(), $interviwers);


          //$this->result[$region] = $tree->getResult();
      }
  //    var_dump($this->result);
      return true;
  }

}
