<?php

class Interviewers
{
    private $interviewersList;

    private $regionTotal;

    public function __construct()
    {
      $this->interviewersList = array();
    }

    public function addTotal($id_user, $total)
    {
        $this->interviewersList[$id_user]['total'] = $total;
    }

    private function calculateRegionTotal()
    {
      $this->regionTotal = array();
      foreach($this->interviewersList as $id_user => $data)
      {
          if(array_key_exists($data['region'], $this->regionTotal))
            $this->regionTotal[$data['region']] += $data['total'];
          else
            $this->regionTotal[$data['region']] = intval($data['total']);

      }

    }

    public function calculateShare($region = null)
    {
        $this->calculateRegionTotal();
        foreach($this->interviewersList as $id_user => &$data)
        {
            if(is_null($region))
            {

              $region = $data['region'];
              $total = $this->getRegionTotal($region);

              $share = $data['total'] / $total * 100;

              $data['share'] = $share;
            }
            else
            {
              $total = $this->getRegionTotal($region);
              if(in_array($data['region'], $region))
              {
                  $shere = $data['total'] / $total * 100;

                  $data['shere'] = $shere;
              }
            }
        }
    }

    public function getTotal($id_user)
    {
      return $this->interviewersList[$id_user]['total'];
    }

    public function getRegion($id_user)
    {
      return $this->interviewersList[$id_user]['region'];
    }

    public function getFromRegion($region)
    {
        $rtnArray = array();
        foreach($this->interviewersList as $id_user => $data)
        {
            //if($data['region'] == $region)
            if(in_array($data['region'], $region))
              $rtnArray['user_' . $id_user] = array("total" => $data['total'], 'share' => $data['shere'], "region" => $data['region']);
        }

        return $rtnArray;
    }

    public function getRegionTotal($region)
    {
      if(!is_array($this->regionTotal) && !array_key_exists($region, $this->regionTotal))
      {
          $this->calculateRegionTotal();
      }

      if(is_array($region))
      {
          $sumRegions = 0;
          foreach ($region as $id_region)
          {
              $sumRegions += $this->regionTotal[$id_region];
          }

          return $sumRegions>0?$sumRegions:false;
      }
      return $this->regionTotal[$region]?$this->regionTotal[$region]:false;
    }

    public function loadInterviwers($id_project, $db)
    {
      $sql = "SELECT id_user, region FROM " . DB_WARPIT_WEBCATI_BASE . "._www_ids as a LEFT JOIN " . DB_WARPIT_WEBCATI_BASE . "._Interviewer as b ON b.id = a.id_user WHERE a.user_type IN(1,0) AND a.id_project = " . $id_project;
      $res = $db->SQLexecute($sql);

      while($row = $db->fetchAssoc($res))
      {
          $this->interviewersList[$row['id_user']] = array("region" => $row['region']);
      }
    }
}
