<?php

class QuotaFields
{
    public function __construct(\quotes $q)
    {
        $this->quotas = $q;
        $this->quotas->select_quota_layer();
    }

    private function getTelIndexName($name)
  	{
  	    if(in_array($name, ['oms', 'region', 'zip'])){
  	      return $name;
  	    }

  	    return 'tel_' . $name;
  	}

    private function getSourceMap()
  	{
  			foreach ($this->quotas->tel_quest_names as $value)
  			{
  					$source = end(explode('_', $value['id_s']));
  					switch($source)
  					{
  							case 2: $prefix = 'QT_';break;
  							default: $prefix = 'TP_';
  					}
  					$sourceMap[$value['name']] = $prefix;
  			}

  			return $sourceMap;
  	}

    public function getAllVariables()
    {

    }

    public function getQuotaVariables()
    {

    }

    public function getQuestionVariables()
    {

    }


    public function getVariables()
  	{
  			$sourceMap = $this->getSourceMap();

  			foreach($this->quotas->quota_layers as $layer)
  			{
  					foreach(explode(',', $layer['names']) as $q_name)
  					{
  							$field =  $sourceMap[$q_name] . $q_name;

  							$telIndexField = null;
  							if($sourceMap[$q_name] === 'TP_'){
  								$telIndexField = $this->getTelIndexName($q_name);
  							}

  							$fieldsList[$layer['id']][] = [
  									'name'		 		  => $q_name,
                    'structureName' => $field,
  									'telIndexName'  => $telIndexField,
  							];
  					}
  				}
  				return $fieldsList;
  	}
    private function returnStructureName($variable)
    {
        return $variable['structureName'];
    }

    private function returnTelIndexName($variable)
    {
        return $variable['telIndexName'];
    }

    public function getTelIndexColumns()
    {
        return $this->getFieldsList([$this, 'returnTelIndexName']);
    }

    public function getStructureColumns()
    {
          return $this->getFields([$this, 'returnStructureName']);
    }

    public function getFields($callback)
    {
          $variables =  $this->getVariables();

          $fields = [];
          foreach($variables as $layerId => $layer){
            foreach($layer as $variable){
                $fields[] = call_user_func($callback, $variable);
            }
          }
          //TODO can we somehow check this on fly in loop???
          return array_unique($fields);
    }


}
