<?php
/**
 * Enter description here...
 *
 */

 use \Defuse\Crypto\Crypto;
 use \Defuse\Crypto\Key;

class Engine {

	public $projname;
	public $id_project;
	public $id_record = 0;

	// array of all characters which should be replaced with space character in condition functions
	private $cleanChars = array("!","=","<",">","|","&",")","(",",","+","-","/","*","#");

	private $questionnaireFinished;
	protected $questFinApp;
	private $init = false;


	public $rotationString;
	public $doNotLog = false;

	public $finalStatus;
	public $finalRecStatus;
	public $StatisticsFinalStatus = 1;
	protected $notSaveFinal; // if status=0, we are not saving the final status

	public $idGenStruc;

	/**
	 * @var Display
	 */
	public $display;
	/**
	 * Enter description here...
	 *
	 * @var db
	 */
	public $db;

	/**
	 * Enter description here...
	 *
	 * @param db $db
	 * @param SurveySession $webSession
	 */
	function __construct($db,$webSession) {
	    //7.1.2015 sql injection
	    if(class_exists('convert'))
        {
            if(isset($_POST['RMclickLogger'])) $_POST['RMclickLogger'] = convert::toJson($_POST['RMclickLogger']);
        }

			$this->db 			= 	$db;
			$this->idGenStruc	=	$webSession->idGenStruc;

			if ($webSession->id_project) 	$this->id_project 	= 	$_SESSION['id_project']	= 	$webSession->id_project;
			if ($webSession->proj_name) 	$this->projname 	= 	$_SESSION['projname'] 	= 	$webSession->proj_name;
			//echo "id projekta: ".$this->id_project."<br>";

			$this->native_session_id 	= 	$webSession->GetNativeSessionId();

			$this->db->LogWrite("id_record:".$_SESSION['id_record'],true,"engine, construct");
			if (!$_SESSION['id_record']) {
                    $startDate = $_SESSION['start_date'];
                    $endDate = $_SESSION["end_date"];

                    if( ($_SESSION['user_type'] == 4 || $_SESSION['user_type'] == 2) && !is_null($_SESSION['validFrom']) && !is_null($_SESSION['validTo'])){
                        $startDate = $_SESSION['validFrom'];
                        $endDate = $_SESSION['validTo'];
                    }
					//echo "I do not have a record ID<br>";
					$this->init = true;
					if(!$_SESSION['testSurvey'] && (!$_SESSION['active'] || strtotime( $startDate ) > time() ||   strtotime( $endDate ) < time() ))
					{
						//echo "project is not active...<br>";
						$sql_wcobj = "SELECT id FROM ".DB_WARPIT_WEBCATI.".$this->projname WHERE q_pos = -16";
						//echo $sql_wcobj."<br>";
						$row = $this->db->fetchRow( $this->db->SQLexecute($sql_wcobj) );
							if(!$row)
							{
								echo "'Not allow' question not found!";
								exit;
							}
							$_SESSION['currentRotationString'] 	= $this->currentRotationString = "/".$row[0]."/";
							$this->hideForward = true;
							$this->hideBackward = true;
					}
					else
					{
					$this->CreateRotationString();

					//echo "WEB session status = ".$webSession->getQstatus()."<br>";
					$this->db->LogWrite("after Create rotation string",true,"engine, construc");
					if(($qStatus = $webSession->getQstatus()) > 0)
					{
						$this->doNotLog = true;
						if($qStatus == 1)
						{
							//echo "you cannot participate...";

							$row = $this->db->fetchRow( $this->db->SQLexecute("SELECT id FROM ".DB_WARPIT_WEBCATI.".$this->projname WHERE q_pos = -15") );
							if(!$row)
							{
								echo "'Not allow' question not found!";
								exit;
							}

							//20190321 Tanis: if we have picked language in language chooser we want to have same language on not allow question.
							$selectedLanguage = (int)$this->db->get($this->projname . "_structure", $_SESSION['id_structure'], 'id_language', DB_WARPIT_WEBCATI_BASE);

							if($selectedLanguage !== null) {
								$_SESSION['id_selectedQuestionLng'] = $selectedLanguage;
							}

							$_SESSION['currentRotationString'] 	= $this->currentRotationString = "/".$row[0]."/";
							$this->hideForward = true;
							$this->hideBackward = true;
						}
						else if($qStatus == 99)
						{

							$_SESSION['id_record'] = $this->id_record = $webSession->getIdStructure();
							$sql 	= "SELECT currentRotationString,questionnairePath FROM ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."___EngineLog
									WHERE id_structure = ".$this->id_record." ORDER BY id DESC LIMIT 1";
							//echo $sql;
							if(!$res = $this->db->SQLexecute($sql)) echo "searching appointment error: ".$this->db->GetError();
							$row= $this->db->fetchAssoc($res);
							$_SESSION['currentRotationString'] 	= $this->currentRotationString = $row['currentRotationString'];
							//echo $this->currentRotationString.'<br>';
							$_SESSION['questionnairePath'] 	=explode(';',$row['questionnairePath']);
							//we delete last position in qPath, becouse it is added again with searchNextQuestion
							unset($_SESSION['questionnairePath'][ count( $_SESSION['questionnairePath'] ) -1  ] );

							//let's get the first record in engineLog...this rotation string is similar to the whole rotation string
							/**
							 * Borut, 2015.06.23, read back the language used inside questionnaire
							 * id_language
							 */
							$sql = "SELECT id,currentRotationString,questionnairePath, id_language FROM ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."___EngineLog
									WHERE id_structure = ".$this->id_record." ORDER BY id ASC LIMIT 1";
							//echo $sql;
							if(!$res = $this->db->SQLexecute($sql)) echo "searching appointment error: ".$this->db->GetError();
							$row= $this->db->fetchAssoc($res);
							$_SESSION['rotationString'] = $this->rotationString = $row['currentRotationString'];

							/**
							 * Borut, 2015.06.23, set language
							 */
							$_SESSION['id_selectedQuestionLng'] = $row['id_language'];

		//					$sql = "UPDATE $this->projname"."_structure SET status = $this->finalStatus,status_rec=$this->finalRecStatus,t_start = ".time()." WHERE id = ".$_SESSION['app_middle'];
		//					$this->db->SQLexecute($sql);

						}
						else
							exit;
					}

					else
					{

						 if($_SESSION['has_user_quotas'] && $_SESSION['id_user'])//check if quotas are filled yes
						{

							$where = "QT_user_id = '".$_SESSION['id_user']."' AND QT_user_type = ".$_SESSION['user_type'];
							$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
							//check if quota is active
							$active = $this->db->get("quota_layer_addon",$_SESSION['has_user_quotas'],'active');

							if($active)
							{

								//20160718 Tanis: added enabled flag.
								$sql = "SELECT q_value, enabled FROM $this->projname"."___quotaLimits WHERE id_layer = {$_SESSION['has_user_quotas']} AND ".$where;
								$res = $this->db->SQLexecute($sql);
								$qLimit = $this->db->fetchRow($res);

								//20160718 Tanis: added enabled flag
								$enabled = $qLimit[1];
								$qLimit = $qLimit[0];

								$sql = "SELECT count(*) FROM $this->projname"."___quotaCalc WHERE ".$where;
								$res = $this->db->SQLexecute($sql);
								$qVal = $this->db->fetchRow($res);
								$qVal = $qVal[0];

								//20160718 Tanis: we check if quota is enabled and if it is full
								if($qVal >= $qLimit && $enabled)
								{
									$quotaFull = true;

								}
							}
						}

						if($quotaFull)
						{
							$row = $this->db->fetchRow( $this->db->SQLexecute("SELECT id FROM ".DB_WARPIT_WEBCATI.".$this->projname WHERE q_pos = -2") );
								if(!$row)
								{
									echo "'Quota full' question not found!";
									exit;
								}
								$_SESSION['currentRotationString'] 	= $this->currentRotationString = "/".$row[0]."/";
								$this->jumpSkipFilter = true; //becouse in defaults it skips quota question
								$this->hideForward = true;
								$this->hideBackward = true;
						}
						else
						{

							$this->db->LogWrite("before create empty record",true,"engine, construct");
							$this->CreateEmptyRecord();
							//running project script!
							$sql = "SELECT script,id_event FROM ".DB_WARPIT_WEBCATI.".".$this->projname."_script WHERE id_question = 0 AND id_event = 1";
							$res = $this->db->SQLexecute($sql);


							// Added by Borut, 2015.06.15
							// if this is a CAPI, here I need to call javascript parent that interview is finished
							/*
							echo "<pre>";
							var_dump($_SESSION);
							echo "</pre>";
							*/
							if ($_SESSION['capi']) {
								echo "<script>parent.saveIDstructure('".$_SESSION['loginSID']."',".$_SESSION['id_record'].")</script>";
							}


							while($src = $this->db->fetchRow($res))
							{
								$script = $src[0];
								include_once (PATH_TO_ROOT.'survey/usrs_methods.php');
		//						$GLOBALS['qInfo'] = $zad;
								$GLOBALS['engine'] = $this;
								eval('try {'.  $script . ' } catch (Exeption $e) { echo "Error in beforeload script!<br> $e"; };' );

		//						$zad = $GLOBALS['qInfo'];
							}
						}

					}

				}
			} else {

				foreach ($_SESSION as $key=>$val) {
					//echo "IF _SESSION['id_record'] -> Session ->".$key." -> ".$val."<br>";
					$this->$key = $val;
				}
			}
			$this->LeaveQuestion = true;
			$this->EngineTime = 0;
	}

	function __destruct() {
		/*$sql = "INSERT INTO ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."___EngineLog
					 (id_structure,q_name,q_pos,engineTime)
					  VALUES (
					  		  ".$this->id_record.",
					  		  ".$_SESSION['nextQuestion']['id'].",
					  		  ".$_SESSION['nextQuestion']['name'].",
					  		  1".$this->EngineTime."
					  		  )";
		$this->db->SQLexecute($sql);		*/
	}


	function isInitialization() { return $this->init; }

	function getAddress() {
		$lanAddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
		$wanAddress = $_SERVER['REMOTE_ADDR'];

		$address = $wanAddress;
		if ($lanAddress) $address .= " [".$lanAddress."]";

		return $address;
	}

	function CreateEmptyRecord()
	{



		// lets check if we have any extra vars and add them to the structure!
		// WARNING: this works only with popup where the get variables are still available!
		$sql = "SELECT var_name FROM ".DB_WARPIT_WEBCATI_BASE."._ProjectExtraVariables WHERE id_project = ".$this->id_project;
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchRow($res)) {
			if($_GET[ $row[0] ])
			{
				$extraVars .= ", EV_".$row[0];
				$extraVals .= ",'".$_GET[ $row[0] ] ."'" ;
			}
		}

		// for id_site and id_capi_sample over GET method we make exception, and save it into database.
		if ( $_GET['id_site'] ) {
			$extraVars .= ", id_site";
			$extraVals .= ",'".$_GET['id_site'] ."'" ;
		} else {
            $webcatiConfig = configLoader::loadConfig('webcati');

            $replaceCharacter = $webcatiConfig['anonymization_ip_character'];
            if(strlen($replaceCharacter) <= 0){
                $replaceCharacter = $this->getAddress();
            }

			$extraVars .= ", id_site";
			$extraVals .= ",'".$replaceCharacter."'" ;
		}

		// all is needed for CAPI with samples *******************************
		// Borut - 2015.07.02
		if ( $_GET['IDsampleMain'] ) {
			$extraVars .= ", id_capi_address";
			$extraVals .= ",'".intval($_GET['IDsampleMain']) ."'" ;
		}

		if ( $_GET['IDsampleTable'] ) {
			$extraVars .= ", id_capi_table";
			$extraVals .= ",'".intval($_GET['IDsampleTable']) ."'" ;
		}

		if ( $_GET['IDsampleProject'] ) {
			$extraVars .= ", id_capi_sample";
			$extraVals .= ",'".intval($_GET['IDsampleProject']) ."'" ;
		}

        	if ( $_GET['address'] ) {
			$extraVars .= ", address_1";
			$extraVals .= ",'" . $_GET['address'] . "'" ;
		}
		// *******************************************************************


		// added 3.3.2014, link to external pool ID over unique link can be made also to full user_id column
		// with predefined from external pool system
		if ($this->idGenStruc) {
			$userIDstruc = $this->idGenStruc;
		} else {
			$userIDstruc = $_SESSION['id_user'];
		}
		$this->db->LogWrite("create empty record:".$this->idGenStruc,true,"inside engine");


		// we can insert forced ID of the structure, if we need connected projects with IDs
		$predifinedID = "null";
		if ( $_GET['structurePreDef'] ) {
			$predifinedID = $_GET['structurePreDef'];
		}

		// Add by Borut 2015.01.26
		// in case of merged projects, we fill sp_man column with send ID from previous project
		$ID_structure_merged = "null";
		if ( $_GET['ID_structure_merged'] ) {
			$ID_structure_merged = intval($_GET['ID_structure_merged']);
		}

		$id_language = $_SESSION['id_selectedQuestionLng'] ? $_SESSION['id_selectedQuestionLng'] :  $_SESSION['id_defaultQuestionLng'];

		// Add by Borut 2015.01.26, fill of sp_man column, it was ment for special sampling, but now it is used for merged project IDs
		$sql = "INSERT INTO ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure (id,user_id,user_type,t_start,d_start,id_device,id_language,sp_man,id_loginSID $extraVars)
			 VALUES ($predifinedID,'".$userIDstruc."',{$_SESSION['user_type']},".time().",'". date("Y-m-d H:i:s") . "',". $_SESSION['detectedDevice'] .",'$id_language',$ID_structure_merged,".$_SESSION['id_loginSID']." $extraVals )";
		//echo $sql."<br><pre>".print_r($_SESSION)."</pre>";
		if(!$this->db->SQLexecute($sql)) echo "create empty record error: ".$this->db->GetError();

		/*
		 * because we want to manualy set the ID of the record we check if we GET ID from the link
		 * If not, we check last inserted ID with MySQL function
		 * Borut add 02.12.2012
		 */
		if ( $_GET['structurePreDef'] ) {
			$insertedStructureID = $_GET['structurePreDef'];
		} else {
			$insertedStructureID = $this->db->GetLastInsertId();
		}
		$_SESSION['id_record'] = $this->id_record = $insertedStructureID;

		$sql =	" INSERT INTO ".DB_WARPIT_WEBCATI_BASE."._www_interviewer_statistics SET
								id_user 		= '".$_SESSION['id_user']."',
								user_type		= ".$_SESSION['user_type'].",
								id_project 		= '".$_SESSION['id_project']."',
								id_loginSID 	= '".$_SESSION['id_loginSID']."',
								id_sessionSID 	= '".$this->native_session_id."',
								startDate 		= NOW(),
								id_structure 	= ".$this->id_record.",
								qStatus			= 99 ";
		//echo $sql."<br>";
		if(!$this->db->SQLexecute($sql)) echo "create empty record error: ".$this->db->GetError();

	}


	private function getRotationDefinition($id_project) {
		$sql = "SELECT id, is_rotated FROM ".DB_WARPIT_WEBCATI_BASE."._QuestionRotation WHERE id_project=$id_project AND type=1";
		//echo $sql."<br>";
		if(!$res = $this->db->SQLexecute($sql)) echo "create rotation string error: ".$this->db->GetError();
		while ($zad = $this->db->fetchAssoc($res)) {
			$rotationDefinition[$zad['id']] = $zad['is_rotated'];
		}

		return $rotationDefinition;
	}


	function CreateRotationString() {

		$packetExists = 0;
		$comPacket = array();
		$rotationStrStart = 0;

		$rotationDefinition = $this->getRotationDefinition($this->id_project);

		// searching for all questions in questionnaire

		$sql = " SELECT a.id, q_pos, q_name, id_sup, id_complex
						FROM ".DB_WARPIT_WEBCATI.".".$this->projname." AS a
							LEFT JOIN ".DB_WARPIT_WEBCATI_BASE."._QuestionRotation AS b ON a.id = b.id_question
									  AND b.id_project = ".$this->id_project." ORDER BY a.q_pos";
		//echo $sql."<br>";
		if(!$res = $this->db->SQLexecute($sql)) echo "create rotation string error: ".$this->db->GetError();
		while ($zad = $this->db->fetchAssoc($res)) {

			if ($zad['id_sup'] && $zad['id_complex']) {

				$comPacket[$zad['id_complex']][$zad['id_sup']][$zad['id']] = $zad['id'];

				$packetArray[$zad['id_sup']][$zad['id']] = $zad['id'];

				if ($packetExists != $zad['id_sup']) $rotationStr['Pack'.$zad['id_sup']] = "|Packet".$zad['id_sup']."|";

				$packetExists = $zad['id_sup'];
			//end question with position gets put on last place
			} else if($zad['q_pos'] == -5)
				$endQuestionId = $zad['id'];
			else if($zad['q_pos'] == -4)
				$confirmQuestionId = $zad['id'];
            //20170116 Bojan Orter - i added another condition, when to add repeal into rotation string. We only add it if its pop up survey (user_type == 3)
            else if($zad['q_pos'] == -3 && $_SESSION["user_type"] == 3)
                $repealQuestionId = $zad['id'];

			else if($zad['q_pos'] == -15 || $zad['q_pos'] == -16)
			{//this question SHALL not be in rotation string! yaay for me :D

			}
			else if($_SESSION['popUpQuestionnaire'] &&  ($zad['q_pos'] == -10 || $zad['q_pos'] == -9 || $zad['q_pos'] == -8) )
			{//popUpquestionnaires skip dialer and status questions!

			}
			else{ if($zad['q_pos'] < 0)
						$rotationStrStart ++;
				  if($zad['q_pos'] == -6)
				  	$_SESSION['rotFirstQuestion'] = $zad['id'];

				$rotationStr['quest'.$zad['id']] = $zad['id'];  $packetExists = 0; }


		}

		if($endQuestionId)
			$rotationStr['quest'.$endQuestionId] = $endQuestionId;
		if($confirmQuestionId)
			$rotationStr['quest'.$confirmQuestionId] = $confirmQuestionId;
        if($repealQuestionId)
            $rotationStr['quest'.$repealQuestionId] = $repealQuestionId;


		// if we have rotation on last question

		//echo implode(",",$rotationStr);

		//echo "<br /><br />";
		// create rotations
		foreach ($comPacket as $complex => $packets) {

			$rotPacket = array();
			$packetString = array();

			foreach ($packets as $packetID => $packetVars) {

				//if I have an option to sort also packets I did this here
				if ($rotationDefinition[$packetID] == 1) {
					shuffle($packetVars);
					$packetArray[$packetID] = $packetVars;
				}

				$rotPacket[] = $packetID;
			}

			shuffle($rotPacket);

			$i = 0;
			foreach ($packets as $packetID => $fake) {
				//$EndOrder[$packetID] = $rotPacket[$i];

				$rotationStr['Pack'.$packetID] = implode("/",$packetArray[$rotPacket[$i]]);
				//echo $packetID." -> ".$rotPacket[$i]."<br />";
				$i++;
			}

			//echo "<br>".implode(",",$rotPacket);
			//echo "<hr>";

		}
		//echo "<hr>".implode("/",$rotationStr);
		//exit;
		// filling two string variables
		// - session variable
		// - class variable
		// - current rotation string

		$_SESSION['rotationString'] 		= $this->rotationString 		= "/".implode("/",$rotationStr)."/";
		//where does our question string start (ignoring all system questions)
		//this is used if you want to jump to a certian position...for example the 5th question regardless of rotation
		$_SESSION['rotationStrStart'] = $rotationStrStart;
		//this is used in progress bar to calculate the % complete
		$_SESSION['rotationStrLength'] = count($rotationStr)-$rotationStrStart-1; //taking out end!
		$_SESSION['currentRotationString'] 	= $this->currentRotationString 	= $this->rotationString;

		$this->getFirstLastQuestions();

		//echo "rotation string: ".$this->currentRotationString."<br>";

	}
	function getFirstLastQuestions()
	{
		$q = explode('/',$this->rotationString);
		//first and last items are blank
		if(!$_SESSION['rotFirstQuestion']) //if this was not set with welcome template!
			$_SESSION['rotFirstQuestion'] = $q[1 + $_SESSION['rotationStrStart'] ];
		$_SESSION['rotLastQuestion'] = $q[ count($q) -1  ];

	}

	function ConditionSandBox($aTableVarArray, $conditonString ) {
		if (!trim($conditonString)) return true;
		if ($aTableVarArray) foreach ($aTableVarArray as $val) { eval($val); }
		#soulskiner
		//echo $conditonString;
		eval(" if (".$conditonString.") \$returnValue = true; else \$returnValue = false;");

		return $returnValue;

	}



	function prepareArrayForSandBox($aArray){

		if (!is_array($aArray)) return array();

		foreach ($aArray as $key => $val) $returnArray[$key] = "\$".$key." = '".addslashes($val)."';";
		return $returnArray;

	}

  public function decryptData($data)
  {
        $fields = array();
        $q_name = array();
        if($data)
        {

          foreach($data as $fieldName => $fieldValue)
          {
            //mr1_1 => mr1
            $underPos = strpos($fieldName, "_");
            $currentField = substr($fieldName, 0, $underPos);
            $q_name[] = "'" . $currentField . "'";
            $fields[$fieldName] = $currentField;
          }
        }
        if($q_name)
        {
          $opens = $this->db->get($this->projname, "q_name IN(" . implode(",", $q_name) . ") AND tip_sql = 4 AND encrypt = 1", "q_name", DB_WARPIT_WEBCATI);

          $surveyConfig = configLoader::loadConfig('survey');
          foreach($data as $fieldName => $fieldValue)
          {
            $currentField = $fields[$fieldName];
             if(( $opens && in_array($currentField, $opens)))
             {
                if($fieldValue)
                {
                  $data[$fieldName] = Crypto::decrypt($fieldValue, Key::loadFromAsciiSafeString($surveyConfig['encryptionKey']));
                }
             }
          }
        }

        return $data;


  }

	function readDatabaseVariables($aTableVariables = array(),$prepSandbox = true) {

		// if their is nothing to do I return false
		if (!is_array($aTableVariables) || count($aTableVariables) == 0) return false;

		$returnArray = array();

		$sql = "SELECT ".implode(",",$aTableVariables)." FROM ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure WHERE id = ".$this->id_record;
		//echo $sql;
		try{
        $res = $this->db->SQLexecute($sql);
		    $zad = $this->db->fetchAssoc($res);

      } catch(Exception $e) { echo "read database variables error: ".$this->db->GetError();

		echo "<br>There is an illegal variable defined in a condition text!";
		}

      $zad = Engine::decryptData($zad);

		if($prepSandbox)
		return $this->prepareArrayForSandBox($zad);

		return $zad;

	}

	function ManageHttpLink($aLink) {

		//$alink = str_replace("&"," &",$aLink);
		if( substr($aLink,0,7) != "http://" && substr($aLink,0,8) != "https://") $aLink = "http://".$aLink;

		$aVar = $this->returnConditionVariables($aLink);
		unset($aVar['loginSID'], $aVar['idRecord']);
		$loginSID = $_SESSION['loginSID'];
		$idRecord = $this->id_record;

		if ($aVar) {
			$preparedVars =  $this->readDatabaseVariables($aVar,true);
			if ($preparedVars) foreach ($preparedVars as $val) { eval($val); }
		}
		eval("\$returnLink = \"".$aLink."\";");
		return str_replace(" ","",$returnLink);
	}


	/**
	 * Enter description here...
	 *
	 */
	function FinishQuestionnaire() {
        if(isset($_SESSION["parentData"]))
        {
            include_once(PATH_TO_ROOT."survey/class.ProjectJumpManager.php");
            $jumpManager = new ProjectJumpManager($this->db);
            $jumpManager->executeResetMainProjectContext();
        }

		global $call_center;
		global $call_center_CallUniqueId;

		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
		//this is not an extremly wise idea! please change ASAP :)
		if(!isset($this->finalStatus)) $this->finalStatus = 1;
		if(!isset($this->finalRecStatus))
    {
        if($this->gotoIdle && $this->finalStatus != 1)
          $this->finalRecStatus=2;
        else if ($_SESSION['testSurvey'])
          $this->finalRecStatus = 2; //testing surveys get recStatus 2!
        else
          $this->finalRecStatus = 1;

        //20170106 Tanis: If we have more then one appointment status we display them again on
        // appointment screen and here we need to save right status
        if($_POST['appointmentStatusRec'] && !$_SESSION['testSurvey'])
        {
            $this->finalRecStatus = intval($_POST['appointmentStatusRec']);
            // status = 91 and status_rec = 20 call some other time(not fixed) appointment on status screen
            // status = 91 and status_rec = 21 call some other time(not fixed) appointment on  screen with gotoidle
            // status = 91 and status_rec = 22 call some other time(not fixed) appointment with gotoidle
            if($this->finalRecStatus == 20 ||$this->finalRecStatus == 10)
            {
              if($this->gotoIdle)
                $this->finalRecStatus += 2;
              else if($this->makeApp)
                $this->finalRecStatus += 1;
            }
        }
        //20170106 Tanis: END
    }

		// in case I have set in main config that last user is the owner of the record I save also user_id
		unset($owner_reset);
		if (DB_RECORD_OWNER != "creator") {
			$refillUserId = $_SESSION['id_user'];
			if (isset($_SESSION['id_user_external'])) $refillUserId = $_SESSION['id_user_external'];
			$owner_reset = "user_id = ".$refillUserId.",user_type = ".$_SESSION['user_type'].",";
		}
		//20181121 Tanis: we want to prevent negative valuse in t_diffs and prevent error raising because of wrong types
		$sql = "UPDATE  ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure SET
					flag_bad = 1,
					$owner_reset
					status = $this->finalStatus,
					status_rec = $this->finalRecStatus,
					t_diffs = IF((t_diffs + cast(t_stop as signed) - cast(t_start as signed)) > 0, (t_diffs + cast(t_stop as signed) - cast(t_start as signed)), t_diffs)
					WHERE id = ".$this->id_record;
//		echo $sql;

		$this->db->SQLexecute($sql);


		//update interview_statistic table
		$sql = "UPDATE _www_interviewer_statistics SET qStatus = ".$this->StatisticsFinalStatus." WHERE id_project = ".$this->id_project."  AND id_structure = ".$this->id_record;
		$this->db->SQLexecute($sql);
		if($_SESSION['id_tel'])
		{
			if($this->questFinApp)
      {
        $finalStatusIfApp = 91;
        //20160720 Tanis: pri appointmentih, ki se ne kličejo avtomatsko ampak ročno se upošteva tudi status_rec
        // zato je potrebno v primeru, da imamo appointment, v tabeli ___telIndex shraniti tudi status_rec
        // od zadnjega appointmenta
        $finalStatusRecifApp = $this->oldStatusRec?$this->oldStatusRec:$this->finalRecStatus;
      }
			else
      {
        $finalStatusIfApp = $this->finalStatus;
        $finalStatusRecifApp = $this->finalRecStatus;

      }

			if (!$this->notSaveFinal) {
				$sql = "UPDATE $this->projname"."___telIndex SET status = $finalStatusIfApp,status_rec=$finalStatusRecifApp WHERE id_tel=".$_SESSION['id_tel'];
				$this->db->LogWrite($sql, true, "FinishQuestionnaire() - index");
				$this->db->SQLexecute($sql);

				$sql = "UPDATE ".$_SESSION['telName']." SET status = $this->finalStatus,status_rec=$this->finalRecStatus,proj_status = $this->finalStatus,proj_status_rec=$this->finalRecStatus WHERE id=".$_SESSION['id_tel'];
				$this->db->LogWrite($sql, true, "FinishQuestionnaire() - tel");
				$this->db->SQLexecute($sql);
			}

			$sql = "UPDATE $this->projname"."___telLog SET status = $this->finalStatus, status_rec = $this->finalRecStatus,end_time = '".time()."' WHERE id = ".$_SESSION['id_tellog'];
			$this->db->LogWrite($sql, true, "FinishQuestionnaire() - log");
			$this->db->SQLexecute($sql);
		}
		$sql = "SELECT id FROM ".DB_WARPIT_WEBCATI_BASE.".quota_layer WHERE id_project = $this->id_project LIMIT 1";
		$useQuotas = $this->db->fetchRow($this->db->SQLexecute($sql));
		if($useQuotas && $this->finalStatus == 1 && $this->finalRecStatus == 1)
		{

			$qFields = $this->db->GetFields($this->projname."___quotaCalc");
			foreach ($qFields as $name) {
				if($name != 'QT_user_id' && $name != 'QT_user_type')
				{
					$allFeilds[] = $name;
				}
			}

			$sql = "SELECT user_id,user_type,".implode(',',$allFeilds) ." FROM $this->projname"."_structure WHERE id = $this->id_record ";
			$TPfields = $this->db->fetchAssoc ($this->db->SQLexecute($sql) );


			$sql = "REPLACE INTO $this->projname"."___quotaCalc(QT_user_id,QT_user_type,".implode(',',$allFeilds) .") VALUES ('".implode('\',\'',$TPfields) ."')";
			$this->db->SQLexecute($sql);
			//let's check if any telephone quotas are fuuulll!

			$sql = "SELECT layer,q_name FROM quota_layer a LEFT JOIN quota_layer_addon b ON a.layer=b.id WHERE id_project = $this->id_project AND telSelect = 1 AND active = 1";
			$res = $this->db->SQLexecute($sql);
			while ($row = $this->db->fetchRow($res))
			{
				$telLayers[ $row[0] ][] = 'TP_'.$row[1];
			}
			if ($telLayers) {
				foreach ($telLayers as $id_layer => &$layerCols) {
					$limCond = array();
					foreach ($layerCols as $lCol) {
						$limCond[] = $lCol.' = '. $TPfields[ $lCol ] ;
					}
					$sql = "SELECT count(*) FROM $this->projname"."___quotaCalc WHERE ".implode(' AND ',$limCond);
					$qNum =  $this->db->fetchRow ($this->db->SQLexecute($sql) );
					$qNum = $qNum[0];

					//20160718 Tanis: added enabled flag.
					$sql = "SELECT q_value, enabled FROM $this->projname"."___quotaLimits WHERE id_layer = $id_layer AND ".implode(' AND ',$limCond);
					$qLimit =  $this->db->fetchRow ($this->db->SQLexecute($sql) );
					//20160718 Tanis: added enabled flag.
					$enabled = $qLimit[1];
					$qLimit = $qLimit[0];

					//20160718 Tanis: added enabled flag.
					if($qNum >= $qLimit && $enabled)
					{
						//lock all the fields that contains those conditions!
						$sql = "UPDATE $this->projname"."___quotaLock SET isLocked = 1 WHERE ".implode(' AND ',$limCond);
						$this->db->SQLexecute($sql);

					}
				}
			}

		}
		//of projects has webpoints conditions we assign them!
			//of projects has webpoints conditions we assign them!
	//20151013 Tanis since new incentive system we have new procedure to calclulate points
  //20161013 Tanis we can add points only on web survey

    if($_SESSION['user_type'] == 2)
    {
		    include_once(PATH_TO_ROOT . '/webcati/_class/class.WebPoints.php');
		    $wp = new WebPoints($this->db);
		    $wp->recalculatePointsForProject($this->id_project,$this->id_record);
	      //20151013 Tanis END
    }
  //20161013 Tanis END


	 /*	$sql = "SELECT * FROM _wwwPointsStructure WHERE id_project = ".$this->id_project.". AND enabled = 1 ORDER BY priority";
		$webPoints = $this->db->SQLexecute($sql);
		while($wpRow = $this->db->fetchAssoc($webPoints))
		{
			$points = $wpRow['setpoints'];
			$cnd = $wpRow['sql_condition'];

			$sql = "INSERT IGNORE INTO _wwwPoints (id_project,id_user,webPoints) SELECT ".$this->id_project.", user_id, ".$points." FROM ".$this->projname."_structure WHERE (".$cnd.") AND id = ".$this->id_record;

			//$sql = "UPDATE _www_interviewer_statistics a INNER JOIN ".$this->projname."._structure b ON a.id_structure = b.id SET webPoints = $points WHERE ($cnd) AND b.id = $this->id_record";
			$this->db->SQLexecute($sql);
			if($this->db->affectedRows() > 0) break;

		}*/


		/*
		*/
		$sql = "SELECT script,id_event FROM ".DB_WARPIT_WEBCATI.".".$this->projname."_script WHERE id_question = 0 AND id_event = 2";
		$res = $this->db->SQLexecute($sql);
		$src = $this->db->fetchRow($res);
		$script = $src[0];
		include_once (PATH_TO_ROOT.'survey/usrs_methods.php');
		// $GLOBALS['engine'] = $this;
		eval('try {'.  $script . ' } catch (Exeption $e) { echo "Error in finish questionnaire Script<br> $e"; };' );

		//file_put_contents("/tmp/post_display.txt", "cisto notri:".print_r($call_center_CallUniqueId,true)."\n", FILE_APPEND | LOCK_EX);
				//added by Sandi Jersic 26.11.2013
				//check if call request is coming from call center
		if($call_center == 1 && strlen($call_center_CallUniqueId) > 0 )
		{
			//file_put_contents("/var/sandek/log/rareEvent.txt", "SESSION: ".print_r($_SESSION,true)."\n", FILE_APPEND | LOCK_EX);
			//require_once(PATH_TO_ROOT."survey/predictive/class.RM_AsteriskManager_predictive.php");
			include_once(PATH_TO_ROOT.'../../../../opt/sors/api/api.php');
			require_once(PATH_TO_ROOT."../../../../opt/sors/etc/config.php");
			require_once(PATH_TO_ROOT."../../../../opt/sors/classes/class.SolvexMemcache.php");

			$sql = "UPDATE ".DB_WARPIT_WEBCATI_BASE."._callCenter_CallStatusesOUT SET DataTimeEnd=NOW() WHERE IdUser=".$_SESSION['id_user']." AND userType=".$_SESSION['user_type']." AND DataTimeEnd='0000-00-00 00:00:00'";
			$this->db->SQLexecute($sql);

			//file_put_contents("/var/sandek/log/zzz3.txt", "callUnique: ".print_r($call_center_CallUniqueId,true)."\n", FILE_APPEND | LOCK_EX);
			$mc = new SolvexMemcache('localhost',11211);
			$agents = $mc->getKeyValue('agents');

			$agentUniqueId = '';
			foreach($agents as $ag){
				if($ag['id'] == $_SESSION['id_user'] && $ag['userType'] == $_SESSION['user_type']){
					$agentUniqueId = $ag['asteriskid'];
					break;
				}
			}

			$api = new apiAkcije();
			$conf = new config();
			$api->hangup($call_center_CallUniqueId);

			$msgQueue = msg_get_queue($conf->memcacheActionQueueId);
			$tmp['action'] = 'update';
			$tmp['key'] = 'agents';
			$tmp['object']['name'] = 'agents';
			$tmp['object']['writer'] = 'autooutbound';
			$tmp['object']['prop'] = array('busy','ts','asteriskid'); //asteriskid MUST always be on the 3rd place
			$tmp['object']['values'] = array(0,time(),$agentUniqueId); //asteriskid MUST always be on the 3rd place
			msg_send($msgQueue,1,$tmp);
			//file_put_contents("/var/sandek/log/rareEvent.txt", "SESSION: ".print_r($tmp,true)."\n", FILE_APPEND | LOCK_EX);
		}

		$this->db->LogWrite("call_center:".$call_center,true,"call center v FinishQuestionnaire()");
		//file_put_contents("/tmp/post_display.txt", $call_center." pred:".print_r($call_center_CallUniqueId,true)."\n", FILE_APPEND | LOCK_EX);
		if(!$_SESSION['popUpQuestionnaire'] && $_SESSION['autoDialing'])
		{//file_put_contents("/tmp/post_display.txt", "notri:".print_r($call_center_CallUniqueId,true)."\n", FILE_APPEND | LOCK_EX);


			//ugasnem xlite ako je!
			require_once(PATH_TO_ROOT."survey/predictive/class.RM_AsteriskManager_predictive.php");

	  				extract( configLoader::loadConfig('asterisk_dialing'));
					$am_addqueue = new RM_AsteriskManager_predictive($this->db);
	  				$interna_stevilka = $_SESSION['asteriskID'];
	  				$id_user = $_SESSION['id_user'];

	  				if ($am_addqueue->LogOn($asterisk_username, $asterisk_password, $asterisk_ip, $asterisk_port, $interna_stevilka , $id_user  )) {

	  					$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
	  					$am_addqueue->Hangup($interna_stevilka);
	  					if(!$this->gotoIdle)
	  						sleep(2);
	  				}
	  				else
	  				{
	  					echo "logon ni uspel";
	  				}
		}

		$this->questionnaireFinished = true;

		// Added by Borut, 2015.06.15
		// if this is a CAPI, here I need to call javascript parent that interview is finished
		/*
		echo "<pre>";
		var_dump($_SESSION);
		echo "</pre>";
		*/
		if ($_SESSION['capi']) {
			echo "<script>parent.endCapi(".$this->finalStatus.",".$this->finalRecStatus.",'".$_SESSION['loginSID']."',".$_SESSION['id_record'].")</script>";
		}


		//ce si finishiral ne smes it naprej al ???
		$this->hideForward = true;

		 //checking redirections!!!
		 if($this->redirectActive)
		 {
		 	echo "redirecting...";
			//20160915 Tanis: If we define dynamic_redirect extra field and send base64_encoded in it will be automaticly redirected to this link after last question
			$extraFields = $this->db->get('_ProjectExtraVariables', "id_project = " . $this->id_project . " AND var_name= 'dynamic_redirect'", 'var_name',DB_WARPIT_WEBCATI_BASE);
		 	if($this->redirectLink)
		 	{
				$this->redirectLink = $this->ManageHttpLink($this->redirectLink);
		 		if($this->redirectDelay)
	 				echo "<script>setTimeout(\" document.location='".$this->redirectLink."';\" ,$this->redirectDelay)</script>";
	 			else
		 			echo "<script>document.location='".$this->redirectLink."';</script>";
		 	}
			else if($extraFields)
			{
					$redirectLink = $this->db->get($this->projname . "_structure", $this->id_record, "EV_dynamic_redirect", DB_WARPIT_WEBCATI_BASE);

					$redirectLink = base64_decode($redirectLink);

					//print $redirectLink;
					if($redirectLink)
						echo "<script>document.location='".$redirectLink."';</script>";


		 	}
		 	else if( $this->finalStatus == 1 )
		 	{
			 	$sqlRedirect = $this->db->SQLexecute("SELECT * FROM ".DB_WARPIT_WEBCATI_BASE."._ProjectRedirectionsConditions WHERE id_project = $this->id_project AND systemCnd = -1");
			 	while ($rowRedirect = $this->db->fetchAssoc($sqlRedirect))
			 	{
			 		$redirectVaribales = $this->readDatabaseVariables($this->returnConditionVariables($rowRedirect['userCnd']));
			 		if($this->ConditionSandBox($redirectVaribales,$rowRedirect['userCnd']))
			 		{
			 			$link = $this->db->get('_ProjectRedirectionsLinks',$rowRedirect['id_link'],'link',DB_WARPIT_WEBCATI_BASE);

			 			$this->redirectDelay = $rowRedirect['delay'];

			 			$link = $this->ManageHttpLink($link);

			 			if($this->redirectDelay)
			 				echo "<script>setTimeout(\" document.location='".$link."';\" ,$this->redirectDelay)</script>";
			 			else
			 				echo "<script>document.location='".$link."';</script>";
			 		}
			 	}
		 	}

		}
		else if($id_mergedProject = $this->checkMergedProjects())
		{
			// Added by Borut 2015.01.26
			// Checking, if project is merged with some other and should continue on next link
			// Curently only support for WEB UNIQUE links are programmed
			$link = $this->createUniqueLink($id_mergedProject);
			if ($link)
			{
				//echo $link;
				echo "<script>document.location='".$link."';</script>";
			}
		}
		else
		{

			//order the browser to start a new quiestionare	or go to login screen
			if($this->gotoIdle){
				// we add dropdown for selectiong the reason for going IDLE
  				// Added by Marko, 2014.11.05
				$this->saveGotoIdleReason($this->gotoIdleReason);
				// *******************************************************

        //20171027 Tanis: if we have quotafull status and go to idle we need to show quotafull screen
        // if we break the interview on quota full screen we want to have redirect
        //
        // More info:
        //   https://gitlab.solve-x.net/warpit/warpit/issues/129
        if($this->finalStatus == 51 && $_POST['startNew'] === null){
            return;
        }

				if($call_center == 1){
					echo "<script>document.location='".PATH_TO_ROOT."tel/index.php?&call_center=1';window.parent.activeOutboundProjectId=0;</script>";
				}
				else{
					echo "<script>document.location='".PATH_TO_ROOT."tel/index.php';</script>";
				}

			}

			else if($this->questionnaireContinue)
			{//in web interview we want to show some final thank you page after the questionairre is finished

			}
			else  if(!$_SESSION['popUpQuestionnaire']){
                $testGET = (isset($_SESSION['testSurvey']) && $_SESSION['testSurvey']) ? "&test=1" : "";
				if($call_center == 1){
					echo "<script>document.location='?loginSID=".$_SESSION['loginSID']."&asteriskID=".$_SESSION['asteriskID']."&call_center=1$testGET';window.parent.activeOutboundProjectId=0;</script>";
				}
				else{
					echo "<script>document.location='?loginSID=".$_SESSION['loginSID']."&asteriskID=".$_SESSION['asteriskID']."$testGET';</script>";
				}
			}
		 }


	}


	/**
	 * get next merged project id
	 * Added by Borut, 2015.01.26
	 * Changed by Tanis 2015.07.31 to public
	 */
	public function checkMergedProjects() {
		// get result only, if projects are merged
		$sql = "SELECT b.id AS id_project,b.merged AS order_project,c.id AS id_folder, c.merged
				FROM " . DB_WARPIT_WEBCATI_BASE . ". `_ProjectsTree` a
				RIGHT JOIN " . DB_WARPIT_WEBCATI_BASE . ".`_ProjectsTree` b
				ON a.id_sup=b.id_sup
				LEFT JOIN " . DB_WARPIT_WEBCATI_BASE . ".`_ProjectsTree` c
				ON b.id_sup=c.id
				WHERE a.id=".$this->id_project." AND c.merged=1 AND b.id=".$this->id_project."
				ORDER BY b.merged";
		//echo "$sql<br>";

		//$_SESSION['echosql'] = $sql;
	//	$this->db->LogWrite($sql, true, "jagababa");
		$res = $this->db->SQLexecute($sql);

		if ($this->db->NumRows($res)) {
			// yes, I have merged projects
			$row = $this->db->fetchAssoc($res);
			$sql = "SELECT id FROM " . DB_WARPIT_WEBCATI_BASE . ".`_ProjectsTree` WHERE `id_sup`=".$row['id_folder']." AND `merged`=".($row['order_project']+1);
			//echo "$sql<br>";
			$res = $this->db->SQLexecute($sql);
			if ($this->db->NumRows($res)) {
				// I found a merged project, returning id...
				$row = $this->db->fetchAssoc($res);
				return $row['id'];
			}
			else {
				// last merged project was reached, no more jumps...
				return false;
			}
		}
		else {
			// there is no merged projects
			return false;
		}
	}

	private function getLoginSID($id_user, $user_type, $nextProject)
	{
		$loginSID = false;
		$sql = "SELECT loginSID FROM " . DB_WARPIT_WEBCATI_BASE."._www_ids WHERE id_user = " . $id_user . " AND user_type = " . $user_type . " AND id_project = " . $nextProject;

		$res = $this->db->SQLexecute($sql);
		if($this->db->NumRows($res))
		{
			$row = $this->db->fetchAssoc($res);
			return $row['loginSID'];
		}

		$sql = "INSERT INTO  ".DB_WARPIT_WEBCATI_BASE."._www_ids (`id_user`, `user_type`, `id_project`, `id_site`, `loginSID`, `idGenStruc`)
				SELECT " . $id_user . ", " . $user_type . ", $nextProject, MAX(id_site)+1, SUBSTRING(md5('$seedSID'),1,15), 0
				FROM ".DB_WARPIT_WEBCATI_BASE."._www_ids WHERE `id_project`=$nextProject";

				//echo $sql."<br>";
		if ($this->db->SQLexecute($sql)) {
			$last_wwwIds = $this->db->GetLastInsertId();
			$sql = "UPDATE IGNORE ".DB_WARPIT_WEBCATI_BASE."._www_ids SET loginSID = CONCAT(loginSID,'-',id)
					WHERE id = ".$last_wwwIds;
			//echo $sql."<br>";
			if ($this->db->SQLexecute($sql)) {
				$sql = "SELECT loginSID FROM ".DB_WARPIT_WEBCATI_BASE."._www_ids WHERE id = " . $last_wwwIds;
				//echo "$sql<br>";
				$res = $this->db->SQLexecute($sql);
				$row = $this->db->fetchAssoc($res);
				$loginSID = $row['loginSID'];
			}
			else {
				return false;
			}
		}

		return $loginSID;
	}

	/**
	 * generate the unique link and return the generated link
	 * Added by Borut, 2015.01.26
	 * Changed by Tanis 2015.07.31 to public
	 */
	public function createUniqueLink($id_mergedProject) {

		//20150731 Tanis at the time of redirection from _notAllow question I don't have set $this->id_record so if is not set I will use value from session. I have also replace all other occurrences of $this->id_record with $id_record
 		$id_record = $this->id_record;
		if($this->id_record == 0) $id_record = $_SESSION['id_structure'];

		$loginSID = $this->getLoginSID($_SESSION['id_user'], $_SESSION['user_type'], $id_mergedProject);

		if($loginSID)
		{
			// to have structure ID over all merged projects inside sp_man, update of leading project is also set here
			$sql = "UPDATE  ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure SET
					sp_man = id
					WHERE id = ".$id_record." AND sp_man IS NULL";
			//echo $sql;
			$this->db->SQLexecute($sql);

			$sql = "SELECT sp_man FROM ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure WHERE id = " . $id_record;
			//echo "$sql<br>";
			$res = $this->db->SQLexecute($sql);
			$row = $this->db->fetchAssoc($res);
			$sp_man = $row['sp_man'];

			$link = WARPIT_WWW . "survey/index.php?loginSID=" . $loginSID . "&ID_structure_merged=".$sp_man;
			//echo "$link<br>";
			return $link;
		}
		//prišlo je do napake
		return FALSE;


	}


	/**
	 * save inside Engine log the reason for goint to IDLE
	 * Added by Marko, 2014.11.05
	 *
	 * @param int $reason
	 */
	public function saveGotoIdleReason($reason){

		$sql = "SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . "._IdleReasons";
		if($res = $this->db->SQLexecute($sql))
		{
				while ($row = $this->db->fetchAssoc($res))
				{
						$reasons[$row['value']] = $row['label'];
				}
		}

		//Go to idle insert into database
	/*	$reasons[1] = '5 min break';
		$reasons[2] = '10 min WC';
		$reasons[3] = '30 min lunch';
*/
		$jsonIdle = array("idIdleReason" => $reason, "textIdleReason" => $reasons[$reason]);

		$sql = "INSERT INTO
		     ".DB_WARPIT_WEBCATI_BASE.".{$this->projname}___EngineLog
		     SET id_structure = '{$this->id_record}',
		     id_user = '{$_SESSION['id_user']}',
		     user_type = '{$_SESSION['user_type']}',
		     q_name = 'gotoIdle',
		     questionnairePath  = '".implode(";",$_SESSION['questionnairePath'])."',
		     questStart = '".time()."',
		     eventLogger = '[".json_encode($jsonIdle)."]'";
		$this->db->LogWrite(print_r($sql,1),true,"saveGotoIdleReason()");
		if(!$this->db->SQLexecute($sql))
			die($this->db->JsonError());
	}

	/**
	 * Enter description here...
	 *
	 * @param unknown_type $aQuestArray
	 */

	function SaveQuestions($aQuestArray = array()) {
		/*

		 1 - nalozim leavequestion condition in goto condition in must_answer?
		 2 - ce gre za info vprasanje grem kar na naslednjo
		 3 - preverim ali lahko zapustim vprasanje
		 4 - ce lahko zapustim preverim goto condition

		*/

		//20151104 Tanis I move configLoader up so I will be able to use data multiple times in this function
		$surveyConfig = configLoader::loadConfig('survey');
        //20170308 Bojan Orter - We get project properties that are used later
        $projectProperties = $this->db->get("_Projects", "id={$this->id_project}", "*", DB_WARPIT_WEBCATI_BASE)[0];
		require_once PATH_TO_ROOT . '/_support/defuse-crypto.phar';

				$sql = "SELECT tip_sql,q_name,q_pos, con_sql,goto_sql,must_answer,use_for_quotas,isFinal,allow_listening, encrypt, open_answers, id_showTogether
					FROM ".DB_WARPIT_WEBCATI.".".$this->projname."
						WHERE id = ".$this->nextQuestion[0]['id'];
		//echo $sql;
		if(!$res = $this->db->SQLexecute($sql)) echo "save question: select error: ".$this->db->GetError();


		$zad = $this->db->fetchAssoc($res);

		// info question
		//igor: this couses to ignore conditions and jumps on info questions! why is this neccesery ?
		if ($zad['tip_sql'] == 5 AND false) {
			$this->defineCurrentRotationString(); return;
		}
		else if($zad['tip_sql'] == 13){
		    $secretKey = configLoader::loadConfig('captcha');
		    $secretKey = $secretKey['secret_key'];

		    $questionName = $zad['q_name'];

		    $clientResponse =  $_POST['g-recaptcha-response'];
		    $captchaValid = $this->validateCaptcha($secretKey, $clientResponse);

		    if($captchaValid !== true){
		        $this->LeaveQuestion = false;
		        return;
            } else {
		        $sqlTmp[$questionName] = "$questionName = '1'";
            }
        }
		else if ($zad['tip_sql'] == 8)
		{//status!!!
			if(!$_POST['status_telnum'])
			{
				$this->LeaveQuestion = false;
				return;
			}
			if($_SESSION['app_exists'] && $_SESSION['app_middle'])
			{//if we have an appointment in the middle we change the record that we are currently working on!
			 //hmm...this should happen earylier!
				//echo $_SESSION['app_middle'].' - session MIDDLE ?<br>';

					$this->updateStatus($zad);

					if($this->finalStatus == 1)//if we continiue we must we don't need to control jumps
					{
						$this->doNotLog = true;
						$_SESSION['id_record'] = $this->id_record = $_SESSION['app_middle'];

						//20160306 Tanis the problem was when someone make appointment and with gotoIdle checked.
						// The last record in engineLog table was gotoIdle without currentRotationString value.
						// I have added AND q_name <> gotoIdle condition so we will skip it and take one before
						//Borut: To je delovalo dokler Kuhar in Kodrič nista šlatala tega
						$sql 	= "SELECT currentRotationString,questionnairePath FROM ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."___EngineLog
								WHERE id_structure = ".$this->id_record." AND q_name <> 'gotoIdle' ORDER BY id DESC LIMIT 1";
						//	echo $sql;
							if(!$res = $this->db->SQLexecute($sql)) echo "searching appointment error: ".$this->db->GetError();
							$row= $this->db->fetchAssoc($res);
							$_SESSION['currentRotationString'] 	= $this->currentRotationString = $row['currentRotationString'];
							//echo $this->currentRotationString.'<br>';
							$_SESSION['questionnairePath'] 	=explode(';',$row['questionnairePath']);
							$sql = "UPDATE $this->projname"."_structure SET status = $this->finalStatus,status_rec=$this->finalRecStatus,t_start = ".time().",d_start = '".date("Y-m-d H:i:s")."' WHERE id = ".$_SESSION['app_middle'];
							$this->db->SQLexecute($sql);
							//update record in telLog
							 $query_update_telnum_log = "UPDATE ".$this->projname."___telLog SET id_structure=$this->id_record WHERE id=".$_SESSION['id_tellog'];
								//echo "UPDATE LOG if app in the middle  -  $query_update_telnum_log<br>";
								 $result_append_telbase = $this->db->SQLexecute(  $query_update_telnum_log);
						return;
					}
						//we update the status of app_middle record!
						$sql = "UPDATE $this->projname"."_structure SET status = $this->finalStatus,status_rec=$this->finalRecStatus WHERE id = ".$_SESSION['app_middle'];
						$this->db->SQLexecute($sql);
						//$this->CreateEmptyRecord();

					//return;
			}
			else
				$this->updateStatus($zad);

			if($this->finalStatus != 1 && $this->finalStatus != 91 && $this->gotoIdle)
			{
				$zad['isFinal'] = true;
			}
			//here we make a jump to the welcome template...in case it is hidden we must jump to first question!

		}
		//dialer question
		else if ($zad['tip_sql'] == 7)
		{
			$this->db->LogWrite($zad['tip_sql'],true,"inside class.engine -> zad['tip_sql']");

			//if no number is selected, then no numbers are avaliable...either quota full or all numbers used up!
			if(!$_SESSION['id_tel'])
			{//-1 is position of no more telefonnumbers!
				$zad['goto_sql'] = "true#-1";
				$this->jumpSkipFilter = true;
				//in this case status will be 52 and status rec will be 2
				$_SESSION['finalStatus'] = 52;
				$_SESSION['gotoIdle'] = true;

			}//else we get to status screen...we update the t_status variable!
			//am not sure if this is compatible with predictive dialer :)
			else
			{
				$sql = "UPDATE  ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure SET t_status = ".time().",d_status='".date("Y-m-d H:i:s")."' WHERE id = ".$this->id_record;
				$this->db->SQLexecute($sql);
			}

		}
		else if($zad['tip_sql'] == 9)
		{//appointment...we update the app_time
			extract($_POST);
            //20161216 Bojan Orter - We changed how we read datetime, nothing eles
            $app_time = DateTime::createFromFormat("d-m-Y H:i", $_POST["appDateTimeValue"]);
            $app_time = $app_time->getTimestamp();
			$_SESSION['finalStatus'] = 91;
			// v primeru, da imam se novo tel. stevilko za klicat shranim le to zraven k komentarju
			$telLogStatus = 91;
			if(strlen($dogovor_email)) $telLogStatus = 93;

			$dogovor_komentar = str_replace(array("'","\""),array("´","˝"),$dogovor_komentar);
			$sql_dogovor_str = "status=" . $telLogStatus . ", call_time='$app_time', app_time='$app_time', app_koment='$dogovor_komentar'";
			if(!$_SESSION['predictiveDialing'])
						$sql_dogovor_str .= ",last_call='".time()."', call_num=call_num+1";
			if($_SESSION['makeApp'])
			{//we hit appointment in the middle of questionarre...we save the id_record
				$sql_dogovor_str .= ",app_middle = $this->id_record";
				unset($_SESSION['makeApp']);
			}
			if ( $dogovor_oms AND $dogovor_telnum ) {
				$sql_dogovor_str .= ",app_call_this_num= '$dogovor_oms/$dogovor_telnum '";
			}
			$query_update_telnum_sts = "UPDATE {$this->projname}___telIndex SET $sql_dogovor_str WHERE id_tel=".$_SESSION['id_tel'];
			$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
			$this->db->SQLexecute($query_update_telnum_sts);
			//update telLog app comment
			$query_update_telnum_log = "UPDATE $this->projname"."___telLog SET app_koment='$dogovor_komentar' WHERE id = ".$_SESSION['id_tellog'];
			$this->db->SQLexecute($query_update_telnum_log);

			if(strlen($dogovor_email))
			{
					include(PATH_TO_ROOT."webcati/_class/class.emailAppointment.php");
			//		var_dump($this); exit;
					EmailAppointment::sendAppointmentOnEmail(mysql_real_escape_string($dogovor_email), $this->id_record);
					$this->StatisticsFinalStatus = 93;
			}

			//let's delete the appointment out of the log
			$sql = "DELETE FROM {$this->projname}___EngineLog WHERE id_structure = $this->id_record AND q_name = 'appointment'";
			$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
			$this->db->SQLexecute($sql);
		//

		}
		//the confirm question...it's a single response, but there is no variable q_name in structure
		//Igor 4.6.2011 this was removed...testing questionnaires are now set trough the testSurvey parameter in session!
		else if($zad['q_pos'] == -4)
		{
			if($aQuestArray)
			{
				foreach ($aQuestArray as $recStatus) {
					$this->finalRecStatus = $recStatus;
				}
				unset($aQuestArray);
				unset($_SESSION['mustAnswerCondition']);
			}

		}
		else if($this->makeApp)
		{
			$zad['goto_sql'] = "true#-8";
			unset($_SESSION['mustAnswerCondition']);
		}
//		else if($zad['q_pos'] == -2)
//		{
//			$_SESSION['finalStatus'] = 51;
//			echo $_SESSION['finalStatus'];
//		}



		if($this->startOther)
		{//jumps to first question
			$zad['goto_sql'] = "true#1";
		}//other cancels final effect!
		else if($zad['isFinal'])
		{

			if(!$this->finalStatus = $_SESSION['finalStatus']) {
				if ( $statTel = $_POST['status_telnum'] ) {
					$statTel_array = explode("_",$statTel);
					$statTel = intval($statTel_array[0]);
				}
				if ($statTel === 0)
					$this->finalStatus = 0;
				else
					$this->finalStatus = 53;

				$this->db->LogWrite($this->finalStatus."-".$statTel,true,"status telnum:");
			}

			$this->FinishQuestionnaire();
		}

		$showApartProperty = getProjectProperty($this->id_project , 'show_apart_on_mobile', false);
		$showApartProperty = filter_var($showApartProperty, FILTER_VALIDATE_BOOLEAN);

		$showApartOnMobile = $_SESSION['detectedDevice'] == 2 && $showApartProperty === true;
		$isShowTogether = isset($zad["id_showTogether"])
			&& $zad["id_showTogether"] > 0
			&& $showApartOnMobile === false;;

        $outFilters = Array();
        $condVariables = Array();
        if($isShowTogether === true){
            $groupOutFilters = $this->db->get($this->projname, "id_showTogether=" . $zad["id_showTogether"], "con_sql", DB_WARPIT_WEBCATI);
            foreach ($groupOutFilters as $groupQuestion) {
                if(!empty($groupQuestion)){
                    $outFilters[] = $groupQuestion;
                }
            }
        }
		else if ($zad['con_sql']) {
            $outFilters[] = $zad['con_sql'];
		}

        foreach ($outFilters as $outFilter) {
            $condVariables = array_merge($condVariables, $this->readDatabaseVariables($this->returnConditionVariables($outFilter)));
		    $condition[] = '(' . $outFilter . ')';
        }

	//	echo "Izpis must Answer session = ".$_SESSION['mustAnswerCondition']."<Br>";

		if ($_SESSION['mustAnswerCondition']) $condition[] = $_SESSION['mustAnswerCondition'];

		// Because I haven't saved data yet I need to merge information from record structure and actual information from current question
		// we also need to delete variables from current question
		/*echo "<pre>";
			var_dump($aQuestArray);
		echo "</pre>";
		*/

    if($zad['open_answers'])
    {
      $q_name = $zad['q_name'];
      $fieldName = $q_name . '_opn';

      if($zad['tip_sql'] == 1)
      {
          if($aQuestArray[$q_name] != $zad['open_answers'])
          {
              $aQuestArray[$fieldName] = '';
          }
      }
      else if($zad['tip_sql'] == 3)
      {

          //we check if fields has two _ in name this means that this question has legend
          $hasLegend = false;
          foreach($aQuestArray as $fName => $fVal)
          {
              if(substr_count($fName, '_') > 1)
              {
                  $hasLegend = true;
                  break;
              }
          }

          //TODO mislim da bi se lahko isti posotopek uporabil tudi pri single open end
          $openEnds = explode(':', $zad['open_answers']);
          foreach($aQuestArray as $fName => &$fVal)
          {
              if(strpos($fName, '_opn') !== false)
              {
                  $exp = explode('_opn', $fName);
                  $fieldNumber = $exp[1];

                  $fieldPair = implode('_', $exp);
                  if(!$hasLegend)
                  {
                      if(!in_array($aQuestArray[$fieldPair],$openEnds ))
                          $fVal = '';
                  }
                  else
                  {
                      $hasPair = false;
                      foreach($aQuestArray as $fName2 => $fVal2)
                      {
                          if (strpos($fName2, $fieldPair) === 0) {
                              $hasPair = true;
                              break;
                          }
                      }
                      if(!$hasPair)
                        $fVal = '';
                  }
              }
          }
          /*else
          {
              print "tu sem pa jaz";
              foreach($aQuestArray as $fName => &$fVal)
              {
                  if(strpos($fName, '_opn') !== false)
                  {

                  $exp = explode('_opn', $fName);
                  $fieldNumber = $exp[1];

                  $fieldPair = implode('_', $exp);
                  /*if(!in_array($aQuestArray[$fieldPair],$openEnds ))
                      $fVal = '';

                }
              }
          }*/
      }
    }






		$qnLng = strlen($zad['q_name']);
		if(is_array($condVariables))
		foreach ($condVariables as $cvKey => $cvValue) {
			if(substr($cvKey,0,$qnLng+1) == $zad['q_name'].'_'  )
				unset($condVariables[$cvKey]);
		}
		//20151124 Tanis: na bloku vprašanj niso delovali filtri out. Če si dodal filter out na prvo vprašanje
		// je upoštevlo samo variable od prvega vrpašanja na drugi pa filter ni deloval.
		//TODO ta del kode se ponovi še enkrat nekaj korakov naprej, kjer  se polni sql za zapis v bazo.
		//To spremeni da ne bo dvakrat kopirano. !!!
		if ($_POST['answersStrNames']) {
			$allAnswersName = array();
			foreach ($_POST['answersStrNames'] as $value) {
				$valArray = explode(',', $value);
				$allAnswersName = array_merge($allAnswersName, $valArray);
			}
			$transAnswerNames = array_flip($allAnswersName);
			$transAnswerNames = array_fill_keys($allAnswersName,MULTI_DEFAULT_VALUE);
			if($aQuestArray)
			{
				$fullAnswerNames = array_merge($transAnswerNames,$aQuestArray);
			}
			if($fullAnswerNames)
			{
				foreach($fullAnswerNames as $q_name => $value)
				{
						if (strtolower($value) == "null")
							$condVariables[$q_name] = "\$" . $q_name . " = " . $value . ";";
						else
							$condVariables[$q_name] = "\$" . $q_name . " = '" . $value . "';";

				}
			}

		}
		//20151124 Tanis: END

		if ($aQuestArray) foreach ($this->prepareArrayForSandBox($aQuestArray) as $key=>$value)  {
			//echo $key." => ".$value."<Br>";
			$condVariables[$key] = $value;
		}

		// I check for leave the condition in sandbox
		if ( !$condition ||  ($condition && $this->ConditionSandBox($condVariables,implode(' AND ',$condition))) )
		{

			// if ($condition) echo implode(' AND ',$condition);
			 if (!is_array($aQuestArray))
					$aQuestArray = array();
			$notSystem = $zad['q_pos'] > 0;
			if(count($aQuestArray) > 0 || $notSystem)
			 {

			 	if ($_SESSION['questionFields'] && $_SESSION['back_delete']) {
			 		foreach ($_SESSION['questionFields'] as $key) $sqlTmp[$key] = "".$key." = NULL ";
			 	}
			 	$_SESSION['questionFields'] = array();

                //Tanis 20150409
                if($zad['allow_listening'] && count($aQuestArray))
                {
                    $settings = configLoader::loadConfig('webcati');
                    if(reset(getVar(reset($aQuestArray))) == $settings['allow_listening_question_value'])
                        $_SESSION['allow_listening'] = TRUE;
                    else
                        $_SESSION['allow_listening'] = FALSE;

                }
                //end section 20150409

			 	//everything is ok, so I can save data into record structure
			 	/**
			 	 * since I can have two models for storing data for multiresponse I add two methods, depending if string which variables exist
			 	 * Borut add this 2013.09.02 - 22:30
			 	 */

			/*20150916 Tanis, v spremenljivki answersStrNames so shranjeni vsi odgovori, ki so bili prikazani na ekranu. Včasih smo shranjevali te fielde v skrito variablo v HTML.
			 *Pri grupiranih odgovorih pa se je pojavil problem. Ker smo izrisovali vsako grupo posebaj smo dobili več hiden variabel z imenom answersStrNames. Upoštevali pa so se samo odgovori
			 * iz zadne groupe vprašanj. Sedaj smo premaknili to iz hidden v SESSION
			 *
			 */
			 	//if ($_POST['answersStrNames']) {
/*foreach ($_POST['answersStrNames'] as $value) {
  var_dump($value);
}*/
			 	if ($_POST['answersStrNames']) {
          $allAnswersName = array();
          foreach ($_POST['answersStrNames'] as $value) {
            $valArray = explode(',', $value);
            $allAnswersName = array_merge($allAnswersName, $valArray);
          }

					//20150916 Tanis
			 		/*$allAnswersName = explode(",",$_POST['answersStrNames']);
			 		$allAnswersName = explode(",",$_POST['answersStrNames']);*/
			 		/*$allAnswersName = array();
          foreach ($_SESSION['answersStrNames'] as $q_name => $list) {
            $allAnswersName = array_merge($allAnswersName, $list);
          }*/
					//unset($_SESSION['answersStrNames']);
					//20150916 Tanis END


			 		$transAnswerNames = array_flip($allAnswersName);
			 		$transAnswerNames = array_fill_keys($allAnswersName,MULTI_DEFAULT_VALUE);
			 		$fullAnswerNames = array_merge($transAnswerNames,$aQuestArray);

					//20150713 Tanis iz baze preberemo, kaj se shrani v bazo, če je bil odgovor prikazana na vpršalaniku in ni bil izbran
					//20151104 Tanis $defaultVal['multiresponse_default_fill'] -> $surveyConfig['multiresponse_default_fill']
					$defaultVal = $surveyConfig['multiresponse_default_fill'];
			 		//20150713 Tanis END

			 		foreach ($fullAnswerNames as $keyVar => $itemVal) {
			 			//20150713 Tanis
			 			if (strtolower($itemVal) == "null")
			 				$sqlTmp[$keyVar] = "".$keyVar." = " . $defaultVal;
						//20150713 Tanis END
			 			//	$sqlTmp[$keyVar] = "".$keyVar." = ".$itemVal;
			 			else
            {

              if($zad['tip_sql'] == 4 && $zad['encrypt'] == 1)
              {
                  $encData = Crypto::encrypt($itemVal, Key::loadFromAsciiSafeString($surveyConfig['encryptionKey']));
                  $sqlTmp[$keyVar] = "".$keyVar." = '". $encData."'";
              }
              else
              {
                $sqlTmp[$keyVar] = "".$keyVar." = '".addslashes($itemVal)."'";
              }
            }
			 		}

			 	} else {
				 	foreach ($aQuestArray as $key => $val)
					{

							if($zad['tip_sql'] == 4 && $zad['encrypt'] == 1)
							{
								//	$encData = Crypto::encrypt('tmp', 'kljuc');
									$encData = Crypto::encrypt($val, Key::loadFromAsciiSafeString($surveyConfig['encryptionKey']));
									$sqlTmp[$key] = "".$key." = '" . $encData . "'";
							}
							else
							{
								$sqlTmp[$key] = "".$key." = '".addslashes($val)."'";
							}
					}
			 	}

				//20150918 Tanis
			//	unset($_SESSION['answersStrNames']);


//echo "<pre>STORE answersStrNames:";
//print_r($sqlTmp);
//echo "</pre>";
				 if($zad['use_for_quotas'])
				 {
				 	//let's recode the value and store the QUOTA rec value
				 	if($zad['tip_sql'] == 1)
				 	{//for single response questions
				 		if($aQuestArray[$zad['q_name']])
				 		{
					 		$sql = "SELECT reconum FROM ".DB_WARPIT_WEBCATI_BASE.".recode WHERE id_project = $this->id_project".
					 		" AND id_question = {$this->nextQuestion[0]['id']} AND source = 2 AND basenum = ".$aQuestArray[$zad['q_name']];
					 		if(!$res = $this->db->SQLexecute($sql)) echo "quota error: ".$this->db->GetError();
					 			if($row = $this->db->fetchRow($res))
					 				$sqlTmp[] = 'QT_'.$zad['q_name']." = ".$row[0];
					 			else
					 				$sqlTmp[] = 'QT_'.$zad['q_name']." = NULL";
				 		}
				 	}
					else if($zad['tip_sql'] == 4)
				 	{//for open questions

						$qValueTmp = $aQuestArray[$zad['q_name'].'_1'];
					//	$qValueTmp = convert::toInt($qValueTmp);

					/*print "<pre>";
					var_dump($aQuestArray);
					print "</pre>";
*/

						//20160107 Tanis: če imamo open vprašanje in na to vpršanje dodamo kvoto je v open odgovor
						// obvezno potrebno vnesti numerično vrednost. Tukaj preverim če je vrednost numerična
						// in če ni se pojavi can't leave messsage.

						if(!ctype_digit(trim(addslashes($qValueTmp))))
						{
	/*						print "qValueTmp: $qValueTmp";
							var_dump(ctype_digit($qValueTmp));
*/
							$this->LeaveQuestion = false;
							return;
						}

				 		$sql = "SELECT reconum FROM ".DB_WARPIT_WEBCATI_BASE.".recode WHERE id_project = $this->id_project".
				 		" AND id_question = {$this->nextQuestion[0]['id']} AND source = 2 AND basenum <= $qValueTmp AND rangn >= $qValueTmp";
				 		if(!$res = $this->db->SQLexecute($sql)) echo "quota error: ".$this->db->GetError();
				 			if($row = $this->db->fetchRow($res))
				 				$sqlTmp[] = 'QT_'.$zad['q_name']." = ".$row[0];
				 	}
				 }
				 //set the t_stop time
				 if($notSystem)
				 	$sqlTmp[] = 't_stop = ' .time().",d_stop = '".date("Y-m-d H:i:s")."'";

				 $sql = "UPDATE  ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure SET ".implode(",",$sqlTmp)." WHERE id = ".$this->id_record;
				 $this->db->LogWrite($sql,true,"update question in structure");
				 if ($this->db->SQLexecute($sql) == 0) {
				 	echo $this->db->GetError();
				 }

				 // I check here if quotas are full, I remove true to check it only on quota question(s)
				 // I'll add an option to the project to allow this or not
				 // true ||

                 //20170308 Bojan Orter - First we check what option is selected on project if:
                 //1 system default -> then we check config if we have set check_quota_on_all_questions,
                 //2 only on quota question -> then we only check question that are used for quota, (false)
                 //3 on all questions -> then we set it to true, so we check quota for every question
                 $checkQuotaOnAllQuestions = false;
                 $projectQuotaOption = $projectProperties["check_for_quota"];
                 if($projectQuotaOption == 1)
                 {
                     $checkQuotaOnAllQuestions = boolval($surveyConfig["check_quota_on_all_questions"]);
                 }
                 else if($projectQuotaOption == 2)
                 {
                     $checkQuotaOnAllQuestions = false;
                 }
                 else if($projectQuotaOption == 3)
                 {
                     $checkQuotaOnAllQuestions = true;
                 }
                 //END Bojan Orter

		      /*20151104 Tanis: you have  two types of behavior for quota questions. First is to check if quota is full only on quota questions
               * and other is to check it if after every question. In config you should set default behavior for whole warpit(check_quota_on_all_questions) but you can override this
               * option for every project in project properties. First we check if default is overriden if is we us non default value ele ve use system value
               */
			  if($zad['use_for_quotas'] || $checkQuotaOnAllQuestions)
				 {
				 	$this->checkQuotas($zad);
				 }
			 }
			 if($_POST['qCommentText'])
				 {
				 	$sql = "INSERT INTO ".DB_WARPIT_WEBCATI."._QuestionComments (id_project,id_question,id_structure,qComment) VALUES ($this->id_project,{$this->nextQuestion[0]['id']},$this->id_record,'{$_POST['qCommentText']}') ON DUPLICATE KEY UPDATE qComment = '{$_POST['qCommentText']}'";
				 	$this->db->SQLexecute($sql);
				 }
			 //checking redirections!!!
			 if($this->redirectActive)
			 {

			 	$sqlRedirect = $this->db->SQLexecute("SELECT * FROM ".DB_WARPIT_WEBCATI_BASE."._ProjectRedirectionsConditions WHERE id_project = $this->id_project AND systemCnd = ".$this->nextQuestion[0]['id']);
			 	while ($rowRedirect = $this->db->fetchAssoc($sqlRedirect))
			 	{
			 		$redirectVaribales = $this->readDatabaseVariables($this->returnConditionVariables($rowRedirect['userCnd']));
			 		if($this->ConditionSandBox($redirectVaribales,$rowRedirect['userCnd']))
			 		{
			 			$link = $this->db->get('_ProjectRedirectionsLinks',$rowRedirect['id_link'],'link',DB_WARPIT_WEBCATI_BASE);
			 			$link = $this->ManageHttpLink($link);
			 			//echo "<script>document.location='".$link."';</script>";
							if ($rowRedirect['questionnaire_status']) {
								$this->finalStatus = $rowRedirect['questionnaire_status'];
								$this->StatisticsFinalStatus = $rowRedirect['questionnaire_statistic_status'];
							}
							else $this->finalStatus = 61;
		 				$this->redirectLink = $link;
		 				$this->redirectDelay = $rowRedirect['delay'];
		 				$this->FinishQuestionnaire();
		 				return;
			 		}
			 	}

			 }


			 if ($zad['goto_sql']) {
				 // I read all variables for goto conditon

				 $condVariables = $this->readDatabaseVariables($this->returnConditionVariables($zad['goto_sql']));

                 $conditionCounter = 0;
				 // razdelim goto condition po vejici in letim skoyi vse pogoje
				 foreach (explode(",",$zad['goto_sql']) as $gotoCondition) {
                     if(isset($_SESSION["jumpConditionIndex"]))
                     {
                         if($conditionCounter == $_SESSION["jumpConditionIndex"])
                         {
                             unset($_SESSION["jumpConditionIndex"]);
                         }
                         continue;
                     }

				 	//razdelim goli pogoj od variable kam naj se skoci
				 	$condTmp = explode("#",$gotoCondition);
				 	// vse skupaj posljem v peskovnik da se evalvira...
				 	if ($this->ConditionSandBox($condVariables,$condTmp[0])) {
				 		//echo $condTmp[0];
				 		/* ce je pogoj uspesen pomeni da moram izvesti skok
				 		 in sedaj moram rotationstring pripraviti glede na skok
				 			1. poiskati moram id variable kam bom skocil
				 			2. poiskati ta id znotraj rotaion stringa
				 			3. nastaviti current rotation string na to mesto...
				 		 */
				 		if(is_numeric($condTmp[1]))
				 		{//we jump to the question in line!
				 		 //with negative values this is q_pos...with positive is the position in the rotation string
					 		 if($condTmp[1] < 0)
					 				$sql	= "SELECT id FROM ".DB_WARPIT_WEBCATI.".".$this->projname." WHERE q_pos = '".$condTmp[1]."'";
					 		 else
					 		 {
					 		 	$tmpRot = explode('/',$this->rotationString);
								$new_quest_id = $tmpRot[ $this->rotationStrStart + $condTmp[1]  ];

					 		 }
				 		}
                        else if($condTmp[1][0] === "!")
                        {
                            $jumpToProjectId = substr($condTmp[1], 1);
                            $_SESSION["jumpToSubProject"] = Array();
                            $_SESSION["jumpToSubProject"]["jumpConditionIndex"] = $conditionCounter;
                            $_SESSION["jumpToSubProject"]["subProjectId"] = $jumpToProjectId;
                        }
				 		else
				 			$sql 		= "SELECT id FROM ".DB_WARPIT_WEBCATI.".".$this->projname." WHERE q_name = '".$condTmp[1]."'";
				 		//echo $sql;
				 		if(!$new_quest_id )
				 		{
					 		if(!$res_qname = $this->db->SQLexecute($sql)) echo "create goto error: ".$this->db->GetError();
					 		$zad_qname	= $this->db->fetchAssoc($res_qname);
					 		$new_quest_id = $zad_qname['id'];
				 		}
				 		//echo '    '.$this->rotationString." ---> ";
				 		// TODO: kaj ce te variable ni vec v rotationstringu?!?!?!?
				 		$tmpRotStr = explode('/'.$new_quest_id."/",$this->rotationString);
				 		$changeCurrentRotationString = "/".$new_quest_id."/".$tmpRotStr[1];

				 		//echo $changeCurrentRotationString." <--- ";
				 		break;
				 	}
                    $conditionCounter++;
				 }
			 }

             if(!isset($_SESSION["jumpToSubProject"]))
             {
                 $this->defineCurrentRotationString($changeCurrentRotationString);
             }
		}
		else
		{
			$this->LeaveQuestion = false;
		//	echo "Ne sme zapustiti vprasanja";
		}


	}

	function defineCurrentRotationString($aMyDefiniton = '') {
		// ce zelim lahko trenutni rotation string nastavim kako jaz zelim
		// drugace izvedem klasicen postopek

		//echo "define it ".$aMyDefiniton."<br>";

		if ($aMyDefiniton) {
			$_SESSION['currentRotationString'] = $this->currentRotationString = $aMyDefiniton;
			return;
		}

		// razdelim string currentRotationString z trenutnim vprasanjem
		// desna polovica je nova situacija...
		// ce na desni nimamo vec nicesar pomeni da smo zakljucili s vprasalnikom
		//echo "test ->".$this->currentRotationString;
		//echo " TMP define it -> ".$this->currentRotationString."<br />";
		$tmp = explode("/".$this->nextQuestion[ count($this->nextQuestion ) - 1  ]['id']."/", $this->currentRotationString);
		//echo " TMP define it -> ".$tmp[1];
		if (!$tmp[1]) $this->FinishQuestionnaire();
			else $_SESSION['currentRotationString'] = $this->currentRotationString = "/".$tmp[1];


	}

	function isFinished() { return $this->questionnaireFinished; }
	function GetProjectName() { return $this->projname; }
	function GetIdProject() { return $this->id_project; }
	function GetIdRecord() { return $this->id_record; }

	function BrowserBackButton() {
		//echo "Gumb nazaj ni omogocen...";
		return $this->nextQuestion;
	}



	function searchingPreviusQuestion() {


    //20161214 Tanis: added q_name
		$sql 	= "SELECT questionnairePath, q_name FROM ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."___EngineLog
						WHERE id_structure = ".$this->id_record." ORDER BY id DESC LIMIT 1";
	//	echo $sql;
		if(!$res = $this->db->SQLexecute($sql)) echo "searching previous error: ".$this->db->GetError();
		$zadPath= $this->db->fetchAssoc($res);

		$_SESSION['questionnairePath']  = explode(";",$zadPath['questionnairePath']);

		$resetPath = $_SESSION['questionnairePath'];

		$actualQuestion = array_pop($_SESSION['questionnairePath']);

    //20161214 Tanis: if we go back from end question we need to delete record from quotaCalc
    if($zadPath['q_name'] == "_End" && $this->db->TableExists($this->projname . "___quotaCalc"))
    {
        $delSql = "DELETE FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->projname . "___quotaCalc WHERE id = " . $this->id_record;
        if(!$res = $this->db->SQLexecute($delSql)) echo $this->db->JsonError();
    }
    //20161214 Tanis END



		/*
			ta primer se lahko zgodi ob gumbu back na prvem vprasanju
			v tem primeru nastavi leave the question na false
			in iniciliziram rotation string z zacetnim.
		*/
		if (!count($_SESSION['questionnairePath'])) {
			$this->LeaveQuestion = false;
			$this->defineCurrentRotationString($this->rotationString);
			$_SESSION['questionnairePath']  = $resetPath;
			return $this->searchingNextQuestion();
		}

		$possibleQuestion = array_pop($_SESSION['questionnairePath']);

		$sql = "SELECT tip_sql FROM ".DB_WARPIT_WEBCATI.".".$this->projname." WHERE id = ".$possibleQuestion;
		if(!$res = $this->db->SQLexecute($sql)) echo "searching previous error: ".$this->db->GetError();
		$zad = $this->db->fetchAssoc($res);


		$rotat = explode("/".$possibleQuestion."/",$this->rotationString);

		//ne sme se vrnit na dialer ali status ekran (razn v primeru, da je na appointmentu)
		if ($zad['tip_sql'] == 7 || ($zad['tip_sql'] == 8 && $_SESSION['finalStatus'] != 91 ) ) {
			$this->LeaveQuestion = false;
			$_SESSION['questionnairePath']  = $resetPath;
			unset($possibleQuestion);
		}

		$this->defineCurrentRotationString("/".$possibleQuestion."/".$rotat[1]);
		//we reset the values
		if($this->LeaveQuestion !== false && $_POST['answers'])
		{
			$sql = "SELECT tip_sql,q_name,q_pos, con_sql,goto_sql,must_answer,use_for_quotas,isFinal
					FROM ".DB_WARPIT_WEBCATI.".".$this->projname."
						WHERE id = ".$this->nextQuestion[0]['id'];
			//echo $sql;
			if(!$res = $this->db->SQLexecute($sql)) echo "save question: select error: ".$this->db->GetError();
			$zad = $this->db->fetchAssoc($res);


			//20150713 Tanis če si imel vklobljen Delete on back button in si spremenil nek odgovor tako, da so se izbrani odgovori skrili sistem ni pobrisal teh skritih odgovorov
			// predvidevam, da je bilo to sprogramirano preden so bili questionFields shranjeni v SESSION in je pobrisal samo odgovore ki so prikazani na formi
			//$aQuestArray = $_POST['answers'];
			$aQuestArray = $_SESSION['questionFields'] ;
			 foreach ($aQuestArray as $key) $sqlTmp[$key] = "".$key." = NULL";
			 //foreach ($aQuestArray as $key => $val) $sqlTmp[$key] = "".$key." = NULL";
					 if($zad['use_for_quotas'])
					 {
					 	//let's recode the value and store the QUOTA rec value
					 	if($zad['tip_sql'] == 1)
					 	{//for single response questions
					 				$sqlTmp[] = 'QT_'.$zad['q_name']." = NULL";
					 	}
						else if($zad['tip_sql'] == 4)
					 	{//for open questions
					 				$sqlTmp[] = 'QT_'.$zad['q_name']." = NULL";
					 	}
					 }
					 //lets update status in case it was set while finished
					 $sql = "UPDATE  ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure SET ".implode(",",$sqlTmp)." WHERE id = ".$this->id_record;
					 //echo $sql."<br />";

					if ($_SESSION['back_delete']) {

						foreach($_SESSION['questionFields'] as $key) $tmpSql = $key . "= NULL";
						$sql = "UPDATE  ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure SET ".implode(",",$sqlTmp)." WHERE id = ".$this->id_record;
						if ($this->db->SQLexecute($sql) == 0) echo $this->db->GetError();
					 }

		}
		else
		{
		 //lets update status in case it was set while finished
		 //pri popupu ko pride do konca se zapise status! s tem ga nazaj overridamo ce je stisno back, po tem ko je do konca priso!
					 $sql = "UPDATE  ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure SET status = 1,status_rec=99 WHERE id = ".$this->id_record;
					 //echo $sql."<br />";
					 if ($this->db->SQLexecute($sql) == 0) {
					 	echo $this->db->GetError();
					 }
					 unset($_SESSION['finalStatus']);
		}

		return $this->searchingNextQuestion();
	}




	function externalConditionSystem(&$aConditionArray, $aOriginalCondition) {
		$tempCondition = $aOriginalCondition;

		if (!$aConditionArray) return $tempCondition;
		//var_dump($aConditionArray);
		foreach ($aConditionArray as $key=>$val) {

			unset($tmp1,$tmp2,$tmp,$tableName,$varName);
			$tmp = explode("{",$key);
			if (count($tmp) == 2) {
				unset($aConditionArray[$key]);
				$tmp1 = explode("}",$tmp[1]);
				$tableName = $tmp1[0];
				$varName = $tmp[0];

					$sql = "SELECT ".$varName." as varValue FROM ".DB_WARPIT_WEBCATI_BASE.".".$tableName." WHERE id = ".$this->id_record;
				//	echo $sql;
					$res = $this->db->SQLexecute($sql);
					$zad = $this->db->fetchAssoc($res);
					$tempCondition = str_replace("\$".$val,$zad['varValue'],$tempCondition);

			}
		}
		return $tempCondition;
	}


	/**
	 * Enter description here...
	 *
	 * @return unknown
	 */

	function searchingNextQuestion() {

		// check, if condition for leave the question is set, if not, stay on same question
		/*
		 * check also, if manual dial is set, then also stay on the same dialer question
		 * (set in display class case: 35, _POST['manual_dial_select'] as hidden input)
		 * auto and manual dialer are responsible for this
		 * ADD: 03.02.2013
		 */
		$this->db->LogWrite("leave question:".$this->LeaveQuestion." --- POST manual dial select:".$_POST['manual_dial_select']." --- isFinished()".$this->isFinished(), true, "inside searchingNextQuestion");

		if ($this->LeaveQuestion == false OR $_POST['manual_dial_select'] == true) {
			$this->db->LogWrite("inside first return",true,"return with the same?");
			return $_SESSION['nextQuestion'];
		}
		elseif ($this->isFinished()) // if I come to the end, it is the end
			return 0;

		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI);
		$showQuestion = array();
		$questionCount = 0;


		//echo "<hr>";
		//echo "RotationString = ".$this->rotationString."<br>";
		//echo "currentRotationString = ".$this->currentRotationString."<hr>";

		$rot = explode("/",$this->currentRotationString);

		//echo " rotation -> ".$this->currentRotationString."<br>";
		//echo " implode 1 -> ".implode("/",$rot)."<br>";
		//echo "<hr>";
		$this->db->LogWrite(print_r($rot,1),true,"searchingNextQuestion - before foreach");

		foreach ($rot as $key=>$idQuestion) {
			if (!$idQuestion) { //two cases: the first and last (becuse we have extra / at end and beginig
				if($key) { //this means we've come to the end and didn't find any aswer to show
					$this->db->LogWrite("key: ".$key,true,"searchingNextQuestion - before FinishQuestionnaire()");
					$this->FinishQuestionnaire();
					return 0;
				}
				else {
					continue;
				}
			}

			$sql = "SELECT id,q_name,tip_sql,fil_sql,q_pos,disable_question,id_showTogether,isFinal,rec_question_id, rec_interval FROM ".DB_WARPIT_WEBCATI.".".$this->projname." WHERE id = ".$idQuestion;
			//echo $sql."<br>";
			$res = $this->db->SQLexecute($sql);
			$zad = $this->db->fetchAssoc($res);
			$qPos = $zad['q_pos'];

			//20160424 Tanis: if we continiue broken link or appointment link in CAPI modul we need to resend data to the server
			if($_SESSION['capi'])
			{
				//if we there is no changes we don't need to send data again. If we got quota full or not allow or not active the questioner is not send again
				if($qPos != "-2" && $qPos != "-16" && $qPos != "-15")
				{
					$sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . "." . $this->projname . "_structure SET flag_cli = NULL WHERE id = " . $_SESSION['id_record'];
					$this->db->SQLexecute($sql);

				}
			}
			//20160424 Tanis END

			if($zad['disable_question'] || $qPos == -1 || $qPos == -2)//some questions are automaticly disabled, quota full and no telephone !!!
			{
				if(!$this->jumpSkipFilter)
					$zad['fil_sql'] = "false";
			}

			// if I have timestamp I write step over time into structure
			if ($zad['tip_sql'] == 6) {
				$sql = "UPDATE  ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure SET ".$zad['q_name']."=NOW()
						WHERE ".$zad['q_name']." IS NULL AND id = ".$this->id_record;
				//echo $sql."<br>";
				if ($this->db->SQLexecute($sql) == 0) echo $this->db->GetError();
			}

            // if I have GPS stamp I write step over time into structure
            if ($zad['tip_sql'] == 14) {
                $sql = "UPDATE  ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure SET ".$zad['q_name']."_status = 2
						WHERE id = ".$this->id_record;
                //echo $sql."<br>";
                if ($this->db->SQLexecute($sql) == 0) echo $this->db->GetError();
                $this->activateGps($zad['q_name'], $this->id_record, $this->id_project);
            }

            $showApartProperty = getProjectProperty($this->id_project , 'show_apart_on_mobile', false);
            $showApartProperty = filter_var($showApartProperty, FILTER_VALIDATE_BOOLEAN);

			$showApartOnMobile = $_SESSION['detectedDevice'] == 2 && $showApartProperty === true;

			$isShowTogether = $showTogether && $showTogether != $zad['id_showTogether'] && $showApartOnMobile === false;

			//if we are in a loop for searching showTogether question, we must check that this question has the same id_showTogether
			if($isShowTogether === true)
			{
				//we have found all questions in this group...if at least one istn't filtered we show the whole set
				// other wise we unset them all from the rot string
				if($filterShowTogether)
					break;
				else
				{
					foreach ($showTogArray as $k) {
						unset($rot[$k]);
					}
					$showTogArray = array();
					$showTogether = 0;
					array_pop($_SESSION['questionnairePath']);
					$showQuestion = array();
					$questionCount = 0;
				}
			}

			//read the script for this question!
			$sql = "SELECT script,id_event FROM ".DB_WARPIT_WEBCATI.".".$this->projname."_script WHERE id_question = $idQuestion";
			$scrRes = $this->db->SQLexecute($sql);
			unset($GLOBALS['scriptEvent']);
			while($src = $this->db->fetchRow($scrRes))
			{
				$GLOBALS['scriptEvent'][$src[1]] = $src[0];

			}
			if($script = $GLOBALS['scriptEvent'][1])
			{
				include_once (PATH_TO_ROOT.'survey/usrs_methods.php');
				$GLOBALS['qInfo'] = $zad;

				eval('try {'.  $script . ' } catch (Exeption $e) { echo "Error in beforeload script!<br> $e"; };' );
				$zad = $GLOBALS['qInfo'];
			}


      if($this->allowRecording($zad['rec_question_id'])){

          $capiConfig = configLoader::loadConfig('capi-external-app');
          $recQuestionId = intval($zad['rec_question_id']);
          $currentPos    = intval($zad['q_pos']);

          require_once(PATH_TO_ROOT . 'webcati/_class/class.Recording.php');

          $recording = new Recording($this->db);
          $recordingPosition = $_SESSION['recording']['position'];

          if($recordingPosition === null){
            $recordingPosition = $recording->getRandomRecordingPosition($recQuestionId, $this->projname);
            $_SESSION['recording']['position'] = $recordingPosition;
          }
          if($currentPos >= $recordingPosition){
            $recField = $recording->getRecFieldName($recQuestionId, $this->projname);
            $this->startRecording($recField, $this->id_record, $this->id_project);
            $_SESSION['recording']['started'] = true;
          }


      }


			$condVariables = $this->returnConditionVariables($zad['fil_sql']);
			$zad['fil_sql'] = $this->externalConditionSystem($condVariables, $zad['fil_sql']);

			//echo $zad['fil_sql'];

            $showApartProperty = getProjectProperty($this->id_project , 'show_apart_on_mobile', false);
            $showApartProperty = filter_var($showApartProperty, FILTER_VALIDATE_BOOLEAN);

			$showApartOnMobile = $_SESSION['detectedDevice'] == 2 && $showApartProperty === true;
			$isShowTogether = $zad['id_showTogether'] > 0 && true && $showApartOnMobile === false;;

			if($isShowTogether === true)
			{//this question is setup to show tohether with other questions!
				//all the keys to be unset in case we skip the question group!
				$showTogArray[] = $key;
				$showQuestion[$questionCount]['id'] = $zad['id'];
				$showQuestion[$questionCount]['q_name'] = $zad['q_name'];

			 	//we fetch all the other questions that share the same id
				if(!$showTogether)
				{//this is the first question in this show together block we add ti to the questionairePath
					$_SESSION['questionnairePath'][] = $zad['id'];
					$showTogether = $zad['id_showTogether'];
				}
				if (  isset($zad['fil_sql']) && !$this->ConditionSandBox($this->readDatabaseVariables($condVariables),$zad['fil_sql'])  )
				{//if question is filteret we mark it as hidden...somehow :/
					$showQuestion[$questionCount]['filter'] = true;
				}
				else
				{
					$filterShowTogether = true;
				}
				$questionCount++;
			}

			//this worked only if a variable was in condition (for example $q == 1 worked but 1 == 2 did not!)
			//if (  !$condVariables || $this->ConditionSandBox($this->readDatabaseVariables($condVariables),$zad['fil_sql'])  )
			//i changed so that it checked if a variable is set
			else if (  !isset($zad['fil_sql']) || $this->ConditionSandBox($this->readDatabaseVariables($condVariables),$zad['fil_sql'])  )
			{
					$showQuestion[$questionCount]['id'] = $zad['id'];
					$showQuestion[$questionCount]['q_name'] = $zad['q_name'];
					if($zad['tip_sql'] == 7)
					{
						//we clear the path, in case the same record is used for another dial
						$this->clearPath();
					}
					else if($_SESSION['popUpQuestionnaire'] && ($zad['q_pos'] == -5 || $zad['isFinal']) )//we need some conditions here becouse we don't want always to use this!
					{
					 //checking redirections for final questioins
					 if($this->redirectActive && $zad['isFinal'] && $zad['q_pos'] > 0 )
					 {

					 	$sqlRedirect = $this->db->SQLexecute("SELECT * FROM ".DB_WARPIT_WEBCATI_BASE."._ProjectRedirectionsConditions WHERE id_project = $this->id_project AND systemCnd = -2");
					 	while ($rowRedirect = $this->db->fetchAssoc($sqlRedirect))
					 	{
					 		$redirectVaribales = $this->readDatabaseVariables($this->returnConditionVariables($rowRedirect['userCnd']));
					 		if($this->ConditionSandBox($redirectVaribales,$rowRedirect['userCnd']))
					 		{
					 			$link = $this->db->get('_ProjectRedirectionsLinks',$rowRedirect['id_link'],'link',DB_WARPIT_WEBCATI_BASE);

					 			$link = $this->ManageHttpLink($link);
					 			if ($rowRedirect['questionnaire_status']) $this->finalStatus = $rowRedirect['questionnaire_status'];
									else $this->finalStatus = 53;


								$this->redirectLink = $link;
		 						$this->redirectDelay = $rowRedirect['delay'];
					 		}
					 	}

					 }
					 //checking redirections for final questioins
					 else if($this->redirectActive  && $zad['q_pos'] == -2 )
					 {

					 	$sqlRedirect = $this->db->SQLexecute("SELECT * FROM ".DB_WARPIT_WEBCATI_BASE."._ProjectRedirectionsConditions WHERE id_project = $this->id_project AND systemCnd = -3");
					 	while ($rowRedirect = $this->db->fetchAssoc($sqlRedirect))
					 	{
					 		$redirectVaribales = $this->readDatabaseVariables($this->returnConditionVariables($rowRedirect['userCnd']));
					 		if($this->ConditionSandBox($redirectVaribales,$rowRedirect['userCnd']))
					 		{
					 			$link = $this->db->get('_ProjectRedirectionsLinks',$rowRedirect['id_link'],'link',DB_WARPIT_WEBCATI_BASE);
					 			$link = $this->ManageHttpLink($link);

					 			if ($rowRedirect['questionnaire_status']) $this->finalStatus = $rowRedirect['questionnaire_status'];
										else $this->finalStatus = 51;
					 			//$this->finalStatus = 51;
								$this->redirectLink = $link;
		 						$this->redirectDelay = $rowRedirect['delay'];
					 		}
					 	}

					 } elseif ($zad['isFinal'] && $_SESSION['popUpQuestionnaire']) {

					 	// Web interviews, we need to define finalstatus so quotas are not included and that record is not signed as succesfully finished.

					 	$this->finalStatus = 54;
          }

						//the reason we're doing this is becouse web surveys are finished when you come to this questions...
						//the user is not requeired to click anything to finish the survey...he can close down the browser
						$this->questionnaireContinue = true;
						$this->FinishQuestionnaire();
						$this->questionnaireFinished = false;
					}

          /*
              20171023 Tanis: when we arrive on quota full question we allways want to set 51 status
              TODO test redirections!!
              More info:
              https://gitlab.solve-x.net/warpit/warpit/issues/113
          */
          if($zad['q_pos'] == -2){
              $this->finalStatus = 51;

              $this->questionnaireContinue = true;
  						$this->FinishQuestionnaire();
  						$this->questionnaireFinished = false;
          }
          //20171023 Tanis: END

					$_SESSION['questionnairePath'][] = $zad['id'];
					// saving old question in history Session
					// be careful, nextquestion is saved in Session in next lines...


					break;
			}
			else
				unset($rot[$key]);

		}
		//echo " implode -> ".implode("/",$rot);

		$_SESSION['nextQuestion'] = $showQuestion;

		$this->defineCurrentRotationString(implode("/",$rot));
		$this->Logging();

		$this->db->LogWrite(print_r($showQuestion,1),true,"showQuestion");
		return $showQuestion;
	}

  private function allowRecording($recQuestionId)
  {
      if($recQuestionId === "0"){
        return false;
      }

      if($_SESSION['recording']['started'] === true){
        return false;
      }

      $recordingConfig = configLoader::loadConfig('recording');
      if($recordingConfig['enabled'] !== "1"){
        return false;
      }

      return true;
  }

  protected function startRecording($recField, $recordId, $projectId)
  {

        $this->sendRequestToExternalCapiApp([
            'field'        => $recField,
            'recordId'     => $recordId,
            'projectId'    => $projectId,
            'enable_media' => 1,
        ]);
  }

    protected function getBrowserCode($type, $value)
    {
        $selectBrowserCode = "SELECT id FROM " . DB_WARPIT_WEBCATI_BASE . "._BrowsersCodeList WHERE code_type = '$type' and code_text = '$value'";
        $resBrowserCode = $this->db->SQLexecute($selectBrowserCode);

        $zadBrowserCode = $this->db->fetchAssoc($resBrowserCode);

        if($zadBrowserCode !== false){
            return (int)$zadBrowserCode['id'];
        }

        $insertBrowserCode = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "._BrowsersCodeList SET code_type = '$type', code_text = '$value'";
        $this->db->SQLexecute($insertBrowserCode);

        return (int)$this->db->GetLastInsertId();
    }

  	protected function getBrowserInfo()
	{
	    if(isset($_SESSION['browserInfo']) === false){
            $userAgent = $_SERVER['HTTP_USER_AGENT'];
            $userAgentId = $this->getBrowserCode(1,$userAgent);
            $deviceTypeId = $this->getBrowserCode(2, $_SESSION['detectedDeviceType']);

            $deviceId = $_SESSION['detectedDevice'] === 0?1:2;


            $_SESSION['browserInfo'] = compact('userAgentId', 'deviceId', 'deviceTypeId');
        }

        return $_SESSION['browserInfo'];

	}

	function Logging() {

	    $browserInfo = $this->getBrowserInfo();

		unset($_SESSION['engineLogId']);
		if($this->doNotLog) return;

        //20171214 Tanis: we added activeRecord column so we can track which question is currently
        //active for give id_user. Last record will always have activeRecord = 1 and before insert
        //we need to update preveusly activeRecord to zero
        $sql = "UPDATE ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."___EngineLog SET
                         activeRecord = '0'
                         WHERE id_user = '".$_SESSION['id_user']."'
                         AND user_type = '".$_SESSION['user_type']."'
                         AND activeRecord = '1'
               ";
       $this->db->SQLexecute($sql);

        /**
		 * Borut, 2015.06.23, added for be able to read back the language used inside questionnaire
		 * id_language = ...
		 */
		$sql = "INSERT INTO ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."___EngineLog SET
						id_structure = ".$this->id_record.",
						id_question = ".$_SESSION['nextQuestion'][0]['id'].",
						 q_name = '".$_SESSION['nextQuestion'][0]['q_name']."',
						 id_user = '".$_SESSION['id_user']."',
						 user_type = '".$_SESSION['user_type']."',
						 id_language = '".$_SESSION['id_selectedQuestionLng']."',
						 questionnairePath 	= '".implode(";",$_SESSION['questionnairePath'])."',
						 currentRotationString = '".$this->currentRotationString."',
                         activeRecord = '1',
						 questStart = ".time().",
						 browser_type_id = '". $browserInfo['userAgentId'] ."',
						 device_property_id = '". $browserInfo['deviceId'] ."',
						 device_name_id = '". $browserInfo['deviceTypeId'] ."'
				";
		$this->db->SQLexecute($sql);
		$_SESSION['engineLogId'] = 	$this->db->GetLastInsertId();
	}



	public function LoggingLeave() {

		if(isset($_SESSION['engineLogId']))
		{
			/**
			 * Borut, 2015.06.23, added for be able to read back the language used inside questionnaire
			 * id_language = ...
			 */
			$languageLogging = $_SESSION['id_defaultQuestionLng'];
			if (isset($_GET['languageID'])) $languageLogging = $_GET['languageID'];
			if (isset($_SESSION['id_selectedQuestionLng'])) $languageLogging = $_SESSION['id_selectedQuestionLng'];
			if (isset($_POST['languageChooser'])) $languageLogging = $_POST['languageChooser'];
			// *******************************************************************************************************
			$sql = "UPDATE ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."___EngineLog SET
							 questEnd = ".time().",
							 id_language = '".$languageLogging."',
							 eventLogger = '".$_POST['RMclickLogger']."'
						WHERE id = ".$_SESSION['engineLogId'];
			//echo "$sql<br>";
			$this->db->SQLexecute($sql);
		}
	}

	private function clearPath()
	{
		$_SESSION['questionnairePath'] = array();
	}

	function returnConditionVariables($aCond) {

		// if their is no condition or no character $ I return false
		if (trim($aCond) == '' || strpos($aCond,'$') === false ) return false;


		$varArray = array();
		// replacing condition string
		$_tmp1  = trim(str_replace($this->cleanChars," ",$aCond));
		// searching php script before first variable
		$_tmp1  = substr($_tmp1,strpos($_tmp1,'$'));

		// now we have only variables and values, we explode this by $, so we get variables in first item of array
		foreach (explode("$",$_tmp1) as $_tmpVars) {
			// we explode once more to get only variables
			$_tmp = explode(" ",$_tmpVars,2);
			// if their is any value in this variable we save it as variable name
			//we exclude the reserved name

			if ($_tmp[0] && $_tmp[0] != 'submit_error') $varArray[$_tmp[0]] = $_tmp[0];

		}

		// if condition doesn't include any variables I return false?!?!?!?
		if (count($varArray) == 0) return false;

		// return array with variables which are in condition string
		return $varArray;
	}

	function updateStatus(&$zad)
	{
		$this->notSaveFinal = 0; // prepare to save final in all cases, I set not to only at the end, if status=0

		$this->questFinApp = 0; // nastavim n 1 samo zato da ne povozim statusa 91, ko zakljucim vprasalnik
		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
		$tel_name = $_SESSION['telName'];
		$idtelName = $_SESSION['id_telname'];
		$id_selected_telnum = $_SESSION['id_tel'];
		if ( $status_telnum = $_POST['status_telnum'] ) {
			$status_telnum_array = explode("_",$status_telnum);
			$status_telnum = $status_telnum_array[0];
			$status_rec_telnum = $status_telnum_array[1];
		}
		else
		{
			//$this->LeaveQuestion = false;
		}
		$tren_tabl = $this->projname;
		$telIndexTable = $tren_tabl.'___telIndex';
		$id_user = $_SESSION['id_user'];
		$user_type = $_SESSION['user_type'];
		$sql = "SELECT * FROM _Projects WHERE id = $this->id_project";
		if(!$myrow_id_project = $this->db->fetchAssoc($this->db->SQLexecute($sql))){return false;}



		// check how to set new call time, if callback is set and for different number of calls
		$sql_callback = "SELECT call_num,callback FROM $telIndexTable WHERE id_tel = $id_selected_telnum";
		if(!$myrow_callback = $this->db->fetchAssoc($this->db->SQLexecute($sql_callback))){return false;}
		$noanswer_delay_arr = explode(",",$myrow_id_project['noanswer_call_delay']);
		$busy_delay_arr = explode(",",$myrow_id_project['busy_call_delay']);
		$callback_delay_arr = explode(",",$myrow_id_project['callback_call_delay']);

		if ($myrow_callback['callback']) {
			$call_num = $myrow_callback['callback'];
			$defined_cb_delays = count($callback_delay_arr)-1;
			if ($call_num > $defined_cb_delays) $call_num = $defined_cb_delays;
			$busy_delay = $callback_delay_arr[($call_num)];
			$noanswer_delay = $callback_delay_arr[($call_num)];
		} else {
			$call_num = $myrow_callback['call_num'];
			$defined_cb_delays = count($busy_delay_arr)-1;
			if ($call_num > $defined_cb_delays) $call_num = $defined_cb_delays;
			$busy_delay = $busy_delay_arr[($call_num)];

			$defined_cb_delays = count($noanswer_delay_arr)-1;
			if ($call_num > $defined_cb_delays) $call_num = $defined_cb_delays;
			$noanswer_delay = $noanswer_delay_arr[($call_num)];
		}



		$noanswer_call_delay = $noanswer_delay*60;
		$busy_call_delay = $busy_delay*60;
		$ID_tellog_input = $_SESSION['id_tellog'];

		$trenuten_cas=time();
		$trenuten_cas_array = getdate($trenuten_cas);
		$this->finalStatus = $status_telnum;
		$this->finalRecStatus = $status_rec_telnum;
		if($status_telnum == 1)
		{
		//if status is 1 we write the status in 4 tables: tel_table , proj_telIndex, proj_telLog,proj_structure
		 //we also fill the structure table with all the data from tel_table
		 // sedaj se zapisem status stevilke in uspesnost klica v bazo tel. stevilk

			// ker zelim v index tabeli doseci konsistenco z _structure tabelo,
	// nekoncano anketo vodim pod statusom 99
				$write_status_telnum = 1;
				$write_status_rec_telnum = 99;
				//print_r($_SESSION['telData']);
				$SQL_append_telbase = "UPDATE $tel_name SET usp_klici=usp_klici+1, status=$write_status_telnum , status_rec='$write_status_rec_telnum', proj_status=$write_status_telnum, proj_status_rec='$write_status_rec_telnum', usp_day=$trenuten_cas_array[mday], usp_month=$trenuten_cas_array[mon], usp_year=$trenuten_cas_array[year], usp_hour=$trenuten_cas_array[hours], usp_min=$trenuten_cas_array[minutes], usp_utime=$trenuten_cas WHERE id=$id_selected_telnum";
		//	echo $SQL_append_telbase;
				$result_append_telbase = $this->db->SQLexecute( $SQL_append_telbase);
		// se update index tabele
			if(!$_SESSION['predictiveDialing'] )
						$write_stat_data = ",last_call='$trenuten_cas', call_num=call_num+1";

				if ($_POST['statusComment']) $writeStatusComment = "\r\n".$_POST['statusComment'];
				$query_update_telnum_sts = "UPDATE $telIndexTable SET status='$write_status_telnum', status_rec='$write_status_rec_telnum', status_comment=CONCAT(status_comment,'".$writeStatusComment."'), call_time='0' $write_stat_data WHERE id_tel=$id_selected_telnum";
				$this->db->LogWrite($query_update_telnum_sts,false,"update index tabele, preverjam status comment (status=1");
				$result_append_telbase = $this->db->SQLexecute(  $query_update_telnum_sts, $SQLconnect);
		// se zapisem status v tel log tabelo
		    $query_update_telnum_log = "UPDATE ".$tren_tabl."___telLog SET status='$write_status_telnum',status_rec='$write_status_rec_telnum', id_structure=$this->id_record WHERE id='$ID_tellog_input' ";
			//echo "$query_update_telnum_log<br>";
			 $result_append_telbase = $this->db->SQLexecute(  $query_update_telnum_log);

			 //v structure tabelo zapisemo vse podatke iz index tabele!!!!
			 $telData = $_SESSION['telData'];
			$sql = "SELECT name FROM _TelephoneTblDefaultVar WHERE use_in_index = 1";
			if(!$res = $this->db->SQLexecute($sql)) return $this->db->JsonError();
			while($row = $this->db->fetchRow($res)){
                $name = $row[0];
                $value = $telData[$row[0]];
                if($row[0] == "telephone"){
                    $sql = "SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . "._Projects WHERE id = ".$_SESSION['id_project'];
                    if(!$projectTelConfig = $this->db->fetchAssoc($this->db->SQLexecute($sql))){	return false;}

                    $telNumberCharLimit = 50;
                    if(!empty($projectTelConfig["structure_tel_char_limit"])){
                        $telNumberCharLimit = ($projectTelConfig["structure_tel_char_limit"] == -1) ? 0 : $projectTelConfig["structure_tel_char_limit"];
                    }

                    $value = substr($value, 0, $telNumberCharLimit);
                }

                $setFields[] = "TP_$name = '$value'";
            }

			$sql = "SELECT name FROM _TelephoneTablesAddon WHERE id_telbaza = $idtelName";
			if(!$res = $this->db->SQLexecute($sql)) return $this->db->JsonError();
			while($row = $this->db->fetchRow($res))
			{
				$setFields[] = 'TP_'.$row[0]." = '".$telData['tel_'.$row[0]]."'";
			}
		 	$sql = "UPDATE ".$tren_tabl."_structure SET status=$write_status_telnum  , status_rec='$write_status_rec_telnum',t_start='$trenuten_cas',d_start='".date("Y-m-d H:i:s")."' ,id_tel= $id_selected_telnum,id_telname=$idtelName ,".implode(',',$setFields)." WHERE id = $this->id_record";
		 	if(!$res = $this->db->SQLexecute($sql)) return $this->db->JsonError();
			 //umetno nastavim skok na prvo vprašanje
//			 $sql = "SELECT q_name FROM ".DB_WARPIT_WEBCATI.".$this->projname WHERE q_pos = 1";
//			 $row = $this->db->fetchRow( $this->db->SQLexecute($sql) );
//			 $firstQ = $row[0];
			 //$zad['goto_sql'] = 'true#1';
			 $this->finalStatus=1;
			 $this->finalRecStatus = 99;

		}
		else if($status_telnum > 1)
		{
			//moram prekinit povezavo...
			if($status_telnum != 91 && $_SESSION['autoDialing'])
			{
				require_once(PATH_TO_ROOT."survey/predictive/class.RM_AsteriskManager_predictive.php");

		  				extract( configLoader::loadConfig('asterisk_dialing'));
						$am_addqueue = new RM_AsteriskManager_predictive($this->db);
		  				$interna_stevilka = $_SESSION['asteriskID'];
		  				$id_user = $_SESSION['id_user'];

		  				if ($am_addqueue->LogOn($asterisk_username, $asterisk_password, $asterisk_ip, $asterisk_port, $interna_stevilka , $id_user  )) {

		  					$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
		  					$am_addqueue->Hangup($interna_stevilka);
		  					sleep(2);
		  				}
		  				else
		  				{
		  					echo "logon ni uspel";
		  				}
			}

		// sedaj se zapisem status stevilke in neuspesnost klica v bazo tel. stevilk
				$SQL_append_telbase = "UPDATE $tel_name SET neusp_klici=neusp_klici+1, status=$status_telnum, status_rec='$status_rec_telnum', proj_status=$status_telnum, proj_status_rec='$status_rec_telnum', neusp_day=$trenuten_cas_array[mday], neusp_month=$trenuten_cas_array[mon], neusp_year=$trenuten_cas_array[year], neusp_hour=$trenuten_cas_array[hours], neusp_min=$trenuten_cas_array[minutes], neusp_utime=$trenuten_cas WHERE id=$id_selected_telnum";
	//		echo $SQL_append_telbase;
				if(!$this->db->SQLexecute($SQL_append_telbase)) echo $this->db->GetError().'<br>'.$SQL_append_telbase;
		// nafilam se log tabelo s pravim statusom
		    $query_update_telnum_log = "UPDATE ".$tren_tabl."___telLog SET status='$status_telnum', status_rec='$status_rec_telnum', end_time='$trenuten_cas' WHERE id='$ID_tellog_input' ";
			$this->db->LogWrite($query_update_telnum_log, false, "log tabela za status>1");
			 $this->db->SQLexecute($query_update_telnum_log);

		// update index tabele v primeru statusa 2 (busy)
				if ( $status_telnum == 22 || $status_telnum == 25 ) {

						$nextCall = $status_telnum == 22 ? $busy_call_delay : $noanswer_call_delay;
						if ($_POST['statusComment']) $writeStatusComment = "\r\n".$_POST['statusComment'];

						//20160513 Tanis: Ko imamo enkrat dogovor je treba obdržati status v telIndex tabeli tudi, če je bil klic busy ali pa ni nihče odgovoril.
						//Tukaj že vemo da je novi status 22 oz 25 zato najprej preverimo če je bil kdaj prej sklenjen dogovor. Če je bil nastavimo status na 91 če pa ne pa na trenutni nov status
            //20170720 Tanis: Če smo imeli appointment s status rec = 10 ali 20 (manual callback appointment), se je v telIndex tabelo prenesel status od appointmenta(91) in
            // in status_rec od novega statusa(0). Dobili smo status 91,0 kar je pomennilo navaden appointment, ki se je po pretečenem času avtomatsko poklical. Iz telLog table bomo prebrali
            // status_rec od zadnjega appointmenta, ki je bil dodan in ga shranili v telIndex
            $statusCheckSql = "SELECT status, status_rec FROM ".$tren_tabl."___telLog WHERE status = 91 AND id_tel = " . $id_selected_telnum . " ORDER BY id DESC LIMIT 1";
						$statusChekcRes = $this->db->SQLexecute($statusCheckSql);
						//if($_SESSION['app_exists'])
						if($this->db->NumRows($statusChekcRes) > 0)
						{
              //20170720 Tanis: preberem star status_rec iz ___telLog table in ga shranim v telIndex
              $statusCheckZad = $this->db->fetchAssoc($statusChekcRes);
              //20170720 Tanis: tukaj si shranim status_rec v globlano spremenljiko, ki jo nato uporabim še kasneje ko se še enkrat posodobit ___telIndex tabela na drugem mestu
              $this->oldStatusRec   = $statusCheckZad['status_rec'];

              $query_update_telnum_sts = "UPDATE $telIndexTable SET status='91', status_rec='$this->oldStatusRec', status_comment=CONCAT(status_comment,'".$writeStatusComment."'), last_call='$trenuten_cas',call_num=call_num+1, id_ank='$id_user',ank_user_type = $user_type, app_time=$trenuten_cas+$nextCall WHERE id_tel=$id_selected_telnum";
							$this->questFinApp = 1;
						}
						else
						{
							// zapisem se app time, ker busy in no answer prestavljam v tocno dolocen cas klica
							$query_update_telnum_sts = "UPDATE $telIndexTable SET  status='$status_telnum', status_rec='$status_rec_telnum', status_comment=CONCAT(status_comment,'".$writeStatusComment."'), last_call='$trenuten_cas', call_num=call_num+1, call_time=$trenuten_cas+$nextCall, app_time=$trenuten_cas+$nextCall WHERE id_tel=$id_selected_telnum";

						}




					$this->db->LogWrite($query_update_telnum_sts, false, "status=22,25,ce je app zapisem da je app se naprej");
				 	if(!$this->db->SQLexecute($query_update_telnum_sts))  echo $this->db->GetError().'<br>'.$query_update_telnum_sts;
				}


		// zapisem se index tabelo
				else if ( $status_telnum > 2 ) {
					if ( $status_telnum == 91 OR $status_telnum == 71 ) {
						$_SESSION['finalStatus'] = $status_telnum;
						$this->finalStatus = $status_telnum;
						//return; // we must not write status yet, but
						$status_telnum = 90;
		//			echo "$dogovor_ura,$dogovor_min,0,$dogovor_mes,$dogovor_dan,$dogovor_year<br>";
						$sql_dogovor_str = ", id_ank='$id_user',ank_user_type = $user_type";

					}
					if(!$_SESSION['predictiveDialing'] && $status_telnum != 90)
						$write_stat_data = ",last_call='$trenuten_cas', call_num=call_num+1";

					if ($_POST['statusComment']) $writeStatusComment = "\r\n".$_POST['statusComment'];
					$query_update_telnum_sts = "UPDATE $telIndexTable SET status='$status_telnum', status_rec='$status_rec_telnum', status_comment=CONCAT(status_comment,'".$writeStatusComment."') $write_stat_data, call_time='0' $sql_dogovor_str WHERE id_tel=$id_selected_telnum";
					$this->db->LogWrite($query_update_telnum_sts, false, "status>2");
					if(!$this->db->SQLexecute( $query_update_telnum_sts))  echo $this->db->GetError().'<br>'.$query_update_telnum_sts;
				}
				$sql = "UPDATE ".$tren_tabl."_structure SET status=$status_telnum  , status_rec='$status_rec_telnum' WHERE id = $this->id_record";
				$this->db->LogWrite($sql, false, "update structure...");
		 		if(!$this->db->SQLexecute( $sql))  echo $this->db->GetError().'<br>'.$query_update_telnum_sts;

				// Borut - 2018.3.17
				// i add two inserts only because of Gernot
				if ($status_telnum == 3 OR $status_telnum == 4) {
					$sql = "INSERT IGNORE INTO _Telephone_black_list SET oms='".$_SESSION['telData']['oms']."', tel='".$_SESSION['telData']['telephone']."', telephone_number=CONCAT('".$_SESSION['telData']['oms']."','".$_SESSION['telData']['telephone']."'), status=$status_telnum, insert_date=UNIX_TIMESTAMP()";
					//echo "save to black list: $sql<br>";
					$this->db->SQLexecute($sql);
					$sql = "INSERT IGNORE INTO _Telephone_black_list SET oms='0".$_SESSION['telData']['oms']."', tel='".$_SESSION['telData']['telephone']."', telephone_number=CONCAT('".$_SESSION['telData']['oms']."','".$_SESSION['telData']['telephone']."'), status=$status_telnum, insert_date=UNIX_TIMESTAMP()";
					//echo "save to black list: $sql<br>";
					$this->db->SQLexecute($sql);
				}

		/*	// zdaj se pobrisem rekord, da ne zasedam zastonj prostora
				 	if ( ! $app_middle_exist ) {
						$query_delete_unused_id = "DELETE FROM ".$tren_tabl."_structure WHERE id='$ID_structure_input'";
			//		echo "$query_delete_unused_id<br>";
						$result_delete_unused_id = mysql_db_query($CATI_base_structure, $query_delete_unused_id, $SQLconnect);
					}*/
		} else {
			if ($status_rec_telnum == 111) {
				$this->notSaveFinal = 1; // I am not saving final, because I do nothing with a number
				if ($_POST['statusComment']) $writeStatusComment = "\r\n".$_POST['statusComment'];
				$this->db->LogWrite("check session", false, "ce je status 0");

				$query_update_telnum_sts = "UPDATE $telIndexTable SET status='".$_SESSION['telData']['status']."', status_rec='".$_SESSION['telData']['status_rec']."', status_comment=CONCAT(status_comment,'".$writeStatusComment."'), call_num=call_num+1 WHERE id_tel=$id_selected_telnum";
				if(!$this->db->SQLexecute( $query_update_telnum_sts))  $this->db->LogWrite($this->db->GetError()." => ".$query_update_telnum_sts, true, "update status index class_Engine...");

			    $query_update_telnum_log = "UPDATE ".$tren_tabl."___telLog SET status='$status_telnum', status_rec='$status_rec_telnum', end_time='$trenuten_cas' WHERE id='$ID_tellog_input' ";
				if(!$this->db->SQLexecute($query_update_telnum_log))  $this->db->LogWrite($this->db->GetError()." => ".$query_update_telnum_log, true, "update status log class_Engine...");

			}
		}
		$_SESSION['finalStatus'] = $this->finalStatus;
	}

	function checkQuotas(&$zad)
	{
		//$this->debugPrint($_SESSION);
		unset($_SESSION['layer_allowOther']);
		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
		//let's check if telefone quotas where disabled! this is faster! :)
		//new strict locking action :)
		//only for CATI questionars!
		if(!$_SESSION['popUpQuestionnaire'])
		{
			$sql = "SELECT distinct id_question,source,q_name FROM quota_layer a LEFT JOIN quota_layer_addon b ON a.layer = b.id WHERE id_project = $this->id_project AND telSelect = 1";
			$res = $this->db->SQLexecute( $sql );
			while ($row = $this->db->fetchRow($res) )
			{
				$telField = $row[2];
				if($row[1] == 1)
					$telField  = 'tel_'.$telField;
				$strictlock_region_def[] = 'TP_'.$row[2]." = " . $_SESSION['telData'][$telField];
			}
			if($strictlock_region_def)
			{
				$sql = "SELECT isLocked FROM $this->projname"."___quotaLock WHERE ".implode(' AND ',$strictlock_region_def);
				$isLocked = $this->db->fetchRow( $this->db->SQLexecute($sql) );

				if($isLocked[0])
				{
					$zad['goto_sql'] = "true#quotaInfo";
					$_SESSION['finalStatus'] = 51;
					$this->finalStatus = $_SESSION['finalStatus'];
					$this->jumpSkipFilter = true;
					return;
				}
			}
		}
		//we find all the other layers
//		$sql = "SELECT DISTINCT a.id,allow_other FROM quota_layer_addon a LEFT JOIN quota_layer b ON a.id = layer WHERE active=1 AND id_project = $this->id_project AND telSelect = 0";
//		if(!$res = $this->db->SQLexecute($sql)) echo "Error getting layers!:". $this->db->SQLerror();
//		while ($row = $this->db->fetchRow($res))
//			$layers[] = $row;

		$sql = "SELECT layer,q_name,source,allow_other FROM quota_layer a LEFT JOIN quota_layer_addon b ON a.layer=b.id WHERE id_project = $this->id_project AND telSelect = 0 AND active = 1";
			$res = $this->db->SQLexecute($sql);
			while ($row = $this->db->fetchRow($res))
			{
				if($row[2]==3)
				{
					//the user quota
					//in structure we have user_id and in quota tables we have QT_ prefix...so this should work :D
					$layers[ $row[0] ][] = "user_id AS QT_user_id,user_type AS QT_user_type";
				}
				else
				{
					if($row[2] == 2)
						$pref = 'QT_';
					else
						$pref = 'TP_';

					$layers[ $row[0] ][] = $pref.$row[1];
				}
			}
			$allowOther[ $row[0] ] = $row[3];

		if(!is_array($layers)) return false;

		//for each layer we check the quota!
		foreach ($layers as $id_layer => $layerArr) {
			//first we get all the variables in this layer
			$haveAllData = true;
				$sql = "SELECT ".implode(',',$layerArr)." FROM $this->projname"."_structure WHERE id  = $this->id_record";
			$res = $this->db->SQLexecute($sql);
			$values = $this->db->fetchAssoc($res);
			$limitWhere = array();
			foreach ($values as $qFld => $qVal) {
				//if a quota value is not yet filled we can't do anything now, can we?
				$limitWhere[] = $qFld .' = '.$qVal;
				if(!$qVal)
					$haveAllData = false;
			}
			if($haveAllData)
			{ //we get the count from _quotaLimits and the values from _quotaCalc
				$where = implode(' AND ',$limitWhere);

				//20160718 Tanis: added enabled flag.
				$sql = "SELECT q_value, enabled FROM $this->projname"."___quotaLimits WHERE id_layer = $id_layer AND ".$where;
				$res = $this->db->SQLexecute($sql);
				$qLimit = $this->db->fetchRow($res);
				//20160718 Tanis: added enabled flag.
				$enabled = $qLimit[1];
				$qLimit = $qLimit[0];

				$sql = "SELECT count(*) FROM $this->projname"."___quotaCalc WHERE ".$where;
				$res = $this->db->SQLexecute($sql);
				$qVal = $this->db->fetchRow($res);
				$qVal = $qVal[0];

				//20160718 Tanis: added enabled flag.
				if($qVal >= $qLimit && $enabled)
				{
					if($allowOther[$id_layer])
						$_SESSION['layer_allowOther'] =true;
					$zad['goto_sql'] = "true#quotaInfo";
					$_SESSION['finalStatus'] = 51;
					$this->finalStatus = $_SESSION['finalStatus'];

					$this->jumpSkipFilter = true;
					return;
				}

			}

		}

	}


	public function getQuestionPosition() {
		/*
		 * it was like this... for two years... Borut change this on 13.10.2012

		$id = $_SESSION['nextQuestion'][0]['id'];
		$rot = explode('/',$this->rotationString);
		$position = array_search($id,$rot)-$_SESSION['rotationStrStart'];
		*/
		$position = array();

		$rotString = explode('/',$this->rotationString);
		$rotStringCurrent = explode('/',$_SESSION['currentRotationString']);
		$currentVar = $rotStringCurrent[1];
		$currentVarKey = array_search($currentVar,$rotString);

		$position[0] = $currentVarKey - $_SESSION['rotationStrStart'];
		if (!$position[0] OR $position[0]<1) $position[0] = 1;

		// -3 because first and last item, -1 because of end template
		$position[1] = count($rotString) - 2 - $_SESSION['rotationStrStart'] - 1;

		//print_r($_SESSION);
		//echo "<br><br>";
		//print_r($rotString);
		//echo "<br><br>curentVar:$currentVar<br>currentVarKey:$currentVarKey<br>position:".$position[0]."<br>count rotStr:".$position[1]."<br>";

		// 0=position in rotation string, 1=count of all questions (excluded system)
		return $position;
	}


	public function getQuestionPosPercent($dec = 0) {
		$qPositionAndAll = $this->getQuestionPosition();

		// it was like this until 2013.09.01 - 12:59
		// I think it was a BUG, but I can not find a reason why I use $_SESSION['rotationStrLength']  and not $qPositionAndAll[1]
		// which is all question count
		//$pct = round( $qPositionAndAll[0] / $_SESSION['rotationStrLength'] * 100 ,$dec );
		$pct = round( $qPositionAndAll[0] / $qPositionAndAll[1] * 100 ,$dec );
		/*
		echo "session:<br>";
		print_r($_SESSION);
		echo "<br><br><br>qPositionAndAll:<br>";
		print_r($qPositionAndAll);
		echo "<br><br>pct: ".$pct."<br>";
		*/
		return $pct;
	}

  public function getBrowserTitle()
  {

      $this->browser_title = $this->db->get("_Projects", $this->id_project, 'browser_title', DB_WARPIT_WEBCATI_BASE);
      return $this->browser_title;
  }

    //20170116 Bojan Orter - I changed function name and functionaliti. Now we have 3 ways that repeal button can work. We also return next question. This is done, so eingine log is not curupted
    public function repealQuestionnaierAndSearchingNextQuestion($type)
    {
        $row = $this->db->fetchAssoc( $this->db->SQLexecute("SELECT id FROM ".DB_WARPIT_WEBCATI.".$this->projname WHERE q_pos = -3") );
        if(!$row)
        {
            echo "'Repeal' question not found!";
            exit;
        }

        $_SESSION['currentRotationString'] 	= $this->currentRotationString = "/".$row["id"]."/";
        $this->hideForward = true;
        $this->hideBackward = true;
        //we first find next question, that is then return at end. Then we go one to repeal questionnaire
        $nextQuestion = $this->searchingNextQuestion();
        $sqls = Array();

        //set structure so we dont count it into statistics
        $sqls[] = "UPDATE " . DB_WARPIT_WEBCATI_BASE . ".{$this->projname}_structure SET status = null, status_rec = null, flag_bad = 99 WHERE id = " . $_SESSION["id_record"];

        if(in_array($type, Array("Reset to first", "Reset to last") ))
        {
            $longSql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . "._www_interviewer_statistics SET qstatus = 99 ";
            $longSql .= " WHERE id_user = " . $_SESSION['id_user']. " AND user_type = " . $_SESSION['user_type'] . " AND id_project = " . $_SESSION["id_project"] . " AND id_loginSID = " . $_SESSION['id_loginSID'];
            $sqls[] = $longSql;

            $logTableName = $this->projname . "___EngineLog";
            $sql = "SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . ".$logTableName WHERE id_user = " . $_SESSION['id_user']. " AND user_type = " . $_SESSION['user_type'] . " AND id_structure = " . $_SESSION["id_record"]. " ORDER BY id ASC";
            if(!$logRes = $this->db->SQLexecute( $sql))
            {
                echo $this->db->GetError();
                return;
            }

            $rows = Array();
            while($row = $this->db->fetchAssoc($logRes)){$rows[] = $row;}

            $previousRecord = null;
            $recordToCopy = null;
            foreach ($rows as $row)
            {
                //first case
                if(is_null($previousRecord))
                {
                    $previousRecord = $row;
                    continue;
                }

                //previous question was _start (start has always id 1)
                if($type == "Reset to first" && $previousRecord["id_question"] == 1)
                {
                    $recordToCopy = $row;
                    break;
                }
                //current question is _end (end has always id 2)
                else if($type == "Reset to last" && $row["id_question"] == 2)
                {
                    $recordToCopy = $previousRecord;
                    break;
                }
                $previousRecord = $row;
            }

            $data = Array();
            $columns = Array();
            foreach ($recordToCopy as $key => $value)
            {
                if($key == "id") continue;

                $columns[] = $key;
                if(is_null($value) || in_array($key, Array("questEnd", "eventLogger", "arriveStatus")))
                {
                    $data[] = "null";
                }
                else if( in_array($key, Array("q_name", "currentRotationString", "questionnairePath", "eventLogger") ))
                {
                    $data[] = "'$value'";
                }
                else
                {
                    $data[] = $value;
                }
            }
            $sqls[] = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . ".$logTableName (" . implode(",", $columns) . ") VALUES (" . implode(",", $data) . ")";
        }
        else if($type == "Full reset")
        {
            $longSql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . "._www_interviewer_statistics SET id_loginSID = (-1) * id_loginSID, id_sessionSID = (-1) * id_sessionSID ";
            $longSql .= " WHERE id_user = " . $_SESSION['id_user']. " AND user_type = " . $_SESSION['user_type'] . " AND id_project = " . $_SESSION["id_project"] . " AND id_loginSID = " . $_SESSION['id_loginSID'];
            $sqls[] = $longSql;

            $sqls[] = "UPDATE " . DB_WARPIT_WEBCATI_BASE . ".{$this->projname}___EngineLog  SET id_structure = -1 * id_structure  WHERE  id_structure = " . $_SESSION["id_record"] . " AND id_question != 1 ";
        }

        foreach ($sqls as $sql) {
            $this->db->SQLexecute($sql);
        }

        return $nextQuestion;
    }

	public function updateLanguage($idLng) {
		$sql = "UPDATE ".DB_WARPIT_WEBCATI_BASE.".".$this->projname."_structure SET id_language=$idLng WHERE id=".$this->id_record;
		$res = $this->db->SQLexecute($sql);
	}


	public function debugPrint($var) {
		echo "<pre>";
		print_r($var);
		echo("</pre>");

	}
    protected function callCaptchaApi($secretKey, $clientResponse)
    {

        $url = "https://www.google.com/recaptcha/api/siteverify";
        $postFields = [
            'secret'   => $secretKey,
            'response' => $clientResponse,
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL,$url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postFields));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $serverRespose = curl_exec($ch);

        curl_close ($ch);

        return json_decode($serverRespose, true);
    }

	protected function validateCaptcha($secretKey, $clientResponse)
    {
        $response = $this->callCaptchaApi($secretKey,$clientResponse);

        return $response['success'] === true;
    }

    protected function sendRequestToExternalCapiApp(array $params)
    {
        $capiConfig = configLoader::loadConfig('capi-external-app');
        $url = "http://127.0.0.1";
        $port = $capiConfig["port"];

        $fullUrl = "$url:$port/";
        $auth = "d2FycGl0LWFwcDphUzBsdjN4eHg=";

        $params['path'] = WARPIT_WWW;

        include_once(PATH_TO_ROOT."_support/Curl/Curl.php");
        include_once(PATH_TO_ROOT."_support/Curl/CaseInsensitiveArray.php");
        $curl = new \Curl\Curl;
        $curl->setHeader('authorization', "Basic $auth");
        return $curl->get($fullUrl, $params);
    }

    protected function activateGps($questionName, $recordId, $projectId)
	{
	    $fields = [
	      $questionName . '_lat',
	      $questionName . '_lon',
	      $questionName . '_acc',
	      $questionName . '_time',
	      $questionName . '_status',
        ];

        $this->sendRequestToExternalCapiApp( [
            'fields'       => json_encode($fields),
            'recordId'     => $recordId,
            'projectId'    => $projectId,
            'enable_gps' => 1,
        ]);
	}
}

?>
