<?php
/**
 * Exports projects into xml.
 * Including all properties from table projects in RM_cati_base
 * and all questions from table project_name in RM_cati
 *
 */
include_once (PATH_TO_ROOT.'webcati/_class/XMLExport.php');
include_once (PATH_TO_ROOT."webcati/_ajax/buildQuestionare/class.buildQuestionnaire.php");
class ExportProjects
{
	//the connection to the database. It's recieved in the constructor
	private $db;
	//the XMLwriter class
	private $wr;

    //additional options for design copy
    private $options;
	/**
	 * Constructor, recieves class.dp.php for database connection
	 *
	 * @param unknown_type $db
	 */
	function __construct($db, $options = NULL)
	{
		$this->db = $db;
        $this->options = $options;
	}
	/**
	 * Exports given project to given filename
	 *
	 * @param string $project - project name
	 * @return db error if any true otherwise
	 */
	function export($id_project)
	{
		//first we get the properties, from RM_cati_base table projects
		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
		$project = $this->db->get('_Projects',$id_project,'proj_name');



		$wr = new XMLWriter();
		$wr->openMemory();
		$wr->startDocument('1.0');

		$wr->startElement('Project');

		$export = new XMLExport($this->db,$wr);

		$fieldsFromProjects = 'language,print_filter,print_jump,print_condition,print_answfilter,stat_show_var,stat_show_val,lock_app_to_user,rotation,regionopt,hide_back_button,qt_useregtel,qt_useactel,reg_strictlock,stat_show_scaleborder,busy_call_delay,noanswer_call_delay,num_max_call,back_delete,set_use_autodial,quota_vars,telselect,proj_backup,strictlock_manual,ml_showopt_www,ml_position_www,ml_html_www,forward_button_link,back_button_link,exit_button_link,help_button_link,quest_distance_buttons,submit_where,submit_auto,question_over,user_status_bar,radio_button_enable,radio_button_disable,chk_button_enable,chk_button_disable,use_img_radio,submit_delay_press,exit_alert_msg,forward_button_disable_link,back_button_disable_link,error_img_scale,start_quest_button_link,quest_start_alert_msg,intstat_opt,webcapi_clear_all,webcapi_clear_finished,webcapi_finished,use_special_sampling,wh_special_sampling,disablebasic,call_time_length,use_predictive,show_src_tel_number,show_app_button,submit_on_enter,interview_show_ans_value,interview_show_variable,stat_show_filter_in,stat_show_filter_out,stat_show_goto,stat_show_answer_filter,stat_show_question_type,stat_show_open_end_type';
		if($this->options['copy_phone_table']  == TRUE)
		{
		    $fieldsFromProjects.=",id_telname";
		}
		$export->exportTable('_Projects','Properties',$fieldsFromProjects ,"proj_name = '$project'");

		$export->exportTable('_LanguageProjects','Language','id_language','id_project = '.$id_project);

        //export design
        if($this->options['copy_styles'] == TRUE)
        {
            $wr->startElement("Designes");
            $export->exportTable('_DesignerManager', 'Design', 'id_template,id_question,id_type,id_user,id_qpos,id_special,type_device', "id_project=".$id_project);
            $wr->endElement();
        }
        //$export->exportTable

   		//we export the rotations in a somewhat peculiar manner!
		$rotColumns = "id_question,orderBy,(SELECT orderBy FROM _QuestionRotation b WHERE b.id = a.id_complex ) AS complex,(SELECT orderBy FROM _QuestionRotation c WHERE c.id = a.id_sup) AS packet";
		$wr->startElement('Rotations');
		$export->exportTable('_QuestionRotation a','Rotation',$rotColumns,"type = 2 AND id_project = $id_project ORDER BY complex,packet,orderBy");
		$wr->endElement();

		//20150608 Tanis we also want export ExtraVariables
        $wr->startElement('ExtraVariables');
        $export->exportTable('_ProjectExtraVariables a','Variable',"var_name,var_type","id_project = $id_project");
        $wr->endElement();
        //20150608 Tanis END

		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI);
		$export->includeCreate('createTable');

		//20160119 Bojan Orter - We need to check if $this->options is set becouse default value in counstructor is NULL
		$pluginsToExport = Array();
		if(($this->options != null) && ($this->options['copy_plugin'] != TRUE))
        {
            $sql = "DESCRIBE " . DB_WARPIT_WEBCATI . ".". $project;
            $res = $this->db->SQLexecute($sql);

            while($dat = $this->db->fetchAssoc($res))
            {
                if($dat['Field'] != 'id_plugin')
                {
                    $columns[] = $dat['Field'];
                }
            }

            $export->exportTable($project,'Question', implode(',', $columns));
        }
        else //if plugins are included
        {
			$sql = "SELECT plugin_path FROM " . DB_WARPIT_WEBCATI_BASE . "._Plugin as a JOIN (SELECT id_plugin FROM " . DB_WARPIT_WEBCATI . "." . $project . " WHERE id_plugin IS NOT NULL GROUP BY id_plugin) as b ON a.id_plugin = b.id_plugin";

			$res = $this->db->SQLexecute($sql);
			while($row = $this->db->fetchAssoc($res))
			{
				$pluginsToExport[] = $row['plugin_path'];
			}
            $export->exportTable($project,'Question');
        }

		$export->includeCreate('createTree');
		$export->exportTable($project.'_tree','QuestionTree');

		$export->includeCreate('createLanguage');
		$export->exportTable($project.'_language','QuestionLanguage');
		$export->includeCreate('createScript');
		$export->exportTable($project.'_script','QuestionScript');

		for($i = 0; $i < count($pluginsToExport); $i++)
		{
			$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
			$tableName = "_plugin_" . $pluginsToExport[$i];
			$tag = "PluginProperties";
			$options = "id_project = ".$id_project;

			$wr->startElement('QuestionPlugin');
			$wr->writeAttribute("pluginName", $pluginsToExport[$i]);

			$export->includeCreate(FALSE);
			$export->exportTable($tableName, $tag, "*", $options);
			$wr->endElement();
		}

		$wr->endElement();

        //print $export->endXML();
	 	return $export->endXML();

	}
}

?>
