<?php
include_once ("_dirinfo.php");
include_once (PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."_ajaxManipulators/_class/class.gridData.php");
include_once (PATH_TO_ROOT."_ajaxManipulators/_class/class.treeData.php");
include_once(PATH_TO_ROOT."config.php");


class statusCountAsGridManipulator extends GridDataManipulator
{
	private function getAllStatuses()
	{
		$allStatuses = Array();
		$sql = "SELECT status, status_rec, opis FROM _TelephoneStatus ORDER BY orderBy";
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchAssoc($res))
		{
			$data = Array();
			$status_key = $row["status"] . "_" . $row["status_rec"];
			$data["type"] = "Telephone";
			$data["status"] = $row["status"];
			$data["status_rec"] = $row["status_rec"];
            $data["idLab"] = $row["opis"];
			$allStatuses[$status_key] = $data;
		}

		$systemStatuses['-1_0'] = "interviewer error or in dial process";
		$systemStatuses['0_0'] = "free numbers";
		$systemStatuses['0_1'] = "reactivated number";
		$systemStatuses['1_1'] = "finished interview";
		$systemStatuses['1_99'] = "browser shutdown or crash";
		$systemStatuses['3_1'] = "person does not want to participate, after appointment";
		$systemStatuses['3_2'] = "person does not want to participate, after appointment in the middle";
		$systemStatuses['89_0'] = "canceled appointment";
		$systemStatuses['90_0'] = "appointment in dial process";
		$systemStatuses['91_1'] = "appointment on status screen";
		$systemStatuses['91_2'] = "appointment in questionnaire";
		$systemStatuses['50_0'] = "quota unsuccessful";
		$systemStatuses['51_1'] = "quota full - start with new interview";
		$systemStatuses['51_2'] = "quota full - exit interview";
		$systemStatuses['52_0'] = "no more telephone numbers";
		$systemStatuses['53_1'] = "question is final - start with new interview";
		$systemStatuses['53_2'] = "question is final - exit interview";
		$systemStatuses['54_1'] = "break the interview - start with new interview";
		$systemStatuses['54_2'] = "break the interview - exit interview";

		foreach ($systemStatuses as $status_key => $description)
		{
			$expKey = explode('_', $status_key);

			$data = Array();
			$data["type"] = "System";
			$data["status"] = $expKey[0];
			$data["status_rec"] = $expKey[1];
            $data["idLab"] = $description;
			$allStatuses[$status_key] = $data;
		}

        return $allStatuses;
	}

	public function selectAction()
	{
		$allStatuses = $this->getAllStatuses();

		$sql = "SELECT CONCAT(status, '_', status_rec) as status_key FROM _StatusRecode WHERE is_leaf = 1";
		$res = $this->db->SQLexecute($sql);

		while ($row = $this->db->fetchAssoc($res))
		{
			unset($allStatuses[$row["status_key"]]);
		}

		$rows = array_values($allStatuses);
		return json_encode(Array("success" => TRUE, "rows" => $rows));
	}

	public function updateAction()
	{

		$parentId = $_POST["nodeId"];
		$statusKeys = explode(",", $_POST["status_keys"]);

		$maxOrderBy = $this->db->get("_StatusRecode", "id_sup = $parentId", "IFNULL(MAX(orderBy), 1) as maxOrderBy");
		if($maxOrderBy)
		{
			$maxOrderBy = $maxOrderBy[0]["maxOrderBy"];
		}
		//var_dump($maxOrderBy);
		$rows = Array();
		foreach ($statusKeys as $status_key)
		{
			$maxOrderBy++;
			$expKey = explode("_", $status_key);

			$data = Array();
			$data[] = $expKey[0];
			$data[] = $expKey[1];
			$data[] = "'Status(" . $expKey[0] . ") - Status_rec(" . $expKey[1] . ")'";
			$data[] = $parentId;
			$data[] = $maxOrderBy;
			$data[] = 1;

			$rows[] = "(".implode(',', $data).")";
		}

		$sql = "INSERT INTO _StatusRecode (status, status_rec, idLab, id_sup, orderBy, is_leaf) VALUES ";
		$sql .= implode(",", $rows);
		$this->db->SQLexecute($sql);

		return json_encode(Array("success" => TRUE, "insert" => $sql, "insertId" => $this->db->GetLastInsertId() ));
	}

}

class statusCountAsTreeManipulator extends TreeDataManipulator
{
	public function selectAction()
	{
		$this->lab = "idLab";
		$_POST["SQL"] = "SELECT id, is_leaf, idLab, id_sup, orderBy FROM _StatusRecode";

		return parent::selectAction();
	}

	public function deleteAction()
	{
		$nodeId = $_POST["nodeId"];
		$isLeaf = ($_POST["is_leaf"] == 'true') ? true : false;

		if(!$isLeaf)
		{
			$sql = "DELETE FROM _StatusRecode WHERE id_sup = $nodeId";
			$this->db->SQLexecute($sql);
		}

		return parent::deleteAction();
	}
}

$db->ChangeDatabase($_POST['database']);
$table = $_POST["RMtable"];

if($_POST["RMcomp"] == "grid")
{
	$manipulator = new statusCountAsGridManipulator($db,$_POST["RMtable"]);
}
else // is tree
{
	$manipulator = new statusCountAsTreeManipulator($db,$_POST["RMtable"]);
}

$comm = $_REQUEST['action'].'Action';
if(method_exists($manipulator,$comm))
	echo $manipulator->$comm();
else
{
	echo '{success:false,error:"Unknown action!"}';
}


?>
