<?php
include_once('_dirinfo.php');
include_once(PATH_TO_ROOT . "init.php");
include_once(PATH_TO_ROOT . "_ajaxManipulators/_class/class.gridData.php");
include_once(PATH_TO_ROOT . "_class/createQuestion/Question.php");

use \Defuse\Crypto\Crypto;
use \Defuse\Crypto\Key;

class recodingGridManipulator extends GridDataManipulator
{
    protected $db;

    protected function getEncryptedFields($projectName)
    {
        $questionIds = $this->db->get($projectName, 'encrypt = 1', 'id', DB_WARPIT_WEBCATI);
        if ($questionIds === null) {
            return [];
        }

        $fields = [];
        foreach ($questionIds as $questionId) {
            $question = Question::createQuestionFromTable($this->db, $projectName, $questionId);
            $fields[] = $question->getStructureFields();
        }

        return $fields;
    }

    protected function getTimeStatistics($projectName)
    {
        $sql = "SELECT a.id_user,a.user_type,b.d_start,b.d_stop,b.status,b.status_rec,b.t_diffs,sum(`questEnd`-`questStart`) as tDiff,`id_structure`, `id_question`,`q_name`,`eventLogger`
		    		FROM " . DB_WARPIT_WEBCATI_BASE . ".`" . $projectName . "___EngineLog` a
			    	LEFT JOIN " . DB_WARPIT_WEBCATI_BASE . ".`" . $projectName . "_structure` b
				    ON a.id_structure = b.id
				    WHERE `questStart`>0 AND `questEnd`>0
				    GROUP BY `id_structure`,`q_name`";

        if (!$this->rs = $this->db->SQLexecute($sql)) {
            return false;
        }

        $records = [];
        while ($row = $this->db->fetchAssoc($this->rs)) {
            $structureId = $row['id_structure'];
            $qName = $row['q_name'];

            $records[$structureId]['time'][$qName] = $row['tDiff'];
            $records[$structureId]['eventLog'][$qName] = $row['eventLogger'];
        }

        return $records;
    }

    protected function getScales($projectName)
    {
        $scales = $this->db->get($projectName, "tip_sql IN (2) ORDER by q_pos", 'q_name', DB_WARPIT_WEBCATI);

        return $scales;
    }

    protected function getScaleDetails($engineLog, $time)
    {
        if ($time === null) {
            return 0;
        }

        $engineLogArray = json_decode($engineLog, true);

        $clientTime = array_shift($engineLogArray);
        $clientTime = $clientTime['ClientTime'];

        $items = [];
        foreach ($engineLogArray as $logRow) {
            $items[$logRow['objName']] += $logRow['clickTimeClient'] - $clientTime;
            $clientTime = $logRow['clickTimeClient'];
        }

        $itemsList = [];
        foreach ($items as $itemName => $itemTime) {
            $itemName = str_replace("answers[", "", $itemName);
            $itemName = str_replace("]", "", $itemName);

            $itemsList[] = "{$itemName}: {$itemTime}";

        }
        return implode(',', $itemsList);

    }

    protected function decryptOpenEnds($value, $encryptionKey)
    {
        try{
            $decryptedValue= Crypto::decrypt($value, Key::loadFromAsciiSafeString($encryptionKey));
        } catch (Exception $e){
            $decryptedValue = $value;
        }

        return $decryptedValue;
    }

    function getSQL()
    {
        $projectName = $_POST['projectName'];
        $recFields = explode(',', $_POST['recFields']);
        $fields = [];

        $encryptedFields = $this->getEncryptedFields($projectName);

        foreach ($encryptedFields as $field) {
            list($field) = $field;
            $fields[] = "a.{$field}";
        }

        foreach ($recFields as $field) {
            $fields[] = "(a.$field IS NOT NULL) as $field";
        }

        return "SELECT a.id, a.d_start, a.d_stop, a.user_id, a.user_type, a.t_diffs, " . implode(',', $fields) . ", b.username FROM " . DB_WARPIT_WEBCATI_BASE . ".{$projectName}_structure as a LEFT JOIN " . DB_WARPIT_WEBCATI_BASE . "._Interviewer as b ON a.user_id = b.id";
    }

    function selectAction()
    {
        $projectName = $_POST['projectName'];
        $recFields = explode(',', $_POST['recFields']);
        $fields = [];

        foreach ($recFields as $field) {
            $fields[] = "(a.$field IS NOT NULL) as $field";
        }

        $_POST['SQL'] = $this->getSQL();
        $this->addWhere('status = 1 and status_rec = 1');

        $timeStatistics = $this->getTimeStatistics($projectName);
        $scales = $this->getScales($projectName);

        $encryptedFields = $this->getEncryptedFields($projectName);
        $encryptedFields = array_map(function ($item) {
            return $item[0];
        }, $encryptedFields);
        parent::selectAction();

        $returnJson = [];
        $surveyConfig = configLoader::loadConfig('survey');

        foreach ($this->arr as $key => $row) {

            //if project contains encrypted fields we decrypt them and show here
            foreach ($encryptedFields as $field) {
                $value = $this->arr[$key][$field];

                if (strlen($value) > 0) {
                    $this->arr[$key][$field] = $this->decryptOpenEnds($value, $surveyConfig['encryptionKey']);
                }
            }

            //add time statistics
            $structureId = $row['id'];
            $time = $timeStatistics[$structureId]['time'];
            $this->arr[$key] = array_merge($this->arr[$key], $time);

            //if we have scale statistics we add details time report for every answer
            foreach ($scales as $scale) {
                $engineLog = $timeStatistics[$structureId]['eventLog'][$scale];
                $this->arr[$key][$scale . '_details'] = $this->getScaleDetails($engineLog, $time[$scale]);
            }


        }
        $returnJson['success'] = true;
        $returnJson['results'] = count($this->arr);
        $returnJson['rows'] = $this->arr;
        return json_encode($returnJson);
    }

    function exportAction()
    {
        $projectName = $_POST['projectName'];
        $recFields = explode(',', $_POST['recFields']);

        //Remove structure id from export
        $expCol = json_decode(stripslashes($_POST['cols']));
        $expHead = json_decode(stripslashes($_POST['heads']));

        array_shift($expCol);
        array_shift($expHead);

        $_POST['cols'] = json_encode($expCol);
        $_POST['heads'] = json_encode($expHead);

        $fields = [];

        foreach ($recFields as $field) {
            $fields[] = "(a.$field IS NOT NULL) as $field";
        }

        $_POST['SQL'] = $this->getSQL();
        $this->addWhere('status = 1 and status_rec = 1');
        unset($_POST['limit']);
        unset($_POST['start']);
        parent::fetchSelect();

        //$this->arr je rezultat tu sem pride koda kak se bo link generiro

        $linkPrefix = WARPIT_WWW . "playSound.php";
        foreach ($this->arr as $key => &$row) {
            foreach ($recFields as $field) {
                if ($row[$field] == 1) {
                    $row[$field] = $linkPrefix . "?projectName=$projectName&structureId=" . $row["id"] . "&field=$field";
                } else {
                    $row[$field] = "/";
                }

                //unset($row['id']);
            }
        }

        parent::exportAction();
    }

    function downloadAction()
    {
        $projectName = $_POST['projectName'];
        $structureId = $_POST['structureId'];
        $recField = $_POST['field'];

        $sql = "SELECT $recField FROM " . DB_WARPIT_WEBCATI_BASE . ".{$projectName}_structure WHERE id = $structureId";
        $res = $this->db->SQLexecute($sql);
        $zad = $this->db->fetchAssoc($res);

        echo json_encode(['success' => true, 'recording' => $zad[$recField]]);
    }

}

$db->ChangeDatabase($_POST['database']);
$manipulator = new recodingGridManipulator($db, $_POST['RMtable']);

$comm = $_REQUEST['action'] . 'Action';
if (method_exists($manipulator, $comm))
    echo $manipulator->$comm();
else {
    echo '{success:false,error:"Unknown action!"}';
}

?>
