<?php
include_once ("_dirinfo.php");
include_once (PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."_ajaxManipulators/_class/class.gridData.php");
include_once(PATH_TO_ROOT . 'webcati/_class/class.quotas.php');
include_once(PATH_TO_ROOT . 'webcati/_class/class.QuotaFields.php');
include_once(PATH_TO_ROOT."config.php");


class showQuotasFull extends GridDataManipulator
{
	private function selectActive($quotas, $start, $limit, $srcField, &$numRows = 0)
	{
        $sql = "SELECT questStart, id_structure, user_id, id_tel, status, b.id, " . $quotas . "
                    FROM ". DB_WARPIT_WEBCATI_BASE .".". $this->projName . "___EngineLog as a
                    JOIN ". DB_WARPIT_WEBCATI_BASE .".". $this->projName . "_structure as b
                    ON a.id_structure = b.id
                    WHERE activeRecord = 1 and status = 51";

        return $this->getData($sql, $start, $limit, $srcField, $numRows);

	}

    private function selectAll($quotas, $start, $limit, $srcField, &$numRows = 0)
	{
			//izberem vse quotafull recorde
			$sql = "SELECT id,id_tel, user_id, status, " . $quotas . "
							FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "_structure
							WHERE status = 51";

			return $this->getData($sql, $start, $limit, $srcField, $numRows);
	}

    private function getData($sql, $start, $limit, $srcField, &$numRows = 0)
    {
            if($srcField){
                    $sql .= ' AND (' . $this->getFilter($srcField) . ')';
            }

            $res     = $this->db->SQLexecute($sql);
            $numRows = $this->db->NumRows($res);

            $data = [];
            if($numRows > 0){
                $sql .= " LIMIT " . $start . ", " . $limit;

                $data = $this->db->getArray($sql);
            }

            $maxIds 	   = $this->getMaxQuestions(array_column($data, 'id'));
            $lastQuestions = $this->getLastQuestions($maxIds);

            return $this->mergeLastQuestions($data, $lastQuestions);

    }

    private function getFilter($srcQuery)
    {
        $tmpQuery[] = 'id_tel IN(' . $srcQuery . ')';
        $tmpQuery[] = 'user_id IN(' . $srcQuery . ')';

        return implode(' OR ', $tmpQuery);

    }

	private function getMaxQuestions(array $ids)
	{
        if(count($ids) === 0){
            return [];
        }

		$sql = "SELECT max(id) as id
								FROM ". DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "___EngineLog
								WHERE q_name NOT IN('gotoIdle', 'quotaInfo', 'appointment')
								AND id_structure IN(" . implode(',', $ids) . ")
								GROUP BY id_structure";
		$maxQuestions = $this->db->getArray($sql);

		return array_column($maxQuestions, 'id');
	}

	private function getLastQuestions(array $maxIds)
	{
        if(count($maxIds) === 0){
            return [];
        }

		$sql = "SELECT q_name, id_structure
						FROM ". DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "___EngineLog
						WHERE id IN ("  . implode(",", $maxIds) . ")";


		$res = $this->db->SQLexecute($sql);
		$lastQuestions = [];
		while($row = $this->db->fetchAssoc($res)){
			$lastQuestions[$row['id_structure']] = $row['q_name'];
		}

		return $lastQuestions;
	}

    private function mergeLastQuestions(array $data, array $lastQuestions)
    {
            if(count($lastQuestions) === 0){
                return $data;
            }

            $mergedArray = [];
            foreach($data as $row){
                $row['q_name'] = $lastQuestions[$row['id']];

                $mergedArray[] = $row;
            }

            return $mergedArray;
    }

	public function selectAction()
	{
            $this->projName = mysql_real_escape_string($_POST['RMtable']);
            $this->projectId = intval($_POST['id_project']);

			$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
			$q = new quotes($this->projectId, $this->db);

			$quotaFields = new QuotaFields($q);
			$quotas = $quotaFields->getStructureColumns();
			$quotas[] = 'TP_telephone';

            $quotasString = implode(',', $quotas);

			$start = intval($_POST['start']);
			$limit = intval($_POST['limit']);

			$numRows = 0;

			if($_POST['srcquery']){
				$srcField = mysql_real_escape_string($_POST['srcquery']);
			}


			if(filter_var($_POST['showOnlyActive'], FILTER_VALIDATE_BOOLEAN) === true){
					$dat = $this->selectActive($quotasString, $start, $limit, $srcField, $numRows);
			}else{
					$dat = $this->selectAll($quotasString, $start, $limit, $srcField, $numRows);
			}


      $data['success'] = TRUE;
      $data['results'] = $numRows;
      $data['rows'] = $dat?$dat:[];

      echo json_encode($data);
	}

}
$db->ChangeDatabase($_POST['database']);

$tableName = $_POST['RMtable'];
$tableAddon = $tableName.'Addon';

$manipulator = new showQuotasFull($db,$_POST['RMtable']);

$manipulator->tableAddon = $tableAddon;
$comm = $_REQUEST['action'].'Action';
if(method_exists($manipulator,$comm))
	echo $manipulator->$comm();
else
{
	echo '{success:false,error:"Unknown action!"}';
}


?>
