$(document).ready(function(){
    var body              = $('body');
    var AT_table_original = body.find('table.answersTable');
    var AT_tr             = AT_table_original.find('> tbody > tr');
    
	if( AT_table_original.length ) {
	
		var submit_button_step  = $('#scalesplit_submit_button');
		var error_msg 			= $('#scalesplit_error_message');
		var error_msg_text 		= $('#scalesplit_error_message_text');

		body.after('<style>.e_opt_input {padding:5px; width:100%; margin:5px 0; box-sizing:border-box;} .inputError {border-color:#f00}</style>');

		//Hide original table
		AT_table_original.hide();

		//Append table steps container
		AT_table_original.after('<div class="tableSteps" data-table-count="'+(AT_tr.length)+'"></div>');

		//Table steps
		var tableSteps = $('.tableSteps');
		var tableSteps_tr_th_css = $($('#scalesplit_title_row').val()).attr('style');
		var tableSteps_tr_odd_css = $($('#scalesplit_odd_row').val()).attr('style');
		var tableSteps_tr_even_css = $($('#scalesplit_even_row').val()).attr('style');

		//Original table tr loop
		AT_tr.each(function(i_tr){
			var tr = $(this);

			i_tr = i_tr + 1;

			var table_html  = '<table data-table-id="'+i_tr+'" class="answersTable " style="width:100%; display:none;border-collapse: collapse;">';

			//TD loop
			$('td',tr).each(function(i_td){
				var td = $(this);
				var td_text = $.trim(AT_tr.eq(0).find('td').eq(i_td).text());                                

				var td_input = td.find('input');
				var td_input_name = td_input.attr('name');

				if( i_td == 0){

					table_html += '<tr><td>'; 
					table_html += ' <div>'+td.text()+'</div>';                                        
					table_html += '</td></tr>';					

					if(error_msg.length){                        
						var error_msg_html = error_msg.val();
						var error_msg_style = $(error_msg_html).attr('style');
						//Error msg
						table_html += '<tr class="tr-error-msg-container" style="display:none; '+error_msg_style+'"><td style="">'+error_msg_text.val()+'</td></tr>';                                              
					} 
					//Spacer
					table_html += '<tr class="tr-spacer"><td></td></tr>';
				}
				else {             
					//Remove <script>
					td.find('script').remove();					
					table_html += '<tr><td>'+td.html()+'</td></tr>'; 
				}

			});        

			table_html += '</table>';  

			//Create table
			tableSteps.append(table_html);    

		});

		//Add css to new tables
		$('table[data-table-id]').each(function(){
			var table = $(this);

			//Append css
			table.find('tr').each(function(i_tr){
				var tr = $(this);

				if(!tr.hasClass('tr-error-msg-container')){ //Dont style error tr         

					if(i_tr == 0){
						tr.find('td').attr('style',tableSteps_tr_th_css);
					}
					else if(i_tr % 2 == 0){            
						tr.find('td').attr('style',tableSteps_tr_odd_css);
					}
					else {
						tr.find('td').attr('style',tableSteps_tr_even_css);
					}

					if(tr.hasClass('tr-spacer')){ //Spacer tr
						tr.find('td').attr('style','background:#DEEAF6; height:10px;');
					}
				}
				else {
					tr.find('td').attr('style','background:#f00; color:#fff; padding:10px;');
				}

			});

			//Set TD width to 100% if !input
			table.find('tr td').each(function(){
				var td = $(this);
				if(!td.find('input').length)
					td.css({'width':'auto','text-align':'left'});
			});

		});

		//Set tmp input name
		tableSteps.find('table[data-table-id] input').each(function(){
			var input = $(this);    
			input.attr('name','temp_'+input.attr('name')).addClass('e_opt_input');
		});

		//Total steps
		var total_steps = $('[data-table-count]').data('table-count');

		//Show first step
		$('.tableSteps [data-table-id]:first-child').css('display','table');    

		//'other' input on keyup
		$('body').on('keyup', 'table[data-table-id] input', function(){
			var input = $(this);
			var input_name = input.attr('name').replace('temp_','');
			if(input.val().length > 0) input.removeClass('inputError');
			$('input[name="'+input_name+'"]').val(input.val());
		});

		//Append new buttons
		var AT_footer_next = $('.button-next');
		var AT_footer_prev = $('.button-prev');
		var AT_footer_next_css = AT_footer_next.attr('style');
		var AT_footer_prev_css = AT_footer_prev.attr('style');

		AT_footer_prev.each(function(){
			$(this).wrap('<div/>').parent('div').css('position','relative').append('<div class="step-prev" style="'+AT_footer_prev_css+' display:none; cursor:pointer; position:Absolute; left:0; top:0; width:100%; height:100%; z-index:20;" onClick="change_step(\'prev\','+total_steps+'); return false;"></div>');
		});
		
		AT_footer_next.each(function(){
			$(this).wrap('<div/>').parent('div').css('position','relative').append('<div class="step-next" style="'+AT_footer_next_css+' cursor:pointer; position:Absolute; left:0; top:0; width:100%; height:100%; z-index:20;" onClick="change_step(\'next\','+total_steps+'); return false;"></div>');
		});

		//Jump to specific step
		if(submit_button_step.length){
			if(submit_button_step.val() == 2){
				jump_to_step(total_steps,AT_table_original);
			}
			else {
				jump_to_step(1,AT_table_original);
			}
		}   
		
	}
});
//Jump to specific table step
function jump_to_step(step,parent_table){
    var next_step_btn = $('.step-next');
    var prev_step_btn = $('.step-prev');
    var total_steps = $('[data-table-count]').data('table-count');
	
    if(step == total_steps){
        //Hide step button
        next_step_btn.hide();
        prev_step_btn.show();
    }
    else if(step == 1){
        prev_step_btn.hide()
    }
    
    parent_table.find('input').each(function(){
        if(typeof this.attributes.checked != 'undefined'){
            $(this).prop('checked', false).prop('checked', true);
        }
    });
    
    $('[data-table-id]').hide();
    $('[data-table-id="'+step+'"]').css('display','table');
}

//Change table step
function change_step(direction, total_steps){
		
    var table_visible = $('[data-table-id]:visible');
    var current_step  = table_visible.attr('data-table-id');
 
    var next_step_btn = $('.step-next');
    var prev_step_btn = $('.step-prev');
    
    var error_msg_container = $('.tr-error-msg-container');
    var aowt 				= $('#scalesplit_must_answer');
	var e_opt_length 	    = 0;
	
	if(aowt.length){
		e_opt_length = aowt.val()
	}	
	
    if( direction == 'next' ){
        
        var input = table_visible.find('input:checked');
        var input_value = input.val();
        var input_name = input.attr('name');
        var error_msg = $('#scalesplit_error_message');
        var current_step_counter = 0;
                
        current_step_counter = parseInt(current_step)+1;
		
        //IF MA is ON
        if(error_msg.length && error_msg.val() != ''){
                    
            //Go to next step if table is valid
            if (table_validate(e_opt_length) == true){            
				
                if(current_step < total_steps){
                    table_visible.hide().next('table').css('display','table');
                }								
                if(current_step == total_steps){
                    //Hide step button
                    next_step_btn.hide();
                    //Trigger next button
                    next_step_btn.prev('input').click();
                }
                else {
                    next_step_btn.show();
                }
            }
            else {
                current_step_counter = current_step;
            }
            
        }
        //IF MA is OFF
        else {

            if(current_step < total_steps){
                table_visible.hide().next('table').css('display','table');
            }
            if(current_step == total_steps){
                //Hide step button
                next_step_btn.hide();
                //Trigger next button
                next_step_btn.prev('input').click();
            }
            else {
                next_step_btn.show();
            } 
        }       
        
    }

    if( direction == 'prev' ){        
        if(current_step > 1){            
            table_visible.hide().prev('table').css('display','table');
            next_step_btn.show();
            error_msg_container.hide();
            current_step_counter = parseInt(current_step)-1;
        }        
    }    

    //Toggle left button
    $('[data-table-id]:visible').attr('data-table-id') == 1 ? prev_step_btn.hide() : prev_step_btn.show();
    
    //Scroll to top
    scroll_to_top(250,200);
        
}

//Check if input option is selected
function table_validate(open_field){
    var table = $('[data-table-id]:visible');
    var error_msg = $('#scalesplit_error_message');
    var error_msg_container = $('.tr-error-msg-container');
	var error = 0;
	
    //Hide / remove error msg / error img 
    error_msg_container.hide();
    table.find('img.input_not_valid_img').remove();

	if( open_field == 1 ){

		if(table.find('.e_opt_input').length){

			table.find('.e_opt_input').removeClass('inputError');

			if(table.find('.e_opt_input').val().length == 0){
				table.find('.e_opt_input').addClass('inputError');
				
				if(error_msg.length){
					if(error_msg != ''){
						error_msg_container.show();
					}
				}				
				
				error++;
			}
		}		
	}	
	
	if(error == 0) return true;
			  else return false;
	
}   
//Scroll to top
function scroll_to_top(speed, delay){
    if(typeof delay != undefined){
        setTimeout(function(){
            $('html, body').animate({ scrollTop: 0 }, speed);}
        ,delay);        
    }
    else {
        $('html, body').animate({ scrollTop: 0 }, speed);
    }
}