<?php
include_once "_dirinfo.php";
include_once PATH_TO_ROOT . "_config/dbConfig.php";
include_once PATH_TO_ROOT . "statview/_class/class.forms.php";
$form = new FormsEvents($db);
$language = configLoader::loadLanguage(1, 'language', 'default_admin', 'dashboard', DB_WARPIT_STATVIEW);
?>

var containerH; 				//višina dropapble containerja
var containerW; 				//širina dropapble containerja
var droppableH; 				//višina območja za pomikanje
var droppableW; 				//širina območja za pomikanje
var containmentBottom = false; 	//polje pomikanja omejeno spodaj
var containmentRight = false; 	//polje pomikanja omejeno desno
var leftOffset = 15;			//odmik levo
var topOffset = 40;				//odmik strani od zgornjega roba

$(window).resize(function(e) {
	if (typeof $(e.target).attr("id") == "undefined") {
		containerH = $(window).height() - topOffset;
		containerW = $(window).width() - 15;

		$(".droppable-container").css({"height": containerH + "px", "width": containerW + "px"});
		$("#catalog").children("div").css("height", ($(window).height() - (2 * topOffset)) + "px");
	}
});

$(function() {
	if ($(window).width() > $("#sredina").width()) {
		leftOffset = -2;
	}

	containerH = $(window).height() - topOffset;
	containerW = $(window).width() - leftOffset;

	if (typeof droppableH == "undefined") {
		droppableH = containerH;
	}
	if (typeof droppableW == "undefined") {
		droppableW = containerW;
	}

	$(".droppable-container").css({"height": containerH + "px", "width": containerW +"px"});
	$("#droppable-zone").css({"height": containerH +"px", "width": containerW +"px"});

	$(".side-bar").resizable({
		minWidth: 100
	}).css({"top": topOffset + "px"});

	//DashboardWidgetsTable - DataTable
	$("#DashboardWidgetsTable").dataTable({
        "language": { "url": "_javascript/dataTables.slo.lang.php"},
        "initComplete": function(settings, json) {
			$(".table-responsive").find("[type=search]").attr("maxlength", 50);
	  	},
        "bPaginate": false,
        "bInfo": false
    });
    //DashboardLabelsTable - DataTable
    $("#DashboardLabelsTable").dataTable({
        "bPaginate": false,
        "bFilter": false,
        "bInfo": false
    });

    //izpis širine in višine droppable območja na top baru
	$("#info-width").html(droppableW);
	$("#info-height").html(droppableH);

	//hide/show side bar
	$(".hide-show-side-bar").children("span").click(function() {
		toggleSideBar();
	});

	//harmonika
	$("#catalog").accordion();

	$("#catalog").children("div").css({"max-height": (containerH - 160) + "px", "height": (containerH - 160) + "px"}); //custom za warpit

	$(".draggable-label, .draggable-widget").draggable({
		appendTo: "body",
		helper: "clone",
		cursor: "pointer",
		containment: "#droppable-zone"
	}).css({"max-width": "200px"});


	//SETTINGS form
	$("#droppanle_color_picker").colorpicker();
	//droppable color
	$("#droppanle_color_picker").colorpicker("val", "#2c3e50");
	$("#droppanle_color_picker").on("change.color", function(e, color) {
	    $("#droppable-zone").css("background-color", color);
	});

	//droppable size
	$("#droppable_height").val(droppableH);
	$("#droppable_width").val(droppableW);

	$("#droppable-settings-form").submit(function(e) {
		e.preventDefault();
		renderDashboardSettings();
		$("#dash-saved").val("");
		$(".dash-title").css("font-style", "italic");
	});

	$("#reset-settings").click(function() {
		$("#droppanle_color_picker").colorpicker("val", "#2c3e50");

		$("#droppable_height").val(droppableH);
		$("#droppable_width").val(droppableW);

		renderDashboardSettings(true);
		$("#dash-saved").val("");
		$(".dash-title").css("font-style", "italic");
	});

	$("#auto_draggable_fit").click(function() {
		if ($(this).is(":checked")) {
			$("#droppable_height").prop("disabled", true);
			$("#droppable_width").prop("disabled", true);
		} else {
			$("#droppable_height").prop("disabled", false);
			$("#droppable_width").prop("disabled", false);
		}
	});
	//SETTINGS form //

	//izbira dashboarda z dropdowna na top baru
	$("#dash-select").change(function() {
		autoSaveDashboard();
		toggleSideBar(true);
		var dashId = $(this).val();
		loadDashboard(dashId);
	});

	//resize autohide
	$(".droppable-container").on("mouseover", "[id^='draggable-widget-'],[id^='draggable-label-']", function() {
		$(this).find(".ui-resizable-se").addClass("ui-icon ui-icon-gripsmall-diagonal-se");
	});

	$(".droppable-container").on("mouseout", "[id^='draggable-widget-'],[id^='draggable-label-']", function() {
		$(this).find(".ui-resizable-se").removeClass("ui-icon ui-icon-gripsmall-diagonal-se");
	});

	//nalaganje nazadnje urejenega dashbaorda
	$.ajax({
		url: "_ajax/ajax.dashboard.php",
		type: "POST",
		data: {action: "getLatestDashId", userId: $("#user-id").val() },
	})
	.done(function(res) {
		var data = JSON.parse(res);

		if (data.id != 0) {
			loadDashboard(data.id);
			$("#dash-select").val(data.id);
			toggleSideBar(true);
		} else {
			initDroppableZone();
		}
	});

	//avtomatsko shranjevanje dashboarda ob kliku na drug navigacijski gumb
	$(".navbar-nav").on("click", "li", function(event) {
		var menuBtnId = $("#main-navbar").find(".active").children().attr("id");

		if (menuBtnId != "l1") {
			autoSaveDashboard();
		}
	});
});

/**
* Inicializira droppable območja
**/
function initDroppableZone() {
	$("#droppable-zone").droppable({
		drop: function(e, ui) {
			var itemClass = ui.draggable.attr("class");
	  		var uuid = guid();

	  		var scrollTop = $(".droppable-container").scrollTop();
	  		var scrollLeft = $(".droppable-container").scrollLeft();
	  		var pos = $(ui.helper).position();
	  		var wTop = (pos.top + scrollTop - topOffset);
	  		var wLeft = (pos.left + scrollLeft - leftOffset);

	  		//label
	  		if (itemClass.indexOf("draggable-label") != -1) {
	  			$(this)
	  			.append($(ui.helper)
					.clone()
					.attr("id", "draggable-label-" + uuid)
					.removeClass("draggable-label")
					.css({
						"max-width": "none",
						"height": "auto",
						"width": "150px",
						"top": wTop + "px",
						"left": wLeft + "px"
					})
					.html(createWidgetHtml(uuid, "label")));

	  			initDraggable("#draggable-label-" + uuid);

				var label = $("#draggable-label-" + uuid);
	  			label.find(".widget-size").html(label.width() + "x" + label.height());

				toggleSideBar();
	  		}
	  		//widget
	  		else if (itemClass.indexOf("draggable-widget") != -1) {
	  			var iframe = $(ui.draggable).find("input[type=hidden]").val();

	  			$(this)
	  			.append($(ui.helper)
					.clone()
					.attr("id", "draggable-widget-" + uuid)
					.removeClass("draggable-widget")
					.css({
						"max-width": "none",
						"height": "200px",
						"width": "400px",
						"top": wTop + "px",
						"left": wLeft + "px"
					})
					.html(createWidgetHtml(uuid, "widget", iframe)));

	  			initDraggable("#draggable-widget-" + uuid);

				//nastavljanje višine iframe-a in widgeta
	  			$(document.getElementsByTagName('iframe')).on('load', function() {
	  				var iframeH = $("iframe").contents().find(".predc").height();
					var iframeW = $("iframe").contents().find(".predc").width();
					$("iframe").css({"width": (iframeW + 10)+"px", "height": (iframeH + 100)+"px"});
	  			});

	  			var widget = $("#draggable-widget-" + uuid);
	  			widget.find(".widget-size").html(widget.width() + "x" + widget.height());

	  			toggleSideBar();
	  		}
		}
	});
}

/**
* Inicializira draggable widget ali labelo
**/
function initDraggable(widgetId) {
	$(widgetId).addClass("ui-resizable-autohide");

	$(widgetId).draggable({
		helper: "original",
		cursor: "pointer",
		scroll: true,
		containment: calcContainment(widgetId),
		start: dragStart,
		stop: dragStop
	}).resizable();

	$(widgetId).resizable("option", { stop: resizeStop });
	$(widgetId).resizable("option", { resize: function(e, ui) {
		$(ui.helper).find(".widget-size").html(ui.size.width + "x" + ui.size.height);
		if (ui.size.width < 120) {
			$(ui.helper).find(".widget-size").css("visibility", "hidden");
		} else {
			$(ui.helper).find(".widget-size").css("visibility", "visible");
		}
	}});

	//ui-resizable-autohide
	$(widgetId).find(".ui-resizable-se").removeClass("ui-icon ui-icon-gripsmall-diagonal-se");

	if (widgetId.indexOf("draggable-widget") != -1) {
		$(widgetId).draggable("option", "snap", true);
	}
}

/**
* Upoštavanje nastavitev dashboarda
**/
function renderDashboardSettings(reset) {
	//droppable size
	var newHeight = parseInt($("#droppable_height").val());
	if (newHeight != droppableH && $("#droppable_height").is(":enabled")) {
		containmentBottom = true;
		$("#containment_bottom").val("true");
		$("#droppable-zone").css({"height": newHeight +"px"});
		$("#info-height").html(newHeight);
	} else {
		containmentBottom = false;
		$("#containment_bottom").val("false");
		$("#droppable-zone").css({"height": droppableH +"px"});
		$("#info-height").html(droppableH);
	}

	var newWidth = parseInt($("#droppable_width").val());
	if (newWidth != droppableW && $("#droppable_width").is(":enabled")) {
		containmentRight = true;
		$("#containment_right").val("true");
		$("#droppable-zone").css({"width": newWidth +"px"});
		$("#info-width").html(newWidth);
	} else {
		containmentRight = false;
		$("#containment_right").val("false");
		$("#droppable-zone").css({"width": droppableW +"px"});
		$("#info-width").html(droppableW);
	}

	//določitev containmenta
	$("[id^='draggable-widget-'],[id^='draggable-label-']").each(function() {
		var widgetId = "#" + $(this).attr("id");
		$(this).draggable("option", "containment", calcContainment(widgetId));
	});

	//avtomatski obrez polja
	if($("#auto_draggable_fit").is(":checked")) {
		$("#auto_draggable_fit").prop("checked", false);
		$("#droppable_height").removeAttr("disabled");
		$("#droppable_width").removeAttr("disabled");

		var leftArr = [];
		var topArr = [];
		var count = 0;

		$("[id^='draggable-widget-'],[id^='draggable-label-']").each(function() {
			leftArr.push($(this).position().left + $(this).width());
			topArr.push($(this).position().top + $(this).height());
			count++;
		});

		if (count > 0) {
    		var maxLeft = Math.round(Math.max.apply(Math, leftArr));
    		var maxTop = Math.round(Math.max.apply(Math, topArr));

    		$("#droppable-zone").height(maxTop);
    		$("#droppable_height").val(maxTop);
    		$("#info-height").html(maxTop);

    		$("#droppable-zone").width(maxLeft);
    		$("#droppable_width").val(maxLeft);
    		$("#info-width").html(maxLeft);
		} else {
			$("#droppable-zone").css("height", "100%");
    		$("#droppable_height").val(containerH);
    		$("#info-height").html(containerH);

    		$("#droppable-zone").css("width", "100%");
    		$("#droppable_width").val(containerW);
    		$("#info-width").html(containerW);
		}
	}
}

/**
* Generiranje html-ja za widgete in labele
**/
function createWidgetHtml(uuid, type, iframe) {
	$("#dash-saved").val("");
	$(".dash-title").css("font-style", "italic");

	if (type == "widget") {
		var html = "<div class='w-head'>" +
						"<span class='widget-size'></span>" +
						"<span class='delete-widget ui-icon ui-icon-trash' onclick=removeWidget('draggable-widget-" + uuid + "')></span>" +
						"<span class='widget-settings ui-icon ui-icon-gear' onclick=openWidgetSettings('draggable-widget-" + uuid + "')></span>" +
						"<span class='resize-widget ui-icon ui-icon-arrowthick-2-se-nw' onclick=resizeWidget('draggable-widget-" + uuid + "')></span>" +
					"</div>" +
			   	    "<div class='iframe-container'>" + iframe + "</div>";
	} else {
		var html = "<div class='w-head'>" +
						"<span class='widget-size'></span>" +
				   		"<span class='delete-widget ui-icon ui-icon-trash' onclick=removeWidget('draggable-label-" + uuid + "')></span>" +
				   		"<span class='widget-settings ui-icon ui-icon-gear' onclick=openLabelProperties('draggable-label-" + uuid + "')></span>" +
				   		"<span class='widget-settings ui-icon ui-icon-clipboard' onclick=openLabelSettings('draggable-label-" + uuid + "')></span>" +
			   	   "</div>" +
				   "<div class='label-content'>Label</div>";
	}

	return html;
}

/**
* Funkcija za brisanje widgetov in label
**/
function removeWidget(widgetId) {
	$("#dash-saved").val("");
	$(".dash-title").css("font-style", "italic");

	$("#" + widgetId).fadeOut('fast', function() {
		$(this).closest(".ui-widget-content").remove();
	});
}

/**
* Inicializacija okna za urejanje html vsebine labele
**/
function openLabelSettings(labelId) {
	var dialog;

	dialog = $("#labelSettingsDialog").dialog({
		width: 600,
		height: 300,
		modal: true,
		buttons: {
			"OK": function() {
				var html = $(this).find(".labelHtml").val();
				$("#" + labelId).find(".label-content").html(html);
				$("#" + labelId).css({"height": "auto", "width": "auto"});
				$(this).find(".labelHtml").val("");

				dialog.dialog("destroy");

				if ($("#" + labelId).width() < 120) {
					$("#" + labelId).find(".widget-size").css("visibility", "hidden");
				} else {
					$("#" + labelId).find(".widget-size").css("visibility", "visible");
				}

				$("#dash-saved").val("");
				$(".dash-title").css("font-style", "italic");
			},
			"<?php echo $language["dash_btn_cancel"]; ?>": function() {
				dialog.dialog("destroy");
			}
		},
		create: function(e, ui) {
			$("#label-id").val(labelId);
			var html = $("#" + labelId).find(".label-content").html();
			$(this).find(".labelHtml").val(html);
		}
	});
}

/**
* Inicializacija okna za urejanje nastavitev labele
**/
function openLabelProperties(widgetId) {
	var dialog;

	dialog = $("#labelPropertiesDialog").dialog({
		width: 400,
		height: 200,
		modal: true,
		buttons: {
			"OK": function() {
				var widgetHeight = $(this).find("#height").val();
				var widgetWidth = $(this).find("#width").val();
				$("#" + widgetId).height(widgetHeight);
				$("#" + widgetId).width(widgetWidth);
				$("#" + widgetId).find(".widget-size").html($("#" + widgetId).width() + "x" + $("#" + widgetId).height());
				$("#dash-saved").val("");
				$(".dash-title").css("font-style", "italic");

				dialog.dialog("destroy");
			},
			"<?php echo $language["dash_btn_cancel"]; ?>": function() {
				dialog.dialog("destroy");
			}
		},
		create: function(e, ui) {
			var widgetHeight = $("#" + widgetId).height();
			var widgetWidth = $("#" + widgetId).width();
			$(this).find("#height").val(widgetHeight);
			$(this).find("#width").val(widgetWidth);
		}
	});
}

/**
* Inicializacija okna za nastavitve widgeta
**/
function openWidgetSettings(widgetId) {
	var dialog;

	dialog = $("#widgetSettingsDialog").dialog({
		width: 400,
		height: 280,
		modal: true,
		buttons: {
			"OK": function() {
				var widgetHeight = $(this).find("#height").val();
				var widgetWidth = $(this).find("#width").val();
				$("#" + widgetId).height(widgetHeight);
				$("#" + widgetId).width(widgetWidth);

				var iframeHeight = $(this).find("#iframe_height").val();
				var iframeWidth = $(this).find("#iframe_width").val();
				$("#" + widgetId).find("iframe").height(iframeHeight);
				$("#" + widgetId).find("iframe").width(iframeWidth);

				if ($(this).find("#widget-overflow").is(":checked")) {
					$("#" + widgetId).css("overflow", "auto");
				} else if($("#" + widgetId).css("overflow") != "hidden") {
					$("#" + widgetId).css("overflow", "hidden");
				}

				$("#" + widgetId).find(".widget-size").html($("#" + widgetId).width() + "x" + $("#" + widgetId).height());
				$("#dash-saved").val("");
				$(".dash-title").css("font-style", "italic");

				dialog.dialog("destroy");
			},
			"<?php echo $language["dash_btn_cancel"]; ?>": function() {
				dialog.dialog("destroy");
			}
		},
		create: function(e, ui) {
			var widgetHeight = $("#" + widgetId).height();
			var widgetWidth = $("#" + widgetId).width();
			$(this).find("#height").val(widgetHeight);
			$(this).find("#width").val(widgetWidth);

			var iframeHeight = $("#" + widgetId).find("iframe").height();
			var iframeWidth = $("#" + widgetId).find("iframe").width();
			$(this).find("#iframe_height").val(iframeHeight);
			$(this).find("#iframe_width").val(iframeWidth);

			if ($("#" + widgetId).css("overflow") != "hidden") {
				$(this).find("#widget-overflow").prop("checked", true);
			}
		}
	});
}

/**
* Povečevanje oz. zmanjševanje widgeta od kliku na ikono "<->"
**/
function resizeWidget(widgetId) {
	$("#dash-saved").val("");
	$(".dash-title").css("font-style", "italic");

	if (!$("#" + widgetId).hasClass("resized")) {
		var iframe = $("#" + widgetId).find("iframe");
		var h = $(iframe).contents().find(".predc").height();
		var w = $(iframe).contents().find(".predc").width();

		$("#" + widgetId).animate({
			"width": (w + 20)+"px",
			"height": (h + 20)+"px"
		});

		$("#" + widgetId).addClass("resized");
		$("#" + widgetId).find(".widget-size").html((w + 20) + "x" + (h + 20));

		//povečanje polja, če je potrebno
		resizeStop(null, widgetId, (w + 20), (h + 20));
	} else {
		$("#" + widgetId).animate({
			"width": "400px",
			"height": "200px"
		});
		$("#" + widgetId).removeClass("resized");
		$("#" + widgetId).find(".widget-size").html("400x200");

		//določitev containmenta
		$("#" + widgetId).draggable("option", "containment", calcContainment("#" + widgetId, 400, 200));
	}
}

/**
* Prikaz obrobe widgeta ob premiku
**/
function dragStart(e, ui) {
	toggleSideBar(true);

	var offTop = $(ui.helper).context.offsetTop;
    var offLeft = $(ui.helper).context.offsetLeft;

    //risanje obrobe
    $("<div></div>")
	.addClass("shadow")
    .css({"height": $(ui.helper).height() + "px",
          "width": $(ui.helper).width() + "px",
          "top": offTop + "px",
          "left": offLeft + "px"})
    .appendTo("#droppable-zone");
}

/**
* Skrivanje obrobe widgeta ob končanju premika
**/
function dragStop(e, ui) {
	$("#dash-saved").val("");
	$(".dash-title").css("font-style", "italic");

	//brisanje obrobe
	$(".shadow").hide();
    $(".shadow").remove();

    //povečevanje dropapble območja
	resizeDroppableZone($(ui.helper));
}

/**
* Povečanje droppable območja, v primeri da pri povečaju widgeta ta sega izven meja
**/
function resizeStop(e, ui, width, height) {
	$("#dash-saved").val("");
	$(".dash-title").css("font-style", "italic");

	var wId = ui;
	if (typeof ui === "object") {
		wId = $(ui.helper).attr("id");
	}
	if (typeof width === "undefined") {
		width = ui.size.width;
	}
	if (typeof height === "undefined") {
		height = ui.size.height;
	}

	var right = $("#" + wId).position().left + width;
	var bottom = $("#" + wId).position().top + height;

	if (right > $("#droppable-zone").width()) {
		var widthTmp = Math.round(right);
		$("#droppable-zone").width(widthTmp);
		$("#info-width").html(widthTmp);
		$("#droppable_width").val(widthTmp);
	}
	if (bottom > $("#droppable-zone").height()) {
		var heightTmp = Math.round(bottom);
		$("#droppable-zone").height(heightTmp);
		$("#info-height").html(heightTmp);
		$("#droppable_height").val(heightTmp);
	}

	//labela se ne sme zmanjšati po urejanju, zato se nastavi min-width in min-height
	if (wId.indexOf("label") > -1) {
		$("#" + wId).css({ "min-width": width + "px", "min-height": height + "px" });
	}

	//določitev containmenta
	$("#" + wId).draggable("option", "containment", calcContainment("#" + wId, width, height));
}

/**
* Funkcija poveča droppable območje če je potrebno in zascrolla na lokacijo widgeta
**/
function resizeDroppableZone(el) {
	$("#dash-saved").val("");
	$(".dash-title").css("font-style", "italic");

	var offset = 0;
	if (el.attr("id").indexOf("draggable-label-") != -1) {
		offset = 5;
	}

	var height = $("#droppable-zone").height();
    var width = $("#droppable-zone").width();

    if (!containmentBottom) {
	    //širjenje navzdol
	    if (height < $("#droppable-zone")[0].scrollHeight) {
	    	var newHeight = $("#droppable-zone")[0].scrollHeight - offset;
	    	$("#droppable-zone").height(newHeight);
	    	$("#droppable-zone").parent().scrollTo(el);
	    	$("#droppable_height").val(newHeight);
	    	$("#info-height").html(newHeight);
	    }
    }
    if (!containmentRight) {
	    //širjenje desno
	    if (width < $("#droppable-zone")[0].scrollWidth) {
	    	var newWidth = $("#droppable-zone")[0].scrollWidth - offset;
	    	$("#droppable-zone").width(newWidth);
	    	$("#droppable-zone").parent().scrollTo(el);
	    	$("#droppable_width").val(newWidth);
	    	$("#info-width").html(newWidth);
	    }
    }
}

/**
* Funkcija vrne polje omejitev pomikanja widgeta [levo, zgoraj, desno, spodaj].
* Če polje pomikanja omejimo, ta funkciaj prepreči pomikanje widgetov in label zunaj dovoljenega območja.
**/
function calcContainment(widgetId, width, height) {
    var left = $("#droppable-zone")[0].offsetLeft + 15;
    var top = $("#droppable-zone")[0].offsetTop + topOffset;
    var widgetWidth = $(widgetId).width();
    var widgetHeight = $(widgetId).height();
    if (typeof width != "undefined") {
    	widgetWidth = width;
    }
    if (typeof height != "undefined") {
    	widgetHeight = height;
    }

    var bottom = 10000;
    if (containmentBottom) {
    	if ($("#droppable-zone")[0].scrollHeight > containerH) {
    		//če je widget večji od zaslona
    		if (widgetHeight > $(window).height()) {
    			bottom = topOffset + $(widgetId).position().top + 2;
    		} else {
    			bottom = $(window).height() - widgetHeight - 5;
    		}
    	} else {
    		bottom = $("#droppable-zone").height() - widgetHeight + topOffset;
    	}
    }

    var right = 10000;
    if (containmentRight) {
    	if ($("#droppable-zone")[0].scrollWidth > containerW) {
    		//če je widget širši od zaslona
    		if (widgetWidth > $(window).width()) {
    			right = leftOffset + $(widgetId).position().left + 2;
    		} else {
    			right = $(window).width() - widgetWidth - 2;
    		}
    	} else {
    		right = $("#droppable-zone").width() - widgetWidth + 15;
    	}
    }

    //offest zaradi prikazanih overflow sliderjev
    if (containerW < $("#droppable-zone")[0].scrollWidth && containerH < $("#droppable-zone")[0].scrollHeight) {
    	right -= 17;
	}
	//offest zaradi prikazanih overflow sliderjev
    if (containerH < $("#droppable-zone")[0].scrollHeight && containerW < $("#droppable-zone")[0].scrollWidth) {
    	bottom -= 17;
	}

    return [left, top, right, bottom];
}

/**
* Prikaz in skrivanje stranskega menija
**/
function toggleSideBar(hide) {
	//hide
	if ($(".side-bar").hasClass("expanded") || hide === true) {
		$(".side-bar").removeClass("expanded");
		$(".side-bar").addClass("closed");

		$(".side-bar").animate({"width": "15px"}, "fast", function() {
			$(".side-bar-content").hide();
		});
		$(".hide-show-side-bar").children("span").removeClass("ui-icon-triangle-1-w");
		$(".hide-show-side-bar").children("span").addClass("ui-icon-triangle-1-e");
		$(".side-bar").resizable("option", "disabled", true);
	}
	//show
	else {
		$(".side-bar").removeClass("closed");
		$(".side-bar").addClass("expanded");

		$(".side-bar").animate({"width": "500px"}, "fast");
		$(".side-bar-content").show();
		$(".hide-show-side-bar").children("span").removeClass("ui-icon-triangle-1-e");
		$(".hide-show-side-bar").children("span").addClass("ui-icon-triangle-1-w");
		$(".side-bar").resizable("option", "disabled", false);
	}
}

/**
* Generiranje GUID-a za id widgetov in label
**/
function guid() {
	function s4() {
    	return Math.floor((1 + Math.random()) * 0x10000)
      		.toString(16)
      		.substring(1);
	}
	return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
		s4() + '-' + s4() + s4() + s4();
}

/**
* Preverjanje imena dashboarda
**/
function checkDashboardName(name) {
	if ($("#auto_draggable_fit").is(":checked")) {
		$("#auto_draggable_fit").prop("checked", false);
		$("#droppable_height").removeAttr("disabled");
		$("#droppable_width").removeAttr("disabled");
	}

	if (name.length == 0) {
		showMessage("error","<?php echo $language["dash_name_err1"]; ?>","#inputErrorSaveDash");
		return false;
	}
	if (name.length > 200) {
		$("#saveDashboardDialog").dialog("option", "height", 200);
		showMessage("error","<?php echo $language["dash_name_err2"]; ?>","#inputErrorSaveDash");
		return false;
	}
	if (name.match("^[a-zA-Z0-9_]*$") === null) {
		$("#saveDashboardDialog").dialog("option", "height", 200);
		showMessage("error","<?php echo $language["dash_name_err3"]; ?>","#inputErrorSaveDash");
		return false;
	}

	var nameRes = CallScript("_ajax/ajax.dashboard.php", {action:"checkDashboardName", name: name, formParameters: null}, '');
	if (nameRes == "duplicated") {
		showMessage("error","<?php echo $language["dash_name_err4"]; ?>","#inputErrorSaveDash");
		return false;
	}

	return true;
}

/**
* Nalaganje dashbaorda z datoteke
**/
function loadDashboard(dashId) {
	var res = CallScript("_ajax/ajax.dashboard.php", {action:"getDashboardHtml", id: dashId, formParameters: null}, '');

	if (res === "file not found") {
	    return;
	}

	$(".droppable-container").html(res.html);
	$("#dash-id").val(res.widget.id);
	$("#dash-name").val(res.widget.name);
	$(".dash-title").html(res.widget.name);
	$("#dash-saved").val("yes");
	$(".dash-title").css("font-style", "normal");

	$("#dashm_3").parent().removeClass("disabled");
	$("#dashm_4").parent().removeClass("disabled");
	$("#dashm_6").parent().removeClass("disabled");
	$("#dashm_7").parent().removeClass("disabled");

	//nalaganje nastavitev
	var settings = JSON.parse(res.widget.dash_settings);
	for (var i = 0; i < settings.length; i++) {
		var settObj = settings[i];

		if (settObj.name == "droppable_width") {
			$("#" + settObj.name).val(settObj.value);
			$("#info-width").html(settObj.value);
		}
		else if (settObj.name == "droppable_height") {
			$("#" + settObj.name).val(settObj.value);
			$("#info-height").html(settObj.value);
		}
		else if (settObj.name == "droppanle_color_picker") {
			$("#" + settObj.name).colorpicker("val", settObj.value);
		}
		else if (settObj.name == "containment_bottom") {
			$("#" + settObj.name).val(settObj.value);
			containmentBottom = (settObj.value == "true" ? true : false);
		}
		else if (settObj.name == "containment_right") {
			$("#" + settObj.name).val(settObj.value);
			containmentRight = (settObj.value == "true" ? true : false);
		}
	}

	//inicializacija droppable območja
	initDroppableZone();

	//renderiranje wigetov
	$("[id^='draggable-widget-'],[id^='draggable-label-']").each(function() {
		var widgetId = "#" + $(this).attr("id");
		initDraggable(widgetId);
	});
}

/**
* Avtomatsko shranjevanje dashboarda
**/
function autoSaveDashboard() {
	if ($("#dash-id").val() != "" && $("#dash-saved").val() == "") {
		var form = $("#droppable-settings-form");
		var settingsFormData = JSON.stringify(form.serializeArray());
		var name = $("#dash-name").val();
		var dashId = $("#dash-id").val();
		var dashHTML = $(".droppable-container").html();

		CallScript('_ajax/ajax.dashboard.php', {action:'saveDashboard', new: false, name: name, id: dashId, settings: settingsFormData, html: dashHTML, formParameters: null}, '');
	}
}

/**
* Menu gumbi
**/
function newDashboard() {
	if ($("#dash-saved").val() == "") {
		var dialog;

		dialog = $("#propmptSaveDashboardDialog").dialog({
			width: 400,
			height: 180,
			modal: true,
			buttons: {
				"<?php echo $language["dash_btn_yes"]; ?>": function() {
					saveDashboard(true);
					CallScript("_ajax/ajax.dashboard.php", {action:"newDashboardSett", formParameters: null}, '');
					dialog.dialog("destroy");
				},
				"<?php echo $language["dash_btn_no"]; ?>": function() {
					$("#dash-id").val("");
					$("#dash-name").val("");
					$("#dash-saved").val("");
					CallScript("_ajax/ajax.dashboard.php", {action:"newDashboardSett", formParameters: null}, '');
					dialog.dialog("destroy");
					loadContent('sredina', '_forms/forms.tables.dashboard.php');
				},
				"<?php echo $language["dash_btn_cancel"]; ?>": function() {
					dialog.dialog("destroy");
				}
			}
		});
	} else {
		CallScript("_ajax/ajax.dashboard.php", {action:"newDashboardSett", formParameters: null}, '');
		loadContent('sredina', '_forms/forms.tables.dashboard.php');
	}
}

function saveDashboard(newDashboard) {
	var form = $("#droppable-settings-form");
	var settingsFormData = JSON.stringify(form.serializeArray());
	var dashHTML = $(".droppable-container").html();
	var dashId = $("#dash-id").val();

	if (dashId == "") {
		//insert
		$("#saveDashboardDialog").dialog({
			width: 420,
			height: 180,
			modal: true,
			title: "<?php echo $language["dash_save_title"]; ?>",
			open: function() {
				$(this).find("#dash-name").val("");
			},
			buttons: [
				{
					text: "OK",
					click: function() {
						var dashName = $(this).find("#dash-name").val();

						if (checkDashboardName(dashName) === true) {
							var resp = CallScript("_ajax/ajax.dashboard.php", {action:"saveDashboard", new: true, name: dashName, settings: settingsFormData, html: dashHTML, formParameters: null}, '');
							$("#dash-id").val(resp.id);
							$("#dash-name").val(resp.name);
							$("#dash-saved").val("yes");
							$(".dash-title").css("font-style", "normal");

							$("#dashm_3").parent().removeClass("disabled");
							$("#dashm_4").parent().removeClass("disabled");
							$("#dashm_6").parent().removeClass("disabled");
							$("#dashm_7").parent().removeClass("disabled");
							$(".dash-title").html(resp.name);
							$("#dash-select").empty().append(resp.dashboards);

							showMessage("ok","<?php echo $language['dash_msg_saved']; ?>","#successSaveDash");

							if (newDashboard === true) { loadContent('sredina', '_forms/forms.tables.dashboard.php'); }

							$(this).dialog("destroy");
						}
					}
				},{
					text: "<?php echo $language["dash_btn_cancel"]; ?>",
					click: function() {
						$(this).dialog("destroy");
					}
				}
			]
		});
	} else {
		//update
		var name = $("#dash-name").val();
		var resp = CallScript('_ajax/ajax.dashboard.php', {action:'saveDashboard', new: false, name: name, id: dashId, settings: settingsFormData, html: dashHTML, formParameters: null}, '');
		showMessage("ok","<?php echo $language['dash_msg_saved']; ?>","#successSaveDash");
		$("#dash-saved").val("yes");
		$(".dash-title").css("font-style", "normal");

		if (newDashboard === true) { loadContent('sredina', '_forms/forms.tables.dashboard.php'); }
	}
}

function saveAsNewDialog() {
	if ($("#dashm_3").closest("li").hasClass("disabled")) {
		return;
	}

	var form = $("#droppable-settings-form");
	var settingsFormData = JSON.stringify(form.serializeArray());
	var dashHTML = $(".droppable-container").html();
	var dashName = $("#dash-name").val();
	var id = $("#dash-id").val();

	$("#saveDashboardDialog").dialog({
		width: 420,
		height: 180,
		modal: true,
		title: "<?php echo $language['dash_saveas_title']; ?>...",
		open: function() {
			$(this).find("#name-label").html("New name:");
			$(this).find("#dash-name").css({"width": "70%"});
		},
		buttons: [
			{
				text: "OK",
				click: function() {
					var dashName = $(this).find("#dash-name").val();

					if (checkDashboardName(dashName) === true) {
						var resp = CallScript("_ajax/ajax.dashboard.php", {action:"saveDashboardAs", id: id, name: dashName, settings: settingsFormData, html: dashHTML, formParameters: null}, '');
						$("#dash-select").empty().append(resp);

						showMessage("ok","<?php echo $language['dash_msg_saved']; ?>","#successSaveDash");

						$(this).dialog("destroy");
					}
				}
			},{
				text: "<?php echo $language["dash_btn_cancel"]; ?>",
				click: function() {
					$(this).dialog("destroy");
				}
			}
		]
	});
}

function renameDialog() {
	if ($("#dashm_4").closest("li").hasClass("disabled")) {
		return;
	}

	var form = $("#droppable-settings-form");
	var settingsFormData = JSON.stringify(form.serializeArray());
	var dashHTML = $(".droppable-container").html();
	var dashName = $("#dash-name").val();
	var id = $("#dash-id").val();

	$("#saveDashboardDialog").dialog({
		width: 420,
		height: 180,
		modal: true,
		title: "<?php echo $language['dash_rename_title']; ?>",
		open: function() {
			$(this).find("#name-label").html("New name:");
			$(this).find("#dash-name").val(dashName).css({"width": "70%"});
		},
		buttons: [
			{
				text: "OK",
				click: function() {
					var dashName = $(this).find("#dash-name").val();

					if (checkDashboardName(dashName) === true) {
						var resp = CallScript("_ajax/ajax.dashboard.php", {action:"renameDashboard", id: id, name: dashName, settings: settingsFormData, html: dashHTML, formParameters: null}, '');
						$(".dash-title").html(resp.name);
						$("#dash-saved").html("yes");
						$("#dash-select").empty().append(resp.dashboards);

						showMessage("ok","<?php echo $language['dash_msg_saved']; ?>","#successSaveDash");

						$(this).dialog("destroy");
					}
				}
			},{
				text: "<?php echo $language["dash_btn_cancel"]; ?>",
				click: function() {
					$(this).dialog("destroy");
				}
			}
		]
	});
}

var prevWindow;

function previewDashboard() {
	if (typeof prevWindow != "undefined") {
		prevWindow.close();
	}
	prevWindow = window.open("<?php echo WARPIT_WWW; ?>statview/_forms/forms.tables.dashboardPreview.php", "<?php echo $language["dash_prev_title"]; ?>");
	var content = $(".droppable-container").html();

	$(prevWindow).load(function() {
		prevWindow.$("#dashboard").html(content);
		prevWindow.$(".w-head").remove();
		prevWindow.$(".ui-resizable-handle").remove();
	});
}

function exportDashboard() {
	if ($("#dashm_6").closest("li").hasClass("disabled")) {
		return;
	}

	var id = $("#dash-id").val();
	window.location = "<?php echo WARPIT_WWW; ?>statview/_export/exportDashboard.php?dashId=" + id;
}

function deleteDialog() {
	if ($("#dashm_7").closest("li").hasClass("disabled")) {
		return;
	}

	var id = $("#dash-id").val();
	var dashName = $("#dash-name").val();
	var dialog;

	dialog = $("#propmptDeleteDashboardDialog").dialog({
		width: 500,
		height: 150,
		modal: true,
		open: function() {
			if (dashName.length > 20) {
				dashName = dashName.substring(0, 20) + "...";
			}
			$(this).html("<?php echo $language["dash_d6_question"]; ?> <b>" + dashName + "</b>?");
		},
		buttons: {
			"<?php echo $language["dash_btn_yes"]; ?>": function() {
				CallScript("_ajax/ajax.dashboard.php", {action:"deleteDashboard", id: id, formParameters: null}, '');
				loadContent('sredina', '_forms/forms.tables.dashboard.php');

				dialog.dialog("destroy");
			},
			"<?php echo $language["dash_btn_cancel"]; ?>": function() {
				dialog.dialog("destroy");
			}
		}
	});
}