<?php
if (!isset($_SESSION['UserInfo']['language'])) {
	$_SESSION['UserInfo']['language'] = "46"; //default jezik za login je ang.
}
$language = configLoader::loadLanguage(1,'language','default_admin','login',DB_WARPIT_STATVIEW);
?>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="sl-si" lang="sl-si" class="ozadje" >
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title>Statview | Forgoten Password</title>
		<link href="<?php echo PATH_TO_ROOT;?>statview/_css/main.css" rel="stylesheet" type="text/css" />
		<link href="<?php echo PATH_TO_ROOT;?>statview/_css/login_style.css" rel="stylesheet" type="text/css" />
		<script type="text/javascript" src="<?php echo PATH_TO_ROOT;?>statview/_javascript/jquery.js"></script>
	</head>
	
	<body>
		<div id="stranp">
	    	<div id="logo_rest_t">
	      		<div class="logo" style="margin-left:16%;"></div>
	      		<div class="logo_sr">StatView ∙ <?php echo $language['forgotten_password']; ?></div>
	      		<div class="lng_sel">
	      			<label id="91" class="lng">SL</label> | <label id="46" class="lng">EN</label> 
	      		</div>
	    	</div>
	    	
	    	<div id="logo_rest_b">
	      		<div class="sd_l">
	      			<div id="text"><?php echo $language['forgotenPass_text']; ?></div>
	      		</div>
	      		<div class="sd_r">
	      			<label id="loginFail"></label>
	      			<form id="loginForm">
	      				<input name="email" id="email" type="email" placeholder="E-mail" required="true" maxlength="50" />
	      			</form>
	      			<div id="cntrl">
		      			<button type="submit" form="loginForm" class="shrani"><?php echo $language['forgotenPass_btn']; ?></button>
	      			</div>
	      		</div>
	    	</div>
	  	</div>
	  	
	<script>
		$("#loginForm").submit(function(e) {
			e.preventDefault();
			
			$.ajax({
	     		url: "<?php echo PATH_TO_ROOT;?>_ajax/ajax.password.reset.php",
	     		data: "action=add&" + $("#loginForm").serialize(),
	     		success: function(resp) {
	     			var data = JSON.parse(resp);
	     			$("#loginFail").show();
	     			
	     			if (data.success === true) {
	     				$("#loginFail").text("<?php echo $language['pass_reset_ok']; ?>");
	     			} else {
	     				switch (data.reason) {
		     				case 'mail_not_sent':
		     					$("#loginFail").text("<?php echo $language['pass_reset_err1']; ?>");
		     					break;
	     					case 'too_many_tries':
	     						$("#loginFail").text("<?php echo $language['pass_reset_err2']; ?>");
		     					break;
	     					case 'user_not_exist':
	     						$("#loginFail").text("<?php echo $language['pass_reset_err3']; ?>");
		     					break;
	     					case 'email_not_given':
	     						$("#loginFail").text("<?php echo $language['email_not_provided']; ?>");
		     					break;
		     			}
	     			}
	  			}
	     	});
		});
		
		$(".lng").click(function() {
			var lng = $(this).attr("id");
			
			$.ajax({
	     		url: "<?php echo PATH_TO_ROOT;?>_ajax/ajax.Login.php",
	     		method: "POST",
	     		data: "action=lngChange&lng=" + lng,
	     		success: function() {
	     			location.reload();
	  			}
	     	});
		});
	</script>
	</body>
</html>