<?php
define("SINGLE_RESPONSE", 1);
define("SCALE_QUESTION", 2);
define("MULTI_RESPONSE", 3);
include_once ("_dirinfo.php");

include_once(PATH_TO_ROOT.'statview/firephp/fb.php');
include_once(PATH_TO_ROOT.'statview/firephp/FirePHP.class.php');

class Crossing{
    
    ########## VARS #############
    
    private $db;
    
    private $workingTable;
    
    private $table;
    
    private $idQ;
    
    private $idCross;
    
    private $paramsQ;
    
    private $paramsCross;
    
    private $weightVariable;
    
    
    ####### PRIVATE ############
    
    private function loadParams($id)
    {
        $sql = "SELECT `questionType`, `questionVars`, `questionSubType`, `id_tableTemplate`, `id_graphTemplate`, `missings`, `hideAnswers` 
                FROM ".$this->workingTable."___calculated WHERE questionName='".$id."'";
        //echo $sql."<br>";
        $result = $this->db->SQLexecute($sql);
        $row = $this->db->fetchAssoc($result);
        
        return $row;
        
    }
    
    protected function getWeightVariable($id) {
        if (isset($this->weightVariable)) return $this->weightVariable();
         
        $weightVar = "unweight";
        $sql = "SELECT weightVar FROM " . $this->table . " WHERE id=".$id;
      //  echo $sql."<br>";
        $result = $this->db->SQLexecute($sql);
        $row = $this->db->fetchAssoc($result);
        if ($row['weightVar']) $weightVar = $row['weightVar'];
        
        return $weightVar;
    }
    
    private function cartesianProduct($array1, $array2)
    {
        $data = array($array1, $array2);
     //  $data = array(array("Q2_1", "Q1_2" ), array("Q1_1", "Q1_2"));
        $result = array(array()); 
        foreach ($data as $arr)
        {
            $new_result = array();
            foreach ($result as $old_element)
                foreach ($arr as $el)
                    $new_result []= array_merge($old_element, array($el));
                    
            $result = $new_result;
        }
        return $result;
    }
    
    private function singleMultiCross($qVar, $crossVar, $ord = FALSE)
    {            
        $weightVarQ = $this->getWeightVariable($this->idQ);
           
        $sql = "SELECT a." .$qVar  . " as q1, a.q as q, cnt AS N FROM ";
        
        foreach($crossVar as $questionVar)
        {
            $tmpSql[] = "SELECT " . $qVar . ", " . $questionVar . " as q, COUNT(*) * " . $weightVarQ ." as cnt 
            FROM " . $this->workingTable . "___data" .
            " GROUP BY " . $qVar . ", " . $questionVar ;
        }
        
        $sql .= "(" .implode( " UNION ALL ", $tmpSql) . ") as a GROUP BY q1, q";
        
        $result = $this->db->SQLexecute($sql);
        $data = array();
        while ($row = $this->db->fetchAssoc($result)) {
            if(!is_null($row['q1']) && !is_null($row['q']) && !is_null($row['N']))
                $data[] = $row;
        }
        
        return $this->createTable($data, $ord); 
    }
    
    private function multiMultiCross($qVar, $crossVar, $ord = FALSE)
    {
        $fields = $this->cartesianProduct($qVar, $crossVar);
        
        $weightVarQ = $this->getWeightVariable($this->idQ);
        
        foreach($fields as $field)
        {
            $tmpSql[] = "SELECT " . $field[0] . " as q1, " . $field[1] . " as q, COUNT(*) * " . $weightVarQ ." as n FROM "  . $this->workingTable . "___data GROUP BY q1, q";
        }
        $sql = "SELECT a.q1, a.q, a.n FROM(";
        $sql .= implode(" UNION ALL ", $tmpSql);
        $sql .= ") as a GROUP BY q1, q";
        
        $result = $this->db->SQLexecute($sql);
        $data = array();
        while ($row = $this->db->fetchAssoc($result)) {
            if(!is_null($row['q1']) && !is_null($row['q']) && !is_null($row['n']))
                $data[] = $row;
        }

       // print $sql;
       
        return $this->createTable($data,$ord);
    }
        
    private function cross_1_3()
    {
        return $this->singleMultiCross($this->paramsQ['questionVars'], explode(',', $this->paramsCross['questionVars']), TRUE);
    }

    private function cross_3_1()
    {
        return $this->singleMultiCross($this->paramsCross['questionVars'], explode(',',$this->paramsQ['questionVars']), FALSE);
    }
    
    
    private function cross_1_1()
    {
        return $this->singleMultiCross($this->paramsCross['questionVars'], array($this->paramsQ['questionVars']));
    }
    
    private function cross_3_3()
    {
        return $this->multiMultiCross(explode(',', $this->paramsCross['questionVars']), explode(',',$this->paramsQ['questionVars']));
    }
    

    private function createTable($data, $ord = FALSE)
    {
        
        if(count($data)> 0)
        {
            $valArray[$this->idCross] = array();
            $valArray[$this->idQ] = array();
            $totalArray[$this->idQ] = array();
            $totalArray[$this->idCross] = array();
            
            if($ord)
            {
                $first = $this->idQ;
                $second = $this->idCross;
                $q1 = "q1";
                $q = "q";
            }
            else {
                $first = $this->idCross;
                $second = $this->idQ;
                $q1 = "q1";
                $q = "q";
            }
            // izračunamo totale in nastavimo numeruse
            
            foreach($data as $key)
            {
                $dataArray[$key['q']][$key['q1']] = array($key['N'], 0, 0 );  
                if(!in_array($key['q1'], $valArray[$first]))
                    $valArray[$first][] = $key['q1'];
                if(!in_array($key['q'], $valArray[$second]))
                    $valArray[$second][] = $key['q'];
              
                
                if(isset($totalArray[$first][$key['q1']]))
                    $totalArray[$first][$key['q1']][0] += intval($key['N']);
                else 
                    $totalArray[$first][$key['q1']] = array(intval($key['N']),100,100);     
                
                if(isset($totalArray[$second][$key['q']]))
                    $totalArray[$second][$key['q']][0] += intval($key['N']);
                else
                    $totalArray[$second][$key['q']] = array(intval($key['N']),100,100); 
                
            }
            
          
            foreach($data as $key)
            {
            	if($totalArray[$first][$key['q1']][0] != 0 || $totalArray[$second][$key['q']][0] * 100 != 0)
                // TEST Mitja
            	//if($totalArray[$first][$key['q1']][0] != 0 && $totalArray[$second][$key['q']][0] * 100 != 0)
                {
                    //row proc
                    $dataArray[$key['q']][$key['q1']][2] =  $dataArray[$key['q']][$key['q1']][0]/$totalArray[$first][$key['q1']][0] * 100;
                    //column proc
                    $dataArray[$key['q']][$key['q1']][1] =  $dataArray[$key['q']][$key['q1']][0]/$totalArray[$second][$key['q']][0] * 100;
                
                }
                else
                {
                     $dataArray[$key['q']][$key['q1']][1] = 0;  
                     $dataArray[$key['q']][$key['q1']][2] = 0;  
                }      
            }
            
            
            $returnData['vals'] = $valArray;
            $returnData['data'] = $dataArray;
            $returnData['total'] = $totalArray;
            
            //return $returnData;
            return $returnData;
        }
        return null;
        
    }

    private function calculateTotals(&$data, $first, $second)
    {
           $total = 0;
           foreach($data as $key => $val)
           {
               $total = 0;
               foreach($val as $key1 => $val2)
               {
                   // FB::info($key1, "key1");
                   // FB::info($val2, "val2");
//                    
                   $total += $val[0];
               }
               $totalArray[$first]['q1'] = array($total, 0, 0);
           }
           
           return $totalArray;
    }

	/*
    private function calculateProc($data)
    {
        $i = 0;
        $j = 0;
        foreach($data['vals'][$this->idCross] as $key){
            
           foreach($data['vals'][$this->idQ] as $key2)
           {
              if(isset($data['data'][$key][$key2]))
              {
                $data['data'][$key][$key2][1] = intval($data['data'][$key][$key2][0]) / intval($data['total'][$this->idCross][$key][0]); 
                $data['data'][$key][$key2][2] = intval($data['data'][$key][$key2][0]) / intval($data['total'][$this->idQ][$key2][0]); 
              // print_r($data['data'][$key][$key2]);
              }
           }
        }
       // print_r($data);
        return $data;
    }
	*/
	private function calculateProc($data)
    {
        $i = 0;
        $j = 0;
        
        foreach($data['vals'][$this->idCross] as $key){
            
           foreach($data['vals'][$this->idQ] as $key2)
           {
              if(isset($data['data'][$key][$key2]))
              {
              	if(intval($data['total'][$this->idCross][$key][0]) != 0 || intval($data['total'][$this->idQ][$key2][0]) != 0){
              	// TEST Mitja
              	//if(intval($data['total'][$this->idCross][$key][0]) != 0 && intval($data['total'][$this->idQ][$key2][0]) != 0){
	                $data['data'][$key2][$key1][1] = intval($data['data'][$key][$key2][0]) / intval($data['total'][$this->idCross][$key2][0]); 
	               // $data['data'][$key][$key2][2] = intval($data['data'][$key][$key2][0]) / intval($data['total'][$this->idQ][$key2][0]);
				} else {
					$data['data'][$key][$key2][1] = 0; 
	                $data['data'][$key][$key2][2] = 0;
				} 
              // print_r($data['data'][$key][$key2]);
              
              }
           }
        }
       // print_r($data);
        return $data;
    }
    ########## PUBLIC ############
    
    public function __construct($db, $workingTable, $table)
    {
        $this->db = $db;
        
        $this->workingTable = $workingTable;
        
        $this->table = $table;
    }
    
    public function getData()
    {
        if(!isset($this->db, $this->workingTable, $this->idCross, $this->idQ))
        {
            return null;
        }
        else
        {
            $this->paramsCross = $this->loadParams($this->idCross);
            $this->paramsQ = $this->loadParams($this->idQ);
            
            
            //return $this->defineType();
            $func = "cross_" . $this->paramsQ['questionType'] . "_" . $this->paramsCross['questionType'];
            FB::info($func, "func:");
            return $this->$func();
        }
    }
    
    public function setId($idQ, $idCross)
    {
        $this->idCross = $idCross;
        $this->idQ = $idQ;
    }
}

?>