<?php
//ini_set('display_errors', '1');
//error_reporting(E_ALL);
/*
define("SINGLE_RESPONSE", 1);
define("SCALE_QUESTION", 2);
define("MULTI_RESPONSE", 3);
 */

include_once "_dirinfo.php";
include_once PATH_TO_ROOT . "_config/dbConfig.php";
include_once PATH_TO_ROOT . 'statview/_class/class_calculate.php';
include_once PATH_TO_ROOT . 'statview/_class/class_labels.php';
include_once PATH_TO_ROOT . 'statview/_class/class.selector.php';
include_once PATH_TO_ROOT . 'statview/_class/class.crossing.php';
include_once PATH_TO_ROOT . 'statview/_class/class.graphOptions.php';

date_default_timezone_set('Europe/Ljubljana');

include_once PATH_TO_ROOT . 'statview/firephp/fb.php';
include_once PATH_TO_ROOT . 'statview/firephp/FirePHP.class.php';

$db = new db;
$db->SetDatabaseConnection(MYSQL_USER, MYSQL_PASS, WARPIT_HOST);
$db->ChangeDatabase(DB_WARPIT_STATVIEW);

/**
 * Pridobitev podatkov za scale grafe
 */
function getScaleData($db, $tablePref, $tableName, $idJoined, $idQ, $subType)
{
    //<filtri>
    $filters = null;
    if (!empty($_POST["aFilters"])) {
        $filters = $_POST["aFilters"];
    }
    //</filtri>

    $idP = $_POST['idProject'];
    $sel = new Selector($db);
    $projName = $sel->getProjectName($idP);
    $projName = str_replace(" ", "_", $projName);

    $calc = new Calculate($db, $tablePref, $tableName, $idJoined);
    $calc->setQuestion($idQ);
    $labs = new Labels($db, '_projects', $projName, $idP);
    $labs->setQuestion($idQ);

    //podtip 1
    if ($subType == 1) {
        $data = $calc->getDescriptives(null, $filters);
        $labels = $labs->getLabels();

        $returnArray['labs'] = $labels[$idQ]['answers'];

        foreach ($data[$idQ] as $key => $value) {
            $labKey = explode("_", $key);
            $labKey = $labKey[count($labKey) - 1];

            $returnArray['perc'][$labKey] = $value['sv'];
            $returnArray['freq'][$labKey] = $value['sv'];
        }
    }
    //podtip 2
    else {
        $freq = $calc->getFrequencies(null, $filters);
        $data = $calc->getDescriptives(null, $filters);
        $total = $calc->getTotal();
        $labels = $labs->getLabels();

        $returnArray['labs'] = $labels[$idQ]['legend'];
        $returnArray['legend'] = $labels[$idQ]['answers'];
        $returnArray['freqs'] = array();

        //frekvence
        foreach ($returnArray['labs'] as $key => $value) {
            foreach ($returnArray['legend'] as $subKey => $subValue) {
                if (isset($freq[$idQ][$idQ . "_" . $subKey][$key])) {
                    $returnArray['freqs'][$key][$subKey] = $freq[$idQ][$idQ . "_" . $subKey][$key];
                } else {
                    $returnArray['freqs'][$key][$subKey] = 0;
                }
            }
        }
        //col in row total
        foreach ($returnArray['freqs'] as $key => $value) {
            $returnArray['colTotal'][$key] = array_sum($value);

            foreach ($value as $subKey => $subVal) {
                $returnArray['rowTotal'][$subKey] += $subVal;
            }
        }
        //total
        $returnArray["total"] = array_sum($returnArray['rowTotal']);
    }

    return $returnArray;
}

/**
 * Prigobitev podatkov za grafe brez križanja
 */
function getData($freq, $labels, $total)
{
    $returnArray['labs'] = $labels['answers'];
    $returnArray['perc'] = array();
    $returnArray['freq'] = array();

    foreach ($labels['answers'] as $key => $value) {
        if (isset($freq[$key])) {
            $val = ($freq[$key] / $total) * 100;
            $returnArray['perc'][$key] = $val;
            $returnArray['freq'][$key] = $freq[$key];
        } else {
            $returnArray['perc'][$key] = 0;
            $returnArray['freq'][$key] = 0;
        }
    }

    return $returnArray;
}

/**
 * Pridobitev podatkov za grafe z križanjem za grafe križanja
 */
function getCrossScaleData($db, $tablePref, $tableName, $idJoined, $idQCross, $idQ, $filter = null, $slider_type = null)
{
    $calc = new Calculate($db, $tablePref, $tableName, $idJoined);
    $calc->setQuestion($idQ);

    //če je vklučen slider, se podatki filtrirajo
    if ($filter != null) {
        if ($slider_type == "range") {
            $data = $calc->getDescriptiveCrosstabs($idQCross, $filter[0], $filter[1]);
        } elseif ($slider_type == "months") {
            $data = $calc->getDescriptiveCrosstabs($idQCross, $filter);
        }

    } else {
        $data = $calc->getDescriptiveCrosstabs($idQCross);
    }

    $returnArray['labs'] = $data['labels'][$idQ]['answers'];
    $returnArray['legend'] = $data['labels'][$idQCross]['answers'];
    $returnArray['freqs'] = array();

    //frekvence
    foreach ($returnArray['labs'] as $questionNumber => $questionLabel) {
        foreach ($returnArray['legend'] as $legendQNumber => $legenQLabel) {

            if (isset($data['cross'][$idQ][$questionNumber][$idQCross][$legendQNumber]['sv'])) {
                $returnArray['freqs'][$questionNumber][$legendQNumber] = $data['cross'][$idQ][$questionNumber][$idQCross][$legendQNumber]['sv'];
            } else {
                $returnArray['freqs'][$questionNumber][$legendQNumber] = 0;
            }

        }
    }

    //print_r($returnArray);
    return $returnArray;
}

/**
 * Pridobitev podatkov za grafe z križanjem
 */
function getCrossData($db, $tablePref, $tableName, $idJoined, $idQ, $idQCross, $filter = null, $slider_type = null)
{
    //<filtri>
    $filters = null;
    if (!empty($_POST["aFilters"])) {
        $filters = $_POST["aFilters"];
    }
    //</filtri>

    $calc = new Calculate($db, $tablePref, $tableName, $idJoined);
    $calc->setQuestion($idQ);

    //če je vklučen slider, se podatki filtrirajo
    if ($filter != null) {
        if ($slider_type == "range") {
            $data = $calc->getCrosstabs($idQCross, $filter[0], $filter[1], null, $filters);
        } elseif ($slider_type == "months") {
            $data = $calc->getCrosstabs($idQCross, $filter, null, null, $filters);
        }

    } else {
        $data = $calc->getCrosstabs($idQCross, null, null, null, $filters);
    }

    $returnArray['labs'] = $data['labels'][$idQ]['answers'];
    $returnArray['legend'] = $data['labels'][$idQCross]['answers'];
    $returnArray['freqs'] = array();
    $returnArray['colTotal'] = array();
    $returnArray['rowTotal'] = array();

    //frekvence
    foreach ($returnArray['labs'] as $questionNumber => $questionLabel) {
        foreach ($returnArray['legend'] as $legendQNumber => $legenQLabel) {
            if (isset($data['cross'][$idQ][$questionNumber][$idQCross][$legendQNumber])) {
                $returnArray['freqs'][$questionNumber][$legendQNumber] = $data['cross'][$idQ][$questionNumber][$idQCross][$legendQNumber];
            } else {
                $returnArray['freqs'][$questionNumber][$legendQNumber] = 0;
            }

        }
    }
    if ($filter != null) {
        //totali z filtru
        foreach ($returnArray['labs'] as $key => $value) {
            $returnArray['colTotal'][$key] = array_sum($returnArray['freqs'][$key]);
        }
        foreach ($returnArray['legend'] as $key => $value) {
            $sum = 0;
            foreach ($returnArray['freqs'] as $subValue) {
                $sum += $subValue[$key];
            }
            $returnArray['rowTotal'][$key] = $sum;
        }
        $returnArray['total'] = array_sum($returnArray['colTotal']);

    } else {
        //totali brez filtra
        foreach ($data['freq'][$idQ]['data'] as $key => $val) {
            $returnArray['colTotal'][$key] = $val;
        }
        foreach ($data['freq'][$idQCross]['data'] as $key => $val) {
            $returnArray['rowTotal'][$key] = $val;
        }
        $returnArray['total'] = $data['freq'][$idQ]['total'];
    }

    return $returnArray;
}

/**
 * Pridobitev podatkov za scale grafe z časovno komponento
 * Izriše se graf z večimi serijami podatkov, ki so izbrane na sliderju
 * Vrne enako strukturo polja, kot funkcija 'getCrossScaleData'
 */
function getSliderScaleData($db, $tablePref, $tableName, $idJoined, $id, $idProject, $show_type, $slider_type, $selector)
{
    $data = array();

    $filterString = "";
    if ($filters != null && $filters != "") {
        $filterString = " AND " . $filter;
    }

    //izbrani podatki na sliderju
    if ($slider_type == "range") {
        if (isset($_POST['slider_sett'])) {
            $sliderSettings = rangeSliderOptions($idProject, $id, $selector, $_POST['slider_sett']);
        } else {
            $sliderSettings = rangeSliderOptions($idProject, $id, $selector);
        }

    } elseif ($slider_type == "months") {
        if (isset($_POST['slider_sett'])) {
            $sliderSettings = explode(",", $_POST['slider_sett']);
        } else {
            $sliderSettings = $selector->getSliderOptions($idProject, $id);
        }

    }
    //imena label sliderja (imena serij)
    $sliderLabels = $selector->getSliderLabels($idProject, $id);
    //podatki križanja z 'research_id'
    $calc = new Calculate($db, $tablePref, $tableName, $idJoined);
    $calc->setQuestion($id);
    $crossData = $calc->getDescriptiveCrosstabs("research_id");
    //default tip prikaza
    if ($show_type == null) {
        $show_type = "type_2";
    }

    switch ($show_type) {
        case 'type_1':
            //labele
            foreach ($sliderSettings as $key => $val) {
                foreach ($sliderLabels as $subKey => $subVal) {
                    if ($subVal['id'] == $val) {
                        $data['labs'][] = $subVal['labelText'];
                        break;
                    }
                }
            }
            //legenda
            $resName = str_replace(" ", "_", $selector->getProjectName($idProject));
            $researchCalculated = $selector->getResearchCalculated($resName);
            $legendArr = explode("/", $researchCalculated[$id]['answer']);
            $keyArray = array();
            foreach ($legendArr as $key => $val) {
                $val = explode(" ", $val, 2);
                $data['legend'][$val[0]] = $val[1];
                $keyArray[] = $val[0];
            }
            //frekvence
            $tmpData = array();
            foreach ($sliderSettings as $key => $value) {
                $tmpData[] = $calc->getDescriptives(null, "research_id = " . $value . $filterString);
            }
            $tmpFreqs = array();
            foreach ($tmpData as $key => $value) {
                foreach ($keyArray as $keyArrVal) {
                    $insertVal = 0;
                    if (isset($value[$id][$keyArrVal])) {
                        $insertVal = $value[$id][$keyArrVal];
                    }

                    $tmpFreqs[$key][$keyArrVal] = $insertVal['sv']['sv'];
                }
                $data['freqs'][] = $tmpFreqs[$key];
            }

            break;

        case 'type_2':
            //labele
            $resName = str_replace(" ", "_", $selector->getProjectName($idProject));
            $researchCalculated = $selector->getResearchCalculated($resName);
            $legendArr = explode("/", $researchCalculated[$id]['answer']);
            $keyArray = array();
            foreach ($legendArr as $key => $val) {
                $val = explode(" ", $val, 2);
                $data['labs'][$val[0]] = $val[1];
                $keyArray[] = $val[0];
            }
            //legenda
            foreach ($sliderSettings as $key => $val) {
                foreach ($sliderLabels as $subKey => $subVal) {
                    if ($subVal['id'] == $val) {
                        $data['legend'][] = $subVal['labelText'];
                        break;
                    }
                }
            }
            //frekvence
            $i = 0;
            foreach ($data['labs'] as $key => $value) {
                foreach ($sliderSettings as $subKey => $subValue) {
                    $tmpData = $calc->getDescriptives(null, "research_id = " . $subValue . $filterString);
                    $tmpFreq = array();
                    foreach ($keyArray as $keyArrVal) {
                        $insertVal = 0;
                        if (isset($tmpData[$id][$keyArrVal])) {
                            $insertVal = $tmpData[$id][$keyArrVal];
                        }

                        $tmpFreq[] = $insertVal['sv']['sv'];
                    }
                    $data['freqs'][$key][$subKey] = $tmpFreq[$i];
                }
                $i++;
            }

            break;
    }
    //print_r($data);
    return $data;
}

/**
 * Pridobitev podatkov za grafe z časovno komponento
 * Izriše se graf z večimi serijami podatkov, ki so izbrane na sliderju
 * Vrne enako strukturo polja, kot funkcija 'getCrossData'
 */
function getSliderData($db, $tablePref, $tableName, $idJoined, $id, $idProject, $show_type, $slider_type, $selector)
{
    //<filtri>
    $filters = null;
    if (!empty($_POST["aFilters"])) {
        $filters = " AND " . $_POST["aFilters"];
    }
    //</filtri>

    $data = array();
    //izbrani podatki na sliderju
    if ($slider_type == "range") {
        if (isset($_POST['slider_sett'])) {
            $sliderSettings = rangeSliderOptions($idProject, $id, $selector, $_POST['slider_sett']);
        } else {
            $sliderSettings = rangeSliderOptions($idProject, $id, $selector);
        }

    } elseif ($slider_type == "months") {
        if (isset($_POST['slider_sett'])) {
            $sliderSettings = explode(",", $_POST['slider_sett']);
        } else {
            $sliderSettings = $selector->getSliderOptions($idProject, $id);
        }

    }
    //imena label sliderja (imena serij)
    $sliderLabels = $selector->getSliderLabels($idProject, $id);
    //podatki križanja z 'research_id'
    $calc = new Calculate($db, $tablePref, $tableName, $idJoined);
    $calc->setQuestion($id);
    $crossData = $calc->getCrosstabs("research_id", null, null, null);
    //default tip prikaza
    if ($show_type == null) {
        $show_type = "type_2";
    }

    switch ($show_type) {
        case 'type_1':
            //labele
            foreach ($sliderSettings as $key => $val) {
                foreach ($sliderLabels as $subKey => $subVal) {
                    if ($subVal['id'] == $val) {
                        $data['labs'][] = $subVal['labelText'];
                        break;
                    }
                }
            }
            //legenda
            $resName = str_replace(" ", "_", $selector->getProjectName($idProject));
            $researchCalculated = $selector->getResearchCalculated($resName);
            $legendArr = explode("/", $researchCalculated[$id]['answer']);
            $keyArray = array();
            foreach ($legendArr as $key => $val) {
                $val = explode(" ", $val, 2);
                $data['legend'][$val[0]] = $val[1];
                $keyArray[] = $val[0];
            }
            //frekvence
            $tmpData = array();
            foreach ($sliderSettings as $key => $value) {
                $tmpData[] = $calc->getFrequencies(null, "research_id = " . $value . $filters);
            }
            $tmpFreqs = array();
            foreach ($tmpData as $key => $value) {
                foreach ($keyArray as $keyArrVal) {
                    $insertVal = 0;
                    if (isset($value[$id][$keyArrVal])) {
                        $insertVal = $value[$id][$keyArrVal];
                    }

                    $tmpFreqs[$key][$keyArrVal] = $insertVal;
                }
                $data['freqs'][] = $tmpFreqs[$key];
            }
            //col totals
            foreach ($sliderSettings as $key => $val) {
                $data['colTotal'][] = $crossData['freq']['research_id']['data'][$val];
            }
            //row totals
            $colTotalArray = array();
            foreach ($data['legend'] as $key => $val) {
                $tmpArr = array();
                foreach ($data['freqs'] as $subKey => $subVal) {
                    $tmpArr[] = $subVal[$key];
                }
                $colTotalArray[$key] = $tmpArr;
            }
            foreach ($colTotalArray as $key => $val) {
                $data['rowTotal'][$key] = array_sum($val);
            }

            break;

        case 'type_2':
            //labele
            $resName = str_replace(" ", "_", $selector->getProjectName($idProject));
            $researchCalculated = $selector->getResearchCalculated($resName);
            $legendArr = explode("/", $researchCalculated[$id]['answer']);
            $keyArray = array();
            foreach ($legendArr as $key => $val) {
                $val = explode(" ", $val, 2);
                $data['labs'][$val[0]] = $val[1];
                $keyArray[] = $val[0];
            }
            //legenda
            foreach ($sliderSettings as $key => $val) {
                foreach ($sliderLabels as $subKey => $subVal) {
                    if ($subVal['id'] == $val) {
                        $data['legend'][] = $subVal['labelText'];
                        break;
                    }
                }
            }
            //frekvence
            $i = 0;
            foreach ($data['labs'] as $key => $value) {
                foreach ($sliderSettings as $subKey => $subValue) {
                    $tmpData = $calc->getFrequencies(null, "research_id = " . $subValue . $filters);
                    $tmpFreq = array();
                    foreach ($keyArray as $keyArrVal) {
                        $insertVal = 0;
                        if (isset($tmpData[$id][$keyArrVal])) {
                            $insertVal = $tmpData[$id][$keyArrVal];
                        }

                        $tmpFreq[] = $insertVal;
                    }
                    $data['freqs'][$key][$subKey] = $tmpFreq[$i];
                }
                $i++;
            }
            //col totals
            $tmpArr = array();
            foreach ($data['freqs'] as $key => $val) {
                $tmpArr[$key] = array_sum($val);
            }
            $data['colTotal'] = $tmpArr;
            //row totals
            foreach ($sliderSettings as $key => $val) {
                $data['rowTotal'][] = $crossData['freq']['research_id']['data'][$val];
            }

            break;
    }
    //total
    $data['total'] = array_sum($data['colTotal']);
    //print_r($data);
    return $data;
}

/**
 * Odstanjevanje skritih vprašanj z podatkov
 * Za grafe brez križanja
 */
function applyHiddenAnswers($id, $idP, &$data)
{
    $projectName = getProjectName($idP);
    $sql = "SELECT hideAnswers FROM " . str_replace(' ', '_', $projectName) . "___calculated WHERE questionName = '" . $id . "'";
    $res = mysql_query($sql);
    $hidden = "";

    if ($res) {
        $row = mysql_fetch_assoc($res);
        $hidden = $row['hideAnswers'];
    }

    if ($hidden != null) {
        $hiddenKeys = explode(",", $hidden);

        foreach ($hiddenKeys as $value) {
            foreach ($data['labs'] as $labKey => $label) {
                if ($labKey == $value) {
                    unset($data['labs'][$labKey]);
                }

            }
            foreach ($data['perc'] as $percKey => $perc) {
                if ($percKey == $value) {
                    unset($data['perc'][$percKey]);
                }

            }
            foreach ($data['freq'] as $freqKey => $freq) {
                if ($freqKey == $value) {
                    unset($data['freq'][$freqKey]);
                }

            }
        }
    }
}

/**
 * Odstanjevanje skritih vprašanj z podatkov
 * Za grafe z križanju
 */
function applyHiddenAnswers_cross($id, $idP, &$data, $slider2 = false)
{
    $projectName = getProjectName($idP);
    $sql = "SELECT hideAnswers FROM " . str_replace(' ', '_', $projectName) . "___calculated WHERE questionName = '" . $id . "'";
    $res = mysql_query($sql);
    $hidden = "";

    if ($res) {
        $row = mysql_fetch_assoc($res);
        $hidden = $row['hideAnswers'];
    }

    if ($hidden != null) {
        $hiddenKeys = explode(",", $hidden);

        if ($slider2 == false) {
            foreach ($hiddenKeys as $hideKey) {
                foreach ($data['legend'] as $legKey => $value) {
                    if ($legKey == $hideKey) {
                        unset($data['legend'][$legKey]);
                    }

                }
                foreach ($data['freqs'] as $key => $freqArr) {
                    foreach ($freqArr as $subKey => $value) {
                        if ($subKey == $hideKey) {
                            unset($data['freqs'][$key][$subKey]);
                        }

                    }
                }
                foreach ($data['colTotal'] as $colKey => $value) {
                    if ($colKey == $hideKey) {
                        unset($data['rowTotal'][$colKey]);
                    }

                }
            }
        } else {
            foreach ($hiddenKeys as $hideKey) {
                foreach ($data['labs'] as $labKey => $value) {
                    if ($labKey == $hideKey) {
                        unset($data['labs'][$labKey]);
                    }

                }
                foreach ($data['freqs'] as $freqKey => $value) {
                    if ($freqKey == $hideKey) {
                        unset($data['freqs'][$freqKey]);
                    }

                }
                foreach ($data['rowTotal'] as $rowKey => $value) {
                    if ($rowKey == $hideKey) {
                        unset($data['colTotal'][$rowKey]);
                    }

                }
            }
        }
    }
}

/**
 * Priprava in sortiranje podatkov za grafe brez križanja
 */
function prepareData(&$data, $total, $percentData, $decimal, $sort)
{
    //SORTIRANJE
    if ($sort != null) {
        if ($sort == "asc") {
            asort($data['freq']);

            $tmpArr = array();
            foreach (array_keys($data['freq']) as $key) {
                $tmpArr[$key] = $data['labs'][$key];
            }
            $data['labs'] = $tmpArr;

            asort($data['perc']);

        } else {
            arsort($data['freq']);

            $tmpArr = array();
            foreach (array_keys($data['freq']) as $key) {
                $tmpArr[$key] = $data['labs'][$key];
            }
            $data['labs'] = $tmpArr;

            arsort($data['perc']);
        }
    }
    //PRIPRAVA ITEMOV ZA SERIJO
    $items = array();

    foreach ($data['labs'] as $key => $value) {
        $yValue = round($data['freq'][$key]);
        if ($percentData == 'on') {
            $yValue = round($data['perc'][$key], $decimal);
        }

        $items[] = "{ y: " . $yValue . ", id: '" . $data['freq'][$key] . ";" . $data['perc'][$key] . "' }";
    }
    //print_r($items);
    return $items;
}

/**
 * Priprava in sortiranje podatkov za grafe z križanju
 */
function prepareData_cross(&$data, $dataType, $sliderType, $decimal, $sortDir, $sortBy)
{
    //PRERAČUNAVANJE
    if ($dataType != "num") {
        foreach ($data['freqs'] as $key => $freqArr) {
            foreach ($freqArr as $subKey => $numVal) {
                if ($dataType == "row") {
                    $data['freqs'][$key][$subKey] = ($data['rowTotal'][$subKey] != 0 ? (($numVal * 100) / $data['rowTotal'][$subKey]) : 0);
                } else {
                    $data['freqs'][$key][$subKey] = ($data['colTotal'][$key] != 0 ? (($numVal * 100) / $data['colTotal'][$key]) : 0);
                }

            }
        }
    }
    //SORTIRANJE

    $dontSortArray = array();
    foreach ($data['freqs'] as $k => $value) {
        foreach ($value as $key => $val) {
            if ($key >= 90) {
                $dontSortArray[$k][$key] = $val;
                unset($data['freqs'][$k][$key]);
            }
        }
    }

    if ($sortDir != null && $sortBy != null) {
        if (count($data['freqs']) > 1) {
            $tmp_arr = array_values($data['labs']);
            $sort_lab = $tmp_arr[$sortBy];
            $tmp_key = array_search($sort_lab, $data['labs']);
            if ($tmp_key != null) {
                $tmp_arr = $data['freqs'][$tmp_key];
            } else {
                $tmp_arr = $data['rowTotal'];
            }

        } else {
            $tmp_arr = $data['rowTotal'];
        }

        if ($sortDir == "asc") {
            asort($tmp_arr);
        } else {
            arsort($tmp_arr);
        }

        if (count($dontSortArray) > 0) {
            foreach ($dontSortArray as $k => $value) {
                foreach ($value as $key => $val) {
                    $data['freqs'][$k][$key] = $val;
                    $tmp_arr[$key] = $val;
                }
            }
        }
        $key_arr = array_keys($tmp_arr);
        //legend
        $tmpArr = array();
        foreach ($key_arr as $key) {
            $tmpArr[$key] = $data['legend'][$key];
        }
        $data['legend'] = $tmpArr;
        //freqs
        foreach ($data['freqs'] as $freqKey => $freqVal) {
            $tmpArr = array();
            foreach ($key_arr as $key) {
                $tmpArr[$key] = $freqVal[$key];
            }
            $data['freqs'][$freqKey] = $tmpArr;
        }
        //col total
        $tmpArr = array();
        foreach ($key_arr as $key) {
            $tmpArr[$key] = $data['rowTotal'][$key];
        }
        $data['rowTotal'] = $tmpArr;
        //setiranje podatkov
        $data['legend'] = array_values($data['legend']);
        foreach ($data['freqs'] as $key => $freqArr) {
            $data['freqs'][$key] = array_values($freqArr);
        }
        $data['rowTotal'] = array_values($data['rowTotal']);
    }
    //PRIPRAVA ITEMOV ZA SERIJE
    $items = array();

    foreach ($data['freqs'] as $key => $freqArr) {
        foreach ($freqArr as $subKey => $val) {
            if ($dataType == "num") {
                $colPercVal = ($data['colTotal'][$key] != 0 ? (($val * 100) / $data['colTotal'][$key]) : 0);
                $rowPercVal = ($data['rowTotal'][$subKey] != 0 ? (($val * 100) / $data['rowTotal'][$subKey]) : 0);

                $idString = $val . ";" . $rowPercVal . ";" . $colPercVal;

                $items[$key][] = "{ y: " . round($val) . ", id: '" . $idString . "' }";
            } elseif ($dataType == "col") {
                $numVal = ($data['colTotal'][$key] != 0 ? (($val * $data['colTotal'][$key]) / 100) : 0);
                $rowPercVal = ($data['rowTotal'][$subKey] != 0 ? (($numVal * 100) / $data['rowTotal'][$subKey]) : 0);

                $idString = $numVal . ";" . $rowPercVal . ";" . $val;

                $items[$key][] = "{ y: " . round($val, $decimal) . ", id: '" . $idString . "' }";
            } elseif ($dataType == "row") {
                $numVal = ($data['rowTotal'][$subKey] != 0 ? (($val * $data['rowTotal'][$subKey]) / 100) : 0);
                $colPercVal = ($data['colTotal'][$key] != 0 ? (($numVal * 100) / $data['colTotal'][$key]) : 0);

                $idString = $numVal . ";" . $val . ";" . $colPercVal;

                $items[$key][] = "{ y: " . round($val, $decimal) . ", id: '" . $idString . "' }";
            }
        }
    }
    return $items;
}

/**
 * Pridobitev dogodkov z tabele '___events'
 */
function getEvents($idQ, $project)
{
    $sql = "SELECT * FROM " . str_replace(' ', '_', $project) . "___events WHERE id_question = '" . $idQ . "'";
    $res = mysql_query($sql);
    $events = array();

    while ($row = mysql_fetch_assoc($res)) {
        $events[] = $row;
    }

    return $events;
}

/**
 * Pridobitev barv za določeno vprašanje
 */
function getColors($project, $reverseOrder, $selector)
{
    $colorShema = $selector->getProjectColorOptions($project);
    $colors = array();

    if (!empty($colorShema["colors"])) {
        $colorShema["colors"] = $colorShema["colors"] . "," . $colorShema["colors"] . "," . $colorShema["colors"];
        $colors = explode(",", $colorShema["colors"]);
    }

    if ($reverseOrder == true) {
        array_reverse($colors, false);
    }

    return $colors;
    /*$sql = "SELECT c.usedColors FROM _colorShema c INNER JOIN _projects p ON c.id = p.colorShema WHERE p.projectName='$project';";
$res = mysql_query($sql);
$colors = array();

if ($res) {
$row = mysql_fetch_assoc($res);
$colors = $row['usedColors'];
}

if ($colors != "") $colors = explode(",", $colors);
$more = explode(",", "#A75C56,#E89C84,#F5C972,#EAB06E,#C3B274,#354B5E,#D74B4B,#DCDDD8,#475F77,#2BBBD8,#102E37,#90CA77,#81C6DD,#993300,#99CC99,#003366,#2C6700,#692DAC,#9D538E,#34ACAF,#333333,#FFCC00,#669966,#993366");

if($reverseOrder == true){
krsort($colors);
$colors = array_values($colors);
}

if (count($colors) < $size) {
while (count($colors) < $size) {
$colors[] = array_pop($more);
}
}

return $colors;*/
}

function setDataColor($index, $colors)
{
    if (!empty($colors)) {
        if (array_key_exists($index, $colors)) {
            return $colors[$index];
        }
    }

    return false;
}

/**
 * Pridobitev imena projekta
 */
function getProjectName($id)
{
    $sql = "SELECT projectName FROM _projects WHERE id='" . $id . "';";
    $res = mysql_query($sql);
    $name = "borut_projekt";

    if ($res) {
        $row = mysql_fetch_assoc($res);
        $name = $row['projectName'];
    }

    return $name;
}

/**
 * Pridobitev imena raziskave
 */
function getResearchName($id)
{
    $sql = "SELECT project FROM _research WHERE id='" . $id . "';";
    $res = mysql_query($sql);
    $name = "borut_projekt";

    if ($res) {
        $row = mysql_fetch_assoc($res);
        $name = $row['project'];
    }

    return $name;
}

/**
 * Funkcija za izračun podatkov stacked line grafa
 * Line, podtip 2
 */
function calculateStackedLineValues($data)
{
    $stackedValues = array();
    //dodajnje prvega sub arraya
    $labelKeys = array_keys($data['labs']);
    $stackedValues['freqs'][$labelKeys[0]] = $data['freqs'][$labelKeys[0]];

    $i = 1;
    foreach ($data['freqs'] as $key => $val) {
        if ($i != 1) {
            foreach ($data['freqs'][$key] as $subKey => $subVal) {
                $tmp = 0;
                $check = 0;
                for ($k = $key; $k > 0; $k--) {
                    if ($check == 0) {
                        $tmp += $data['freqs'][$key][$subKey] + $data['freqs'][$key - $k][$subKey];
                    } else {
                        $tmp += $data['freqs'][$key - $k][$subKey];
                    }
                    $check++;
                }
                $stackedValues['freqs'][$key][$subKey] = $tmp;
            }
        } else {
            $i++;
        }
    }
    $mergedArray = array_merge($data, $stackedValues);
    //print_r($mergedArray);
    return $mergedArray;
}

/**
 * Funkcija za izračun podatkov 100% stacked line grafa
 * Line, podtip 3
 */
function calculatePercentStackedLineValues($data)
{
    $values = calculateStackedLineValues($data);
    $percentValues = array();

    $labelKeys = array_keys($data['labs']);
    $last = end($labelKeys);
    $lastSubArr = $values['freqs'][$last];

    foreach ($values['freqs'] as $key => $subArr) {
        foreach ($subArr as $subKey => $val) {
            if ($lastSubArr[$subKey] != 0) {
                $percentValues['freqs'][$key][$subKey] = round(($val * 100) / $lastSubArr[$subKey], 1);
            } else {
                $percentValues['freqs'][$key][$subKey] = 0;
            }
        }
    }
    $mergedArray = array_merge($data, $percentValues);
    //print_r($mergedArray);
    return $mergedArray;
}

/**
 * Funkcija za izris dogodkov na črtnem grafu
 * Vrednost 'val' določa kje na X-osi se bo izrisal dogodek
 * vrednost 'val' je še na testni vrednosti!
 */
function drawEvents($events, $colors)
{
    foreach ($events as $value) {
        $eventDescription = $value['event'];
        $eventId = $value['id_question'];
        $eventName = $value['eventName'];
        $val = 2; //testna vrednost, ki določa pozicijo dogodka na x-osi

        echo "graf.xAxis[0].addPlotLine({
			 value: " . $val . ",
			 id: '" . $eventId . "',
			 width: 2,
			 color: 'gray',
			 dashStyle: 'shortdash',
			 events: {
                 mouseover: function(e) {
				 	var parentOffset = $('#container').parent().offset();
				    var relX = e.pageX - parentOffset.left;
				    var relY = e.pageY - parentOffset.top - 28;

				    $('#plotline').css({'top':relY, 'left':relX, color:'black', 'border-color':'" . $colors[0] . "', 'display':'inherit'});
                 	$('#plotline').html('" . $eventDescription . "');
                 },
                 mouseout: function() {
                 	$('#container').mouseleave(function() {
                 		$('#plotline').css({'display':'none'});
             		});
                 }
             },
			 label: {
			 	 text: '" . $eventName . "',
			 	 rotation: 0,
			 	 textAlign: 'center',
			 	 verticalAlign: 'bottom',
			 	 y: 15, style: {
			 	 	 fontWeight: 'bold',
			 	 	 fontSize: '12px',
			 	 	 padding: '8px'
		 	 	 	}
		 	 	 }
	 	 	 });";
    }
}

/**
 * Funkcija za osvetljevanje/temnjenje hex barv
 * Uporabljeno pri pie grafu, podtip 3
 */
function colourBrightness($hex, $percent)
{
    $hash = '';
    if (stristr($hex, '#')) {
        $hex = str_replace('#', '', $hex);
        $hash = '#';
    }
    $rgb = array(hexdec(substr($hex, 0, 2)), hexdec(substr($hex, 2, 2)), hexdec(substr($hex, 4, 2)));

    for ($i = 0; $i < 3; $i++) {
        if ($percent > 0) {
            // Lighter
            $rgb[$i] = round($rgb[$i] * $percent) + round(255 * (1 - $percent));
        } else {
            // Darker
            $positivePercent = $percent - ($percent * 2);
            $rgb[$i] = round($rgb[$i] * $positivePercent) + round(0 * (1 - $positivePercent));
        }
        if ($rgb[$i] > 255) {
            $rgb[$i] = 255;
        }
    }
    $hex = '';
    for ($i = 0; $i < 3; $i++) {
        $hexDigit = dechex($rgb[$i]);
        if (strlen($hexDigit) == 1) {
            $hexDigit = "0" . $hexDigit;
        }
        $hex .= $hexDigit;
    }
    return $hash . $hex;
}

/**
 * Funkcija vrne naključne simbole, za markerje na line grafu
 * Uporabljena je samo ob izbrani opciji mešanih markerjev na grafu
 */
function mixedLineSymbols($index)
{
    $symbols = array(1 => "circle", 2 => "square", 3 => "diamond", 4 => "triangle", 5 => "triangle-down");

    if ($index > count($symbols)) {
        $index = rand(1, 5);
    }

    echo "marker: { symbol: '" . $symbols[$index] . "' }";
}

/**
 * Funkcija vrne vse vmesne id-je mescev, označenih na trackerju
 */
function rangeSliderOptions($idP, $idQ, $selector, $slider_sett = null)
{
    if ($slider_sett != null) {
        $slider_sett = explode(",", $slider_sett);
        $range = range($slider_sett[0], $slider_sett[1]);
    } else {
        $rangeOpt = $selector->getRangedSliderOptions($idP, $idQ);
        $range = range($rangeOpt[0], $rangeOpt[1]);
    }
    $sliderLabs = $selector->getSliderLabels($idP, $idQ);

    $tmpArr = array();
    foreach ($sliderLabs as $key => $value) {
        array_push($tmpArr, $value['id']);
    }

    $labels = array_intersect($tmpArr, $range);
    $labels = array_values($labels);

    return $labels;
}

/**
 * Funkcija za izris pie grafa
 */
function drawPieChart($data, $total, $colors, $graphType, $subType)
{
    //uporabniške nastavitve
    $graphOptions = new options();
    $options = $graphOptions->graphOptions($_POST['id'], $_POST['idQcross'], $_POST['idProject'], $_POST['subType'], $_POST['type'], $total[$_POST['id']]);
    if (count($options['beforeLoad'])) {
        foreach ($options['beforeLoad'] as $key => $val) {echo $val;}
    }

    //decimalke procentov
    $decimal = 1;
    if ($options['proc_decimal'][0] > 1) {
        $decimal = $options['proc_decimal'][0];
    }

    //nastavitve za podtip 2
    $inner = "";
    if ($subType == "2") {
        $inner = "innerSize: '50%',";
    }

    //skrivanje odgovorov
    applyHiddenAnswers($_POST['id'], $_POST['idProject'], $data);

    //določanje serije
    echo "graf.addSeries({
		  type: 'pie',";
    echo "showInLegend: ";if ($options['pieLegendEnable'][0] == 'on') {echo "true,";} else {echo "false,";} //skrivanje in prikazovanje labele v legendi
    echo $inner . "
		data: [";
    $items = array();
    $i = 0;
    foreach ($data['labs'] as $key => $value) {
        $label = $value;
        //lomljenje label legende
        if (isset($options['stBesedLegPie'][0])) {
            $l = explode(" ", $label);
            array_splice($l, $options['stBesedLegPie'][0]);
            $label = implode(" ", $l);
        }
        $numValue = round($data['freq'][$key]);
        $percentValue = round($data['perc'][$key], $decimal);
        $color = (setDataColor($i, $colors) != false ? " color: '" . setDataColor($i, $colors) . "', " : "");

        if ($subType == "1") //podtip 1
        {
            array_push($items, "{ name: '" . addslashes($label) . "',
										  x: " . $numValue . ",
										  y: " . $percentValue . ",
										  " . $color . "
										  id: " . $i . " }");
        } elseif ($subType == "2") //podtip 2
        {
            array_push($items, "{ name: '" . addslashes($label) . "',
										  x: " . $numValue . ",
										  y: " . $percentValue . ",
										  " . $color . "
										  id: " . $i . ",
										  selected: true, sliced: true }");
        }

        $i++;
    }
    echo implode(",", $items);
    echo "]
	});";
    //uporabniške nastavitve
    if (count($options['afterLoad'])) {
        foreach ($options['afterLoad'] as $key => $val) {echo $val;}
    }

}

/**
 * Funkcija za izris pie grafa križanja
 * Pie, podtip 3
 */
function drawCrossPieChart($data, $colors, $graphType, $subType)
{
    //uporabniške nastavitve
    $graphOptions = new options();
    $options = $graphOptions->graphOptions($_POST['id'], $_POST['idQcross'], $_POST['idProject'], $_POST['subType'], $_POST['type'], $data['total']);
    if (count($options['beforeLoad'])) {
        foreach ($options['beforeLoad'] as $key => $val) {echo $val;}
    }

    //decimalke procentov
    $decimal = 1;
    if ($options['proc_decimal'][0] > 1) {
        $decimal = $options['proc_decimal'][0];
    }

    //upoštevanje skritih vprašanj
    applyHiddenAnswers_cross($_POST['id'], $_POST['idProject'], $data);

    $innerCircle = array();
    $outerCircle = array();
    //seštevek polj za notranji krog
    $freqSum = array();
    foreach ($data['freqs'] as $key => $val) {
        array_push($freqSum, array_sum($val));
    }

    //podatki za notranji krog
    $i = 0;
    foreach ($data['labs'] as $key => $val) {
        $color = (setDataColor($i, $colors) != false ? " color: '" . setDataColor($i, $colors) . "', " : "");
        array_push($innerCircle, "{ name: '" . addslashes($val) . "', " . $color . " y: " . $freqSum[$i] . " }");
        $i++;
    }
    //podatki za zunanji krog
    $legend = array_values($data['legend']);
    $j = 0;
    foreach ($data['freqs'] as $key => $val) {
        $brightness = 0.2;
        $k = 0;
        foreach ($val as $subKey => $subVal) {
            //$color = (setDataColor($j, $colors) != false ? " color: '".colourBrightness(setDataColor($j, $colors), $brightness)."', " : "");
            $color = (setDataColor($j, $colors) != false ? " color: '" . setDataColor($j, $colors) . "', " : "");

            $colPercentVal = ($subVal * 100) / $data['colTotal'][$subKey];
            $rowPercentVal = ($subVal * 100) / $data['rowTotal'][$key];

            array_push($outerCircle, "{ name: '" . addslashes($legend[$k]) . "', y: " . round($subVal) . ", " . $color . " id: '" . $rowPercentVal . ";" . $colPercentVal . "' }");
            $brightness = $brightness + 0.2;
            $k++;
        }
        $j++;
    }
    //vklop/izklop notranjih label
    $innerLabels = "off";
    if (isset($options['pie3InnerLabs'][0])) {
        $innerLabels = "on";
    }

    //vklop/izklop zunanjih label
    $outerLabels = "off";
    if (isset($options['pie3OuterLabs'][0])) {
        $outerLabels = "on";
    }

    //notranji krog
    echo "graf.addSeries({
		type: 'pie',
		name: 'Skupna vrednost odgovora',
		data: [ " . implode(", ", $innerCircle) . " ],
		size: '60%',
		dataLabels: {
			formatter: function(){
				return this.y > 1 ? this.point.name : null;
			},";
    if (isset($options['pie3InnerColor'][0])) {echo "color: '" . $options['pie3InnerColor'][0] . "',";} else {echo "color: 'white',";}
    if (isset($options['pie3InnerSize'][0])) {echo "style: { fontSize: '" . $options['pie3InnerSize'][0] . "px' },";} else {echo "style: { fontSize: '11px' },";}
    echo "	distance: -30
		}
	});";
    //zunanji krog
    echo "graf.addSeries({
		type: 'pie',
		id: 1,
		name: 'Vrednost',
		data: [ " . implode(", ", $outerCircle) . " ],
		size: '80%',
		innerSize: '60%',
		dataLabels: {
			formatter: function(){
				return this.y > 1 ? this.point.name + ': <b>' +  this.y + '</b>' : null;
			},";
    if (isset($options['pie3OuterColor'][0])) {echo "color: '" . $options['pie3OuterColor'][0] . "',";} else {echo "color: '#666666',";}
    if (isset($options['pie3OuterSize'][0])) {echo "style: { fontSize: '" . $options['pie3OuterSize'][0] . "px' }";} else {echo "style: { fontSize: '11px' }";}
    echo "}
	});";
    //uporabniške nastavitve
    if (count($options['afterLoad'])) {
        foreach ($options['afterLoad'] as $key => $val) {echo $val;}
    }

}

/**
 * Funkcija za izris grafa brez križanja
 */
function drawChart($data, $project, $colors, $graphType, $total)
{
    //uporabniške nastavitve
    $graphOptions = new options();
    $options = $graphOptions->graphOptions($_POST['id'], $_POST['idQcross'], $_POST['idProject'], $_POST['subType'], $_POST['type'], $total[$_POST['id']]);

    if (count($options['beforeLoad'])) {
        foreach ($options['beforeLoad'] as $key => $val) {echo $val;}
    }

    if ($options['barChart'][0] == 'on') {
        $graphType = 'bar';
    }

    //decimalke procentov
    $decimal = 1;
    if ($options['proc_decimal'][0] > 1) {
        $decimal = $options['proc_decimal'][0];
    }

    //skrivanje odgovorov
    applyHiddenAnswers($_POST['id'], $_POST['idProject'], $data);
    //računanje in sortiranje podatkov
    if ($options['sort_direction'][0] != 'none') {
        $sort = $options['sort_direction'][0];
    }
    $items = prepareData($data, $total[$_POST['id']], $options['percentData'][0], $decimal, $sort);
    $color = (setDataColor(0, $colors) != false ? " color: '" . setDataColor(0, $colors) . "', " : "");

    //določanje kategorij
    echo "graf.xAxis[0].setCategories([" . "\"" . implode("\", \"", $data['labs']) . "\"" . "]);";
    //dodajanje serije
    echo "graf.addSeries({
		  data: [" . implode(", ", $items) . "],
		  type: '" . $graphType . "',
		  showInLegend: false,
		  " . $color . "
		  name: '" . addslashes($project) . "'";
    //color: '". $colors[1] ."',";
    if (($graphType == "column" || $graphType == 'bar') && isset($options['pointWidth'][0])) {
        echo ", pointWidth: '" . $options['pointWidth'][0] . "'"; //določanje širine stolpcev
    }
    echo "});";
    //uporabniške nastavitve
    if (count($options['afterLoadUpdate'])) {
        foreach ($options['afterLoadUpdate'] as $key => $val) {echo $val;}
    }

    if (count($options['afterLoad'])) {
        foreach ($options['afterLoad'] as $key => $val) {echo $val;}
    }

}

/**
 * Funkcija za izris grafa križanja
 */
function drawCrossChart($data, $colors, $graphType, $columnSlider = false)
{
    //uporabniške nastavitve
    $seriesCount = count($data['labs']);
    $graphOptions = new options();
    $options = $graphOptions->graphOptions($_POST['id'], $_POST['idQcross'], $_POST['idProject'], $_POST['subType'], $_POST['type'], $data['total'], $columnSlider, $seriesCount);

    if (count($options['beforeLoad'])) {
        foreach ($options['beforeLoad'] as $key => $val) {
            echo $val;
        }
    }

    //tip column garaf
    if ($options['barChart'][0] == 'on') {
        $graphType = 'bar';
    }

    //decimalke procentov
    $decimal = 1;
    if ($options['proc_decimal'][0] > 1) {
        $decimal = $options['proc_decimal'][0];
    }

    //upoštevanje skritih vprašanj
    $slider2 = false;
    if ($graphType == "line" && $options['line_slider_type'][0] == "type_2") {
        $slider2 = true;
    }

    applyHiddenAnswers_cross($_POST['id'], $_POST['idProject'], $data, $slider2);
    //računanje in sortiranje podatkov
    if ($options['sort_direction'][0] != 'none') {
        $sortBy = $options['sort_data_by'][0];
        $sortDir = $options['sort_direction'][0];
    }
    $dataType = "num";
    if ($options['percentData'][0] == "on") {
        $dataType = $options['percentType'][0];
    }

    $items = prepareData_cross($data, $dataType, $options['line_slider_type'][0], $decimal, $sortDir, $sortBy);

    $i = 0;
    $j = 1;
    foreach ($data['labs'] as $key => $val) {
        $color = (setDataColor($i, $colors) != false ? " color: '" . setDataColor($i, $colors) . "', " : "");

        //določanje kategorij
        echo "graf.xAxis[0].setCategories([" . "\"" . implode("\", \"", $data['legend']) . "\"" . "]);";
        //dodajanje serij
        echo "graf.addSeries({";
        echo "id: '" . $data['labs'][$key] . "',";
        echo "type: '" . $graphType . "',";
        echo "name: '";if (isset($options['legendLabelLenght'][0])) {
//rezanje label v legendi
            $seriesName = explode(" ", $data['labs'][$key]);
            array_splice($seriesName, $options['legendLabelLenght'][0]);
            echo implode(" ", $seriesName) . "', ";
        } else {
            echo $data['labs'][$key] . "', ";
        }
        // Prikaži samo zadnji podatek
        /*echo "

        dataLabels: {
        enabled: true,
        useHTML: true,
        formatter: function() {
        var total = this.series.data.length - 1;

        if (this.series.data.indexOf( this.point ) == total) {
        return this.y;
        } else {
        return null;
        }
        }
        },
        scrollbar: {
        enabled: true
        },

        ";*/
        echo "showInLegend: ";if ($options['legendEnable'][0] == 'on') {echo "true,";} else {echo "false,";} //skrivanje in prikazovanje labele v legendi
        echo $color . "
			  data: [" . implode(", ", $items[$key]) . "], ";
        if ($graphType == "column" || $graphType == 'bar') {
            if (isset($options['pointWidth'][0])) {echo "pointWidth: '" . $options['pointWidth'][0] . "'";}
        }
//določanje širine stolpcev
        if ($graphType == "line") {
            if (isset($options['mixedMarkerSymbols'][0])) {
                mixedLineSymbols($j);
                $j++;}
        }
//klicanje funkcije za različne markerje
        echo "});";
        $i++;
    }
    //uporabniške nastavitve
    if (count($options['afterLoadUpdate'])) {
        foreach ($options['afterLoadUpdate'] as $key => $val) {
            echo $val;
        }
    }

    if (count($options['afterLoad'])) {
        foreach ($options['afterLoad'] as $key => $val) {
            echo $val;
        }
    }

}

//<filters>
$filters = null;

if (!empty($_POST["aFilters"])) {
    $filters = $_POST["aFilters"];
}
//</filters>

$sel = new Selector($db);

$id = isset($_POST['id']) ? $_POST['id'] : "";
if (isset($_POST['idProject'])) {
    $idJoined = $_POST['idProject'];
    $tablePref = '_projects';
    $tableName = str_replace(" ", "_", $sel->getProjectName($idJoined));
} else if (isset($_POST['idResearch'])) {
    $idJoined = $_POST['idResearch'];
    $tablePref = '_research';
    $tableName = str_replace(" ", "_", $sel->getResearcheName($idJoined));
}

$graphOptions = new options();
$options = $graphOptions->graphOptions($_POST['id'], $_POST['idQcross'], $_POST['idProject'], $_POST['subType'], $_POST['type']);

$reverseColors = (isset($options['barve_obratno'][0]) ? true : false);

$calc = new Calculate($db, $tablePref, $tableName, $idJoined);
$calc->setQuestion($id);
$labs = new Labels($db, $tablePref, $tableName, $idJoined);
$labs->setQuestion($id);
$params = $calc->getParameters();
//$freq = $calc->getFrequencies();
$freq = $calc->getFrequencies(null, $filters);
$total = $calc->getTotal();
$labels = $labs->getLabels();
$project = isset($_POST['idResearch']) ? getResearchName($_POST['idResearch']) : getProjectName($_POST['idProject']);

//$colors = getColors($db, $project, $id, count($data['labs']), $reverseColors);
$colors = getColors($project, $reverseColors, $sel);
$events = getEvents($_POST['id'], $project);

/**
 * IZRIS GRAFOV
 */
if (isset($_POST['type'])) {
    if ($params['questionType'] != SCALE_QUESTION) {
        $data = getData($freq[$_POST['id']], $labels[$_POST['id']], $total[$_POST['id']]);
        $graphType = $_POST['type'];

        //COLUMN
        if ($graphType == 'column') {
            //podtip 1
            if ($_POST['subType'] == 1) {
                //izris grafa brez križanja
                if ($_POST['idQcross'] == null) {
                    echo "graf.options.columnSettings1();";
                    //če je vključen slider
                    /*if(isset($options['time_int'][0]) && $options['time_int'][0] != 'brez'){
                    if($options['time_int'][0] == 'range'){
                    $slider_type = "range";
                    } elseif($options['time_int'][0] == 'months') {
                    $slider_type = "months";
                    }
                    $data = getSliderData($db, $tablePref, $tableName, $idJoined, $_POST['id'], $_POST['idProject'], "type_1", $slider_type, $sel);
                    drawCrossChart($data, $colors, $graphType, true);
                    }
                    //če slider ni vključen
                    else {
                    drawChart($data, $project, $colors, $graphType, $total);
                    }*/
                    drawChart($data, $project, $colors, $graphType, $total);
                }
                //izris grafa z križanju
                else {
                    echo "graf.options.columnSettings1();";
                    //če je vključen slider
                    $filter = "";
                    $slider_type = "";

                    /*if(isset($options['time_int'][0]) && $options['time_int'][0] != 'brez'){
                    $slider_type = $options['time_int'][0];
                    if($slider_type == 'range'){
                    if(isset($_POST['slider_sett'])) $filter = rangeSliderOptions($_POST['idProject'], $_POST['id'], $sel, $_POST['slider_sett']);
                    else $filter = $sel->getRangedSliderOptions($_POST['idProject'], $_POST['idProject']);
                    } elseif($slider_type == 'months') {
                    if(isset($_POST['slider_sett'])) $filter = explode(",", $_POST['slider_sett']);
                    else $filter = $sel->getSliderOptions($_POST['idProject'], $_POST['id']);
                    }
                    }*/
                    $data = getCrossData($db, $tablePref, $tableName, $idJoined, $_POST['idQcross'], $id, $filter, $slider_type);
                    drawCrossChart($data, $colors, $graphType);
                }

            }
            //podtip 2
            elseif ($_POST['subType'] == 2 && $_POST['idQcross'] != null) {
                echo "graf.options.columnSettings2();";
                //če je vključen slider
                $filter = "";
                $slider_type = "";

                /*if(isset($options['time_int'][0]) && $options['time_int'][0] != 'brez'){
                $slider_type = $options['time_int'][0];
                if($slider_type == 'range'){
                if(isset($_POST['slider_sett'])) $filter = rangeSliderOptions($_POST['idProject'], $_POST['id'], $sel, $_POST['slider_sett']);
                else $filter = $sel->getRangedSliderOptions($_POST['idProject'], $_POST['idProject']);
                } elseif($slider_type == 'months') {
                if(isset($_POST['slider_sett'])) $filter = explode(",", $_POST['slider_sett']);
                else $filter = $sel->getSliderOptions($_POST['idProject'], $_POST['id']);
                }
                }*/
                $data = getCrossData($db, $tablePref, $tableName, $idJoined, $_POST['idQcross'], $id, $filter, $slider_type);
                drawCrossChart($data, $colors, $graphType);
            } elseif ($_POST['subType'] == 2 && $_POST['idQcross'] == null) {
                echo "graf.options.graphError2();";
            }
            //podtip 3
            elseif ($_POST['subType'] == 3 && $_POST['idQcross'] != null) {
                echo "graf.options.columnSettings3();";
                //če je vključen slider
                $filter = "";
                $slider_type = "";

                /*if(isset($options['time_int'][0]) && $options['time_int'][0] != 'brez'){
                $slider_type = $options['time_int'][0];
                if($slider_type == 'range'){
                if(isset($_POST['slider_sett'])) $filter = rangeSliderOptions($_POST['idProject'], $_POST['id'], $sel, $_POST['slider_sett']);
                else $filter = $sel->getRangedSliderOptions($_POST['idProject'], $_POST['idProject']);
                } elseif($slider_type == 'months') {
                if(isset($_POST['slider_sett'])) $filter = explode(",", $_POST['slider_sett']);
                else $filter = $sel->getSliderOptions($_POST['idProject'], $_POST['id']);
                }
                }*/
                $data = getCrossData($db, $tablePref, $tableName, $idJoined, $_POST['idQcross'], $id, $filter, $slider_type);
                drawCrossChart($data, $colors, $graphType);
            } elseif ($_POST['subType'] == 3 && $_POST['idQcross'] == null) {
                echo "graf.options.graphError2();";
            }
        }

        //LINE
        elseif ($graphType == 'line') {
            //podtip 1
            if ($_POST['subType'] == 1) {
                //izris line grafa brez križanja
                if ($_POST['idQcross'] == null) {
                    echo "graf.options.lineSettings();";
                    drawChart($data, $project, $colors, $graphType, $total);
                }
                //izris line grafa z križanju
                else {
                    echo "graf.options.lineSettings();";
                    $data = getCrossData($db, $tablePref, $tableName, $idJoined, $_POST['idQcross'], $id);
                    drawCrossChart($data, $colors, $graphType);
                }

            }
            //podtip 2
            elseif ($_POST['subType'] == 2 && $_POST['idQcross'] != null) {
                echo "graf.options.lineSettings();";
                $data = getCrossData($db, $tablePref, $tableName, $idJoined, $_POST['idQcross'], $id);
                $stackedData = calculateStackedLineValues($data);
                drawCrossChart($stackedData, $colors, $graphType);
            } elseif ($_POST['subType'] == 2 && $_POST['idQcross'] == null) {
                echo "graf.options.graphError2();";
            }
            //podtip 3
            elseif ($_POST['subType'] == 3 && $_POST['idQcross'] != null) {
                echo "graf.options.lineSettings();";
                $data = getCrossData($db, $tablePref, $tableName, $idJoined, $_POST['idQcross'], $id);
                $stackedData = calculatePercentStackedLineValues($data);
                drawCrossChart($stackedData, $colors, $graphType);
            } elseif ($_POST['subType'] == 3 && $_POST['idQcross'] == null) {
                echo "graf.options.graphError2();";
            }
            //podtip 4
            elseif ($_POST['subType'] == 4 && $_POST['idQcross'] != null) {
                echo "graf.options.lineSettings();";

                if (isset($options['time_int'][0]) && $options['time_int'][0] != 'brez') {
                    $show_type = $options['line_slider_type'][0];

                    if ($options['time_int'][0] == 'range') {
                        $slider_type = "range";
                    } elseif ($options['time_int'][0] == 'months') {
                        $slider_type = "months";
                    }
                    $data = getSliderData($db, $tablePref, $tableName, $idJoined, $_POST['id'], $_POST['idProject'], $show_type, $slider_type, $sel);
                    drawCrossChart($data, $colors, $graphType);
                } else {
                    echo "graf.options.graphError4();";
                }
            }
        }

        //PIE
        elseif ($graphType == 'pie') {
            //podtip 1
            if ($_POST['subType'] == 1 && $_POST['idQcross'] == null) {
                echo "graf.options.pieSettings1();";
                //če je vključen slider
                $filter = "";

                /*if(isset($options['time_int'][0]) && $options['time_int'][0] != 'brez'){
                $slider_type = $options['time_int'][0];
                if($slider_type == 'range'){
                if(isset($_POST['slider_sett'])) $filter = rangeSliderOptions($_POST['idProject'], $_POST['id'], $sel, $_POST['slider_sett']);
                else $filter = $sel->getRangedSliderOptions($_POST['idProject'], $_POST['idProject']);
                } elseif($slider_type == 'months') {
                if(isset($_POST['slider_sett'])) $filter = explode(",", $_POST['slider_sett']);
                else $filter = $sel->getSliderOptions($_POST['idProject'], $_POST['id']);
                }
                //izračun podatkov
                $freq = $calc->getFrequencies(null, "research_id IN(".implode(", ", $filter).")");
                $total = array( $_POST['id'] => array_sum($freq[$_POST['id']]));
                $labels = $labs->getLabels();
                $data = getData($freq[$_POST['id']], $labels[$_POST['id']], $total[$_POST['id']]);
                $project = isset($_POST['idResearch']) ? getResearchName($_POST['idResearch']) : getProjectName($_POST['idProject']);
                $colors = getColors($db, $project, $id, count($data['labs']), $reverseColors);
                }*/
                drawPieChart($data, $total, $colors, $graphType, "1");
            } elseif ($_POST['subType'] == 1 && $_POST['idQcross'] != null) {
                echo "graf.options.graphError();";
            }
            //podtip 2
            elseif ($_POST['subType'] == 2 && $_POST['idQcross'] == null) {
                echo "graf.options.pieSettings2();";
                //če je vključen slider
                $filter = "";

                /*if(isset($options['time_int'][0]) && $options['time_int'][0] != 'brez'){
                $slider_type = $options['time_int'][0];
                if($slider_type == 'range'){
                if(isset($_POST['slider_sett'])) $filter = rangeSliderOptions($_POST['idProject'], $_POST['id'], $sel, $_POST['slider_sett']);
                else $filter = $sel->getRangedSliderOptions($_POST['idProject'], $_POST['idProject']);
                } elseif($slider_type == 'months') {
                if(isset($_POST['slider_sett'])) $filter = explode(",", $_POST['slider_sett']);
                else $filter = $sel->getSliderOptions($_POST['idProject'], $_POST['id']);
                }
                //izračun podatkov
                $freq = $calc->getFrequencies(null, "research_id IN(".implode(", ", $filter).")");
                $total = array( $_POST['id'] => array_sum($freq[$_POST['id']]) );
                $labels = $labs->getLabels();
                $data = getData($freq[$_POST['id']], $labels[$_POST['id']], $total[$_POST['id']]);
                $project = isset($_POST['idResearch']) ? getResearchName($_POST['idResearch']) : getProjectName($_POST['idProject']);
                $colors = getColors($db, $project, $id, count($data['labs']), $reverseColors);
                }*/
                drawPieChart($data, $total, $colors, $graphType, "2");
            } elseif ($_POST['subType'] == 2 && $_POST['idQcross'] != null) {
                echo "graf.options.graphError();";
            }
            //podtip 3
            elseif ($_POST['subType'] == 3 && $_POST['idQcross'] != null) {
                echo "graf.options.pieSettings3();";
                //če je vključen slider
                $filter = "";
                $slider_type = "";

                /*if(isset($options['time_int'][0]) && $options['time_int'][0] != 'brez'){
                $slider_type = $options['time_int'][0];
                if($slider_type == 'range'){
                if(isset($_POST['slider_sett'])) $filter = rangeSliderOptions($_POST['idProject'], $_POST['id'], $sel, $_POST['slider_sett']);
                else $filter = $sel->getRangedSliderOptions($_POST['idProject'], $_POST['idProject']);
                } elseif($slider_type == 'months') {
                if(isset($_POST['slider_sett'])) $filter = explode(",", $_POST['slider_sett']);
                else $filter = $sel->getSliderOptions($_POST['idProject'], $_POST['id']);
                }
                }*/
                $data = getCrossData($db, $tablePref, $tableName, $idJoined, $_POST['idQcross'], $id, $filter, $slider_type);
                drawCrossPieChart($data, $colors, $graphType, "3");
            } elseif ($_POST['subType'] == 3 && $_POST['idQcross'] == null) {
                echo "graf.options.graphError2();";
            }
        }
    }

    //SCALE VPRAŠANJA
    elseif ($params['questionType'] == SCALE_QUESTION) {
        $graphType = $_POST['type'];

        //COLUMN
        if ($graphType == 'column') {
            //podtip 1
            if ($_POST['subType'] == 1) {
                echo "graf.options.columnSettings1();";
                $data = getScaleData($db, $tablePref, $tableName, $idJoined, $_POST['id'], 1);
                drawChart($data, $project, $colors, $graphType, $total);
            }
            //podtip 2
            elseif ($_POST['subType'] == 2) {
                echo "graf.options.columnSettings1();";
                $data = getScaleData($db, $tablePref, $tableName, $idJoined, $_POST['id'], 2);
                drawCrossChart($data, $colors, $graphType);
            }
            //podtip 3
            elseif ($_POST['subType'] == 3) {
                echo "graf.options.graphError5();";
            }
        }

        //LINE
        elseif ($graphType == 'line') {
            //podtip 1
            if ($_POST['subType'] == 1) {
                echo "graf.options.lineSettings();";
                $data = getScaleData($db, $tablePref, $tableName, $idJoined, $_POST['id'], 1);
                drawChart($data, $project, $colors, $graphType, $total);
            }
            //podtip 2
            elseif ($_POST['subType'] == 2) {
                echo "graf.options.lineSettings();";
                $data = getScaleData($db, $tablePref, $tableName, $idJoined, $_POST['id'], 2);
                drawCrossChart($data, $colors, $graphType);
            }
            //podtip 3
            elseif ($_POST['subType'] == 3) {
                echo "graf.options.graphError5();";
            } elseif ($_POST['subType'] == 3) {
                echo "graf.options.graphError5();";
            }
            //podtip 4
            elseif ($_POST['subType'] == 4) {
                echo "graf.options.graphError5();";
            }
        }

        //PIE
        elseif ($graphType == 'pie') {
            //podtip 1
            if ($_POST['subType'] == 1) {
                echo "graf.options.pieSettings1();";
                $data = getScaleData($db, $tablePref, $tableName, $idJoined, $_POST['id'], 1);
                drawPieChart($data, $total, $colors, $graphType, "1");
            }
            //podtip 2
            elseif ($_POST['subType'] == 2) {
                echo "graf.options.pieSettings2();";
                $data = getScaleData($db, $tablePref, $tableName, $idJoined, $_POST['id'], 1);
                drawPieChart($data, $total, $colors, $graphType, "2");
            }
            //podtip 3
            elseif ($_POST['subType'] == 3) {
                echo "graf.options.pieSettings3();";
                $data = getScaleData($db, $tablePref, $tableName, $idJoined, $_POST['id'], 2);
                drawCrossPieChart($data, $colors, $graphType, "3");
            }
        }
    }
} else {
    echo "Error creating graph. Please define type of drawing!";
}
