<?php
class Question
{
    private $idCategory;
    private $name;
    private $tip_sql;
    private $label;
    private $answers;
    private $answersDatabaseName;
    private $answersScalar;
    private $maxAnswerValue;

    public function __construct($name, $label, $idCategory)
    {
        $this->idCategory = $idCategory;
        $this->name = $name;
        $this->label = $label;
    }

    public function setTipSql($type)
    {
        $this->tip_sql = $type;
    }

    public function getLabel()
    {
        return $this->label;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getAnswersDatabaseName()
    {
        return $this->answersDatabaseName;
    }

    public function addAnswer($weigth, $answerId, $legendId)
    {
        if(empty($weigth)) return;
        $weigth = is_null($weigth) ? 0 : $weigth;

        //$this->answers[$answerId] = $answerId;
        if($this->tip_sql == 2){
            $this->answersScalar[$answerId][$legendId] = $weigth;
        }
        else{
            $this->answersScalar[$answerId] = $weigth;
        }

        if ($this->tip_sql == 1) {
            $variableInDatabase = $this->name;
        } else if ($this->tip_sql  == 3 || $this->tip_sql  == 2) {
            $variableInDatabase = $this->name . "_" . $answerId;
        }
        $this->answersDatabaseName[$variableInDatabase] = $variableInDatabase;
        $this->calculateMaxAnswerValue();
    }


    public function getMaxAnswerValue()
    {
        return isset($this->maxAnswerValue) ? $this->maxAnswerValue : 0;
    }
    private function calculateMaxAnswerValue()
    {
        $answersScalarArray = $this->answersScalarToArray();
        if(count($answersScalarArray) == 0)
        {
            $this->maxAnswerValue = 0;
        }
        else if($this->tip_sql == 1)
        {
            $this->maxAnswerValue = max($answersScalarArray);
        }
        else if($this->tip_sql == 2 || $this->tip_sql == 3)
        {
            $maxValue = 0;
            foreach ($answersScalarArray as $value)
            {
                $maxValue += $value;
            }
            //$this->maxAnswerValue =  max($answersScalarArray);
            $this->maxAnswerValue =  $maxValue;
        }
    }

    public function getAnswerScalarValue($answerId, $legendId)
    {
        if($this->tip_sql == 2){
            return $this->answersScalar[$legendId][$answerId];
        }
        else{
            if(is_null($answerId) || $answerId <= 0 || !isset($this->answersScalar[$answerId])) return 0;
            return $this->answersScalar[$answerId];
        }
    }

    private function answersScalarToArray()
    {
        $rtnArray = Array();
        if($this->tip_sql == 2){
            foreach ($this->answersScalar as $scaleAnswer) {
                foreach ($scaleAnswer as $value) {
                    if($value >= 0)
                    {
                        $rtnArray[] = $value;
                    }
                }
            }
        }
        else{
            foreach ($this->answersScalar as $value) {
                if($value >= 0)
                {
                    $rtnArray[] = $value;
                }
            }
        }

        return $rtnArray;
    }
}
?>
