<?php
class Category
{
    private $id;
    private $name;
    private $isRoot;
    private $subCategories;
    private $questions;
    private $DBColumnNameToQuestionName;

    public function __construct($id, $name, $isRoot = FALSE)
    {
        $this->id = $id;
        $this->name = $name;
        $this->isRoot = $isRoot;
        $this->DBColumnNameToQuestionName;
    }

    public function showInStatisticTable()
    {
        return (isset($this->DBColumnNameToQuestionName) && !is_null($this->DBColumnNameToQuestionName));
    }

    public function showInStatisticTableRecursive()
    {
        if($this->showInStatisticTable())
        {
            return TRUE;
        }

        if($this->hasCategories())
        {
            foreach ($this->getCategories() as $subCategory)
            {
                $show = $subCategory->showInStatisticTableRecursive();
                if($show)
                {
                    return TRUE;
                }
            }
        }

        return FALSE;
    }

    private function showInStatisticTableRecursiveHelper($category)
    {
        if($category->showInStatisticTable())
        {
            return TRUE;
        }

        foreach ($category->getCategories() as $subCategory)
        {
            if($subCategory->showInStatisticTable())
            {
                return TRUE;
            }
            $subCategory->showInStatisticTableRecursive();
        }
    }


    public function isRoot()
    {
        return $this->isRoot;
    }

    public function getId()
    {
        return $this->id;
    }

    public function getName()
    {
        return $this->name;
    }

    public function addCategory($category = null)
    {
        $this->subCategories[$category->id] = $category;
    }

    public function getCategoryRecursive($categoryId)
    {
        if($this->id == $categoryId)
        {
            return $this;
        }

        if(is_null($this->subCategories))
        {
            return null;
        }

        $hasCategory = array_key_exists($categoryId, $this->subCategories);
        if($hasCategory)
        {
            return $this->getCategory($categoryId);
        }
        else
        {
            foreach ($this->subCategories as $categoryToSearch)
            {
                $category = $categoryToSearch->getCategoryRecursive($categoryId);
                if(!is_null($category))
                {
                    return $category;
                }
            }
        }
    }

    public function hasCategories()
    {
        return (!is_null($this->subCategories) || count($this->subCategories));
    }

    public function getCategory($categoryId)
    {
        return $this->subCategories[$categoryId];
    }

    public function getQuestionRecursive($questionName)
    {
        if($this->hasQuestions() && $this->isQuestionInCategory($questionName))
        {
            return $this->getQuestionByDatabaseColumn($questionName);
        }

        if($this->hasCategories())
        {
            foreach ($this->getCategories() as $subCategory)
            {
                $question = $subCategory->getQuestionRecursive($questionName);
                if(!is_null($question))
                {
                    return $question;
                }
            }
        }
    }

    public function getCategories()
    {
        return $this->subCategories;
    }

    public function addQuestion($question = null)
    {
        $this->questions[$question->getName()] = $question;

        $questionColumns = $question->getAnswersDatabaseName();
        if(is_array($questionColumns))
        {
            foreach ($questionColumns as $key => $value) {
                $this->DBColumnNameToQuestionName[$key] = $question->getName();
            }
        }
    }

    public function getQuestionByDatabaseColumn($columnName)
    {
        $questionName = $this->DBColumnNameToQuestionName[$columnName];
        return $this->getQuestion($questionName);
    }

    public function hasQuestions()
    {
        return !is_null($this->questions);
    }

    public function getQuestion($name)
    {
        return $this->questions[$name];
    }

    public function getQuestions()
    {
        return $this->questions;
    }

    public function isQuestionInCategory($quesitonColumnName)
    {
        if(is_null($this->DBColumnNameToQuestionName ))
        {
            return FALSE;
        }
        return (array_key_exists($quesitonColumnName, $this->DBColumnNameToQuestionName));
    }
}
?>
