<?php 

include_once ("_dirinfo.php");
include_once (PATH_TO_ROOT."init.php");

?>

<head>
  <title>Graphs</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <style type="text/css">
  table
	{ 
	margin-left: auto;
	margin-right: auto;
	}
  </style>
   <script type="text/javascript" src="<?php echo PATH_TO_ROOT;?>_support/jquery.js"></script>
   <script type="text/javascript" src="<?php echo PATH_TO_ROOT;?>_plugins/charts/js/highcharts.js"></script>
   <script type="text/javascript" src="<?php echo PATH_TO_ROOT;?>_plugins/charts/js/modules/exporting.js"></script>
</head>
<body>
<?php 

$graphData =  $_SESSION['mysteryReportGraph'];
foreach ($graphData as $data) {
	if($data['checked'])
	{
		$data1y[] = intval($data['data1y']);
		$data2y[] = intval($data['data2y']);
		$labels[] = "'".str_replace("\n"," ",$data['gLabel'])."'";
	}
}


 echo  "<script type=\"text/javascript\">
						$(function () {
						    var chart;
						    $(document).ready(function() {
						        chart = new Highcharts.Chart({
						            chart: {
						                renderTo: 'container',
						                type: 'bar'
						            },
						            title: {
						                text: ''
						            },
						            exporting: {
						            
						            width: 2000,
						            filename: 'totalGraph-".$_GET['projectName']."'
						            },
						            xAxis: {
						                categories: [ ".implode(",",$labels)."],
						                labels: {
						                	style: {
						                		fontSize: '16px'
						                	}
						                }
						                			 
						            },
						            yAxis: {
						                min: 0,
						                max:100,
						                title: {
						                    text: '%'
						                },
						                stackLabels: {
						                    enabled: false,
						                    style: {
						                        fontWeight: 'bold',
						                        fontSize: '20px',
						                        color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
						                    }
						                }
						            },
						            tooltip: {
						                formatter: function() {
						                        return '<b>'+ this.series.name +'</b><br/>'+
						                        this.x +': '+ this.y +'%';
						                }
						            },
						            credits: {
						                enabled: false
						            },

						            legend: {
						          

						                reverse: true
						            },
						         
						            plotOptions: {
						                series: {
						                    stacking: 'normal',
						                     dataLabels: {
						                        enabled: true,
						                        align: 'center',
						                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
						                        formatter: function() {
						                        	return  this.y +'%';
						                		}
						                    }

						                }
						            },
						            
						            series: [{
							                name: 'Postignuće %',
							                color: '#465623',
							                data: [".implode(",",$data1y)."]
							            }, {
							                name: 'Nedostatak %',
							                color: '#7D2725',
							                data: [".implode(",",$data2y)."]
							            }]
						            ";
   									
   				echo "					
						        });
						    });
						    
						});
				</script>
		

				<div id=\"container\" style=\"min-width: 400px; max-width:95%; height: 600px; margin: 0 auto\"></div>";
?>
</body>
</html>