<?php

namespace SolveX\Session;

/**
 * Redis (phpredis) session backend.
 *
 * @link https://github.com/phpredis/phpredis
 *
 * Stores session data into Redis under 'session_' . SESSION_NAME . '_' . $sessionId keys.
 */
class RedisSessionHandler
{
    protected $redis;

    public function open($savePath, $sessionName)
    {
        $this->redis = new Redis;
        $success = $this->redis->connect(env('REDIS_CONNECTION'));
        if ($success)
            $this->redis->setOption(Redis::OPT_PREFIX, 'session_' . env('SESSION_NAME') . '_');

        return $success;
    }


    public function close()
    {
        $this->redis->close();
    }


    public function read($sessionId)
    {
        $data = $this->redis->get($sessionId);
        if ($data === false)
            return '';

        return $data;
    }


    public function write($sessionId, $data)
    {
        return $this->redis->set($sessionId, $data);
    }


    public function destroy($sessionId)
    {
        return ($this->redis->del($sessionId) === 1);
    }


    public function gc($maxlifetime) 
    {
        return true;
    }
}
