<?php

$container = new Illuminate\Container\Container;

$container->instance(Illuminate\Contracts\Container\Container::class, $container);
$container['facades'] = [
    'DBL'      => SolveX\Facades\DB::class,
    'Log'     => SolveX\Facades\Log::class,
    'Request' => SolveX\Facades\Request::class,
    'Route'   => SolveX\Facades\Route::class,
    'Session' => SolveX\Facades\Session::class,
    'Response'=> App\Facades\Response::class,
];

$container->singleton('DBL', function ($container) {
    $capsule = new Illuminate\Database\Capsule\Manager($container);
    $capsule->setFetchMode(PDO::FETCH_OBJ);
    $capsule->addConnection([
        'driver'    => 'mysql',
        'host'      => WARPIT_HOST,
        'username'  => MYSQL_USER,
        'password'  => MYSQL_PASS,
        'database'  => DB_WARPIT_MAIN,
        'charset'   => 'utf8',
        'collation' => 'utf8_unicode_ci',
        'prefix'    => '',
        'options'   => [
            PDO::ATTR_STRINGIFY_FETCHES => true,
            PDO::MYSQL_ATTR_LOCAL_INFILE => true,
        ],
    ]);

    $capsule->addConnection([
        'driver'    => 'mysql',
        'host'      => WARPIT_HOST,
        'username'  => MYSQL_USER,
        'password'  => MYSQL_PASS,
        'database'  => DB_WARPIT_MAIN . '_Webcati',
        'charset'   => 'utf8',
        'collation' => 'utf8_unicode_ci',
        'prefix'    => '',
        'options'   => [
            PDO::ATTR_STRINGIFY_FETCHES => true,
            PDO::MYSQL_ATTR_LOCAL_INFILE => true,
        ],
    ], 'webcati');

    $capsule->addConnection([
        'driver'    => 'mysql',
        'host'      => WARPIT_HOST,
        'username'  => MYSQL_USER,
        'password'  => MYSQL_PASS,
        'database'  => DB_WARPIT_MAIN . '_Webcati_base',
        'charset'   => 'utf8',
        'collation' => 'utf8_unicode_ci',
        'prefix'    => '',
        'options'   => [
            PDO::ATTR_STRINGIFY_FETCHES => true,
            PDO::MYSQL_ATTR_LOCAL_INFILE => true,
        ],
    ], 'webcati_base');

    $capsule->addConnection([
        'driver'    => 'mysql',
        'host'      => WARPIT_HOST,
        'username'  => MYSQL_USER,
        'password'  => MYSQL_PASS,
        'database'  => DB_WARPIT_MAIN . '_Webuserspool',
        'charset'   => 'utf8',
        'collation' => 'utf8_unicode_ci',
        'prefix'    => '',
        'options'   => [
            PDO::ATTR_STRINGIFY_FETCHES => true,
            PDO::MYSQL_ATTR_LOCAL_INFILE => true,
        ],
    ], 'webuserspool');

    $capsule->setEventDispatcher(new Illuminate\Events\Dispatcher($container));
    $capsule->bootEloquent();

    //20170720 Tanis: changed this to getDatabaseManager so we can use multiple databse connections
    $db = $capsule->getDatabaseManager();

    if (env('DISABLE_MYSQL_STRICT_MODE', false)) {
        // Force MySQL mode (application was not coded with strict mode in mind from the start).
        $db->statement('SET sql_mode="NO_ENGINE_SUBSTITUTION"');
    }
    /*if (! env('QUERY_LOG_FOLDER', false)) {
        return $db;
    }*/

  //  $queryLogger = new App\Support\Log\QueryLogger($container, env('QUERY_LOG_FOLDER'));
//    $queryLogger->registerQueryListener($db);
    return $db;
});

// Kickstart DB (Eloquent models dont use DB facade directly).
//$container->make('DB');


$container->singleton('Log',      SolveX\Log\Log::class);
$container->singleton('Route',    App\Routing\Route::class);
$container->singleton('Request',  App\Http\Request::class);
$container->singleton('Session',  SolveX\Session\Session::class);
$container->singleton('Response', App\Http\Response::class);

$container->bind(SolveX\Interfaces\ExceptionHandlerInterface::class, App\Exceptions\Handler::class);
$container->bind(SolveX\ViewModel\DataSourceInterface::class, 'Request');

$container->alias('DBL', SolveX\Interfaces\DatabaseInterface::class);
$container->alias('Log', SolveX\Interfaces\LogInterface::class);
$container->alias('Route', SolveX\Interfaces\RouteInterface::class);
$container->alias('Request', SolveX\Interfaces\RequestInterface::class);
$container->alias('Session', SolveX\Interfaces\SessionInterface::class);
$container->alias('Response', App\Interfaces\ResponseInterface::class);
