#!/usr/bin/env bash

export VAULT_ADDRESS=https://dev-vault.solve-x.net
export VAULT_APPROLE_ROLE_NAME=warpit-warpit-${TENANT}
export VAULT_ROLEID_VAR_NAME=$(echo "VAULT_APPROLE_ROLEID_${TENANT}" | awk '{print toupper($0)}')
export VAULT_APPROLE_ROLEID="${!VAULT_ROLEID_VAR_NAME}"

export X_VAULT_TOKEN=$(deployment/vault_login.sh)
if [[ ${#X_VAULT_TOKEN} -ge 50 ]]; then
    echo "Error while logging into Vault: $X_VAULT_TOKEN";
    exit 1;
fi

export SECRET_MYSQL_PASSWORD=$(deployment/update_secret.sh env/warpit/warpit/${TENANT}/install.MYSQL_PASS w_mp_${TENANT})
export SECRET_INSTALL_CONFIG=$(deployment/update_secret.sh deployment/install_config.template.php w_install_${TENANT})
